/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TSTrackManager;
import mpi.eudico.client.annotator.timeseries.TimeSeriesTrack;
import mpi.eudico.server.corpora.clom.Transcription;

public class ExtractStep2
extends StepPane
implements ListSelectionListener {
    private TSTrackManager manager;
    private JList trackList;
    private DefaultListModel trackModel;
    private JRadioButton aveRB;
    private JRadioButton minRB;
    private JRadioButton maxRB;
    private JRadioButton sumRB;
    private JRadioButton atBeginRB;
    private JRadioButton atEndRB;
    private JRadioButton rangeRB;
    private JRadioButton medianRB;
    private JCheckBox overwriteCB;

    public ExtractStep2(MultiStepPane multiPane, Transcription transcription, TSTrackManager manager) {
        super(multiPane);
        this.manager = manager;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        this.trackModel = new DefaultListModel();
        this.trackList = new JList(this.trackModel);
        this.trackList.setSelectionMode(0);
        JScrollPane listScroll = new JScrollPane(this.trackList);
        if (this.manager != null) {
            List<TimeSeriesTrack> tracks = this.manager.getRegisteredTracks();
            for (int i = 0; i < tracks.size(); ++i) {
                AbstractTSTrack tr = (AbstractTSTrack)tracks.get(i);
                this.trackModel.addElement(tr.getName());
            }
        }
        ButtonGroup group = new ButtonGroup();
        this.aveRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.Average"));
        this.minRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.Minimum"));
        this.maxRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.Maximum"));
        this.sumRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.Sum"));
        this.atBeginRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.AtBegin"));
        this.atEndRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.AtEnd"));
        this.medianRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.Median"));
        this.rangeRB = new JRadioButton(ElanLocale.getString("TimeSeriesViewer.Extract.Range"));
        group.add(this.aveRB);
        group.add(this.minRB);
        group.add(this.maxRB);
        group.add(this.sumRB);
        group.add(this.atBeginRB);
        group.add(this.atEndRB);
        group.add(this.medianRB);
        group.add(this.rangeRB);
        this.minRB.setSelected(true);
        this.overwriteCB = new JCheckBox(ElanLocale.getString("TimeSeriesViewer.Extract.Overwrite"));
        this.overwriteCB.setSelected(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel("<html>" + ElanLocale.getString("TimeSeriesViewer.Extract.SourceTrack") + "</html>"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)listScroll, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel("<html>" + ElanLocale.getString("TimeSeriesViewer.Extract.Method") + "</html>"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        this.add((Component)this.minRB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.maxRB, gbc);
        gbc.gridx = 2;
        this.add((Component)this.rangeRB, gbc);
        gbc.gridx = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.aveRB, gbc);
        gbc.gridy = 4;
        gbc.gridx = 0;
        this.add((Component)this.sumRB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.atBeginRB, gbc);
        gbc.gridx = 2;
        this.add((Component)this.atEndRB, gbc);
        gbc.gridx = 3;
        this.add((Component)this.medianRB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 5;
        gbc.gridwidth = 4;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)this.overwriteCB, gbc);
        this.trackList.getSelectionModel().addListSelectionListener(this);
        this.readPrefs();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("TimeSeriesViewer.Extract.SelectTrack");
    }

    @Override
    public void enterStepForward() {
        if (this.trackList.getSelectedIndex() >= 0) {
            this.multiPane.setButtonEnabled(3, true);
        } else {
            this.multiPane.setButtonEnabled(3, false);
        }
    }

    @Override
    public void enterStepBackward() {
        this.enterStepForward();
    }

    @Override
    public boolean leaveStepForward() {
        if (this.trackList.getSelectedIndex() >= 0) {
            String trackName = (String)this.trackList.getSelectedValue();
            this.multiPane.putStepProperty("TrackName", trackName);
            String calcType = "Min";
            if (this.maxRB.isSelected()) {
                calcType = "Max";
            } else if (this.aveRB.isSelected()) {
                calcType = "Ave";
            } else if (this.sumRB.isSelected()) {
                calcType = "Sum";
            } else if (this.atBeginRB.isSelected()) {
                calcType = "AtBegin";
            } else if (this.atEndRB.isSelected()) {
                calcType = "AtEnd";
            } else if (this.medianRB.isSelected()) {
                calcType = "Median";
            } else if (this.rangeRB.isSelected()) {
                calcType = "Range";
            }
            this.multiPane.putStepProperty("Calc", calcType);
            this.multiPane.putStepProperty("Overwrite", String.valueOf(this.overwriteCB.isSelected()));
            this.storePrefs();
            return true;
        }
        return false;
    }

    @Override
    public boolean doFinish() {
        if (this.leaveStepForward()) {
            this.multiPane.nextStep();
        }
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.trackList.getSelectedIndex() >= 0) {
            this.multiPane.setButtonEnabled(3, true);
        } else {
            this.multiPane.setButtonEnabled(3, false);
        }
    }

    private void storePrefs() {
        String calcType = "Minimum";
        if (this.maxRB.isSelected()) {
            calcType = "Maximum";
        } else if (this.aveRB.isSelected()) {
            calcType = "Average";
        } else if (this.sumRB.isSelected()) {
            calcType = "Sum";
        } else if (this.atBeginRB.isSelected()) {
            calcType = "AtBegin";
        } else if (this.atEndRB.isSelected()) {
            calcType = "AtEnd";
        } else if (this.medianRB.isSelected()) {
            calcType = "Median";
        } else if (this.rangeRB.isSelected()) {
            calcType = "Range";
        }
        Preferences.set("TimeSeriesViewer.Extract.Calculation", calcType, null);
        Preferences.set("TimeSeriesViewer.Extract.Overwrite", this.overwriteCB.isSelected(), null);
    }

    private void readPrefs() {
        Boolean overWrPref;
        String calcType = Preferences.getString("TimeSeriesViewer.Extract.Calculation", null);
        if (calcType != null) {
            if (calcType.equals("Maximum")) {
                this.maxRB.setSelected(true);
            } else if (calcType.equals("Average")) {
                this.aveRB.setSelected(true);
            } else if (calcType.equals("Sum")) {
                this.sumRB.setSelected(true);
            } else if (calcType.equals("AtBegin")) {
                this.atBeginRB.setSelected(true);
            } else if (calcType.equals("AtEnd")) {
                this.atEndRB.setSelected(true);
            } else if (calcType.equals("Median")) {
                this.medianRB.setSelected(true);
            } else if (calcType.equals("Range")) {
                this.rangeRB.setSelected(true);
            }
        }
        if ((overWrPref = Preferences.getBool("TimeSeriesViewer.Extract.Overwrite", null)) != null) {
            this.overwriteCB.setSelected(overWrPref);
        }
    }
}

