/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ExtractTrackDataCommand;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TSTrackManager;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExtractStep3
extends ProgressStepPane
implements ProgressListener {
    private TranscriptionImpl transcription;
    private TSTrackManager manager;
    private Command command;

    public ExtractStep3(MultiStepPane multiPane, TranscriptionImpl transcription, TSTrackManager manager) {
        super(multiPane);
        this.transcription = transcription;
        this.manager = manager;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        super.initComponents();
        this.progressLabel.setText(ElanLocale.getString("TimeSeriesViewer.Extract.Extracting"));
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("TimeSeriesViewer.Extract.Extracting");
    }

    @Override
    public boolean doFinish() {
        TierImpl sourceTier;
        this.multiPane.setButtonEnabled(8, false);
        String sourceTierName = (String)this.multiPane.getStepProperty("SourceTier");
        String destTierName = (String)this.multiPane.getStepProperty("DestTier");
        String trackName = (String)this.multiPane.getStepProperty("TrackName");
        String method = (String)this.multiPane.getStepProperty("Calc");
        if (method == null) {
            ClientLogger.LOG.warning("Unknown calculation method.");
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NoMethod"));
            return false;
        }
        String overwr = (String)this.multiPane.getStepProperty("Overwrite");
        boolean overwrite = true;
        if ("false".equals(overwr)) {
            overwrite = false;
        }
        if ((sourceTier = this.transcription.getTierWithId(sourceTierName)) == null) {
            ClientLogger.LOG.warning("Source tier is null: " + sourceTierName);
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + sourceTierName);
            return false;
        }
        TierImpl destTier = this.transcription.getTierWithId(destTierName);
        if (destTier == null) {
            ClientLogger.LOG.warning("Destination tier is null: " + destTierName);
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + destTierName);
            return false;
        }
        AbstractTSTrack track = this.manager.getTrack(trackName);
        if (track == null) {
            ClientLogger.LOG.warning("Track is null: " + trackName);
            this.notifyCancel(ElanLocale.getString("TimeSeriesViewer.Extract.NotFound") + " " + trackName);
            return false;
        }
        this.command = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ExtractTrackData");
        ((ExtractTrackDataCommand)this.command).addProgressListener(this);
        this.command.execute(this.transcription, new Object[]{sourceTierName, destTierName, track, method, overwrite});
        return false;
    }

    @Override
    public void enterStepForward() {
        this.doFinish();
    }

    private void notifyCancel(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
        this.multiPane.setButtonEnabled(4, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    protected void endOfProcess() {
        if (this.command != null) {
            ((ExtractTrackDataCommand)this.command).removeProgressListener(this);
        }
        this.multiPane.close();
    }
}

