/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.timeseries.AbstractTSTrack;
import mpi.eudico.client.annotator.timeseries.TSRuler;
import mpi.eudico.client.annotator.timeseries.TSRulerImpl;
import mpi.eudico.client.annotator.timeseries.TSTrackPanel;
import mpi.eudico.client.annotator.timeseries.TimeValue;
import mpi.eudico.client.annotator.timeseries.TimeValueStart;

public class TSTrackPanelImpl
implements TSTrackPanel {
    private List<AbstractTSTrack> tracks;
    private TSRulerImpl vertRuler;
    private int rulerWidth;
    private float zoomLevel;
    private float msPerPixel;
    private int height;
    private int width;
    private Insets margin;
    private Rectangle trackRect;
    private int[] tickYPos = new int[3];
    private final int INVALID = (int)Math.pow(2.0, 30.0);

    public TSTrackPanelImpl() {
        this.tracks = new ArrayList<AbstractTSTrack>(4);
        this.vertRuler = new TSRulerImpl();
        this.vertRuler.setTrackPanel(this);
        this.margin = new Insets(3, 3, 3, 3);
        this.rulerWidth = 40;
        this.vertRuler.setWidth(this.rulerWidth);
        this.trackRect = new Rectangle();
    }

    public void setRulerWidth(int rulerWidth) {
        this.rulerWidth = rulerWidth;
        this.vertRuler.setWidth(rulerWidth);
        this.trackRect.x = this.margin.left + rulerWidth;
    }

    public int getRulerWidth() {
        return this.rulerWidth;
    }

    public void setRuler(TSRuler ruler) {
        this.vertRuler = (TSRulerImpl)ruler;
        this.vertRuler.setTrackPanel(this);
        this.vertRuler.setWidth(this.rulerWidth);
        this.vertRuler.setHeight(this.height - this.margin.top - this.margin.bottom);
        this.trackRect.x = this.margin.left + this.rulerWidth;
    }

    public TSRulerImpl getRuler() {
        return this.vertRuler;
    }

    public void paint(Graphics2D g2d, long intervalBeginTime) {
        int i;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.width, this.height);
        g2d.setColor(Color.BLACK);
        g2d.drawRect(this.trackRect.x, this.trackRect.y - 1, this.trackRect.width, this.trackRect.height + 2);
        g2d.translate(this.margin.left, this.margin.top);
        this.vertRuler.paint(g2d);
        g2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.tickYPos = this.vertRuler.getTickYPositions();
        for (i = 0; i < this.tickYPos.length; ++i) {
            g2d.drawLine(this.trackRect.x, this.tickYPos[i], this.trackRect.x + this.trackRect.width, this.tickYPos[i]);
        }
        g2d.translate(this.trackRect.x, 0);
        g2d.setClip(0, 0, this.trackRect.width, this.trackRect.height);
        for (i = 0; i < this.tracks.size(); ++i) {
            this.paintTrack(g2d, this.tracks.get(i), intervalBeginTime, this.trackRect.width, this.trackRect.height);
        }
        g2d.setClip(null);
        g2d.translate(-this.margin.left - this.trackRect.x, -this.margin.top);
    }

    public void paintTrack(Graphics2D g2d, AbstractTSTrack track, long beginTime, int w, int h) {
        if (g2d == null || track == null || w <= 0 || h <= 0) {
            return;
        }
        switch (track.getType()) {
            case 0: {
                break;
            }
            case 1: {
                this.paintFloatArrayTrack(g2d, track, beginTime, w, h);
                break;
            }
            case 2: {
                break;
            }
            case 11: {
                this.paintTimeValueTrack(g2d, track, beginTime, w, h);
            }
            default: {
                return;
            }
        }
    }

    private void paintFloatArrayTrack(Graphics2D g2d, AbstractTSTrack track, long beginTime, int w, int h) {
        if (w <= 0 || h <= 0) {
            return;
        }
        g2d.setColor(track.getColor());
        float[] data = (float[])track.getData();
        float[] range = this.vertRuler.getRange();
        float scaleUnit = (float)h / (range[1] - range[0]);
        long endTime = beginTime + (long)((float)w * this.msPerPixel);
        int xShift = (int)((float)beginTime / this.msPerPixel) + (int)((float)track.timeOffset / this.msPerPixel);
        int beginIndex = track.getIndexForTime(beginTime);
        int endIndex = track.getIndexForTime(endTime);
        float samplesPerPixel = this.msPerPixel * (track.getSampleRate() / 1000.0f);
        int x1 = 0;
        int x2 = -1;
        int y1 = 0;
        int y2 = 0;
        if (samplesPerPixel > 1.0f) {
            int index1;
            int index2 = index1 = beginIndex;
            for (int i = 0; i <= w; ++i) {
                float val = 0.0f;
                boolean validPix = false;
                index1 = track.getIndexForTime(beginTime + (long)((int)((float)i * this.msPerPixel)));
                index2 = track.getIndexForTime(beginTime + (long)((int)((float)(i + 1) * this.msPerPixel)));
                if (index1 < 0 || index2 < 0 || index1 == index2) continue;
                if (index2 < data.length) {
                    for (int j = index1; j < index2; ++j) {
                        if (Float.isNaN(data[j])) continue;
                        val += data[j];
                        validPix = true;
                    }
                    val /= (float)(index2 - index1);
                    if (x2 == -1) {
                        x2 = i;
                        if (validPix) {
                            y2 = (int)(scaleUnit * (range[1] - val));
                            continue;
                        }
                        y2 = this.INVALID;
                        continue;
                    }
                    x1 = x2;
                    y1 = y2;
                    x2 = i;
                    y2 = validPix ? (int)(scaleUnit * (range[1] - val)) : this.INVALID;
                    if (y1 == this.INVALID || y2 == this.INVALID) continue;
                    g2d.drawLine(x1, y1, x2, y2);
                    continue;
                }
                break;
            }
        } else {
            float pixelPerSample = 1.0f / samplesPerPixel;
            for (int i = beginIndex; i <= endIndex && i < data.length; ++i) {
                if (i < 0) continue;
                float v = data[i];
                if (x2 == -1) {
                    x2 = (int)((float)i * pixelPerSample) - xShift;
                    if (!Float.isNaN(v)) {
                        y2 = (int)(scaleUnit * (range[1] - v));
                        continue;
                    }
                    y2 = this.INVALID;
                    continue;
                }
                x1 = x2;
                y1 = y2;
                x2 = (int)((float)i * pixelPerSample) - xShift;
                y2 = !Float.isNaN(v) ? (int)(scaleUnit * (range[1] - v)) : this.INVALID;
                if (y1 == this.INVALID || y2 == this.INVALID) continue;
                g2d.drawLine(x1, y1, x2, y2);
            }
        }
    }

    private void paintTimeValueTrack(Graphics2D g2d, AbstractTSTrack track, long beginTime, int w, int h) {
        TimeValue tv;
        if (w <= 0 || h <= 0) {
            return;
        }
        g2d.setColor(track.getColor());
        List data = (List)track.getData();
        float[] range = this.vertRuler.getRange();
        float scaleUnit = (float)h / (range[1] - range[0]);
        long endTime = beginTime + (long)((float)w * this.msPerPixel);
        int xShift = (int)((float)beginTime / this.msPerPixel) + (int)((float)track.timeOffset / this.msPerPixel);
        int beginIndex = 0;
        beginIndex = beginTime >= 0L ? track.getIndexForTime(beginTime) : track.getIndexForTime(0L);
        int endIndex = track.getIndexForTime(endTime);
        if (endIndex >= 0 && endIndex < data.size() - 1) {
            tv = (TimeValue)data.get(endIndex);
            if (tv.time < endTime) {
                ++endIndex;
            }
        }
        int x1 = 0;
        int x2 = -1;
        int y1 = 0;
        int y2 = 0;
        for (int i = beginIndex; i <= endIndex; ++i) {
            tv = (TimeValue)data.get(i);
            if (x2 == -1) {
                x2 = (int)((float)tv.time / this.msPerPixel) - xShift;
                if (!Float.isNaN(tv.value)) {
                    y2 = (int)(scaleUnit * (range[1] - tv.value));
                    continue;
                }
                y2 = this.INVALID;
                continue;
            }
            x1 = x2;
            y1 = y2;
            x2 = (int)((float)tv.time / this.msPerPixel) - xShift;
            y2 = !Float.isNaN(tv.value) ? (int)(scaleUnit * (range[1] - tv.value)) : this.INVALID;
            if (tv instanceof TimeValueStart || y1 == this.INVALID || y2 == this.INVALID) continue;
            g2d.drawLine(x1, y1, x2, y2);
        }
    }

    public void setVerticalZoom(float vertZoom) {
        this.zoomLevel = vertZoom;
    }

    public float getVerticalZoom() {
        return this.zoomLevel;
    }

    @Override
    public void addTrack(AbstractTSTrack track) {
        this.tracks.add(track);
    }

    @Override
    public boolean removeTrack(AbstractTSTrack track) {
        return this.tracks.remove(track);
    }

    @Override
    public boolean removeTrack(String trackID) {
        if (trackID == null) {
            return false;
        }
        AbstractTSTrack track = this.getTrack(trackID);
        if (track != null) {
            return this.tracks.remove(track);
        }
        return false;
    }

    @Override
    public AbstractTSTrack getTrack(String trackID) {
        AbstractTSTrack track = null;
        AbstractTSTrack tr = null;
        for (int i = 0; i < this.tracks.size(); ++i) {
            tr = this.tracks.get(i);
            if (!tr.getName().equals(trackID)) continue;
            track = tr;
            break;
        }
        return track;
    }

    @Override
    public List<AbstractTSTrack> getTracks() {
        return this.tracks;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
        this.vertRuler.setHeight(height - this.margin.top - this.margin.bottom);
        this.trackRect.height = height - this.margin.top - this.margin.bottom;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
        this.trackRect.width = width - this.rulerWidth - this.margin.left - this.margin.right;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setMargin(Insets margin) {
        this.margin = margin;
        this.vertRuler.setHeight(this.height - margin.top - margin.bottom);
        this.trackRect.x = margin.left;
        this.trackRect.y = margin.top;
        this.trackRect.width = this.width - this.rulerWidth - margin.left - margin.right;
        this.trackRect.height = this.height - margin.top - margin.bottom;
    }

    @Override
    public Insets getMargin() {
        return this.margin;
    }

    public float getMsPerPixel() {
        return this.msPerPixel;
    }

    public void setMsPerPixel(float msPerPixel) {
        this.msPerPixel = msPerPixel;
    }
}

