/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultCellEditor;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.transcriptionMode.AnnotationCellPlaceholder;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTable;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableEditBox;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TranscriptionTableCellEditor
extends DefaultCellEditor {
    private static final String EMPTY = "";
    private Annotation annotation;
    private TranscriptionTableEditBox inlineEditBox;
    private TranscriptionViewer viewer;
    private int startEditInOneClick = 1;

    public TranscriptionTableCellEditor(TranscriptionViewer viewer) {
        super(new JTextField());
        this.getComponent().setEnabled(false);
        this.viewer = viewer;
        this.setClickCountToStart(this.startEditInOneClick);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.annotation = null;
        if (this.inlineEditBox == null) {
            this.inlineEditBox = new TranscriptionTableEditBox(this.viewer, (TranscriptionTable)table);
        }
        if (value instanceof Annotation) {
            this.annotation = (Annotation)value;
            this.configureEditBox(table, row, column);
            this.viewer.updateMedia(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
            if (this.viewer.isAutoPlayBack()) {
                this.viewer.playInterval(this.annotation.getBeginTimeBoundary(), this.annotation.getEndTimeBoundary());
            }
            this.inlineEditBox.startEdit();
            return this.inlineEditBox.getEditorComponent();
        }
        if (value instanceof AnnotationCellPlaceholder) {
            AnnotationCellPlaceholder cellPH = (AnnotationCellPlaceholder)value;
            if (cellPH.canCreate) {
                this.createAnnotation(table, row, column);
                return this.getComponent();
            }
        }
        return this.getComponent();
    }

    public TranscriptionTableEditBox getEditorComponent() {
        if (this.inlineEditBox != null) {
            return this.inlineEditBox;
        }
        return null;
    }

    private void createAnnotation(JTable table, int row, int column) {
        int columnNo = table.convertColumnIndexToModel(column);
        int columnIndexInMap = columnNo - 1;
        AbstractAnnotation ann = null;
        TierImpl currentTier = null;
        long beginTime = 0L;
        long endTime = 0L;
        for (int i = 1; i < table.getColumnCount(); ++i) {
            Object val;
            if (i == column || !((val = table.getValueAt(row, i)) instanceof Annotation)) continue;
            ann = (AbstractAnnotation)val;
            break;
        }
        if (ann == null) {
            Object valueObj = table.getValueAt(row, column);
            if (valueObj instanceof AnnotationCellPlaceholder) {
                AnnotationCellPlaceholder cellPH = (AnnotationCellPlaceholder)valueObj;
                beginTime = cellPH.bt;
                endTime = cellPH.et;
                currentTier = (TierImpl)this.viewer.getViewerManager().getTranscription().getTierWithId(cellPH.tierName);
            }
        } else {
            beginTime = ann.getBeginTimeBoundary();
            endTime = ann.getEndTimeBoundary();
            TierImpl linkedTier = (TierImpl)ann.getTier();
            if (linkedTier.getLinguisticType().getConstraints() != null && linkedTier.getLinguisticType().getConstraints().getStereoType() == 4) {
                TierImpl parentTier = linkedTier.getParentTier();
                while (parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4) {
                    parentTier = parentTier.getParentTier();
                }
                currentTier = this.viewer.getTierMap().get(parentTier).get(columnIndexInMap);
            } else {
                currentTier = this.viewer.getTierMap().get(linkedTier).get(columnIndexInMap);
            }
        }
        if (currentTier != null) {
            final TierImpl targetTier = currentTier;
            final long bt = beginTime;
            final long et = endTime;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TranscriptionTableCellEditor.this.viewer.createAnnotation(targetTier, bt, et);
                }
            });
        }
    }

    private void configureEditBox(JTable table, int row, int column) {
        this.inlineEditBox.setAnnotation(this.annotation);
        Font ff = null;
        if (table instanceof TranscriptionTable) {
            ff = ((TranscriptionTable)table).getFontForTier(((Annotation)table.getValueAt(row, column)).getTier().getName());
            if (ff == null) {
                ff = table.getFont();
            }
            ff = new Font(ff.getFontName(), ff.getStyle(), ((TranscriptionTable)table).getFontSize());
        }
        if (this.inlineEditBox.isUsingControlledVocabulary()) {
            table.setRowHeight(row, 120);
            this.inlineEditBox.configureEditor(JScrollPane.class, ff, table.getCellRect(row, column, true).getSize());
        } else {
            this.inlineEditBox.configureEditor(JTextArea.class, ff, table.getCellRect(row, column, true).getSize());
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.annotation != null) {
            return this.annotation;
        }
        return EMPTY;
    }

    public void showPopUp(Component comp, int x, int y) {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.showPopUp(comp, x, y);
        }
    }

    public void updateLocale() {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.updateLocale();
        }
    }

    public void commitChanges() {
        if (this.inlineEditBox != null && this.inlineEditBox.isDeselectCommitChanges()) {
            this.inlineEditBox.commitChanges();
        }
    }

    @Override
    public void cancelCellEditing() {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.cancelEdit();
        }
    }
}

