/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.gui.AdvancedTierOptionsDialog;
import mpi.eudico.client.annotator.layout.TranscriptionManager;
import mpi.eudico.client.annotator.transcriptionMode.AnnotationCellPlaceholder;
import mpi.eudico.client.annotator.transcriptionMode.SelectChildTiersDlg;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTable;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableCellEditor;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableCellRenderer;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableEditBox;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.util.TableSubHeaderObject;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.util.ControlledVocabulary;

public class TranscriptionViewer
extends AbstractViewer
implements ListSelectionListener,
ACMEditListener,
Zoomable {
    public static final String CREATE_ANN = "create";
    private TranscriptionManager layoutManager;
    private ViewerManager2 viewerManager;
    private SignalViewer signalViewer;
    private JScrollPane scroller;
    private TranscriptionTable table;
    private TranscriptionTableModel tableModel;
    private Map<String, Integer> columnOrder;
    private Map<String, Integer> columnWidth;
    private Map<TierImpl, List<TierImpl>> tierMap;
    private List<String> hiddenTiersList;
    private List<String> nonEditableTiersList;
    private List<String> columnTypeList;
    private List<Color> tierColorsList;
    private JPopupMenu popupMenu;
    private JMenuItem nonEditableTierMI;
    private JMenuItem hideAllTiersMI;
    private JMenuItem showHideMoreMI;
    private JMenuItem changeColorMI;
    private boolean merge = false;
    private boolean showTierNames = true;
    private boolean autoPlayBack = true;
    private int playAroundSelection = 500;
    private ArrayList<KeyStroke> keyStrokesList;
    private AnnotationCellPlaceholder newAnnotationPH = null;

    public TranscriptionViewer(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.signalViewer = viewerManager.getSignalViewer();
        if (this.signalViewer != null) {
            this.signalViewer.setRecalculateInterval(false);
        }
    }

    public void intializeViewer(TranscriptionManager transManager) {
        this.layoutManager = transManager;
        this.tierColorsList = new ArrayList<Color>();
        this.hiddenTiersList = new ArrayList<String>();
        this.tierMap = new HashMap<TierImpl, List<TierImpl>>();
        this.hiddenTiersList = new ArrayList<String>();
        this.nonEditableTiersList = new ArrayList<String>();
        this.columnOrder = new HashMap<String, Integer>();
        this.columnWidth = new HashMap<String, Integer>();
        this.keyStrokesList = new ArrayList();
        for (KeyStroke ks : ShortcutsUtil.getInstance().getShortcutKeysOnlyIn("Menu.Options.TranscriptionMode").values()) {
            if (ks == null) continue;
            this.keyStrokesList.add(ks);
        }
        this.initializeTable();
        this.preferencesChanged();
    }

    private void createPopUpMenu() {
        ActionListener actionLis = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == TranscriptionViewer.this.nonEditableTierMI) {
                    TranscriptionViewer.this.editOrNoneditableTier();
                } else if (e.getSource() == TranscriptionViewer.this.hideAllTiersMI) {
                    TranscriptionViewer.this.hideTiers();
                } else if (e.getSource() == TranscriptionViewer.this.showHideMoreMI) {
                    TranscriptionViewer.this.showHideMoreTiers();
                } else if (e.getSource() == TranscriptionViewer.this.changeColorMI) {
                    TranscriptionViewer.this.showChangeColorDialog(TranscriptionViewer.this.table.getTierName(TranscriptionViewer.this.table.getCurrentRow(), TranscriptionViewer.this.table.getCurrentColumn()));
                }
            }
        };
        this.popupMenu = new JPopupMenu("HideTier");
        this.nonEditableTierMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.EditableTier"));
        this.nonEditableTierMI.addActionListener(actionLis);
        this.hideAllTiersMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.HideLinkedTiers"));
        this.hideAllTiersMI.addActionListener(actionLis);
        this.showHideMoreMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.ShoworHideTiers"));
        this.showHideMoreMI.addActionListener(actionLis);
        this.changeColorMI = new JMenuItem(ElanLocale.getString("TranscriptionTable.Label.ChangeColorForThisTier"));
        this.changeColorMI.addActionListener(actionLis);
        this.popupMenu.add(this.changeColorMI);
        this.popupMenu.add(this.nonEditableTierMI);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.hideAllTiersMI);
        this.popupMenu.add(this.showHideMoreMI);
    }

    public void showChangeColorDialog(String tierName) {
        AdvancedTierOptionsDialog dialog = new AdvancedTierOptionsDialog((Frame)ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), ElanLocale.getString("EditTierDialog.Title.Change"), (TranscriptionImpl)this.viewerManager.getTranscription(), tierName);
        dialog.setVisible(true);
        this.setPreferredFontAndColorSettings();
    }

    public boolean isEditableTier(String tierName) {
        return !this.nonEditableTiersList.contains(tierName);
    }

    private void editOrNoneditableTier() {
        String tierName = this.table.getTierName(this.table.getCurrentRow(), this.table.getCurrentColumn());
        this.editOrNoneditableTier(tierName);
    }

    public void editOrNoneditableTier(String tierName) {
        if (!this.nonEditableTiersList.contains(tierName)) {
            this.nonEditableTiersList.add(tierName);
        } else {
            this.nonEditableTiersList.remove(tierName);
        }
        this.table.setNoneditableTiers(this.nonEditableTiersList);
        if (this.tierMap.size() >= 1 && this.columnTypeList.size() > 1) {
            for (Map.Entry<TierImpl, List<TierImpl>> keyObj : this.tierMap.entrySet()) {
                if (this.tierMap.get(keyObj) == null || this.tierMap.get(keyObj).size() <= 1) continue;
                this.table.startEdit(null);
                if (this.table.isEditing()) continue;
                this.table.goToNextEditableCell();
            }
        }
    }

    public void setNoneditableTier(List<String> tierList) {
        if (tierList != null) {
            this.nonEditableTiersList = tierList;
            this.table.setNoneditableTiers(this.nonEditableTiersList);
        }
    }

    public void hideTiers() {
        int row = this.table.getCurrentRow();
        int column = this.table.getCurrentColumn();
        this.hideTiersLinkedWith(this.table.getTierName(row, column));
    }

    public void hideTiersLinkedWith(String tierName) {
        TierImpl linkedTier;
        if (this.table.isEditing()) {
            ((TranscriptionTableCellEditor)this.table.getCellEditor()).commitChanges();
        }
        if ((linkedTier = (TierImpl)this.viewerManager.getTranscription().getTierWithId(tierName)) != null) {
            List<TierImpl> tierList = null;
            for (TierImpl keyObj : this.tierMap.keySet()) {
                if (!(this.tierMap.get(keyObj) instanceof List) || !(tierList = this.tierMap.get(keyObj)).contains(linkedTier) || this.hiddenTiersList.contains(keyObj.getName())) continue;
                this.hiddenTiersList.add(keyObj.getName());
                this.loadTable();
                break;
            }
        }
    }

    public void showHideMoreTiers() {
        if (this.table.isEditing()) {
            ((TranscriptionTableCellEditor)this.table.getCellEditor()).commitChanges();
        }
        SelectChildTiersDlg dialog = new SelectChildTiersDlg(this.layoutManager.getElanLayoutManager(), this.tierMap, this.hiddenTiersList, this.columnTypeList);
        dialog.setVisible(true);
        if (dialog.isValueChanged()) {
            if (dialog.getHiddenTiers() != null) {
                this.setHiddenTiersList(dialog.getHiddenTiers());
            }
            this.setTierMap(dialog.getTierMap());
            this.loadTable();
        }
    }

    public Transcription getTranscription() {
        return this.viewerManager.getTranscription();
    }

    public void setTierMap(Map<TierImpl, List<TierImpl>> map) {
        if (map != null) {
            this.tierMap = map;
        } else {
            this.tierMap.clear();
        }
    }

    public void setHiddenTiersList(List<String> list) {
        if (list != null) {
            this.hiddenTiersList = list;
        } else {
            this.hiddenTiersList.clear();
        }
    }

    public Map<TierImpl, List<TierImpl>> getTierMap() {
        return this.tierMap;
    }

    public List<String> getHiddenTiers() {
        return this.hiddenTiersList;
    }

    private void initializeTable() {
        this.tableModel = new TranscriptionTableModel();
        this.table = new TranscriptionTable();
        this.table.setModel(this.tableModel);
        this.table.setDefaultEditor(Object.class, new TranscriptionTableCellEditor(this));
        this.table.setDefaultRenderer(Object.class, new TranscriptionTableCellRenderer(this.getTranscription()));
        this.table.getColumnModel().getColumn(0).setMinWidth(40);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        this.scroller = new JScrollPane(this.table);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (TranscriptionViewer.this.popupMenu == null) {
                        TranscriptionViewer.this.createPopUpMenu();
                    }
                    if (TranscriptionViewer.this.table.getRowCount() == 0) {
                        TranscriptionViewer.this.nonEditableTierMI.setEnabled(false);
                        TranscriptionViewer.this.changeColorMI.setEnabled(false);
                        TranscriptionViewer.this.hideAllTiersMI.setEnabled(false);
                        TranscriptionViewer.this.popupMenu.show(TranscriptionViewer.this.scroller, e.getX(), e.getY());
                        TranscriptionViewer.this.popupMenu.setVisible(true);
                        return;
                    }
                    TranscriptionViewer.this.hideAllTiersMI.setEnabled(true);
                    int r = TranscriptionViewer.this.table.rowAtPoint(e.getPoint());
                    int c = TranscriptionViewer.this.table.columnAtPoint(e.getPoint());
                    if (c == 0) {
                        TranscriptionViewer.this.nonEditableTierMI.setEnabled(false);
                        TranscriptionViewer.this.changeColorMI.setEnabled(false);
                        TranscriptionViewer.this.popupMenu.show(TranscriptionViewer.this.table, e.getX(), e.getY());
                        TranscriptionViewer.this.popupMenu.setVisible(true);
                        return;
                    }
                    if (r >= 0 && c >= 0) {
                        String tierName;
                        if (TranscriptionViewer.this.table.getValueAt(r, c) instanceof TableSubHeaderObject) {
                            if (TranscriptionViewer.this.table.isEditing()) {
                                ((TranscriptionTableCellEditor)TranscriptionViewer.this.table.getCellEditor()).commitChanges();
                            }
                            TranscriptionViewer.this.table.changeSelection(r, c, false, false);
                            tierName = TranscriptionViewer.this.table.getTierName(r, c);
                            if (tierName != null) {
                                TranscriptionViewer.this.nonEditableTierMI.setEnabled(true);
                                TranscriptionViewer.this.changeColorMI.setEnabled(true);
                                if (TranscriptionViewer.this.nonEditableTiersList.contains(tierName)) {
                                    TranscriptionViewer.this.nonEditableTierMI.setText(ElanLocale.getString("TranscriptionTable.Label.EditableTier"));
                                } else {
                                    TranscriptionViewer.this.nonEditableTierMI.setText(ElanLocale.getString("TranscriptionTable.Label.NonEditableTier"));
                                }
                                TranscriptionViewer.this.popupMenu.show(TranscriptionViewer.this.table, e.getX(), e.getY());
                                TranscriptionViewer.this.popupMenu.setVisible(true);
                                return;
                            }
                        }
                        if (TranscriptionViewer.this.table.isEditing()) {
                            ((TranscriptionTableCellEditor)TranscriptionViewer.this.table.getCellEditor()).commitChanges();
                        }
                        TranscriptionViewer.this.table.changeSelection(r, c, false, false);
                        TranscriptionViewer.this.table.startEdit(null);
                        if (TranscriptionViewer.this.table.isEditing()) {
                            ((TranscriptionTableCellEditor)TranscriptionViewer.this.table.getCellEditor()).showPopUp(TranscriptionViewer.this.table, e.getX(), e.getY());
                        } else {
                            tierName = TranscriptionViewer.this.table.getTierName(r, c);
                            if (tierName != null) {
                                TranscriptionViewer.this.nonEditableTierMI.setEnabled(true);
                                if (TranscriptionViewer.this.nonEditableTiersList.contains(tierName)) {
                                    TranscriptionViewer.this.nonEditableTierMI.setText(ElanLocale.getString("TranscriptionTable.Label.EditableTier"));
                                } else {
                                    TranscriptionViewer.this.nonEditableTierMI.setText(ElanLocale.getString("TranscriptionTable.Label.NonEditableTier"));
                                }
                                TranscriptionViewer.this.popupMenu.show(TranscriptionViewer.this.table, e.getX(), e.getY());
                                TranscriptionViewer.this.popupMenu.setVisible(true);
                                return;
                            }
                        }
                    }
                }
            }
        };
        this.table.addMouseListener(mouseListener);
        this.scroller.addMouseListener(mouseListener);
        this.scroller.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                long selectionBeginTime = 0L;
                long selectionEndTime = 0L;
                boolean playback = TranscriptionViewer.this.isAutoPlayBack();
                TranscriptionViewer.this.setAutoPlayBack(false);
                long mediaTime = TranscriptionViewer.this.viewerManager.getMasterMediaPlayer().getMediaTime();
                TranscriptionViewer.this.table.startEdit(null);
                TranscriptionViewer.this.table.scrollIfNeeded();
                TranscriptionViewer.this.setAutoPlayBack(playback);
                TranscriptionViewer.this.viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
                if (TranscriptionViewer.this.viewerManager.getSelection() != null) {
                    selectionBeginTime = TranscriptionViewer.this.viewerManager.getSelection().getBeginTime();
                    selectionEndTime = TranscriptionViewer.this.viewerManager.getSelection().getEndTime();
                }
                if (selectionBeginTime > 0L && selectionEndTime > 0L && TranscriptionViewer.this.signalViewer != null) {
                    TranscriptionViewer.this.signalViewer.setSelection(selectionBeginTime, selectionEndTime);
                    TranscriptionViewer.this.layoutManager.getTranscriptionModePlayerController().getSelectionPanel().setBegin(selectionBeginTime);
                    TranscriptionViewer.this.layoutManager.getTranscriptionModePlayerController().getSelectionPanel().setEnd(selectionEndTime);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.scroller, "Center");
        this.table.getSelectionModel().addListSelectionListener(this);
        this.setPreferredFontAndColorSettings();
    }

    private void commitTableChanges() {
        if (this.table.isEditing()) {
            TranscriptionTableCellEditor editor = (TranscriptionTableCellEditor)this.table.getCellEditor(this.table.getCurrentRow(), this.table.getCurrentColumn());
            editor.commitChanges();
        }
    }

    private void reloadColumns() {
        this.commitTableChanges();
        this.storeColumnOrder();
        this.storeColumnWidth();
        this.table.setStoreColumnOrder(false);
        int count = this.table.getColumnCount() - 1;
        if (count != this.columnTypeList.size()) {
            while (this.table.getColumnCount() > 1) {
                this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1));
            }
        }
        this.tableModel.updateModel(this.columnTypeList);
        String[] identifiers = this.tableModel.getColumnIdentifiers();
        for (int i = 0; i < identifiers.length; ++i) {
            TableColumn tc = this.table.getColumn(identifiers[i]);
            tc.setIdentifier(identifiers[i]);
            if (i == 0) {
                tc.setHeaderValue(ElanLocale.getString("TranscriptionTable.Column.No"));
                continue;
            }
            tc.setHeaderValue(ElanLocale.getString("TranscriptionTable.ColumnPrefix") + " " + i + " : " + identifiers[i]);
        }
        this.table.setStoreColumnOrder(true);
    }

    public void setScrollerSize(int width, int height) {
        this.scroller.setPreferredSize(new Dimension(width, height));
    }

    private void setPreferredFontAndColorSettings() {
        Map<String, Font> fo;
        Preferences.set("TranscriptionMode.Temp.TierColors", null, this.viewerManager.getTranscription());
        Map<String, Color> colorMap = Preferences.getMapOfColor("TierColors", this.viewerManager.getTranscription());
        if (colorMap != null) {
            this.table.clearColorPrefernces();
            this.table.setFontColorForTiers(colorMap);
            if (this.tierMap != null) {
                for (List<TierImpl> tierList : this.tierMap.values()) {
                    if (tierList == null) continue;
                    for (TierImpl t : tierList) {
                        if (t == null) continue;
                        this.checkColorForTier(t.getName());
                    }
                }
            }
        }
        if ((fo = Preferences.getMapOfFont("TierFonts", this.viewerManager.getTranscription())) != null) {
            this.table.setFontsForTiers(fo);
        }
        this.table.repaint();
    }

    public void setFontSize(Integer size) {
        this.table.setFont(new Font(this.table.getFont().getFontName(), this.table.getFont().getStyle(), size));
        this.table.reCalculateRowHeight();
    }

    public Integer getFontSize() {
        return this.table.getFontSize();
    }

    public void moveViaColumn(boolean selected) {
        this.table.moveViaColumn(selected);
    }

    public void scrollActiveCellInCenter(boolean selected) {
        this.table.scrollActiveCellInCenter(selected);
    }

    public void setAutoPlayBack(boolean selected) {
        this.autoPlayBack = selected;
    }

    public void autoCreateAnnotations(boolean create) {
        this.table.setAutoCreateAnnotations(create);
    }

    public boolean isAnnotationsCreatedAutomatically() {
        return this.table.isAnnotationsCreatedAutomatically();
    }

    public boolean isAutoPlayBack() {
        return this.autoPlayBack;
    }

    public boolean isTierNamesShown() {
        return this.showTierNames;
    }

    public void showColorOnlyOnNoColumn(boolean selected) {
        ((TranscriptionTableCellRenderer)this.table.getDefaultRenderer(Object.class)).showColorOnlyOnNoColumn(selected);
        if (!this.layoutManager.isInitialized() || this.table.getRowCount() <= 0) {
            return;
        }
        this.table.revalidate();
        this.table.repaint();
    }

    public void showTierNames(boolean selected) {
        this.showTierNames = selected;
        ((TranscriptionTableCellRenderer)this.table.getDefaultRenderer(Object.class)).setShowTierNames(this.showTierNames);
        if (!this.layoutManager.isInitialized() || this.table.getRowCount() <= 0) {
            return;
        }
        int currentRow = this.table.getCurrentRow();
        int currentColumn = this.table.getCurrentColumn();
        int annNumber = 0;
        boolean plaBack = this.isAutoPlayBack();
        this.setAutoPlayBack(false);
        if (currentRow < 0 || currentRow >= this.table.getRowCount()) {
            annNumber = 1;
        } else {
            Object val = this.table.getValueAt(currentRow, 0);
            if (val instanceof Integer) {
                annNumber = (Integer)val;
            }
        }
        if (this.layoutManager.isInitialized()) {
            this.loadTable();
        }
        if (this.showTierNames) {
            int n = 0;
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                Object val = this.table.getValueAt(i, 0);
                if (!(val instanceof Integer) || (n = ((Integer)val).intValue()) != annNumber) continue;
                this.table.changeSelection(i, currentColumn, false, false);
                if (this.table.editCellAt(i, currentColumn)) {
                    this.table.startEdit(null);
                    this.table.scrollIfNeeded();
                }
                break;
            }
        } else if (annNumber > 0 && this.table.getRowCount() - 1 >= annNumber - 1) {
            this.table.changeSelection(annNumber - 1, currentColumn, false, false);
            if (this.table.editCellAt(annNumber - 1, currentColumn)) {
                this.table.startEdit(null);
                this.table.scrollIfNeeded();
            }
        }
        this.table.scrollIfNeeded();
        this.setAutoPlayBack(plaBack);
    }

    public void setColumnTypeList(List<String> types) {
        this.columnTypeList = types;
        this.reloadColumns();
    }

    public List<String> getColumnTypes() {
        return this.columnTypeList;
    }

    public void checkForMerge() {
        List<? extends Tier> tierList;
        this.merge = false;
        if (this.columnTypeList != null && this.columnTypeList.size() > 0 && (tierList = this.viewerManager.getTranscription().getTiersWithLinguisticType(this.columnTypeList.get(0))) != null && tierList.size() > 0) {
            Tier tier = tierList.get(0);
            if (tier.hasParentTier() && tier.getLinguisticType().getConstraints().getStereoType() == 4) {
                Tier parentTier;
                for (parentTier = tier.getParentTier(); parentTier != null && parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4; parentTier = parentTier.getParentTier()) {
                }
                if (parentTier.getLinguisticType().getConstraints() == null) {
                    this.merge = true;
                }
            } else if (tier.getLinguisticType().getConstraints() == null) {
                this.merge = true;
            }
        }
    }

    public void focusTable() {
        if (this.table.isEditing()) {
            ((TranscriptionTableCellEditor)this.table.getCellEditor()).getEditorComponent().grabFocus();
        } else {
            this.table.requestFocusInWindow();
        }
    }

    public boolean getMerge() {
        return this.merge;
    }

    public void toggleLoopMode() {
        this.layoutManager.getTranscriptionModePlayerController().toggleLoopMode();
    }

    public void storeColumnOrder() {
        if (!this.table.getStoreColumnOrder()) {
            return;
        }
        if (this.table.getColumnCount() - 1 != this.columnOrder.size()) {
            this.columnOrder.clear();
        }
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            this.columnOrder.put(String.valueOf(this.getColumnNumber(i)), i);
        }
        this.setPreference("TranscriptionTable.ColumnOrder", this.columnOrder, this.viewerManager.getTranscription());
    }

    private int getColumnNumber(int column) {
        return this.table.convertColumnIndexToModel(column);
    }

    private void storeColumnWidth() {
        if (!this.table.getStoreColumnOrder()) {
            return;
        }
        if (this.table.getColumnCount() - 1 != this.columnWidth.size()) {
            this.columnWidth.clear();
        }
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            this.columnWidth.put(String.valueOf(this.getColumnNumber(i)), this.table.getColumnModel().getColumn(i).getWidth());
        }
        this.setPreference("TranscriptionTable.ColumnWidth", this.columnWidth, this.viewerManager.getTranscription());
    }

    private void restoreColumnWidth() {
        String[] columnNames = this.tableModel.getColumnIdentifiers();
        if (this.columnWidth.size() <= 0) {
            return;
        }
        if (columnNames.length - 1 != this.columnWidth.size()) {
            this.columnWidth.clear();
            return;
        }
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            int columnIndex = this.table.getColumnModel().getColumnIndex(columnNames[i]);
            Integer width = this.columnWidth.get(String.valueOf(i));
            if (width == null || width < 0 || columnIndex >= this.table.getColumnCount()) continue;
            this.table.getColumnModel().getColumn(columnIndex).setPreferredWidth(width);
        }
    }

    private void restorePrefferedOrder() {
        this.table.setStoreColumnOrder(false);
        String[] columnNames = this.tableModel.getColumnIdentifiers();
        if (this.columnOrder.size() <= 0) {
            return;
        }
        if (columnNames.length - 1 != this.columnOrder.size()) {
            this.columnOrder.clear();
            return;
        }
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            String columnName = columnNames[i];
            int columnIndex = this.table.getColumnModel().getColumnIndex(columnName);
            Integer targetColumnIndex = this.columnOrder.get(String.valueOf(i));
            if (targetColumnIndex == null || targetColumnIndex < 0 || targetColumnIndex >= this.table.getColumnCount()) continue;
            this.table.moveColumn(columnIndex, targetColumnIndex);
        }
        this.restoreColumnWidth();
        this.table.setStoreColumnOrder(true);
    }

    private List<TierImpl> getLinkedTiersOfType(TierImpl refTier, String type) {
        List<TierImpl> childTiers = refTier.getChildTiers();
        ArrayList<TierImpl> linkedTiers = new ArrayList<TierImpl>();
        for (int i = 0; i < childTiers.size(); ++i) {
            TierImpl childTier = childTiers.get(i);
            if (childTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
            if (childTier.getLinguisticType().getLinguisticTypeName().equals(type)) {
                linkedTiers.add(childTier);
            }
            List<TierImpl> dependentTiers = childTier.getDependentTiers();
            for (int y = 0; y < dependentTiers.size(); ++y) {
                TierImpl dependantTier = dependentTiers.get(y);
                if (!dependantTier.getLinguisticType().getLinguisticTypeName().equals(type)) continue;
                linkedTiers.add(dependantTier);
            }
        }
        return linkedTiers;
    }

    public void loadTable() {
        this.commitTableChanges();
        this.table.getSelectionModel().removeListSelectionListener(this);
        this.table.clearRows();
        List<Object> tiers = new ArrayList();
        ArrayList<TierImpl> parentTierListType = new ArrayList<TierImpl>();
        ArrayList<AbstractAnnotation> annotationsList = new ArrayList<AbstractAnnotation>();
        if (this.columnTypeList == null || this.columnTypeList.size() < 1) {
            return;
        }
        tiers = ((TranscriptionImpl)this.viewerManager.getTranscription()).getTiersWithLinguisticType(this.columnTypeList.get(0));
        ArrayList<String> types = new ArrayList<String>();
        for (int i = 0; i < this.columnTypeList.size(); ++i) {
            if (types.contains(this.columnTypeList.get(i))) continue;
            types.add(this.columnTypeList.get(i));
        }
        if (tiers != null && tiers.size() > 0) {
            int i;
            TierImpl tier;
            int x;
            TierImpl tierC1 = (TierImpl)tiers.get(0);
            if (tierC1.getLinguisticType().getConstraints() != null && tierC1.getLinguisticType().getConstraints().getStereoType() == 4) {
                for (x = 0; x < tiers.size(); ++x) {
                    TierImpl parentTier;
                    tier = (TierImpl)tiers.get(x);
                    for (parentTier = tier.getParentTier(); parentTier != null && parentTier.getLinguisticType().getConstraints() != null && parentTier.getLinguisticType().getConstraints().getStereoType() == 4; parentTier = parentTier.getParentTier()) {
                    }
                    if (parentTierListType.contains(parentTier) || this.hiddenTiersList.contains(parentTier.getName())) continue;
                    parentTierListType.add(parentTier);
                    List<TierImpl> linkedTiers = this.tierMap.get(parentTier);
                    ArrayList<TierImpl> matchedTiersType = new ArrayList<TierImpl>();
                    if (linkedTiers != null) {
                        if (linkedTiers.size() < this.columnTypeList.size()) {
                            for (i = linkedTiers.size(); i < this.columnTypeList.size(); ++i) {
                                linkedTiers.add(null);
                            }
                        } else if (linkedTiers.size() > this.columnTypeList.size()) {
                            for (i = linkedTiers.size(); i > this.columnTypeList.size(); --i) {
                                linkedTiers.remove(i - 1);
                            }
                        }
                    } else {
                        linkedTiers = new ArrayList<TierImpl>();
                        for (i = 0; i < this.columnTypeList.size(); ++i) {
                            linkedTiers.add(null);
                        }
                    }
                    for (int c = 0; c < types.size(); ++c) {
                        matchedTiersType.clear();
                        matchedTiersType.addAll(this.getLinkedTiersOfType(parentTier, (String)types.get(c)));
                        if (types.size() != this.columnTypeList.size()) {
                            for (int i2 = c; i2 < this.columnTypeList.size(); ++i2) {
                                if (!this.columnTypeList.get(i2).equals(types.get(c))) continue;
                                if (linkedTiers.get(i2) == null || !matchedTiersType.contains(linkedTiers.get(i2))) {
                                    if (matchedTiersType.size() >= 1) {
                                        linkedTiers.set(i2, (TierImpl)matchedTiersType.get(0));
                                        matchedTiersType.remove(matchedTiersType.get(0));
                                        continue;
                                    }
                                    linkedTiers.set(i2, null);
                                    continue;
                                }
                                if (!matchedTiersType.contains(linkedTiers.get(i2))) continue;
                                matchedTiersType.remove(linkedTiers.get(i2));
                            }
                            continue;
                        }
                        int index = this.columnTypeList.indexOf(this.columnTypeList.get(c));
                        if (linkedTiers.get(index) == null || !matchedTiersType.contains(linkedTiers.get(index))) {
                            if (matchedTiersType.size() >= 1) {
                                linkedTiers.set(index, (TierImpl)matchedTiersType.get(0));
                                matchedTiersType.remove(matchedTiersType.get(0));
                                continue;
                            }
                            linkedTiers.set(index, null);
                            continue;
                        }
                        if (!matchedTiersType.contains(linkedTiers.get(index))) continue;
                        matchedTiersType.remove(linkedTiers.get(index));
                    }
                    this.tierMap.put(parentTier, linkedTiers);
                }
            } else {
                for (x = 0; x < tiers.size(); ++x) {
                    int i3;
                    tier = (TierImpl)tiers.get(x);
                    if (this.hiddenTiersList.contains(tier.getName())) continue;
                    parentTierListType.add(tier);
                    List<TierImpl> linkedTiers = this.tierMap.get(tier);
                    ArrayList<TierImpl> matchedTiersType = new ArrayList<TierImpl>();
                    if (linkedTiers != null) {
                        if (linkedTiers.size() < this.columnTypeList.size()) {
                            for (i3 = linkedTiers.size(); i3 < this.columnTypeList.size(); ++i3) {
                                linkedTiers.add(null);
                            }
                        } else if (linkedTiers.size() > this.columnTypeList.size()) {
                            for (i3 = linkedTiers.size(); i3 > this.columnTypeList.size(); --i3) {
                                linkedTiers.remove(i3 - 1);
                            }
                        }
                    } else {
                        linkedTiers = new ArrayList<TierImpl>();
                        for (i3 = 0; i3 < this.columnTypeList.size(); ++i3) {
                            linkedTiers.add(null);
                        }
                    }
                    linkedTiers.set(0, tier);
                    for (int c = 1; c < types.size(); ++c) {
                        matchedTiersType.clear();
                        matchedTiersType.addAll(this.getLinkedTiersOfType(tier, (String)types.get(c)));
                        if (types.size() != this.columnTypeList.size()) {
                            for (i = c; i < this.columnTypeList.size(); ++i) {
                                if (!this.columnTypeList.get(i).equals(types.get(c))) continue;
                                if (linkedTiers.get(i) == null || !matchedTiersType.contains(linkedTiers.get(i))) {
                                    if (matchedTiersType.size() >= 1) {
                                        linkedTiers.set(i, (TierImpl)matchedTiersType.get(0));
                                        matchedTiersType.remove(matchedTiersType.get(0));
                                        continue;
                                    }
                                    linkedTiers.set(i, null);
                                    continue;
                                }
                                if (!matchedTiersType.contains(linkedTiers.get(i))) continue;
                                matchedTiersType.remove(linkedTiers.get(i));
                            }
                            continue;
                        }
                        int index = this.columnTypeList.indexOf(this.columnTypeList.get(c));
                        if (linkedTiers.get(index) == null || !matchedTiersType.contains(linkedTiers.get(index))) {
                            if (matchedTiersType.size() >= 1) {
                                linkedTiers.set(index, (TierImpl)matchedTiersType.get(0));
                                matchedTiersType.remove(matchedTiersType.get(0));
                                continue;
                            }
                            linkedTiers.set(index, null);
                            continue;
                        }
                        if (!matchedTiersType.contains(linkedTiers.get(index))) continue;
                        matchedTiersType.remove(linkedTiers.get(index));
                    }
                    this.tierMap.put(tier, linkedTiers);
                }
            }
        }
        for (int x = 0; x < parentTierListType.size(); ++x) {
            TierImpl tier = (TierImpl)parentTierListType.get(x);
            if (tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 4 || this.tierMap.get(tier) == null) continue;
            annotationsList.addAll(tier.getAnnotations());
        }
        if (this.columnTypeList != null && this.columnTypeList.size() >= 1 && annotationsList.size() == 0 && this.hiddenTiersList.size() == 0) {
            String message = ElanLocale.getString("TranscriptionManager.Message.NoSegments");
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.viewerManager.getTranscription()), message, ElanLocale.getString("Message.Warning"), 2);
            return;
        }
        AnnotationComparator annComparator = new AnnotationComparator();
        Collections.sort(annotationsList, annComparator);
        HashMap annotationMap = new HashMap();
        for (int i = 0; i < annotationsList.size(); ++i) {
            AbstractAnnotation ann = (AbstractAnnotation)annotationsList.get(i);
            TierImpl parentTier = (TierImpl)ann.getTier();
            List<TierImpl> linkedTiers = this.tierMap.get(parentTier);
            ArrayList<Object> linkedAnn = new ArrayList<Object>();
            for (int y = 0; y < linkedTiers.size(); ++y) {
                linkedAnn.add(this.getLinkedAnnotation(ann, linkedTiers.get(y)));
            }
            annotationMap.put(ann, linkedAnn);
        }
        Annotation activeAnn = null;
        if (this.viewerManager.getActiveAnnotation() != null) {
            activeAnn = this.viewerManager.getActiveAnnotation().getAnnotation();
        }
        int n = 0;
        String tierName = null;
        String parentTierName = null;
        int rowIndex = -1;
        TranscriptionTableModel tableModel = (TranscriptionTableModel)this.table.getModel();
        for (int i = 0; i < annotationsList.size(); ++i) {
            Annotation ann = (Annotation)annotationsList.get(i);
            List objList = (List)annotationMap.get(ann);
            List<TierImpl> tierList = this.tierMap.get(ann.getTier());
            if (this.showTierNames) {
                if (i == 0) {
                    parentTierName = ann.getTier().getName();
                    tableModel.addRow(new Object[]{new TableSubHeaderObject("")});
                    ++rowIndex;
                } else if (!parentTierName.equals(ann.getTier().getName())) {
                    tableModel.addRow(new Object[]{new TableSubHeaderObject("")});
                    ++rowIndex;
                }
            }
            tableModel.addRow(new Object[]{++n});
            ++rowIndex;
            for (int x = 0; x < objList.size(); ++x) {
                Object obj = objList.get(x);
                TierImpl tier = tierList.get(x);
                if (tier != null) {
                    tierName = tier.getName();
                    this.checkColorForTier(tierName);
                } else {
                    tierName = null;
                }
                if (this.showTierNames) {
                    if (i == 0) {
                        parentTierName = ann.getTier().getName();
                        tableModel.setValueAt(new TableSubHeaderObject(tierName), rowIndex - 1, x + 1);
                    } else if (!parentTierName.equals(ann.getTier().getName())) {
                        tableModel.setValueAt(new TableSubHeaderObject(tierName), rowIndex - 1, x + 1);
                    }
                }
                tableModel.setValueAt(obj, rowIndex, x + 1);
                if (activeAnn == null || !(obj instanceof Annotation) || !activeAnn.equals(obj)) continue;
                Preferences.set("TranscriptionTable.LastActiveRow", rowIndex, this.viewerManager.getTranscription());
                Preferences.set("TranscriptionTable.LastActiveColumn", tableModel.getColumnName(x + 1), this.viewerManager.getTranscription());
            }
            parentTierName = ann.getTier().getName();
        }
        if (n > 999) {
            this.table.getColumnModel().getColumn(0).setMaxWidth(50);
            this.table.getColumnModel().getColumn(0).setMinWidth(50);
        } else if (n > 99) {
            this.table.getColumnModel().getColumn(0).setMaxWidth(45);
            this.table.getColumnModel().getColumn(0).setMinWidth(45);
        } else if (n < 100) {
            this.table.getColumnModel().getColumn(0).setMinWidth(40);
            this.table.getColumnModel().getColumn(0).setMaxWidth(40);
        }
        this.restorePrefferedOrder();
        this.table.reCalculateRowHeight();
        this.table.revalidate();
        this.table.requestFocusInWindow();
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setStoreColumnOrder(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getLinkedAnnotation(AbstractAnnotation refAnnotation, TierImpl tier) {
        Annotation annotation = null;
        if (tier == null) return new AnnotationCellPlaceholder(false, null, refAnnotation.getBeginTimeBoundary(), refAnnotation.getEndTimeBoundary());
        if (!tier.hasParentTier() || tier.getLinguisticType().getConstraints().getStereoType() != 4) return refAnnotation;
        Tier refTier = refAnnotation.getTier();
        List<Annotation> childAnnotations = refAnnotation.getParentListeners();
        TierImpl parentTier = tier.getParentTier();
        if (parentTier != refTier) {
            AbstractAnnotation parentAnn = (AbstractAnnotation)parentTier.getAnnotationAtTime(refAnnotation.getBeginTimeBoundary());
            if (parentAnn == null) return new AnnotationCellPlaceholder(false, tier.getName(), refAnnotation.getBeginTimeBoundary(), refAnnotation.getEndTimeBoundary());
            childAnnotations = parentAnn.getParentListeners();
            for (int j = 0; j < childAnnotations.size(); ++j) {
                if (childAnnotations.get(j).getTier() != tier) continue;
                annotation = childAnnotations.get(j);
                break;
            }
        } else {
            for (int j = 0; j < childAnnotations.size(); ++j) {
                if (childAnnotations.get(j).getTier() != tier) continue;
                annotation = childAnnotations.get(j);
                break;
            }
        }
        if (annotation != null) return annotation;
        return new AnnotationCellPlaceholder(true, tier.getName(), refAnnotation.getBeginTimeBoundary(), refAnnotation.getEndTimeBoundary());
    }

    private void checkColorForTier(String tierName) {
        Color c = this.table.getFontColorForTier(tierName);
        if (c == null) {
            TierImpl tier = (TierImpl)this.viewerManager.getTranscription().getTierWithId(tierName);
            if (tier.hasParentTier()) {
                TierImpl parentTier = tier.getParentTier();
                c = this.table.getFontColorForTier(parentTier.getName());
                if (c == null) {
                    this.setColorForTier(parentTier.getName());
                } else {
                    HashMap<String, Color> map = new HashMap<String, Color>();
                    map.put(tierName, c);
                    this.table.setFontColorForTiers(map);
                }
            } else {
                this.setColorForTier(tierName);
            }
        } else {
            this.tierColorsList.add(c);
        }
    }

    private void setColorForTier(String tierName) {
        int b;
        int g;
        int r;
        Color c;
        while ((c = new Color(r = (int)(Math.random() * 255.0), g = (int)(Math.random() * 255.0), b = (int)(Math.random() * 255.0))) == Color.BLACK || c == Color.WHITE || c == new Color(238, 238, 238) || c == TranscriptionTableCellRenderer.NO_ANN_BG || this.tierColorsList.contains(c)) {
        }
        this.tierColorsList.add(c);
        HashMap<String, Color> map = new HashMap<String, Color>();
        map.put(tierName, c);
        this.table.setFontColorForTiers(map);
    }

    public void updateSignalViewer(SignalViewer viewer) {
        if (viewer != null) {
            this.signalViewer = viewer;
            this.signalViewer.setRecalculateInterval(false);
            if (this.table.isEditing()) {
                this.signalViewer.setEnabled(true);
                Object obj = this.table.getValueAt(this.table.getCurrentRow(), this.table.getCurrentColumn());
                if (obj instanceof Annotation) {
                    long begin = ((Annotation)obj).getBeginTimeBoundary();
                    long end = ((Annotation)obj).getEndTimeBoundary();
                    this.updateMedia(begin, end);
                }
            }
        }
    }

    public void updateMedia(long begin, long end) {
        this.clearSelection();
        if (this.viewerManager.getMasterMediaPlayer() != null) {
            if (this.layoutManager.getTranscriptionModePlayerController().getLoopMode()) {
                this.layoutManager.getTranscriptionModePlayerController().stopLoop();
            }
            if (this.viewerManager.getMasterMediaPlayer().isPlaying()) {
                this.viewerManager.getMasterMediaPlayer().stop();
            }
            this.viewerManager.getMasterMediaPlayer().setMediaTime(begin);
        }
        if (this.signalViewer != null && this.signalViewer.isLoadTranscriptionMode()) {
            this.signalViewer.updateInterval(begin, end);
        }
        this.layoutManager.getTranscriptionModePlayerController().getSelectionPanel().setBegin(begin);
        this.layoutManager.getTranscriptionModePlayerController().getSelectionPanel().setEnd(end);
    }

    public void playMedia() {
        if (this.table.isEditing()) {
            this.table.getEditorComponent().requestFocusInWindow();
            Annotation ann = (Annotation)this.table.getValueAt(this.table.getEditingRow(), this.table.getEditingColumn());
            this.playInterval(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
        } else {
            if (this.table.getSelectedRow() > -1 && this.table.getSelectedColumn() > -1) {
                Annotation ann = (Annotation)this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
                long mediaTime = this.getMediaTime();
                if (mediaTime > ann.getBeginTimeBoundary() + 5L && mediaTime < ann.getEndTimeBoundary() - 5L) {
                    this.playInterval(mediaTime, ann.getEndTimeBoundary());
                } else {
                    this.updateMedia(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
                    this.playInterval(ann.getBeginTimeBoundary(), ann.getEndTimeBoundary());
                }
            }
            this.table.requestFocusInWindow();
        }
    }

    public void playSelection() {
        Selection sel = this.viewerManager.getSelection();
        if (sel != null && sel.getBeginTime() != sel.getEndTime()) {
            Component editorComponent = this.table.getEditorComponent();
            if (editorComponent != null) {
                editorComponent.requestFocusInWindow();
            }
            this.playInterval(sel.getBeginTime(), sel.getEndTime());
        }
    }

    private boolean isValidMediaTime(long beginTime, long endTime) {
        long mediaTime = this.viewerManager.getMasterMediaPlayer().getMediaTime();
        if (mediaTime < beginTime) {
            return false;
        }
        return mediaTime <= endTime;
    }

    public void goToOnepixelForwardOrBackward(String commandName, long beginTime, long endTime) {
        long mediaTime = this.viewerManager.getMasterMediaPlayer().getMediaTime();
        Command c = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), commandName);
        Object[] args = new Object[]{this.viewerManager.getTimeScale()};
        c.execute(this.viewerManager.getMasterMediaPlayer(), args);
        if (!this.isValidMediaTime(beginTime, endTime)) {
            this.viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
        }
    }

    public void goToPreviousOrNextFrame(String commandName, long beginTime, long endTime) {
        long mediaTime = this.viewerManager.getMasterMediaPlayer().getMediaTime();
        Command c = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), commandName);
        c.execute(this.viewerManager.getMasterMediaPlayer(), null);
        if (!this.isValidMediaTime(beginTime, endTime)) {
            this.viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
        }
    }

    public void goToOneSecondForwardOrBackward(String commandName, long beginTime, long endTime) {
        long mediaTime = this.viewerManager.getMasterMediaPlayer().getMediaTime();
        Command c = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), commandName);
        c.execute(this.viewerManager.getMasterMediaPlayer(), null);
        if (!this.isValidMediaTime(beginTime, endTime)) {
            this.viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
        }
    }

    public void playAroundSelection(long beginTime, long endTime) {
        Selection s = this.viewerManager.getSelection();
        if (s != null) {
            long selBeginTime = s.getBeginTime();
            long selEndTime = s.getEndTime();
            boolean timeChanged = false;
            if (s.getBeginTime() != s.getEndTime()) {
                if (selBeginTime < beginTime) {
                    selBeginTime = beginTime;
                    timeChanged = true;
                }
                if (selEndTime > endTime) {
                    selBeginTime = endTime;
                    timeChanged = true;
                }
                if (timeChanged) {
                    s.setSelection(selBeginTime, selEndTime);
                }
                if (selBeginTime < selEndTime && selBeginTime >= beginTime && selEndTime <= endTime) {
                    beginTime = selBeginTime;
                    endTime = selEndTime;
                }
            }
        }
        if ((beginTime -= (long)this.playAroundSelection) < 0L) {
            beginTime = 0L;
        }
        if ((endTime += (long)this.playAroundSelection) > this.viewerManager.getMasterMediaPlayer().getMediaDuration()) {
            endTime = this.viewerManager.getMasterMediaPlayer().getMediaDuration();
        }
        this.playInterval(beginTime, endTime);
    }

    public void playIntervalFromBeginTime(long beginTime, long endTime) {
        if (beginTime == endTime) {
            return;
        }
        if (!this.layoutManager.isInitialized()) {
            return;
        }
        if (this.viewerManager.getMasterMediaPlayer() == null) {
            return;
        }
        if (this.viewerManager.getMasterMediaPlayer().isPlaying()) {
            this.viewerManager.getMasterMediaPlayer().stop();
            this.layoutManager.getTranscriptionModePlayerController().stopLoop();
            return;
        }
        this.viewerManager.getMasterMediaPlayer().playInterval(beginTime, endTime);
    }

    @Override
    public void stopPlayer() {
        if (this.viewerManager.getMasterMediaPlayer() == null && this.viewerManager.getMasterMediaPlayer().isPlaying()) {
            return;
        }
        this.viewerManager.getMasterMediaPlayer().stop();
        this.layoutManager.getTranscriptionModePlayerController().stopLoop();
    }

    @Override
    public void playInterval(long beginTime, long endTime) {
        if (beginTime == endTime) {
            return;
        }
        if (!this.layoutManager.isInitialized()) {
            return;
        }
        if (this.viewerManager.getMasterMediaPlayer() == null) {
            return;
        }
        boolean isPlaying = this.viewerManager.getMasterMediaPlayer().isPlaying();
        if (isPlaying) {
            this.viewerManager.getMasterMediaPlayer().stop();
            this.layoutManager.getTranscriptionModePlayerController().stopLoop();
            return;
        }
        long mediaTime = this.viewerManager.getMasterMediaPlayer().getMediaTime();
        if (!isPlaying && mediaTime > beginTime && mediaTime < endTime - 5L) {
            this.viewerManager.getMasterMediaPlayer().playInterval(mediaTime, endTime);
            if (this.layoutManager.getTranscriptionModePlayerController().getLoopMode()) {
                this.delayedStartLoop(beginTime, endTime);
            }
            return;
        }
        if (this.layoutManager.getTranscriptionModePlayerController().getLoopMode()) {
            this.layoutManager.getTranscriptionModePlayerController().startLoop(beginTime, endTime);
        } else {
            this.viewerManager.getMasterMediaPlayer().playInterval(beginTime, endTime);
        }
    }

    public void clearSelection() {
        Selection sel = this.viewerManager.getSelection();
        if (sel != null && (sel.getBeginTime() != 0L || sel.getEndTime() != 0L)) {
            sel.clear();
            if (this.signalViewer != null) {
                this.signalViewer.updateSelection();
            }
        }
    }

    void mergeBeforeAnn(Annotation annotation) {
        if (this.viewerManager.getMasterMediaPlayer() != null && this.viewerManager.getMasterMediaPlayer().isPlaying()) {
            this.viewerManager.getMasterMediaPlayer().stop();
        }
        this.setPreference("TranscriptionTable.LastActiveRow", this.table.getCurrentRow() - 1, this.viewerManager.getTranscription());
        this.setPreference("TranscriptionTable.LastActiveColumn", this.table.getColumnName(this.table.getCurrentColumn()), this.viewerManager.getTranscription());
        Transcription transcription = annotation.getTier().getTranscription();
        Command c = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.MergeWithBefore");
        Object[] args = new Object[]{annotation, false};
        c.execute(transcription, args);
    }

    void mergeNextAnn(Annotation annotation) {
        if (this.viewerManager.getMasterMediaPlayer() != null && this.viewerManager.getMasterMediaPlayer().isPlaying()) {
            this.viewerManager.getMasterMediaPlayer().stop();
        }
        this.setPreference("TranscriptionTable.LastActiveRow", this.table.getCurrentRow(), this.viewerManager.getTranscription());
        this.setPreference("TranscriptionTable.LastActiveColumn", this.table.getColumnName(this.table.getCurrentColumn()), this.viewerManager.getTranscription());
        Command c = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "Menu.Annotation.MergeWithNext");
        Object[] args = new Object[]{annotation, true};
        c.execute(this.viewerManager.getTranscription(), args);
    }

    void deleteAnnotation(Annotation annotation) {
        int leadColumn;
        int leadRow;
        if (this.viewerManager.getMasterMediaPlayer() != null && this.viewerManager.getMasterMediaPlayer().isPlaying()) {
            this.viewerManager.getMasterMediaPlayer().stop();
        }
        if (this.table.getValueAt(leadRow = this.table.getSelectionModel().getLeadSelectionIndex(), leadColumn = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex()) instanceof TableSubHeaderObject) {
            return;
        }
        Transcription transcription = annotation.getTier().getTranscription();
        Command c = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.DeleteAnnotation");
        Object[] args = new Object[]{this.viewerManager, annotation};
        c.execute(annotation.getTier(), args);
    }

    public void updateTable() {
        Integer lastActiveRow = Preferences.getInt("TranscriptionTable.LastActiveRow", this.viewerManager.getTranscription());
        String lastActiveColumnName = Preferences.getString("TranscriptionTable.LastActiveColumn", this.viewerManager.getTranscription());
        int lastActiveColumn = -1;
        if (lastActiveRow != null && lastActiveColumnName != null) {
            int i = this.tableModel.findColumn(lastActiveColumnName);
            if (i >= 0) {
                lastActiveColumn = this.table.getColumnModel().getColumnIndex(lastActiveColumnName);
            }
            if (lastActiveRow > -1 && lastActiveColumn > -1) {
                this.table.changeSelection(lastActiveRow, lastActiveColumn, false, false);
                this.table.scrollIfNeeded();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int currentRow = this.table.getSelectionModel().getLeadSelectionIndex();
        int currentColumn = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        String selColumnId = "";
        if (currentColumn > -1) {
            selColumnId = (String)this.table.getColumnModel().getColumn(currentColumn).getIdentifier();
        }
        this.setPreference("TranscriptionTable.LastActiveRow", currentRow, this.viewerManager.getTranscription());
        this.setPreference("TranscriptionTable.LastActiveColumn", selColumnId, this.viewerManager.getTranscription());
        if (currentRow > -1 && currentColumn > -1) {
            Object obj = null;
            if (this.table.getRowCount() > currentRow) {
                obj = this.table.getValueAt(currentRow, currentColumn);
            }
            if (obj instanceof Annotation || obj instanceof AnnotationCellPlaceholder) {
                this.layoutManager.getTranscriptionModePlayerController().enableButtons(true);
                if (this.signalViewer != null) {
                    this.signalViewer.setEnabled(true);
                }
            } else {
                this.layoutManager.getTranscriptionModePlayerController().enableButtons(false);
                if (this.signalViewer != null) {
                    this.signalViewer.setEnabled(false);
                }
                this.updateMedia(0L, 0L);
            }
        }
    }

    public void reValidateTable() {
        this.table.repaint();
    }

    public void loadPreferences() {
        Map<String, Integer> newColumnWidth;
        Map<String, Integer> newColumnOrder = Preferences.getMapOfInt("TranscriptionTable.ColumnOrder", this.viewerManager.getTranscription());
        if (newColumnOrder != null) {
            if (this.columnOrder == null) {
                this.columnOrder = new HashMap<String, Integer>();
            }
            for (String key : newColumnOrder.keySet()) {
                Integer value = newColumnOrder.get(key);
                if (key.length() > 1) {
                    this.columnOrder.put(key.substring(key.length() - 1), value);
                    continue;
                }
                this.columnOrder.put(key, value);
            }
        }
        if ((newColumnWidth = Preferences.getMapOfInt("TranscriptionTable.ColumnWidth", this.viewerManager.getTranscription())) != null) {
            if (this.columnWidth == null) {
                this.columnWidth = new HashMap<String, Integer>();
            }
            for (String key : newColumnWidth.keySet()) {
                Integer value = newColumnWidth.get(key);
                if (key.length() > 1) {
                    this.columnWidth.put(key.substring(key.length() - 1), value);
                    continue;
                }
                this.columnWidth.put(key, value);
            }
        }
    }

    public List<KeyStroke> getKeyStrokeList() {
        return this.keyStrokesList;
    }

    public void shortcutsChanged() {
        TranscriptionTableEditBox editBox;
        this.keyStrokesList.clear();
        for (KeyStroke ks : ShortcutsUtil.getInstance().getShortcutKeysOnlyIn("Menu.Options.TranscriptionMode").values()) {
            if (ks == null) continue;
            this.keyStrokesList.add(ks);
        }
        TranscriptionTableCellEditor editor = (TranscriptionTableCellEditor)this.table.getDefaultEditor(Object.class);
        if (editor != null && (editBox = editor.getEditorComponent()) != null) {
            editBox.updateShortCuts();
        }
    }

    @Override
    public void isClosing() {
        if (this.table.isEditing()) {
            TranscriptionTableCellEditor editor = (TranscriptionTableCellEditor)this.table.getCellEditor(this.table.getCurrentRow(), this.table.getCurrentColumn());
            editor.commitChanges();
        }
        this.storePreferences();
    }

    private void storePreferences() {
        this.storeColumnWidth();
        this.setPreference("TranscriptionTable.ColumnTypes", this.columnTypeList, this.viewerManager.getTranscription());
        this.setPreference("TranscriptionMode.Temp.TierColors", this.table.getFontColorTierMap(), this.viewerManager.getTranscription());
        this.setPreference("TranscriptionTable.TierMap", this.changeToStorableMap(this.tierMap), this.viewerManager.getTranscription());
        this.setPreference("TranscriptionTable.HiddenTiers", this.hiddenTiersList, this.viewerManager.getTranscription());
        this.setPreference("TranscriptionTable.NonEditableTiers", this.nonEditableTiersList, this.viewerManager.getTranscription());
    }

    private Map<String, List<String>> changeToStorableMap(Map<TierImpl, List<TierImpl>> map) {
        if (map != null) {
            HashMap<String, List<String>> newMap = new HashMap<String, List<String>>();
            List<TierImpl> tierList = null;
            ArrayList<String> tierNamesList = null;
            for (TierImpl keyObj : map.keySet()) {
                tierList = map.get(keyObj);
                tierNamesList = new ArrayList<String>();
                for (int i = 0; i < tierList.size(); ++i) {
                    TierImpl tier = tierList.get(i);
                    if (tier == null) {
                        tierNamesList.add("No tier");
                        continue;
                    }
                    tierNamesList.add(tier.getName());
                }
                newMap.put(keyObj.getName(), tierNamesList);
            }
            return newMap;
        }
        return null;
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StopEvent) {
            this.layoutManager.getTranscriptionModePlayerController().setPlayingState(false);
        }
        if (event instanceof StartEvent) {
            this.layoutManager.getTranscriptionModePlayerController().setPlayingState(true);
        }
    }

    private void validateColumns() {
        Iterator<List<TierImpl>> it;
        ArrayList<Integer> nullValueIndex = new ArrayList<Integer>();
        for (int i = 0; i < this.columnTypeList.size(); ++i) {
            int numberofnullValues = 0;
            it = this.tierMap.values().iterator();
            while (it.hasNext()) {
                if (it.next().get(i) != null) continue;
                ++numberofnullValues;
            }
            if (numberofnullValues != this.tierMap.size()) continue;
            nullValueIndex.add(i);
        }
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(this.columnTypeList);
        for (int i = nullValueIndex.size() - 1; i >= 0; --i) {
            int index = (Integer)nullValueIndex.get(i);
            types.remove(index);
            it = this.tierMap.values().iterator();
            while (it.hasNext()) {
                it.next().remove(index);
            }
        }
        int columnwidth0 = this.table.getColumnModel().getColumn(0).getPreferredWidth();
        if (nullValueIndex.size() > 0) {
            this.setColumnTypeList(types);
            for (List<TierImpl> tierList : this.tierMap.values()) {
                for (int i = nullValueIndex.size() - 1; i >= 0; --i) {
                    tierList.remove(nullValueIndex.get(i));
                }
            }
            this.table.getColumnModel().getColumn(0).setMinWidth(columnwidth0);
            this.table.getColumnModel().getColumn(0).setMaxWidth(columnwidth0);
            this.table.repaint();
        }
    }

    private void deleteRowAndUpdateTable(int rowIndex) {
        Object rowVal;
        Object val;
        if (this.showTierNames && rowIndex >= 1 && (val = this.table.getValueAt(rowIndex - 1, 1)) instanceof TableSubHeaderObject) {
            if (rowIndex + 1 < this.table.getRowCount()) {
                val = this.table.getValueAt(rowIndex + 1, 1);
                if (val instanceof TableSubHeaderObject) {
                    ((DefaultTableModel)this.table.getModel()).removeRow(rowIndex - 1);
                    String tierName = null;
                    for (int index = --rowIndex - 1; index >= 0; --index) {
                        Object value = this.table.getValueAt(index, 1);
                        if (!(value instanceof TableSubHeaderObject)) continue;
                        tierName = value.toString();
                        break;
                    }
                    if (val.toString().equals(tierName)) {
                        ((DefaultTableModel)this.table.getModel()).removeRow(rowIndex + 1);
                    }
                }
            } else {
                ((DefaultTableModel)this.table.getModel()).removeRow(rowIndex - 1);
                --rowIndex;
            }
        }
        int n = -1;
        if (rowIndex == 0) {
            rowVal = this.table.getValueAt(rowIndex, 0);
            if (rowVal instanceof Integer) {
                n = (Integer)rowVal - 1;
            }
        } else {
            rowVal = this.table.getValueAt(rowIndex - 1, 0);
            if (rowVal instanceof Integer) {
                n = (Integer)rowVal;
            } else {
                rowVal = this.table.getValueAt(rowIndex, 0);
                if (rowVal instanceof Integer) {
                    n = (Integer)rowVal - 1;
                }
            }
        }
        ((DefaultTableModel)this.table.getModel()).removeRow(rowIndex);
        if (n == -1 && ClientLogger.LOG.isLoggable(Level.WARNING)) {
            ClientLogger.LOG.warning("Unexpected row index at: " + rowIndex);
        }
        this.updateRowIndicesStartingAt(rowIndex);
    }

    private void insertRowAndUpdateTable(Annotation addedAnn) {
        if (addedAnn == null) {
            return;
        }
        String typeName = addedAnn.getTier().getLinguisticType().getLinguisticTypeName();
        int annColumnModel = this.tableModel.findColumn(typeName);
        if (annColumnModel == -1) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine("Cannot insert the annotation, its type is not in the table: " + addedAnn);
            }
            return;
        }
        TierImpl annTier = (TierImpl)addedAnn.getTier();
        if (this.hasAncestorInTable(addedAnn)) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                for (int j = 0; j < this.tableModel.getColumnCount(); ++j) {
                    Object value = this.table.getValueAt(i, j);
                    if (!(value instanceof Annotation)) continue;
                    Annotation other = (Annotation)value;
                    if (other.getBeginTimeBoundary() == addedAnn.getBeginTimeBoundary() && other.getEndTimeBoundary() == addedAnn.getEndTimeBoundary() && annTier.hasAncestor(other.getTier())) {
                        if (j != annColumnModel) {
                            this.table.setValueAt(addedAnn, i, annColumnModel);
                            return;
                        }
                        if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                            ClientLogger.LOG.warning("Cannot insert the annotation, there is already an annotation in the target cell: " + addedAnn);
                        }
                    }
                    if (other.getBeginTimeBoundary() <= addedAnn.getBeginTimeBoundary()) continue;
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning("Cannot insert the annotation, no row with the correct begin and end time was found: " + addedAnn);
                    }
                    return;
                }
            }
        } else {
            Object v;
            int insertRow = -1;
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                Object value = this.tableModel.getValueAt(i, 1);
                long bt = -1L;
                long et = -1L;
                if (value instanceof Annotation) {
                    Annotation other = (Annotation)value;
                    bt = other.getBeginTimeBoundary();
                    et = other.getEndTimeBoundary();
                } else if (value instanceof AnnotationCellPlaceholder) {
                    AnnotationCellPlaceholder cellPH = (AnnotationCellPlaceholder)value;
                    bt = cellPH.bt;
                    et = cellPH.et;
                }
                if (bt > addedAnn.getBeginTimeBoundary()) {
                    insertRow = i;
                    break;
                }
                if (bt != addedAnn.getBeginTimeBoundary()) continue;
                if (et > addedAnn.getEndTimeBoundary()) {
                    insertRow = i;
                    break;
                }
                if (et == addedAnn.getEndTimeBoundary()) {
                    insertRow = i;
                    break;
                }
                insertRow = i + 1;
                break;
            }
            if (insertRow > 0 && (v = this.tableModel.getValueAt(insertRow - 1, 1)) instanceof TableSubHeaderObject) {
                TableSubHeaderObject tsho = (TableSubHeaderObject)v;
                if (!annTier.getName().equals(tsho.getContent())) {
                    --insertRow;
                }
            }
            List<TierImpl> linkedTiers = this.tierMap.get(annTier);
            ArrayList<Object> linkedAnn = new ArrayList<Object>();
            if (linkedTiers != null) {
                for (int y = 0; y < linkedTiers.size(); ++y) {
                    linkedAnn.add(this.getLinkedAnnotation((AbstractAnnotation)addedAnn, linkedTiers.get(y)));
                }
            } else {
                linkedTiers = new ArrayList<TierImpl>(1);
                linkedTiers.add(annTier);
            }
            int rowIndex = -1;
            if (insertRow == -1 || insertRow == this.table.getRowCount()) {
                this.tableModel.addRow(new Object[0]);
                this.tableModel.setValueAt(0, this.table.getRowCount() - 1, 0);
                rowIndex = this.table.getRowCount() - 1;
            } else {
                this.tableModel.insertRow(insertRow, new Object[0]);
                this.tableModel.setValueAt(0, insertRow, 0);
                rowIndex = insertRow;
            }
            for (int i = 0; i < linkedAnn.size(); ++i) {
                this.tableModel.setValueAt(linkedAnn.get(i), rowIndex, i + 1);
            }
            if (this.showTierNames) {
                int i;
                List<TierImpl> tierList = linkedTiers;
                int headerRowBefore = -1;
                if (rowIndex == 0) {
                    headerRowBefore = 0;
                } else {
                    for (i = rowIndex - 1; i >= 0; --i) {
                        Object value = this.tableModel.getValueAt(i, annColumnModel);
                        if (!(value instanceof Annotation)) continue;
                        if (annTier.getName().equals(((Annotation)value).getTier().getName())) break;
                        headerRowBefore = i + 1;
                        break;
                    }
                }
                if (headerRowBefore > -1) {
                    this.tableModel.insertRow(headerRowBefore, new Object[]{new TableSubHeaderObject("")});
                    for (i = 0; i < this.tableModel.getColumnCount() - 1; ++i) {
                        if (i < tierList.size()) {
                            TierImpl ti = tierList.get(i);
                            if (ti != null) {
                                this.tableModel.setValueAt(new TableSubHeaderObject(ti.getName()), headerRowBefore, i + 1);
                                continue;
                            }
                            this.tableModel.setValueAt(null, headerRowBefore, i + 1);
                            continue;
                        }
                        this.tableModel.setValueAt(null, headerRowBefore, i + 1);
                    }
                    ++rowIndex;
                }
                int headerRowAfter = -1;
                if (rowIndex < this.tableModel.getRowCount() - 1) {
                    for (int i2 = rowIndex + 1; i2 < this.tableModel.getRowCount(); ++i2) {
                        Object value = this.tableModel.getValueAt(i2, annColumnModel);
                        if (value instanceof Annotation) {
                            if (annTier.getName().equals(((Annotation)value).getTier().getName())) break;
                            headerRowAfter = i2;
                            break;
                        }
                        if (!(value instanceof TableSubHeaderObject)) continue;
                        TableSubHeaderObject tsho = (TableSubHeaderObject)value;
                        if (annTier.getName().equals(tsho.getContent())) continue;
                        headerRowAfter = -1;
                        break;
                    }
                }
                if (headerRowAfter > -1) {
                    Annotation nextAnn = (Annotation)this.tableModel.getValueAt(headerRowAfter, annColumnModel);
                    tierList = this.tierMap.get(nextAnn.getTier());
                    if (tierList == null) {
                        tierList = new ArrayList<TierImpl>(1);
                        tierList.add((TierImpl)nextAnn.getTier());
                    }
                    this.tableModel.insertRow(headerRowAfter, new Object[]{new TableSubHeaderObject("")});
                    for (int i3 = 0; i3 < this.tableModel.getColumnCount() - 1; ++i3) {
                        if (i3 < tierList.size()) {
                            TierImpl ti = tierList.get(i3);
                            if (ti != null) {
                                this.tableModel.setValueAt(new TableSubHeaderObject(ti.getName()), headerRowAfter, i3 + 1);
                                continue;
                            }
                            this.tableModel.setValueAt(null, headerRowAfter, i3 + 1);
                            continue;
                        }
                        this.tableModel.setValueAt(null, headerRowAfter, i3 + 1);
                    }
                }
            }
            this.updateRowIndicesStartingAt(rowIndex);
            this.table.reCalculateRowHeight();
        }
    }

    private void updateRowIndicesStartingAt(int fromRowIndex) {
        Object v;
        int i;
        if (fromRowIndex < 0 || fromRowIndex >= this.tableModel.getRowCount()) {
            return;
        }
        int index = 0;
        if (fromRowIndex > 0) {
            for (i = fromRowIndex - 1; i >= 0; --i) {
                v = this.tableModel.getValueAt(i, 0);
                if (!(v instanceof Integer)) continue;
                index = (Integer)v;
                break;
            }
        }
        for (i = fromRowIndex; i < this.tableModel.getRowCount(); ++i) {
            v = this.tableModel.getValueAt(i, 0);
            if (!(v instanceof Integer)) continue;
            this.tableModel.setValueAt(++index, i, 0);
        }
    }

    private void replaceCellAndUpdateRow(int[] cell, Object replacement) {
        block5: {
            Object curValue;
            block4: {
                curValue = this.tableModel.getValueAt(cell[0], cell[1]);
                this.tableModel.setValueAt(replacement, cell[0], cell[1]);
                if (!(replacement instanceof Annotation)) break block4;
                if (!(curValue instanceof AnnotationCellPlaceholder)) break block5;
                for (int column = cell[1] + 1; column < this.tableModel.getColumnCount(); ++column) {
                    Object cellValue = this.tableModel.getValueAt(cell[0], column);
                    if (!(cellValue instanceof AnnotationCellPlaceholder)) continue;
                    AnnotationCellPlaceholder acph = (AnnotationCellPlaceholder)cellValue;
                    Tier t = this.viewerManager.getTranscription().getTierWithId(acph.tierName);
                    if (t.getParentTier() != ((Annotation)replacement).getTier()) continue;
                    acph.canCreate = true;
                }
                break block5;
            }
            if (replacement instanceof AnnotationCellPlaceholder && curValue instanceof Annotation) {
                for (int column = cell[1] + 1; column < this.tableModel.getColumnCount(); ++column) {
                    Object cellValue = this.tableModel.getValueAt(cell[0], column);
                    if (cellValue instanceof Annotation) {
                        Tier t = ((Annotation)cellValue).getTier();
                        if (!t.hasAncestor(((Annotation)curValue).getTier())) continue;
                        AnnotationCellPlaceholder acph = new AnnotationCellPlaceholder();
                        acph.tierName = t.getName();
                        acph.bt = ((Annotation)cellValue).getBeginTimeBoundary();
                        acph.et = ((Annotation)cellValue).getEndTimeBoundary();
                        acph.canCreate = false;
                        this.tableModel.setValueAt(acph, cell[0], column);
                        continue;
                    }
                    if (!(cellValue instanceof AnnotationCellPlaceholder)) continue;
                    AnnotationCellPlaceholder acph = (AnnotationCellPlaceholder)cellValue;
                    Tier t = this.viewerManager.getTranscription().getTierWithId(acph.tierName);
                    if (!t.getParentTier().getName().equals(((AnnotationCellPlaceholder)replacement).tierName)) continue;
                    acph.canCreate = false;
                }
            }
        }
    }

    private int[] getCellForAnnotation(Annotation ann) {
        if (ann == null) {
            return null;
        }
        String typeName = ann.getTier().getLinguisticType().getLinguisticTypeName();
        String tierName = ann.getTier().getName();
        int annColumn = this.tableModel.findColumn(typeName);
        if (annColumn > -1) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                Object value = this.tableModel.getValueAt(i, annColumn);
                if (value == ann) {
                    return new int[]{i, annColumn};
                }
                if (!(value instanceof AnnotationCellPlaceholder)) continue;
                AnnotationCellPlaceholder acph = (AnnotationCellPlaceholder)value;
                if (!tierName.equals(acph.tierName) || ann.getBeginTimeBoundary() != acph.bt || ann.getEndTimeBoundary() != acph.et) continue;
                return new int[]{i, annColumn};
            }
        }
        return null;
    }

    private boolean hasAncestorInTable(Annotation ann) {
        if (ann == null) {
            return false;
        }
        if (!ann.hasParentAnnotation()) {
            return false;
        }
        int ancestorColumn = -1;
        for (Annotation ancestAnn = ann.getParentAnnotation(); ancestAnn != null && ancestorColumn == -1; ancestAnn = ancestAnn.getParentAnnotation()) {
            String tierName = ancestAnn.getTier().getName();
            if (this.hiddenTiersList.contains(tierName)) continue;
            String parentTypeName = ancestAnn.getTier().getLinguisticType().getLinguisticTypeName();
            ancestorColumn = this.tableModel.findColumn(parentTypeName);
        }
        return ancestorColumn > -1;
    }

    private boolean replaceCellByAddOrRemove(Annotation ann) {
        if (ann == null) {
            return false;
        }
        if (!ann.hasParentAnnotation()) {
            return false;
        }
        String tierName = ann.getTier().getName();
        String typeName = ann.getTier().getLinguisticType().getLinguisticTypeName();
        return !this.hiddenTiersList.contains(tierName) && this.tableModel.findColumn(typeName) > -1;
    }

    void createAnnotation(TierImpl tier, long bt, long et) {
        this.newAnnotationPH = new AnnotationCellPlaceholder(false, tier.getName(), bt, et);
        Command com = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "Menu.Annotation.NewAnnotation");
        if (tier.isTimeAlignable()) {
            com.execute(tier, new Object[]{bt, et});
        } else {
            long time = (bt + et) / 2L;
            com.execute(tier, new Object[]{time, time});
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        int currentRow = this.table.getCurrentRow();
        int currentColumn = this.table.getCurrentColumn();
        block0 : switch (e.getOperation()) {
            case 3: {
                int[] cellRC;
                Annotation addedAnn = (Annotation)e.getModification();
                if (this.replaceCellByAddOrRemove(addedAnn)) {
                    cellRC = this.getCellForAnnotation(addedAnn);
                    if (cellRC != null) {
                        this.replaceCellAndUpdateRow(cellRC, addedAnn);
                    }
                } else {
                    this.insertRowAndUpdateTable(addedAnn);
                }
                if (this.newAnnotationPH == null || addedAnn.getTier().getName() != this.newAnnotationPH.tierName || addedAnn.getBeginTimeBoundary() != this.newAnnotationPH.bt) break;
                cellRC = this.getCellForAnnotation(addedAnn);
                if (cellRC != null) {
                    if (this.table.getCellEditor() != null) {
                        this.table.getCellEditor().cancelCellEditing();
                    }
                    this.table.changeSelection(cellRC[0], cellRC[1], false, false);
                    this.table.startEdit(null);
                }
                this.newAnnotationPH = null;
                break;
            }
            case 7: {
                Annotation beforeAnn;
                Annotation afterAnn;
                Object value;
                int[] cellRC;
                Annotation changedAnn = (Annotation)e.getModification();
                if (changedAnn == null || (cellRC = this.getCellForAnnotation(changedAnn)) == null) break;
                if (cellRC[0] < this.tableModel.getRowCount() - 1 && (value = this.tableModel.getValueAt(cellRC[0] + 1, cellRC[1])) instanceof Annotation && (afterAnn = (Annotation)value).getTier() == changedAnn.getTier() && changedAnn.getBeginTimeBoundary() == afterAnn.getBeginTimeBoundary()) {
                    this.deleteRowAndUpdateTable(cellRC[0] + 1);
                }
                if (cellRC[0] <= 0 || !((value = this.tableModel.getValueAt(cellRC[0] - 1, cellRC[1])) instanceof Annotation) || (beforeAnn = (Annotation)value).getTier() != changedAnn.getTier() || changedAnn.getBeginTimeBoundary() != beforeAnn.getBeginTimeBoundary()) break;
                this.deleteRowAndUpdateTable(cellRC[0] - 1);
                break;
            }
            case 6: {
                int[] cellRC;
                Annotation deletedAnn = (Annotation)e.getModification();
                if (deletedAnn == null || (cellRC = this.getCellForAnnotation(deletedAnn)) == null) break;
                if (this.replaceCellByAddOrRemove(deletedAnn)) {
                    AnnotationCellPlaceholder acph = new AnnotationCellPlaceholder(true, deletedAnn.getTier().getName(), deletedAnn.getBeginTimeBoundary(), deletedAnn.getEndTimeBoundary());
                    this.replaceCellAndUpdateRow(cellRC, acph);
                    break;
                }
                this.deleteRowAndUpdateTable(cellRC[0]);
                break;
            }
            case 8: {
                this.table.repaint();
                break;
            }
            case 14: {
                this.loadTable();
                if (currentRow < this.table.getRowCount()) {
                    this.table.changeSelection(currentRow, currentColumn, false, false);
                    break;
                }
                this.table.changeSelection(this.table.getRowCount() - 1, currentColumn, false, false);
                break;
            }
            case 0: {
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl)) break;
                TierImpl tier = (TierImpl)obj;
                String type = tier.getLinguisticType().getLinguisticTypeName();
                if (this.columnTypeList == null || !this.columnTypeList.contains(type)) break;
                this.loadTable();
                break;
            }
            case 1: {
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl)) break;
                TierImpl tier = (TierImpl)obj;
                String type = tier.getLinguisticType().getLinguisticTypeName();
                if (this.columnTypeList == null || !this.columnTypeList.contains(type)) break;
                for (TierImpl keyObj : this.tierMap.keySet()) {
                    List<TierImpl> tierList = this.tierMap.get(keyObj);
                    if (!tierList.contains(tier)) continue;
                    tierList.set(tierList.indexOf(tier), null);
                    this.loadTable();
                    this.validateColumns();
                    if (currentRow >= this.table.getRowCount()) {
                        currentRow = this.table.getRowCount() - 1;
                    }
                    if (currentColumn >= this.table.getColumnCount()) {
                        currentColumn = this.table.getColumnCount() - 1;
                    }
                    this.table.changeSelection(currentRow, currentColumn, false, false);
                    if (this.table.getEditorComponent() == null) break block0;
                    this.table.getEditorComponent().requestFocusInWindow();
                    break block0;
                }
                break;
            }
            case 2: {
                Object obj = e.getSource();
                if (!(obj instanceof TierImpl)) break;
                TierImpl tier = (TierImpl)obj;
                List<? extends Tier> tiers = this.viewerManager.getTranscription().getTiers();
                if (!tiers.contains(tier)) break;
                this.setPreferredFontAndColorSettings();
                Iterator<TierImpl> keyIt = this.tierMap.keySet().iterator();
                while (keyIt.hasNext()) {
                    List<TierImpl> tierList = this.tierMap.get(keyIt.next());
                    if (tierList == null || !tierList.contains(tier)) continue;
                    this.loadTable();
                    this.validateColumns();
                    if (currentColumn >= this.table.getColumnCount()) {
                        currentColumn = this.table.getColumnCount() - 1;
                    }
                    this.table.changeSelection(currentRow, currentColumn, false, false);
                    if (this.table.getEditorComponent() == null) break block0;
                    this.table.getEditorComponent().requestFocusInWindow();
                    break block0;
                }
                break;
            }
            case 13: {
                Object obj = e.getModification();
                if (!(obj instanceof ControlledVocabulary)) break;
                ControlledVocabulary cv = (ControlledVocabulary)obj;
                if (!this.table.isEditing() || !((TranscriptionTableCellEditor)this.table.getCellEditor()).getEditorComponent().isUsingControlledVocabulary()) break;
                ((TranscriptionTableCellEditor)this.table.getCellEditor()).getEditorComponent().cvChanged(cv);
                break;
            }
            case 11: {
                Object obj = e.getModification();
                String oldName = null;
                for (int i = 0; i < this.columnTypeList.size(); ++i) {
                    if (this.viewerManager.getTranscription().getLinguisticTypeByName(this.columnTypeList.get(i)) != null) continue;
                    oldName = this.columnTypeList.get(i);
                    break;
                }
                if (oldName == null) break;
                String newName = ((LinguisticType)obj).getLinguisticTypeName();
                this.columnTypeList.set(this.columnTypeList.indexOf(oldName), newName);
                String[] identifiers = this.tableModel.getColumnIdentifiers();
                this.tableModel.updateTypeName(oldName, newName);
                for (int i = 0; i < identifiers.length; ++i) {
                    TableColumn tc = this.table.getColumn(identifiers[i]);
                    tc.setIdentifier(identifiers[i]);
                    if (i == 0) {
                        tc.setHeaderValue(ElanLocale.getString("TranscriptionTable.Column.No"));
                        continue;
                    }
                    tc.setHeaderValue(ElanLocale.getString("TranscriptionTable.ColumnPrefix") + " " + i + " : " + identifiers[i]);
                }
                break;
            }
        }
    }

    @Override
    public void updateSelection() {
        Selection s = this.viewerManager.getSelection();
        if (this.table != null) {
            if (this.table.isEditing()) {
                Annotation ann = (Annotation)this.table.getValueAt(this.table.getEditingRow(), this.table.getEditingColumn());
                long beginTime = ann.getBeginTimeBoundary();
                long endTime = ann.getEndTimeBoundary();
                if (s != null && s.getBeginTime() != s.getEndTime()) {
                    if (s.getBeginTime() >= beginTime && s.getEndTime() <= endTime) {
                        return;
                    }
                    if (s.getBeginTime() >= beginTime) {
                        if (this.signalViewer != null) {
                            this.signalViewer.setSelection(s.getBeginTime(), endTime);
                            this.signalViewer.repaint();
                        }
                        return;
                    }
                    if (s.getEndTime() <= endTime) {
                        if (this.signalViewer != null) {
                            this.signalViewer.setSelection(beginTime, s.getEndTime());
                            this.signalViewer.repaint();
                        }
                        return;
                    }
                }
            } else {
                this.table.requestFocusInWindow();
            }
        }
    }

    @Override
    public void updateActiveAnnotation() {
        int[] cellRC;
        if (this.tableModel == null) {
            return;
        }
        Annotation activeAnn = this.getActiveAnnotation();
        if (activeAnn != null && (cellRC = this.getCellForAnnotation(activeAnn)) != null) {
            this.stopPlayer();
            this.commitTableChanges();
            this.table.changeSelection(cellRC[0], cellRC[1], false, false);
            this.table.startEdit(null);
        }
    }

    public void editInAnnotationMode() {
        this.layoutManager.editInAnnotationMode();
    }

    public void setActiveAnnotation() {
        Object val;
        if (this.table.getCurrentRow() < this.table.getRowCount() && this.table.getCurrentColumn() < this.table.getColumnCount() && this.table.getCurrentRow() > 0 && this.table.getCurrentColumn() > 0 && (val = this.table.getValueAt(this.table.getCurrentRow(), this.table.getCurrentColumn())) instanceof Annotation) {
            TierImpl tier = (TierImpl)((Annotation)val).getTier();
            if (tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 4) {
                Annotation parentAnn = ((Annotation)val).getParentAnnotation();
                if (parentAnn != null) {
                    this.setActiveAnnotation(parentAnn);
                } else {
                    this.setActiveAnnotation((Annotation)val);
                }
            } else {
                this.setActiveAnnotation((Annotation)val);
            }
        }
    }

    @Override
    public void updateLocale() {
        if (this.table != null) {
            String[] identifiers = this.tableModel.getColumnIdentifiers();
            for (int i = 0; i < identifiers.length; ++i) {
                TableColumn tc = this.table.getColumn(identifiers[i]);
                if (i == 0) {
                    tc.setHeaderValue(ElanLocale.getString("TranscriptionTable.Column.No"));
                    continue;
                }
                tc.setHeaderValue(ElanLocale.getString("TranscriptionTable.ColumnPrefix") + " " + i + " : " + identifiers[i]);
            }
            this.table.getTableHeader().repaint();
        }
    }

    @Override
    public void preferencesChanged() {
        Integer intPref;
        String stringPref = Preferences.getString("PlayAroundSelection.Mode", null);
        boolean msMode = true;
        if (stringPref != null && "frames".equals(stringPref)) {
            msMode = false;
        }
        if ((intPref = Preferences.getInt("PlayAroundSelection.Value", null)) != null) {
            int playaroundVal = intPref;
            if (!msMode) {
                this.playAroundSelection = playaroundVal = (int)((double)playaroundVal * this.viewerManager.getMasterMediaPlayer().getMilliSecondsPerSample());
            }
        }
    }

    private void delayedStartLoop(long begin, long end) {
        LoopThread loopthread = new LoopThread(begin, end);
        loopthread.start();
    }

    @Override
    public void zoomInStep() {
        int index = this.getFontIndex();
        if (index > -1 && index < Constants.FONT_SIZES.length - 1) {
            this.setFontSize(Constants.FONT_SIZES[index + 1]);
            this.setPreference("TranscriptionTable.FontSize", this.getFontSize(), null);
        }
    }

    @Override
    public void zoomOutStep() {
        int index = this.getFontIndex();
        if (index > 0 && index < Constants.FONT_SIZES.length) {
            this.setFontSize(Constants.FONT_SIZES[index - 1]);
            this.setPreference("TranscriptionTable.FontSize", this.getFontSize(), null);
        }
    }

    private int getFontIndex() {
        int i;
        int curFontSize = this.getFontSize();
        int index = -1;
        for (i = 0; i < Constants.FONT_SIZES.length; ++i) {
            if (Constants.FONT_SIZES[i] != curFontSize) continue;
            index = i;
            break;
        }
        if (index != -1) {
            return index;
        }
        for (i = 0; i < Constants.FONT_SIZES.length - 1; ++i) {
            if (Constants.FONT_SIZES[i] >= curFontSize || curFontSize >= Constants.FONT_SIZES[i + 1]) continue;
            if (curFontSize - Constants.FONT_SIZES[i] < Constants.FONT_SIZES[i + 1] - curFontSize) {
                return i;
            }
            return i + 1;
        }
        return index;
    }

    @Override
    public void zoomToDefault() {
        this.setFontSize(Constants.DEFAULTFONT.getSize());
        this.setPreference("TranscriptionTable.FontSize", this.getFontSize(), null);
    }

    private class AnnotationComparator
    implements Comparator<Annotation> {
        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            Long bt2;
            Long bt1 = o1.getBeginTimeBoundary();
            if (bt1 != (bt2 = Long.valueOf(o2.getBeginTimeBoundary()))) {
                return bt1.compareTo(bt2);
            }
            Long et1 = o1.getEndTimeBoundary();
            Long et2 = o2.getEndTimeBoundary();
            return et1.compareTo(et2);
        }
    }

    private class LoopThread
    extends Thread {
        private long beginTime;
        private long endTime;

        LoopThread(long begin, long end) {
            this.beginTime = begin;
            this.endTime = end;
            this.setName("delayed Loop Thread");
        }

        @Override
        public void run() {
            if (TranscriptionViewer.this.layoutManager.getTranscriptionModePlayerController().getLoopMode()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (TranscriptionViewer.this.viewerManager.getMasterMediaPlayer().isPlaying()) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                TranscriptionViewer.this.layoutManager.getTranscriptionModePlayerController().startLoop(this.beginTime, this.endTime);
            }
        }
    }
}

