/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FontSizer;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TaSCellEditor;
import mpi.eudico.client.annotator.turnsandscenemode.TaSCellPanel;
import mpi.eudico.client.annotator.turnsandscenemode.TaSCellRenderer;
import mpi.eudico.client.annotator.turnsandscenemode.TaSTable;
import mpi.eudico.client.annotator.turnsandscenemode.commands.TaSMergeAction;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class TurnsAndSceneViewer
extends AbstractViewer
implements ACMEditListener,
ListSelectionListener,
FontSizer {
    private TranscriptionImpl transcription;
    private String transTierId = "transcript";
    private TierImpl curTier;
    private List<TaSAnno> segmentList;
    private JScrollPane scrollPane;
    private DefaultTableModel tableModel;
    private TaSTable annoTable;
    private TaSMergeAction mergePreviousMouseAction;
    private TaSMergeAction mergeNextMouseAction;
    private TaSCellPanel editorPanel;
    private TaSCellEditor cellEditor;
    private TaSCellRenderer cellRenderer;
    private JPopupMenu popupMenu;
    private int rowAtMediaTime = -1;
    private int scrollRowToLocation;
    private int primaryFontSize = 16;
    private boolean continuousPlayMode = false;

    public TurnsAndSceneViewer() {
    }

    public TurnsAndSceneViewer(Transcription transcription) {
        this();
        this.transcription = (TranscriptionImpl)transcription;
        this.initComponents();
    }

    public TaSCellPanel getEditor() {
        return this.editorPanel;
    }

    public JTable getAnnotationTable() {
        return this.annoTable;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.tableModel = new DefaultTableModel(0, 1);
        this.annoTable = new TaSTable(this.tableModel);
        this.annoTable.setTableHeader(null);
        this.editorPanel = new TaSCellPanel();
        this.popupMenu = new JPopupMenu();
        this.mergePreviousMouseAction = new TaSMergeAction(this, TaSMergeAction.MERGE_ROW.PREVIOUS);
        this.mergePreviousMouseAction.putValue("Name", ElanLocale.getString("Menu.Annotation.MergeWithBefore"));
        this.mergeNextMouseAction = new TaSMergeAction(this, TaSMergeAction.MERGE_ROW.NEXT);
        this.mergeNextMouseAction.putValue("Name", ElanLocale.getString("Menu.Annotation.MergeWithNext"));
        this.popupMenu.add(this.mergePreviousMouseAction);
        this.popupMenu.add(this.mergeNextMouseAction);
        this.editorPanel.getTextArea().getDocument().addDocumentListener(new CellDocumentListener());
        this.cellEditor = new TaSCellEditor(this, this.editorPanel);
        this.cellRenderer = new TaSCellRenderer(this);
        this.annoTable.getColumnModel().getColumn(0).setCellRenderer(this.cellRenderer);
        this.annoTable.setShowGrid(false);
        this.annoTable.setRowSorter(null);
        this.annoTable.getSelectionModel().setSelectionMode(0);
        this.annoTable.getColumnModel().getColumn(0).setCellEditor(this.cellEditor);
        this.scrollPane = new JScrollPane(this.annoTable);
        this.addComponentListener(new ViewerComponentListener());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.scrollPane, gbc);
        this.scrollRowToLocation = 1;
        this.annoTable.getSelectionModel().addListSelectionListener(this);
        this.annoTable.addMouseListener(new TableMouseListener());
    }

    private void initTier() {
        if (this.transcription != null) {
            TierImpl t = this.transcription.getTierWithId(this.transTierId);
            if (t == null) {
                if (this.transcription.getTiers().isEmpty()) {
                    LinguisticType type = new LinguisticType(this.transTierId);
                    this.transcription.addLinguisticType(type);
                    TierImpl tier = new TierImpl(this.transTierId, "", this.transcription, type);
                    this.transcription.addTier(tier);
                    tier.setDefaultLocale(null);
                    t = tier;
                } else {
                    List<TierImpl> topTiers = this.transcription.getTopTiers();
                    if (!topTiers.isEmpty()) {
                        t = topTiers.get(0);
                    }
                }
            }
            if (t != null) {
                this.curTier = t;
                this.fillAnnotationList(t);
            }
        }
        this.recalculateAllRowHeights();
    }

    private void fillAnnotationList(Tier t) {
        if (t != null) {
            List<? extends Annotation> annos = t.getAnnotations();
            this.segmentList = new ArrayList<TaSAnno>();
            long timeSoFar = 0L;
            long mediaDuration = this.getMediaDuration();
            if (mediaDuration == 0L) {
                mediaDuration = Long.MAX_VALUE;
            }
            if (annos.isEmpty()) {
                this.segmentList.add(new TaSAnno(timeSoFar, mediaDuration));
            } else {
                for (int i = 0; i < annos.size(); ++i) {
                    AbstractAnnotation aa = (AbstractAnnotation)annos.get(i);
                    if (aa.getBeginTimeBoundary() > timeSoFar) {
                        this.segmentList.add(new TaSAnno(timeSoFar, aa.getBeginTimeBoundary()));
                    }
                    this.segmentList.add(new TaSAnno(aa));
                    timeSoFar = aa.getEndTimeBoundary();
                    if (i != annos.size() - 1 || aa.getEndTimeBoundary() >= mediaDuration) continue;
                    this.segmentList.add(new TaSAnno(aa.getEndTimeBoundary(), mediaDuration));
                }
            }
            for (TaSAnno a2d : this.segmentList) {
                this.tableModel.addRow(new Object[]{a2d});
            }
        }
    }

    private void insertNewAnnotation(TaSAnno tasAnno) {
        if (tasAnno.getAnnotation() == null) {
            ClientLogger.LOG.warning("Cannot insert an empty (gap) annotation.");
            return;
        }
        int[] overlRows = this.getOverlappingRows(tasAnno.getBeginTime(), tasAnno.getEndTime());
        if (overlRows[0] == -1 || overlRows[1] == -1) {
            ClientLogger.LOG.warning("Error inserting a new row, there should be at least one time-overlapping row already in the table");
            return;
        }
        if (overlRows[0] == overlRows[1]) {
            TaSAnno curRow = (TaSAnno)this.tableModel.getValueAt(overlRows[0], 0);
            if (curRow.getBeginTime() == tasAnno.getBeginTime() && curRow.getEndTime() == tasAnno.getEndTime()) {
                this.tableModel.removeRow(overlRows[0]);
                this.tableModel.insertRow(overlRows[0], new Object[]{tasAnno});
                this.calculateRowHeight(overlRows[0]);
            } else if (curRow.getBeginTime() == tasAnno.getBeginTime()) {
                curRow.setBeginTime(tasAnno.getEndTime());
                this.tableModel.insertRow(overlRows[0], new Object[]{tasAnno});
                this.calculateRowHeight(overlRows[0]);
                this.calculateRowHeight(overlRows[0] + 1);
            } else {
                ClientLogger.LOG.warning("Cannot replace one single row because the time values of the new annotation are not equal to the existing ones.");
            }
        } else {
            ClientLogger.LOG.warning("There are more than one overlapping segments on this tier cannot insert the new annotation");
        }
    }

    private int[] getOverlappingRows(long bt, long et) {
        int startIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            TaSAnno rowAnno = (TaSAnno)this.tableModel.getValueAt(i, 0);
            if (rowAnno.getEndTime() <= bt) continue;
            if (rowAnno.getEndTime() > bt && rowAnno.getBeginTime() < et) {
                if (startIndex == -1) {
                    startIndex = i;
                }
                if (i == this.tableModel.getRowCount() - 1) {
                    endIndex = i;
                }
            }
            if (rowAnno.getBeginTime() < et) continue;
            if (endIndex != -1) break;
            endIndex = i - 1;
            break;
        }
        return new int[]{startIndex, endIndex};
    }

    public int getRowAtTime(long time) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            TaSAnno rowAnno = (TaSAnno)this.tableModel.getValueAt(i, 0);
            if (time < rowAnno.getBeginTime() || time >= rowAnno.getEndTime()) continue;
            return i;
        }
        return -1;
    }

    private int getRowForAnnotation(Annotation a) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            TaSAnno rowAnno = (TaSAnno)this.tableModel.getValueAt(i, 0);
            if (rowAnno.getAnnotation() != a) continue;
            return i;
        }
        return -1;
    }

    private void updateNeighborSegments(Annotation annotation) {
        if (annotation != null) {
            int rowIndex = this.getRowForAnnotation(annotation);
            if (rowIndex == -1) {
                ClientLogger.LOG.warning("Error updating neighboring rows, the annotation was not found in the table");
                return;
            }
            TaSAnno prevAnno = null;
            TaSAnno nextAnno = null;
            if (rowIndex > 0) {
                prevAnno = (TaSAnno)this.tableModel.getValueAt(rowIndex - 1, 0);
            }
            if (rowIndex < this.tableModel.getRowCount() - 1) {
                nextAnno = (TaSAnno)this.tableModel.getValueAt(rowIndex + 1, 0);
            }
            if (prevAnno == null) {
                if (annotation.getBeginTimeBoundary() > 0L) {
                    this.tableModel.insertRow(0, new Object[]{new TaSAnno(0L, annotation.getBeginTimeBoundary())});
                    this.calculateRowHeight(rowIndex);
                    ++rowIndex;
                }
            } else if (annotation.getBeginTimeBoundary() > prevAnno.getEndTime()) {
                if (prevAnno.getAnnotation() != null) {
                    this.tableModel.insertRow(rowIndex, new Object[]{new TaSAnno(prevAnno.getEndTime(), annotation.getBeginTimeBoundary())});
                    this.calculateRowHeight(rowIndex);
                    ++rowIndex;
                } else {
                    prevAnno.setEndTime(annotation.getBeginTimeBoundary());
                }
            } else if (annotation.getBeginTimeBoundary() < prevAnno.getEndTime() && prevAnno.getAnnotation() == null) {
                prevAnno.setEndTime(annotation.getBeginTimeBoundary());
                if (prevAnno.getBeginTime() == prevAnno.getEndTime()) {
                    this.tableModel.removeRow(rowIndex - 1);
                }
            }
            if (nextAnno == null) {
                if (annotation.getEndTimeBoundary() < this.getMediaDuration()) {
                    this.tableModel.addRow(new Object[]{new TaSAnno(annotation.getEndTimeBoundary(), this.getMediaDuration())});
                    this.calculateRowHeight(this.tableModel.getRowCount() - 1);
                }
            } else if (annotation.getEndTimeBoundary() < nextAnno.getBeginTime()) {
                if (nextAnno.getAnnotation() != null) {
                    this.tableModel.insertRow(rowIndex + 1, new Object[]{new TaSAnno(annotation.getEndTimeBoundary(), nextAnno.getBeginTime())});
                    this.calculateRowHeight(rowIndex + 1);
                } else {
                    nextAnno.setBeginTime(annotation.getEndTimeBoundary());
                }
            } else if (annotation.getEndTimeBoundary() > nextAnno.getBeginTime()) {
                if (nextAnno.getAnnotation() == null) {
                    nextAnno.setBeginTime(annotation.getEndTimeBoundary());
                    if (nextAnno.getBeginTime() == nextAnno.getEndTime()) {
                        this.tableModel.removeRow(rowIndex + 1);
                    }
                } else if (nextAnno.getBeginTime() == nextAnno.getEndTime()) {
                    this.tableModel.removeRow(rowIndex + 1);
                }
            }
        }
    }

    private void updateRow(Annotation annotation) {
        if (annotation != null) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                TaSAnno rowAnno = (TaSAnno)this.tableModel.getValueAt(i, 0);
                if (rowAnno.getAnnotation() != annotation) continue;
                this.calculateRowHeight(i);
                break;
            }
        }
    }

    private void annotationRemoved(Annotation remAnn) {
        if (remAnn != null) {
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                TaSAnno rowAnno = (TaSAnno)this.tableModel.getValueAt(i, 0);
                if (rowAnno.getAnnotation() != remAnn) continue;
                boolean gapBefore = false;
                boolean gapAfter = false;
                TaSAnno prevAnno = null;
                TaSAnno nextAnno = null;
                if (i > 0) {
                    prevAnno = (TaSAnno)this.tableModel.getValueAt(i - 1, 0);
                    boolean bl = gapBefore = prevAnno.getAnnotation() == null;
                }
                if (i < this.tableModel.getRowCount() - 1) {
                    nextAnno = (TaSAnno)this.tableModel.getValueAt(i + 1, 0);
                    boolean bl = gapAfter = nextAnno.getAnnotation() == null;
                }
                if (gapBefore && gapAfter) {
                    this.tableModel.removeRow(i + 1);
                    this.tableModel.removeRow(i);
                    prevAnno.setEndTime(nextAnno.getEndTime());
                    this.calculateRowHeight(i - 1);
                    break;
                }
                if (gapBefore) {
                    this.tableModel.removeRow(i);
                    prevAnno.setEndTime(remAnn.getEndTimeBoundary());
                    this.calculateRowHeight(i - 1);
                    break;
                }
                if (gapAfter) {
                    this.tableModel.removeRow(i);
                    nextAnno.setBeginTime(remAnn.getBeginTimeBoundary());
                    this.calculateRowHeight(i);
                    break;
                }
                this.tableModel.removeRow(i);
                this.tableModel.insertRow(i, new Object[]{new TaSAnno(remAnn.getBeginTimeBoundary(), remAnn.getEndTimeBoundary())});
                this.calculateRowHeight(i);
                break;
            }
        }
    }

    private synchronized void reloadAnnotationTable() {
        int selRow = this.annoTable.getSelectedRow();
        long annoBT = 0L;
        long annoET = 0L;
        if (selRow > -1) {
            TaSAnno curSelAnno = (TaSAnno)this.annoTable.getValueAt(selRow, 0);
            annoBT = curSelAnno.getBeginTime();
            annoET = curSelAnno.getEndTime();
        }
        this.clearAnnotationTable();
        this.fillAnnotationList(this.curTier);
        this.recalculateAllRowHeights();
        selRow = this.getRowAtTime((annoBT + annoET) / 2L);
        if (selRow > 0) {
            this.annoTable.getSelectionModel().setSelectionInterval(selRow, selRow);
        }
    }

    private synchronized void clearAnnotationTable() {
        if (this.tableModel != null) {
            for (int j = this.tableModel.getRowCount() - 1; j >= 0; --j) {
                this.tableModel.removeRow(j);
            }
        }
    }

    public int calculateRowHeight(int row) {
        if (row < 0 || row >= this.annoTable.getRowCount()) {
            throw new IllegalArgumentException("There is no row with index: " + row);
        }
        TaSCellPanel renderComp = (TaSCellPanel)this.cellRenderer.getTableCellRendererComponent(this.annoTable, this.tableModel.getValueAt(row, 0), false, false, row, 0);
        int prefHeight = renderComp.getPreferredSize().height;
        this.annoTable.setRowHeight(row, prefHeight);
        if (row == this.annoTable.getRowCount() - 1) {
            this.annoTable.setRowHeight(row, 2 * prefHeight);
        }
        return prefHeight;
    }

    public void recalculateAllRowHeights() {
        for (int i = 0; i < this.annoTable.getRowCount(); ++i) {
            this.calculateRowHeight(i);
        }
        this.annoTable.revalidate();
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        int medRow;
        long mediaTime = this.getMediaTime();
        this.cellEditor.updatMediaTime(mediaTime);
        this.cellRenderer.updatMediaTime(mediaTime);
        int editingRow = this.annoTable.getEditingRow();
        if (editingRow > -1) {
            this.cellEditor.repaint();
        }
        if ((medRow = this.getRowAtTime(mediaTime)) > -1 && medRow != this.rowAtMediaTime) {
            this.scrollToRow(medRow);
            this.rowAtMediaTime = medRow;
        }
        this.repaint();
    }

    @Override
    public void updateSelection() {
        this.repaint();
    }

    @Override
    public void setActiveAnnotation(Annotation annotation) {
        if (!this.continuousPlayMode) {
            super.setActiveAnnotation(annotation);
        } else {
            Command c = ELANCommandFactory.createCommand(this.transcription, "Commands.ActiveAnnotation");
            c.execute(this.getViewerManager(), new Object[]{annotation, Boolean.FALSE});
        }
    }

    @Override
    public void updateActiveAnnotation() {
        if (this.annoTable != null) {
            // empty if block
        }
    }

    @Override
    public void updateLocale() {
        if (this.mergePreviousMouseAction != null) {
            this.mergePreviousMouseAction.putValue("Name", ElanLocale.getString("Menu.Annotation.MergeWithBefore"));
            this.mergeNextMouseAction.putValue("Name", ElanLocale.getString("Menu.Annotation.MergeWithNext"));
        }
    }

    @Override
    public void preferencesChanged() {
        if (this.curTier == null && this.transcription.getTopTiers().size() > 0) {
            this.setTier(this.transcription.getTopTiers().get(0));
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        this.cellEditor.cancelCellEditing();
        switch (e.getOperation()) {
            case 3: {
                if (!(e.getInvalidatedObject() instanceof TierImpl) || !(e.getModification() instanceof Annotation) || e.getInvalidatedObject() != this.curTier) break;
                this.insertNewAnnotation(new TaSAnno((Annotation)e.getModification()));
                break;
            }
            case 7: {
                Annotation modAnno;
                if (!(e.getModification() instanceof Annotation) || (modAnno = (Annotation)e.getModification()).getTier() != this.curTier) break;
                this.updateNeighborSegments(modAnno);
                break;
            }
            case 8: {
                if (!(e.getInvalidatedObject() instanceof Annotation)) break;
                this.updateRow((Annotation)e.getInvalidatedObject());
                break;
            }
            case 14: {
                this.reloadAnnotationTable();
                break;
            }
            case 6: {
                Annotation remAnn;
                if (!(e.getModification() instanceof Annotation) || (remAnn = (Annotation)e.getModification()).getTier() != this.curTier) break;
                this.annotationRemoved(remAnn);
                break;
            }
            case 1: {
                if (!(e.getModification() instanceof TierImpl) || e.getModification() != this.curTier) break;
                this.tableModel.setRowCount(0);
                this.revalidate();
                break;
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selRow;
        if (!e.getValueIsAdjusting() && (selRow = this.annoTable.getSelectedRow()) > -1) {
            TaSAnno selAnno = (TaSAnno)this.annoTable.getValueAt(selRow, 0);
            this.setSelection(selAnno.getBeginTime(), selAnno.getEndTime());
            if (!this.continuousPlayMode || !this.playerIsPlaying()) {
                this.setMediaTime(selAnno.getBeginTime());
            }
            this.setActiveAnnotation(selAnno.getAnnotation());
            this.annoTable.repaint();
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int curWidth = this.getWidth();
        super.setBounds(x, y, width, height);
        if (curWidth != width) {
            this.recalculateAllRowHeights();
        }
        this.revalidate();
    }

    @Override
    public void setFontSize(int fontSize) {
        if (this.primaryFontSize != fontSize) {
            this.primaryFontSize = fontSize;
            if (this.annoTable != null) {
                this.annoTable.setFont(this.annoTable.getFont().deriveFont((float)this.primaryFontSize));
                if (this.annoTable.isEditing()) {
                    ((TaSCellPanel)this.cellEditor.getComponent()).setFont(this.annoTable.getFont());
                }
                this.recalculateAllRowHeights();
            }
        }
    }

    @Override
    public int getFontSize() {
        return this.primaryFontSize;
    }

    private void loadTierFont(Tier tier) {
        if (tier != null) {
            Map<String, Font> fonts = Preferences.getMapOfFont("TierFonts", this.getViewerManager().getTranscription());
            if (fonts != null) {
                if (fonts.get(tier.getName()) != null) {
                    this.editorPanel.setMainTierFont(fonts.get(tier.getName()));
                    this.cellRenderer.setMainTierFont(fonts.get(tier.getName()));
                } else {
                    this.editorPanel.setMainTierFont(Constants.DEFAULTFONT);
                    this.cellRenderer.setMainTierFont(Constants.DEFAULTFONT);
                }
            } else {
                this.editorPanel.setMainTierFont(Constants.DEFAULTFONT);
                this.cellRenderer.setMainTierFont(Constants.DEFAULTFONT);
            }
        } else {
            this.editorPanel.setMainTierFont(null);
            this.cellRenderer.setMainTierFont(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRow(int row) {
        if (row > -1) {
            TaSTable taSTable = this.annoTable;
            synchronized (taSTable) {
                Dimension viewSize = this.scrollPane.getViewport().getViewSize();
                Rectangle viewRect = this.scrollPane.getViewport().getViewRect();
                Rectangle cellRect = this.annoTable.getCellRect(row, 0, true);
                if (!viewRect.contains(cellRect)) {
                    switch (this.scrollRowToLocation) {
                        case 1: {
                            cellRect.height = viewRect.height - cellRect.height;
                            break;
                        }
                        case 0: {
                            cellRect.height += (viewRect.height - cellRect.height) / 2;
                            break;
                        }
                        case 3: {
                            cellRect.height += 10;
                            break;
                        }
                    }
                    if (cellRect.y + cellRect.height > viewSize.height) {
                        cellRect.height = viewSize.height - cellRect.y;
                    }
                    this.annoTable.scrollRectToVisible(cellRect);
                }
            }
        }
    }

    public void setTier(Tier tier) {
        if (tier == this.curTier) {
            return;
        }
        if (this.curTier != null) {
            this.cellEditor.stopCellEditing();
            this.clearAnnotationTable();
        }
        this.curTier = (TierImpl)tier;
        this.fillAnnotationList(tier);
        this.loadTierFont(tier);
        this.recalculateAllRowHeights();
    }

    public Tier getTier() {
        return this.curTier;
    }

    public void setTierByName(String tierName) {
        TierImpl t = this.transcription.getTierWithId(tierName);
        if (t.getParentTier() == null) {
            this.setTier(t);
        }
    }

    public String getTierName() {
        if (this.curTier != null) {
            return this.curTier.getName();
        }
        return null;
    }

    public boolean isContinuousPlayMode() {
        return this.continuousPlayMode;
    }

    public void setContinuousPlayMode(boolean continuousPlayMode) {
        this.continuousPlayMode = continuousPlayMode;
    }

    private class CellDocumentListener
    implements DocumentListener {
        private CellDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (e.getLength() > 1) {
                TurnsAndSceneViewer.this.editorPanel.getTextArea().revalidate();
                TurnsAndSceneViewer.this.editorPanel.revalidate();
            }
            this.checkRowHeight(TurnsAndSceneViewer.this.annoTable.getEditingRow());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.checkRowHeight(TurnsAndSceneViewer.this.annoTable.getEditingRow());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        private void checkRowHeight(int row) {
            if (row > -1) {
                try {
                    int curHeight = TurnsAndSceneViewer.this.editorPanel.getTextArea().getHeight();
                    int curPrefHeight = ((TurnsAndSceneViewer)TurnsAndSceneViewer.this).editorPanel.getTextArea().getPreferredSize().height;
                    if (curHeight != curPrefHeight && (row != TurnsAndSceneViewer.this.annoTable.getRowCount() - 1 || curHeight <= curPrefHeight)) {
                        TurnsAndSceneViewer.this.annoTable.setRowHeight(row, TurnsAndSceneViewer.this.annoTable.getRowHeight(row) + (curPrefHeight - curHeight));
                        TurnsAndSceneViewer.this.annoTable.revalidate();
                        TurnsAndSceneViewer.this.editorPanel.revalidate();
                    }
                }
                catch (Throwable t) {
                    ClientLogger.LOG.warning("Cannot update row height: " + t.getMessage());
                }
            }
        }
    }

    private class ViewerComponentListener
    implements ComponentListener {
        private ViewerComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            TurnsAndSceneViewer.this.recalculateAllRowHeights();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            TurnsAndSceneViewer.this.recalculateAllRowHeights();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    private class TableMouseListener
    implements MouseListener {
        private TableMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource() == TurnsAndSceneViewer.this.annoTable && (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger())) {
                int row = TurnsAndSceneViewer.this.annoTable.rowAtPoint(e.getPoint());
                boolean mergePrevEnabled = false;
                boolean mergeNextEnabled = false;
                mergePrevEnabled = row > 0;
                mergeNextEnabled = row < TurnsAndSceneViewer.this.annoTable.getRowCount() - 1;
                TurnsAndSceneViewer.this.mergePreviousMouseAction.setSourceRow(row);
                TurnsAndSceneViewer.this.mergePreviousMouseAction.setEnabled(mergePrevEnabled);
                TurnsAndSceneViewer.this.mergeNextMouseAction.setSourceRow(row);
                TurnsAndSceneViewer.this.mergeNextMouseAction.setEnabled(mergeNextEnabled);
                TurnsAndSceneViewer.this.popupMenu.show(TurnsAndSceneViewer.this.annoTable, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

