/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.util.ClientLogger;

public class TaSPostPasteAction
extends AbstractAction {
    private TurnsAndSceneViewer viewer;

    public TaSPostPasteAction(TurnsAndSceneViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewer != null) {
            this.pasteAction();
        }
    }

    private void pasteAction() {
        int editingRow = this.viewer.getAnnotationTable().getEditingRow();
        if (editingRow == -1) {
            ClientLogger.LOG.info("A paste action occurred but it is unknown in which cell.");
            return;
        }
        TaSAnno curAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow, 0);
        String curText = this.viewer.getEditor().getTextArea().getText();
        if (curAnno.getAnnotation() != null) {
            if (curText != null && !curText.equals(curAnno.getAnnotation().getValue())) {
                Command com = ELANCommandFactory.createCommand(this.viewer.getViewerManager().getTranscription(), "Menu.Annotation.ModifyAnnotation");
                com.execute(curAnno.getAnnotation(), new Object[]{curAnno.getAnnotation().getValue(), curText});
            }
        } else {
            int caretPos = this.viewer.getEditor().getTextArea().getCaretPosition();
            long splitTime = -1L;
            Command twoCom = ELANCommandFactory.createCommand(this.viewer.getViewerManager().getTranscription(), "Menu.Annotation.NewAnnotationsInGap");
            twoCom.execute(this.viewer.getTier(), new Object[]{curAnno.getBeginTime(), curAnno.getEndTime(), splitTime, curText, caretPos});
        }
    }
}

