/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class TaSSplitAction
extends AbstractAction {
    private TurnsAndSceneViewer viewer;

    public TaSSplitAction(TurnsAndSceneViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.viewer != null) {
            this.splitAnnotation();
        }
    }

    private void splitAnnotation() {
        String curText = this.viewer.getEditor().getTextArea().getText();
        int caretPos = this.viewer.getEditor().getTextArea().getCaretPosition();
        long curMediaTime = this.viewer.getMediaTime();
        int editingRow = this.viewer.getAnnotationTable().getEditingRow();
        if (editingRow < 0) {
            return;
        }
        TaSAnno curAnno = (TaSAnno)this.viewer.getAnnotationTable().getValueAt(editingRow, 0);
        this.viewer.getEditor().getTextArea().transferFocusUpCycle();
        if (this.viewer.getAnnotationTable().getCellEditor() != null) {
            this.viewer.getAnnotationTable().getCellEditor().stopCellEditing();
        }
        boolean shouldSplit = curMediaTime > curAnno.getBeginTime() && curMediaTime < curAnno.getEndTime();
        Transcription transcription = this.viewer.getViewerManager().getTranscription();
        if (curAnno.getAnnotation() != null) {
            boolean annHasDepending;
            boolean bl = annHasDepending = !((AbstractAnnotation)curAnno.getAnnotation()).getParentListeners().isEmpty();
            if (!shouldSplit || shouldSplit && annHasDepending) {
                if (shouldSplit && annHasDepending) {
                    ClientLogger.LOG.warning("Splitting of annotations that have depending annotations is not supported.");
                }
                if (curText != null && !curText.equals(curAnno.getAnnotation().getValue())) {
                    Command com = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.ModifyAnnotation");
                    com.execute(curAnno.getAnnotation(), new Object[]{curAnno.getAnnotation().getValue(), curText});
                }
            } else {
                Command splitCom = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.SplitAnnotation");
                Object[] args = new Object[]{curAnno.getAnnotation(), curMediaTime, curText, caretPos};
                splitCom.execute(transcription, args);
            }
        } else {
            long splitTime = shouldSplit ? curMediaTime : -1L;
            Command twoCom = ELANCommandFactory.createCommand(transcription, "Menu.Annotation.NewAnnotationsInGap");
            twoCom.execute(this.viewer.getTier(), new Object[]{curAnno.getBeginTime(), curAnno.getEndTime(), splitTime, curText, caretPos});
        }
        int newEditingRow = Math.min(editingRow + 1, this.viewer.getAnnotationTable().getRowCount() - 1);
        this.viewer.getAnnotationTable().getSelectionModel().setSelectionInterval(newEditingRow, newEditingRow);
        this.viewer.getAnnotationTable().editCellAt(newEditingRow, 0);
        this.viewer.getEditor().startEditing();
    }
}

