/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class IPAGIMToHTML {
    String res = "/src/resources/guk/im/data/ipa-extension.gim";

    public IPAGIMToHTML() {
        this.convert();
        System.out.println("Conversion completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convert() {
        String sourceFile = System.getProperty("user.dir") + this.res;
        String outFile = sourceFile.replaceFirst("gim", "html");
        BufferedReader bufRead = null;
        BufferedWriter writer = null;
        try {
            FileReader fileRead = new FileReader(sourceFile);
            bufRead = new BufferedReader(fileRead);
            FileOutputStream out = new FileOutputStream(outFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            writer = new BufferedWriter(osw);
            writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd\">");
            writer.write("\n<html><head><title>MPI - IPA extended keyboard mapping</title></head>\n");
            writer.write("<body>\n<h3>MPI - IPA extended keyboard mapping (GUK)</h3>\n");
            writer.write("<table>\n");
            writer.write("<tr><th align=\"left\" width=\"120\">Key sequence</th><th align=\"left\" width=\"120\">Unicode code</th><th align=\"left\">IPA character</th></tr>\n");
            String li = null;
            char ch = '1';
            int index = 0;
            while ((li = bufRead.readLine()) != null) {
                StringTokenizer tokenizer;
                if (li.length() == 0 || ++index < 120 || li.charAt(0) == '#' || (tokenizer = new StringTokenizer(li)).countTokens() != 4) continue;
                tokenizer.nextToken();
                String code = tokenizer.nextToken();
                if (code.length() > 1 && code.charAt(1) != ch) {
                    writer.write("<tr><td colspan=\"3\">&nbsp;</td></tr>\n");
                    ch = code.charAt(1);
                }
                writer.write("<tr><td>");
                writer.write(code + "</td><td>");
                tokenizer.nextToken();
                code = tokenizer.nextToken();
                writer.write(code + "</td><td>");
                writer.write("&#" + code.substring(1) + ";");
                writer.write("</td></tr>\n");
            }
            writer.write("</table></body></html>");
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ioe) {
                System.out.println("Could not close output stream...");
                ioe.printStackTrace();
            }
            try {
                if (bufRead != null) {
                    bufRead.close();
                }
            }
            catch (IOException ioe) {
                System.out.println("Could not close input stream...");
                ioe.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        new IPAGIMToHTML();
    }
}

