/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;

public class LocaleDiff {
    private String outputPath;

    public LocaleDiff(String outputPath) {
        this.outputPath = outputPath != null ? outputPath : System.getProperty("user.home");
    }

    public void run() {
        ResourceBundle english = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", new Locale("", "", ""));
        PropertyResourceBundle other = null;
        Collection<Locale> allLocs = ELANCommandFactory.getLocales();
        for (Locale loc : allLocs) {
            if (loc.equals(Locale.ENGLISH)) continue;
            try {
                other = (PropertyResourceBundle)ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", loc);
            }
            catch (Exception ee) {
                System.out.println("Could not load resource: " + ee.getMessage());
                continue;
            }
            Enumeration<String> engEn = english.getKeys();
            ArrayList<String> list = new ArrayList<String>();
            while (engEn.hasMoreElements()) {
                String key = engEn.nextElement();
                try {
                    Integer.valueOf(english.getString(key));
                }
                catch (NumberFormatException numberFormatException) {
                    if (other.handleGetObject(key) != null) continue;
                    list.add(key + "=" + english.getString(key));
                }
            }
            Collections.sort(list);
            this.writeProperties(loc, list);
        }
    }

    private void writeProperties(Locale loc, List<String> props) {
        try {
            File f = new File(this.outputPath + File.separator + this.getSuffix(loc) + ".properties");
            FileWriter writer = new FileWriter(f);
            for (int i = 0; i < props.size(); ++i) {
                if (props.get(i).indexOf(10) >= 0) {
                    writer.write(props.get(i).replaceAll("\n", "\\\\n") + "\n");
                    continue;
                }
                writer.write(props.get(i) + "\n");
            }
            writer.close();
            File cf = new File(this.outputPath + File.separator + loc.getLanguage() + ".csv");
            FileWriter cw = new FileWriter(cf);
            cw.write("\"English\",\"Translation\"\n\n");
            for (int i = 0; i < props.size(); ++i) {
                String prop = props.get(i);
                if (prop.indexOf(34) >= 0) {
                    prop = props.get(i).replaceAll("\"", "\"\"");
                }
                if (prop.indexOf(10) >= 0) {
                    prop = prop.replaceAll("\n", "\\\\n");
                }
                cw.write("\"");
                cw.write(prop);
                cw.write("\",\"");
                cw.write(prop);
                cw.write("\"\n");
            }
            cw.close();
        }
        catch (Exception e) {
            System.out.println("Could not write file: " + e.getMessage());
        }
    }

    private String getSuffix(Locale loc) {
        if (loc.getCountry() != null && !loc.getCountry().isEmpty()) {
            return loc.getLanguage() + "_" + loc.getCountry();
        }
        return loc.getLanguage();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            new LocaleDiff(args[0]).run();
        } else {
            new LocaleDiff(null).run();
        }
    }
}

