/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.client.annotator.util.ClientLogger;

public class SystemReporting {
    public static final String OS_NAME;
    public static final String USER_HOME;
    public static boolean antiAliasedText;
    public static boolean useBufferedPainting;
    public static boolean isBufferedPaintingPropertySet;
    private static boolean isMacOS;
    private static boolean isMacSierraOrHigher;
    private static boolean isWindows;
    private static boolean isVista;
    private static boolean isWin7;
    private static boolean isLinux;

    public static boolean isMacOS() {
        return isMacOS;
    }

    public static boolean isMacOSSierraOrHigher() {
        return isMacSierraOrHigher;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isWindowsVista() {
        return isVista;
    }

    public static boolean isWindows7OrHigher() {
        return isWin7;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static void printProperty(String prop) {
        System.out.println(prop + " = " + System.getProperty(prop));
    }

    public static File getLibExtDir() {
        if (OS_NAME.startsWith("Mac OS X")) {
            return SystemReporting.verifyMacUserLibExt();
        }
        return new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "ext");
    }

    public static File[] getLibExt() {
        File ext = SystemReporting.getLibExtDir();
        if (ext != null && ext.exists()) {
            return SystemReporting.getLibExtDir().listFiles();
        }
        return null;
    }

    private static File verifyMacUserLibExt() {
        String userLibJavaExt = USER_HOME + "/Library/Java/Extensions";
        File userLibExt = new File(userLibJavaExt);
        if (!userLibExt.exists()) {
            try {
                boolean success = userLibExt.mkdirs();
                if (!success) {
                    ClientLogger.LOG.warning("Unable to create folder: " + userLibExt);
                    return null;
                }
            }
            catch (SecurityException se) {
                ClientLogger.LOG.warning("Unable to create folder: " + userLibExt);
                ClientLogger.LOG.warning("Cause: " + se.getMessage());
                return null;
            }
        }
        return userLibExt;
    }

    public static void printLibExt() {
        File[] potext = SystemReporting.getLibExt();
        int NOFfiles = potext == null ? 0 : potext.length;
        System.out.println("Found " + NOFfiles + " potential extension(s)");
        for (int i = 0; i < NOFfiles; ++i) {
            System.out.println("\t" + potext[i]);
        }
    }

    public static List<String> getScreenInfo() {
        ArrayList<String> infoList = new ArrayList<String>(4);
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] screens = ge.getScreenDevices();
            int count = 0;
            for (GraphicsDevice gd : screens) {
                DisplayMode dMode = gd.getDisplayMode();
                infoList.add(String.format("Screen %d - isDefault:%b, %s", ++count, gd == ge.getDefaultScreenDevice(), String.format("w:%d, h:%d, bitDepth:%d", dMode.getWidth(), dMode.getHeight(), dMode.getBitDepth())));
            }
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            infoList.add(String.format("Main screen resolution:%d (w:%d, h:%d)", Toolkit.getDefaultToolkit().getScreenResolution(), dim.width, dim.height));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return infoList;
    }

    public static int getScreenResolution() {
        try {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static int getJavaMacroVersion() {
        block8: {
            String[] verSplit;
            String versionStr = System.getProperty("java.version");
            if (versionStr != null && (verSplit = versionStr.split("\\.")).length >= 2) {
                if (verSplit[0].equals("1")) {
                    try {
                        return Integer.parseInt(verSplit[1]);
                    }
                    catch (NumberFormatException nfe) {
                        if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                            ClientLogger.LOG.info("Unable to parse the main Java version from: " + verSplit[1]);
                        }
                        break block8;
                    }
                }
                if (verSplit[0].length() > 1) {
                    try {
                        return Integer.parseInt(verSplit[0]);
                    }
                    catch (NumberFormatException nfe) {
                        if (!ClientLogger.LOG.isLoggable(Level.INFO)) break block8;
                        ClientLogger.LOG.info("Unable to parse the main Java version from: " + verSplit[0]);
                    }
                }
            }
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        SystemReporting.printProperty("java.home");
        SystemReporting.printLibExt();
    }

    static {
        String awtRH;
        Object aaHint;
        Map map;
        antiAliasedText = false;
        useBufferedPainting = false;
        isBufferedPaintingPropertySet = false;
        isMacSierraOrHigher = false;
        isVista = false;
        isWin7 = false;
        OS_NAME = System.getProperty("os.name");
        USER_HOME = System.getProperty("user.home");
        String lowerOS = OS_NAME.toLowerCase();
        if (lowerOS.indexOf("win") > -1) {
            isWindows = true;
        } else if (lowerOS.indexOf("mac") > -1) {
            isMacOS = true;
        } else if (lowerOS.indexOf("lin") > -1) {
            isLinux = true;
        }
        String version = System.getProperty("os.version");
        try {
            String[] verTokens;
            int minor;
            int major;
            if (isWindows) {
                if (version.indexOf(46) > -1) {
                    String[] verTokens2 = version.split("\\.");
                    major = Integer.parseInt(verTokens2[0]);
                    if (verTokens2.length > 1) {
                        minor = Integer.parseInt(verTokens2[1]);
                        if (major > 6) {
                            isWin7 = true;
                        } else if (major == 6) {
                            if (minor > 0) {
                                isWin7 = true;
                            } else {
                                isVista = true;
                            }
                        }
                    }
                } else {
                    int major2 = Integer.parseInt(version);
                    if (major2 > 6) {
                        isWin7 = true;
                    } else if (major2 == 6) {
                        isVista = true;
                    }
                }
            } else if (isMacOS && (verTokens = version.split("\\.")).length >= 2) {
                major = Integer.parseInt(verTokens[0]);
                if (major == 10) {
                    minor = Integer.parseInt(verTokens[1]);
                    if (minor >= 11) {
                        isMacSierraOrHigher = true;
                    }
                } else if (major > 10) {
                    isMacSierraOrHigher = true;
                }
            }
        }
        catch (NumberFormatException nfe) {
            ClientLogger.LOG.warning("Unable to parse the OS version.");
        }
        String atp = System.getProperty("swing.aatext");
        if ("true".equals(atp)) {
            antiAliasedText = true;
        }
        if ((map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) != null && RenderingHints.VALUE_TEXT_ANTIALIAS_OFF != (aaHint = map.get(RenderingHints.KEY_TEXT_ANTIALIASING))) {
            antiAliasedText = true;
        }
        if ("on".equals(awtRH = System.getProperty("awt.useSystemAAFontSettings"))) {
            antiAliasedText = true;
        } else if (map != null && ("off".equals(awtRH) || "false".equals(awtRH) || "default".equals(awtRH))) {
            antiAliasedText = false;
        }
        String bufImg = System.getProperty("useBufferedImage");
        if (bufImg != null) {
            isBufferedPaintingPropertySet = true;
            if (bufImg.toLowerCase().equals("true")) {
                useBufferedPainting = true;
            }
        }
    }
}

