/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.util;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;

public class TierNameCompare {
    public static final int PREFIX_MODE = -1;
    public static final int SUFFIX_MODE = 1;
    public static final int KEEP_LEFT_PART = -1;
    public static final int KEEP_RIGHT_PART = 1;

    public int[] findCorrespondingAffix(String tierName1, String tierName2) {
        int i;
        if (tierName1 == null || tierName2 == null) {
            return null;
        }
        int[] indices = new int[]{-1, -1};
        char[] ch1 = tierName1.toCharArray();
        char[] ch2 = tierName2.toCharArray();
        int bi = -1;
        int ei = -1;
        int bi2 = -1;
        int ei2 = -1;
        for (i = 0; i < ch1.length && i < ch2.length && ch1[i] == ch2[i]; ++i) {
            if (bi == -1) {
                bi = i;
                ei = i;
                continue;
            }
            ei = i;
        }
        i = ch1.length - 1;
        for (int j = ch2.length - 1; i > -1 && j > -1 && ch1[i] == ch2[j]; --i, --j) {
            if (ei2 == -1) {
                bi2 = i;
                ei2 = j;
                continue;
            }
            bi2 = i;
        }
        if (bi == 0 && ei > 0) {
            if (bi2 > -1 && ch1.length - 1 - bi2 > ei - bi) {
                indices[0] = bi2;
                indices[1] = 1;
            } else {
                indices[0] = ei;
                indices[1] = -1;
            }
        } else if (bi2 > -1 && ei2 > -1) {
            indices[0] = bi2;
            indices[1] = 1;
        }
        return indices;
    }

    public void adjustTierNames(DefaultMutableTreeNode root, String newAffix, char from, int leftOrRight) {
        if (root == null) {
            return;
        }
        DefaultMutableTreeNode n = null;
        Enumeration<TreeNode> nodeIt = root.breadthFirstEnumeration();
        while (nodeIt.hasMoreElements()) {
            int index;
            n = (DefaultMutableTreeNode)nodeIt.nextElement();
            AnnotationDataRecord adr = (AnnotationDataRecord)n.getUserObject();
            if (leftOrRight <= -1) {
                index = adr.getTierName().lastIndexOf(from);
                if (index <= -1) continue;
                adr.setTierName(adr.getTierName().substring(0, index) + newAffix);
                continue;
            }
            index = adr.getTierName().indexOf(from);
            if (index <= -1) continue;
            adr.setTierName(newAffix + adr.getTierName().substring(index));
        }
    }

    public void addAffixToTierNames(DefaultMutableTreeNode root, String newAffix, int leftOrRight) {
        if (root == null) {
            return;
        }
        DefaultMutableTreeNode n = null;
        Enumeration<TreeNode> nodeIt = root.breadthFirstEnumeration();
        while (nodeIt.hasMoreElements()) {
            n = (DefaultMutableTreeNode)nodeIt.nextElement();
            AnnotationDataRecord adr = (AnnotationDataRecord)n.getUserObject();
            if (leftOrRight <= -1) {
                adr.setTierName(adr.getTierName() + newAffix);
                continue;
            }
            adr.setTierName(newAffix + adr.getTierName());
        }
    }
}

