/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.TimeRuler;
import mpi.eudico.client.annotator.viewer.TimeScaleBasedViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.util.TimeFormatter;

public class DefaultTimeScaleBasedViewer
extends TimeScaleBasedViewer
implements ComponentListener,
ActionListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    public final int DEFAULT_MS_PER_PIXEL = 10;
    public final int SCROLL_OFFSET = 16;
    protected BufferedImage bi;
    protected Graphics2D big2d;
    protected int imageWidth;
    protected int imageHeight;
    protected int intervalWidth;
    protected Font font;
    protected FontMetrics metrics;
    protected int rulerHeight;
    protected TimeRuler ruler;
    protected int vertRulerWidth;
    protected AffineTransform identity;
    protected long crossHairTime;
    protected int crossHairPos;
    protected long intervalBeginTime;
    protected long intervalEndTime;
    protected long selectionBeginTime;
    protected long selectionEndTime;
    protected int selectionBeginPos;
    protected int selectionEndPos;
    protected boolean clearSelOnSingleClick = true;
    protected long dragStartTime;
    protected Point dragStartPoint;
    protected Point dragEndPoint;
    protected AlphaComposite alpha04;
    protected AlphaComposite alpha05;
    protected AlphaComposite alpha07;
    protected float msPerPixel;
    protected boolean timeScaleConnected;
    protected boolean panMode;
    protected boolean timeRulerVisible;
    protected boolean attached;
    protected JPopupMenu popup;
    protected ButtonGroup zoomBG;
    protected JMenu zoomMI;
    protected JCheckBoxMenuItem timeScaleConMI;
    protected JRadioButtonMenuItem customZoomMI;
    protected JMenuItem zoomSelectionMI;
    protected JCheckBoxMenuItem timeRulerVisMI;
    protected long mediaTimeOffset;
    protected int horScrollSpeed = 10;
    protected boolean useBufferedImage = false;

    public DefaultTimeScaleBasedViewer() {
        this.initViewer();
        this.useBufferedImage = SystemReporting.useBufferedPainting;
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setDoubleBuffered(true);
        this.setOpaque(true);
    }

    protected void initViewer() {
        this.setLayout(null);
        this.font = Constants.DEFAULTFONT;
        this.setFont(this.font);
        this.metrics = this.getFontMetrics(this.font);
        this.ruler = Constants.DEFAULT_LF_LABEL_FONT != null ? new TimeRuler(Constants.deriveSmallFont(Constants.DEFAULT_LF_LABEL_FONT), TimeFormatter.toString(0L)) : new TimeRuler(this.font, TimeFormatter.toString(0L));
        this.rulerHeight = this.ruler.getHeight();
        this.timeRulerVisible = true;
        this.vertRulerWidth = 43;
        this.msPerPixel = 10.0f;
        this.crossHairTime = 0L;
        this.crossHairPos = 0;
        this.selectionBeginTime = 0L;
        this.selectionEndTime = 0L;
        this.selectionBeginPos = 0;
        this.selectionEndPos = 0;
        this.dragStartTime = 0L;
        this.alpha04 = AlphaComposite.getInstance(3, 0.4f);
        this.alpha05 = AlphaComposite.getInstance(3, 0.5f);
        this.alpha07 = AlphaComposite.getInstance(3, 0.7f);
        this.imageWidth = 0;
        this.imageHeight = 0;
        this.intervalWidth = 0;
        this.mediaTimeOffset = 0L;
        this.identity = new AffineTransform();
    }

    public int getLeftMargin() {
        return 0;
    }

    public int getRightMargin() {
        return 0;
    }

    protected void createPopupMenu() {
        this.popup = new JPopupMenu("TimeScaleBasedViewer");
        this.zoomMI = new JMenu(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
        this.zoomBG = new ButtonGroup();
        this.zoomSelectionMI = new JMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Selection"));
        this.zoomSelectionMI.addActionListener(this);
        this.zoomSelectionMI.setActionCommand("zoomSel");
        this.zoomMI.add(this.zoomSelectionMI);
        this.customZoomMI = new JRadioButtonMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        this.customZoomMI.setEnabled(false);
        this.zoomBG.add(this.customZoomMI);
        this.zoomMI.add(this.customZoomMI);
        this.zoomMI.addSeparator();
        for (int element : this.ZOOMLEVELS) {
            JRadioButtonMenuItem zoomRB = new JRadioButtonMenuItem(element + "%");
            zoomRB.setActionCommand(String.valueOf(element));
            zoomRB.addActionListener(this);
            this.zoomBG.add(zoomRB);
            this.zoomMI.add(zoomRB);
            if (element != 100) continue;
            zoomRB.setSelected(true);
        }
        this.popup.add(this.zoomMI);
        this.timeRulerVisMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.TimeRuler.Visible"));
        this.timeRulerVisMI.setSelected(this.timeRulerVisible);
        this.timeRulerVisMI.addActionListener(this);
        this.popup.add(this.timeRulerVisMI);
        this.timeScaleConMI = new JCheckBoxMenuItem(ElanLocale.getString("TimeScaleBasedViewer.Connected"), this.timeScaleConnected);
        this.timeScaleConMI.setActionCommand("connect");
        this.timeScaleConMI.addActionListener(this);
        this.popup.add(this.timeScaleConMI);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        int zoom = (int)(100.0f * (10.0f / this.msPerPixel));
        if (zoom <= 0) {
            zoom = 100;
        }
        this.updateZoomPopup(zoom);
    }

    protected void updatePopup(Point p) {
    }

    protected void updateZoomPopup(float zoom) {
        if (this.popup == null) {
            return;
        }
        if (zoom > 74.99f && zoom < 75.0f) {
            zoom = 75.0f;
        } else if ((double)zoom > 149.99 && zoom < 150.0f) {
            zoom = 150.0f;
        }
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i;
            break;
        }
        Enumeration<AbstractButton> en = this.zoomBG.getElements();
        int counter = 0;
        while (en.hasMoreElements()) {
            JRadioButtonMenuItem rbmi = (JRadioButtonMenuItem)en.nextElement();
            if (counter == zoomMenuIndex + 1) {
                rbmi.setSelected(true);
                break;
            }
            rbmi.setSelected(false);
            ++counter;
        }
        if (zoomMenuIndex == -1) {
            this.customZoomMI.setSelected(true);
            this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom") + " - " + zoom + "%");
        } else {
            this.customZoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom.Custom"));
        }
    }

    protected void zoomIn() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom + 10.0f;
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    protected void zoomOut() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        float nz = zoom - 10.0f;
        if (nz < 10.0f) {
            nz = 10.0f;
        }
        float nm = 100.0f / nz * 10.0f;
        this.setMsPerPixel(nm);
    }

    protected void zoomToSelection() {
    }

    public int xAt(long t) {
        return (int)((float)(t - this.intervalBeginTime) / this.msPerPixel);
    }

    public long timeAt(int x) {
        return this.intervalBeginTime + (long)((int)((float)x * this.msPerPixel));
    }

    protected int timeToPixels(long theTime) {
        return (int)((float)theTime / this.msPerPixel);
    }

    protected long pixelToTime(int x) {
        return (long)((float)x * this.msPerPixel);
    }

    public long getMediaTimeOffset() {
        return this.mediaTimeOffset;
    }

    public void setMediaTimeOffset(long offset) {
        this.mediaTimeOffset = offset;
    }

    protected boolean pointInHorizontalRuler(int yPos) {
        return yPos < this.rulerHeight;
    }

    @Override
    public void updateTimeScale() {
        if (this.timeScaleConnected) {
            if (this.getGlobalTimeScaleMsPerPixel() != this.msPerPixel) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            } else if (this.getGlobalTimeScaleIntervalBeginTime() != this.intervalBeginTime) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public void setTimeScaleConnected(boolean connected) {
        this.timeScaleConnected = connected;
        if (this.timeScaleConnected) {
            if (this.msPerPixel != this.getGlobalTimeScaleMsPerPixel()) {
                this.setLocalTimeScaleMsPerPixel(this.getGlobalTimeScaleMsPerPixel());
            }
            if (this.intervalBeginTime != this.getGlobalTimeScaleIntervalBeginTime()) {
                this.setLocalTimeScaleIntervalBeginTime(this.getGlobalTimeScaleIntervalBeginTime());
            }
        }
    }

    public boolean getTimeScaleConnected() {
        return this.timeScaleConnected;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
        if (this.timeScaleConMI != null) {
            this.timeScaleConMI.setEnabled(attached);
            this.timeScaleConMI.setSelected(attached);
        }
        this.setTimeScaleConnected(attached);
    }

    public long getIntervalBeginTime() {
        return this.intervalBeginTime;
    }

    public long getIntervalEndTime() {
        return this.intervalEndTime;
    }

    public void setIntervalBeginTime(long begin) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(begin);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleIntervalBeginTime(begin);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void recalculateInterval(long mediaTime) {
        long newBeginTime = this.intervalBeginTime;
        long newEndTime = this.intervalEndTime;
        if (this.intervalWidth == 0) {
            this.intervalWidth = 16;
        }
        long intervalMS = (long)((float)this.intervalWidth * this.msPerPixel);
        if (this.playerIsPlaying()) {
            if (this.intervalEndTime < mediaTime) {
                newBeginTime = this.intervalEndTime;
                for (newEndTime = newBeginTime + intervalMS; newEndTime < mediaTime; newEndTime += intervalMS) {
                    newBeginTime += intervalMS;
                }
            } else {
                if (mediaTime >= this.intervalBeginTime) return;
                newEndTime = this.intervalBeginTime;
                newBeginTime = newEndTime - intervalMS;
                while (mediaTime < newBeginTime) {
                    newBeginTime -= intervalMS;
                    newEndTime -= intervalMS;
                }
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                    newEndTime = intervalMS;
                }
            }
        } else {
            if (mediaTime <= this.intervalBeginTime) {
                newBeginTime = mediaTime - (long)((int)(16.0f * this.msPerPixel));
                if (newBeginTime < 0L) {
                    newBeginTime = 0L;
                }
                newEndTime = newBeginTime + intervalMS;
            } else if (mediaTime >= this.intervalEndTime && (newBeginTime = (newEndTime = mediaTime + (long)((int)(16.0f * this.msPerPixel))) - intervalMS) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + intervalMS;
            }
            if (newBeginTime == this.getSelectionBeginTime() && (float)newBeginTime > 16.0f * this.msPerPixel) {
                newBeginTime = (long)((float)newBeginTime - 16.0f * this.msPerPixel);
                newEndTime = newBeginTime + intervalMS;
            }
            if (newEndTime == this.getSelectionEndTime() && (newBeginTime = (newEndTime = (long)((float)newEndTime + 16.0f * this.msPerPixel)) - intervalMS) < 0L) {
                newBeginTime = 0L;
                newEndTime = newBeginTime + intervalMS;
            }
        }
        if (newBeginTime == this.intervalBeginTime && newEndTime == this.intervalEndTime) {
            return;
        }
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(newBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(newEndTime);
            return;
        } else {
            this.setLocalTimeScaleIntervalBeginTime(newBeginTime);
        }
    }

    protected void setLocalTimeScaleIntervalBeginTime(long begin) {
    }

    protected void setLocalTimeScaleMsPerPixel(float step) {
    }

    protected void setTimeRulerVisible(boolean visible) {
        this.timeRulerVisible = visible;
        this.rulerHeight = this.timeRulerVisible ? this.ruler.getHeight() : 0;
    }

    public void setMsPerPixel(float mspp) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleMsPerPixel(mspp);
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        } else {
            this.setLocalTimeScaleMsPerPixel(mspp);
        }
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.crossHairTime = this.getMediaTime();
            if (!this.playerIsPlaying()) {
                this.recalculateInterval(this.crossHairTime);
                this.crossHairPos = this.xAt(this.crossHairTime);
                this.repaint();
            } else if (this.crossHairTime < this.intervalBeginTime || this.crossHairTime > this.intervalEndTime) {
                this.recalculateInterval(this.crossHairTime);
            } else {
                int oldPos = this.crossHairPos;
                int newPos = this.crossHairPos = this.xAt(this.crossHairTime);
                if (this.useBufferedImage) {
                    if (newPos >= oldPos) {
                        this.repaint(oldPos - 2, 0, newPos - oldPos + 4, this.getHeight());
                    } else {
                        this.repaint(newPos - 2, 0, oldPos - newPos + 4, this.getHeight());
                    }
                } else {
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void updateSelection() {
        this.selectionBeginPos = (int)((float)this.getSelectionBeginTime() / this.msPerPixel);
        this.selectionEndPos = (int)((float)this.getSelectionEndTime() / this.msPerPixel);
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateLocale() {
        if (this.popup != null) {
            this.zoomMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Zoom"));
            this.timeScaleConMI.setText(ElanLocale.getString("TimeScaleBasedViewer.Connected"));
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.zoomSelectionMI) {
            this.zoomToSelection();
        } else if (e.getActionCommand().equals("connect")) {
            boolean connected = ((JCheckBoxMenuItem)e.getSource()).getState();
            this.setTimeScaleConnected(connected);
        } else if (e.getSource() == this.timeRulerVisMI) {
            this.setTimeRulerVisible(this.timeRulerVisMI.isSelected());
        } else {
            String zoomString = e.getActionCommand();
            int zoom = 100;
            try {
                zoom = Integer.parseInt(zoomString);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Error parsing the zoom level");
                return;
            }
            float newMsPerPixel = 100.0f / (float)zoom * 10.0f;
            this.setMsPerPixel(newMsPerPixel);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean signalSel;
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        if (e.getClickCount() == 1 && e.isShiftDown()) {
            long clickTime;
            if (this.getSelectionBeginTime() != this.getSelectionEndTime()) {
                clickTime = this.timeAt(e.getPoint().x);
                if (clickTime > this.getSelectionEndTime()) {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                } else if (clickTime < this.getSelectionBeginTime()) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else if (clickTime - this.getSelectionBeginTime() < this.getSelectionEndTime() - clickTime) {
                    this.setSelection(clickTime, this.getSelectionEndTime());
                } else {
                    this.setSelection(this.getSelectionBeginTime(), clickTime);
                }
            } else {
                long medTime;
                clickTime = this.timeAt(e.getPoint().x);
                if (clickTime > (medTime = this.getMediaTime())) {
                    this.setSelection(medTime, clickTime);
                } else if (clickTime < medTime) {
                    this.setSelection(clickTime, medTime);
                }
            }
        } else {
            this.setMediaTime(this.timeAt(e.getPoint().x));
        }
        boolean bl = signalSel = this.getSelectionBeginTime() != 0L && this.getSelectionEndTime() != 0L;
        if (this.clearSelOnSingleClick && signalSel && e.getClickCount() == 1 && !e.isShiftDown() && !this.getViewerManager().getMediaPlayerController().getSelectionMode()) {
            this.setSelection(0L, 0L);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Point pp = e.getPoint();
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            this.updatePopup(pp);
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
            return;
        }
        if (this.playerIsPlaying()) {
            this.stopPlayer();
        }
        this.dragStartPoint = e.getPoint();
        this.dragStartTime = this.timeAt(this.dragStartPoint.x);
        if (e.isAltDown() && this.pointInHorizontalRuler(this.dragStartPoint.y)) {
            this.dragStartTime = this.timeAt(this.dragStartPoint.x);
            this.panMode = true;
            this.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.panMode = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.timeScaleConnected) {
            this.setGlobalTimeScaleIntervalBeginTime(this.intervalBeginTime);
            this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
        }
        if (this.panMode) {
            this.panMode = false;
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        this.dragEndPoint = e.getPoint();
        if (this.panMode) {
            int scrolldiff = this.dragEndPoint.x - this.dragStartPoint.x;
            long newTime = this.intervalBeginTime - (long)((int)((float)scrolldiff * this.msPerPixel));
            if (this.intervalBeginTime < 0L && newTime < this.intervalBeginTime) {
                newTime = this.intervalBeginTime;
            }
            this.setIntervalBeginTime(newTime);
            this.dragStartPoint = this.dragEndPoint;
            return;
        }
        if (this.timeAt(this.dragEndPoint.x) > this.dragStartTime) {
            this.selectionEndTime = this.timeAt(this.dragEndPoint.x);
            if (this.selectionEndTime > this.getMediaDuration()) {
                this.selectionEndTime = this.getMediaDuration();
            }
            this.selectionBeginTime = this.dragStartTime;
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionEndTime);
        } else {
            this.selectionBeginTime = this.timeAt(this.dragEndPoint.x);
            if (this.selectionBeginTime > this.getMediaDuration()) {
                this.selectionBeginTime = this.getMediaDuration();
            }
            this.selectionEndTime = this.dragStartTime;
            if (this.selectionEndTime > this.getMediaDuration()) {
                this.selectionEndTime = this.getMediaDuration();
            }
            if (this.selectionBeginTime < 0L) {
                this.selectionBeginTime = 0L;
            }
            if (this.selectionEndTime < 0L) {
                this.selectionEndTime = 0L;
            }
            this.setMediaTime(this.selectionBeginTime);
        }
        this.setSelection(this.selectionBeginTime, this.selectionEndTime);
        this.updateSelection();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() == 0 && e.getPreciseWheelRotation() == 0.0) {
            return;
        }
        if (e.isControlDown()) {
            if (e.getUnitsToScroll() > 0) {
                this.zoomOut();
            } else {
                this.zoomIn();
            }
            return;
        }
        if (e.isShiftDown()) {
            if (e.getWheelRotation() != 0) {
                long newTime;
                int timeDiff = (int)((float)(this.horScrollSpeed * e.getWheelRotation()) * this.msPerPixel);
                long l = newTime = this.intervalBeginTime + (long)timeDiff > 0L ? this.intervalBeginTime + (long)timeDiff : 0L;
                if (newTime != this.intervalBeginTime && newTime < this.getMediaDuration()) {
                    this.setIntervalBeginTime(newTime);
                }
            }
            return;
        }
        if (e.isAltDown()) {
            long newTime;
            int timeDiff = (int)((float)this.intervalWidth * this.msPerPixel);
            if (e.getWheelRotation() < 0) {
                timeDiff = -timeDiff;
            }
            long l = newTime = this.intervalBeginTime + (long)timeDiff > 0L ? this.intervalBeginTime + (long)timeDiff : 0L;
            if (newTime != this.intervalBeginTime && newTime < this.getMediaDuration()) {
                this.setIntervalBeginTime(newTime);
            }
            return;
        }
    }

    @Override
    public void preferencesChanged() {
        Integer intPref;
        Boolean boolPref = Preferences.getBool("ClearSelectionOnSingleClick", null);
        if (boolPref instanceof Boolean) {
            this.clearSelOnSingleClick = boolPref;
        }
        if ((intPref = Preferences.getInt("Preferences.TimeLine.HorScrollSpeed", null)) instanceof Integer) {
            this.horScrollSpeed = intPref;
        }
        boolPref = Preferences.getBool("UI.UseBufferedPainting", null);
        if (!SystemReporting.isBufferedPaintingPropertySet && boolPref != null) {
            this.useBufferedImage = boolPref;
        }
    }

    @Override
    public void zoomInStep() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        if (zoom >= (float)this.ZOOMLEVELS[this.ZOOMLEVELS.length - 1]) {
            return;
        }
        int zoomMenuIndex = -1;
        for (int i = 0; i < this.ZOOMLEVELS.length; ++i) {
            if (zoom < (float)this.ZOOMLEVELS[i]) {
                zoomMenuIndex = i;
                break;
            }
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i + 1;
        }
        if (zoomMenuIndex >= 0 && zoomMenuIndex < this.ZOOMLEVELS.length) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    @Override
    public void zoomOutStep() {
        float zoom = 100.0f / (this.msPerPixel / 10.0f);
        if (zoom <= (float)this.ZOOMLEVELS[0]) {
            return;
        }
        int zoomMenuIndex = -1;
        for (int i = this.ZOOMLEVELS.length - 1; i >= 0; --i) {
            if (zoom > (float)this.ZOOMLEVELS[i]) {
                zoomMenuIndex = i;
                break;
            }
            if (zoom != (float)this.ZOOMLEVELS[i]) continue;
            zoomMenuIndex = i - 1;
        }
        if (zoomMenuIndex >= 0 && zoomMenuIndex < this.ZOOMLEVELS.length) {
            int nextZoom = this.ZOOMLEVELS[zoomMenuIndex];
            float nextMsPerPixel = 100.0f / (float)nextZoom * 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }

    @Override
    public void zoomToDefault() {
        if ((int)this.msPerPixel != 10) {
            int nextZoom = 100;
            float nextMsPerPixel = 10.0f;
            this.setMsPerPixel(nextMsPerPixel);
            this.updateZoomPopup(nextZoom);
        }
    }
}

