/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.lexicon.LexiconClientFactoryLoader;
import mpi.eudico.client.annotator.lexicon.LexiconLoginDialog;
import mpi.eudico.client.annotator.lexicon.ValueChooseDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.eudico.server.corpora.lexicon.EntryElement;
import mpi.eudico.server.corpora.lexicon.Lexicon;
import mpi.eudico.server.corpora.lexicon.LexiconEntry;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.Pair;

public class LexiconEntryViewer
extends AbstractViewer
implements ACMEditListener,
ActionListener,
ElanLocaleListener,
TreeSelectionListener {
    private JPanel mainPanel;
    private JTextField activeAnnotationValue;
    private JLabel activeAnnotationLabel;
    private JTree lexiconResponseTree;
    private JButton getLexiconEntryButton;
    private String activeAnnotationText;
    private TierImpl tierOfActiveAnnotation;
    private LexiconServiceClient currentClient;
    private JLabel tierOfActiveAnnotationLabel;
    private JTextField tierOfActiveAnnotationValue;
    private JLabel constraintsLabel;
    private JComboBox constraintsComboBox;
    private DefaultMutableTreeNode resultsNode;
    private DefaultTreeModel resultsTreeModel;
    private LexiconQueryBundle2 currentLexiconQueryBundle;
    private JScrollPane lexiconResponseTextScroller;
    private JLabel message;
    private Lexicon searchResultLexicon;
    private JButton changeAnnotationButton;
    private JButton changeAnnotationsButton;
    private LexiconEntry activeLexiconEntry;
    private Annotation activeAnnotation;
    private ArrayList<String> selectedEntryValues;
    private boolean clientLoadStateChecked = false;
    private boolean lexiconEntrySelected = false;
    private boolean lexiconEntryFieldSelected = false;
    private static final Pair<ExternalReference, String> noPair = Pair.makePair(null, null);

    public LexiconEntryViewer() {
        this.initComponents();
    }

    private void initComponents() {
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.activeAnnotationLabel = new JLabel();
        searchPanel.add((Component)this.activeAnnotationLabel, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.activeAnnotationValue = new JTextField();
        searchPanel.add((Component)this.activeAnnotationValue, gbc);
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.tierOfActiveAnnotationLabel = new JLabel();
        searchPanel.add((Component)this.tierOfActiveAnnotationLabel, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.tierOfActiveAnnotationValue = new JTextField();
        this.tierOfActiveAnnotationValue.setEditable(false);
        searchPanel.add((Component)this.tierOfActiveAnnotationValue, gbc);
        gbc.fill = 0;
        gbc.anchor = 22;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.constraintsLabel = new JLabel();
        searchPanel.add((Component)this.constraintsLabel, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.constraintsComboBox = new JComboBox();
        searchPanel.add((Component)this.constraintsComboBox, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        this.getLexiconEntryButton = new JButton();
        this.getLexiconEntryButton.setEnabled(false);
        this.getLexiconEntryButton.addActionListener(this);
        searchPanel.add((Component)this.getLexiconEntryButton, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        this.changeAnnotationButton = new JButton();
        this.changeAnnotationButton.setEnabled(false);
        this.changeAnnotationButton.addActionListener(this);
        searchPanel.add((Component)this.changeAnnotationButton, gbc);
        gbc.fill = 2;
        gbc.anchor = 21;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        this.changeAnnotationsButton = new JButton();
        this.changeAnnotationsButton.setEnabled(false);
        this.changeAnnotationsButton.addActionListener(this);
        searchPanel.add((Component)this.changeAnnotationsButton, gbc);
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new GridBagLayout());
        gbc.fill = 1;
        gbc.anchor = 21;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        this.message = new JLabel();
        this.message.setBackground(Color.WHITE);
        this.resultsNode = new DefaultMutableTreeNode("Results");
        this.resultsTreeModel = new DefaultTreeModel(this.resultsNode);
        this.lexiconResponseTree = new JTree(this.resultsTreeModel);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setOpenIcon(null);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setClosedIcon(null);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setLeafIcon(null);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setTextNonSelectionColor(Color.BLACK);
        ((DefaultTreeCellRenderer)this.lexiconResponseTree.getCellRenderer()).setTextSelectionColor(Color.BLACK);
        this.lexiconResponseTree.getSelectionModel().setSelectionMode(1);
        this.lexiconResponseTree.addTreeSelectionListener(this);
        this.lexiconResponseTree.setRootVisible(true);
        this.lexiconResponseTextScroller = new JScrollPane(this.lexiconResponseTree);
        resultsPanel.add((Component)this.lexiconResponseTextScroller, gbc);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.mainPanel.add((Component)searchPanel, gbc);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.mainPanel.add((Component)resultsPanel, gbc);
        this.setLayout(new GridBagLayout());
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.mainPanel, gbc);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getLexiconEntryButton) {
            this.doSearch();
        } else if (e.getSource() == this.changeAnnotationButton) {
            this.changeAnnotation();
        } else if (e.getSource() == this.changeAnnotationsButton) {
            this.changeAnnotationAndDependents();
        }
    }

    private void doSearch() {
        String searchString = this.activeAnnotationValue.getText();
        if (this.currentClient != null && !searchString.equals("")) {
            this.lexiconResponseTree.removeTreeSelectionListener(this);
            boolean trySearch = true;
            while (trySearch) {
                try {
                    String resultsStr = ElanLocale.getString("LexiconEntryViewer.Results");
                    String lexiconStr = ElanLocale.getString("LexiconEntryViewer.Lexicon");
                    String fieldStr = ElanLocale.getString("LexiconEntryViewer.Field");
                    String constraintsStr = ElanLocale.getString("LexiconEntryViewer.Constraints");
                    String searchStringStr = ElanLocale.getString("LexiconEntryViewer.SearchString");
                    String performingStr = ElanLocale.getString("LexiconEntryViewer.PerformingMessage");
                    String rootText = "(" + lexiconStr + ": <i>" + this.currentLexiconQueryBundle.getLink().getLexId().getName() + "</i>; " + fieldStr + ": <i>" + this.currentLexiconQueryBundle.getFldId().getName() + "</i>; " + constraintsStr + ": <i>" + this.constraintsComboBox.getSelectedItem() + "</i>; " + searchStringStr + ": <i>" + searchString + "</i>)</html>";
                    this.message.setText("<html><b>" + performingStr + "</b> " + rootText);
                    this.lexiconResponseTextScroller.setViewportView(this.message);
                    this.searchResultLexicon = this.currentClient.search(this.currentLexiconQueryBundle.getLink().getLexId(), this.currentLexiconQueryBundle.getFldId(), (String)this.constraintsComboBox.getSelectedItem(), searchString);
                    this.searchResultLexicon.setName("<html><b>" + resultsStr + "</b> " + rootText);
                    this.lexiconResponseTree.setModel(this.searchResultLexicon);
                    if (this.lexiconResponseTree.getModel().getChildCount(this.searchResultLexicon) > 0) {
                        Object[] pathElements = new Object[]{this.searchResultLexicon, this.searchResultLexicon.getEntry(0)};
                        TreePath path = new TreePath(pathElements);
                        this.lexiconResponseTree.expandPath(path);
                    }
                    this.lexiconResponseTextScroller.setViewportView(this.lexiconResponseTree);
                    trySearch = false;
                    this.lexiconEntrySelected = false;
                    this.lexiconEntryFieldSelected = false;
                    this.activeLexiconEntry = null;
                    this.updateChangeAnnotationButtons();
                }
                catch (LexiconServiceClientException ex) {
                    if (ex.getMessage().equals("No username or password") || ex.getMessage().equals("Incorrect username or password") || ex.getMessage().equals("CONNECTION_MALFUNCTION")) {
                        Container parent = this.getRootPane().getParent();
                        if (parent instanceof Frame) {
                            LexiconLoginDialog loginDialog = new LexiconLoginDialog((Frame)parent, this.currentLexiconQueryBundle.getLink());
                            loginDialog.setVisible(true);
                            if (loginDialog.isCanceled()) {
                                trySearch = false;
                            }
                        }
                    }
                    String title = ElanLocale.getString("LexiconLink.Action.Error");
                    String message = title + "\n" + ElanLocale.getString("LexiconServiceClientException.Cause") + " " + ElanLocale.getString(ex.getMessageLocaleKey());
                    JOptionPane.showMessageDialog(this, message, title, 0);
                    trySearch = false;
                }
                this.message.setText("");
            }
            this.lexiconResponseTree.addTreeSelectionListener(this);
        }
    }

    private void changeAnnotation() {
        String newAnnotationValue = "";
        if (this.selectedEntryValues.size() == 1) {
            newAnnotationValue = this.selectedEntryValues.get(0);
        } else if (this.selectedEntryValues.size() > 1) {
            Container parent = this.getRootPane().getParent();
            ValueChooseDialog chooser = new ValueChooseDialog((Frame)parent, this.selectedEntryValues);
            chooser.setVisible(true);
            if (!chooser.isCanceled()) {
                newAnnotationValue = chooser.getSelectedValue();
            } else {
                return;
            }
        }
        LinguisticType type = this.tierOfActiveAnnotation.getLinguisticType();
        Pair<ExternalReference, String> refs = this.getExtRefAndId(type, newAnnotationValue);
        String cveId = refs.getSecond();
        Command c = ELANCommandFactory.createCommand(this.tierOfActiveAnnotation.getTranscription(), "Menu.Annotation.ModifyAnnotation");
        Object[] args = new Object[]{this.activeAnnotation.getValue(), newAnnotationValue, null, cveId};
        c.execute(this.activeAnnotation, args);
    }

    private Pair<ExternalReference, String> getExtRefAndId(LinguisticType type, String newAnnotationValue) {
        TranscriptionImpl trans;
        ControlledVocabulary cv;
        CVEntry cvEntry;
        Pair<ExternalReference, String> refs = noPair;
        if (type.isUsingControlledVocabulary() && (cvEntry = (cv = (trans = this.tierOfActiveAnnotation.getTranscription()).getControlledVocabulary(type.getControlledVocabularyName())).getEntryWithValue(newAnnotationValue)) != null) {
            ExternalReference extRef = cvEntry.getExternalRef();
            String cveId = cvEntry.getId();
            refs = Pair.makePair(extRef, cveId);
        }
        return refs;
    }

    private void changeAnnotationAndDependents() {
        ArrayList<String> args = new ArrayList<String>();
        String lexiconname = this.currentLexiconQueryBundle.getLinkName();
        ArrayList<TierImpl> tiers = new ArrayList<TierImpl>();
        tiers.add(this.tierOfActiveAnnotation);
        List<TierImpl> dependentTiers = this.tierOfActiveAnnotation.getDependentTiers();
        if (dependentTiers != null) {
            tiers.addAll(dependentTiers);
        }
        for (TierImpl currentTier : tiers) {
            LinguisticType lingtype = currentTier.getLinguisticType();
            LexiconQueryBundle2 lexicon = lingtype.getLexiconQueryBundle();
            if (lexicon == null || !lexiconname.equals(lexicon.getLinkName())) continue;
            String fieldname = lexicon.getFldId().getName();
            String newAnnotationValue = this.findField(this.activeLexiconEntry, fieldname);
            Pair<ExternalReference, String> refs = this.getExtRefAndId(lingtype, newAnnotationValue);
            String cveId = refs.getSecond();
            args.add(currentTier.getName());
            args.add(newAnnotationValue);
            args.add(null);
            args.add(cveId);
        }
        Object[] oargs = args.toArray();
        Command c = ELANCommandFactory.createCommand(this.tierOfActiveAnnotation.getTranscription(), "LexiconEntryViewer.ChangeAnnotations");
        c.execute(this.activeAnnotation, oargs);
    }

    private String findField(EntryElement entry, String fieldname) {
        if (entry.isField()) {
            if (fieldname.equals(entry.getName())) {
                return entry.getValue();
            }
            return "";
        }
        String s = this.findFieldRecursive(entry, fieldname);
        return s == null ? "" : s;
    }

    private String findFieldRecursive(EntryElement entry, String fieldname) {
        for (EntryElement e : entry.getElements()) {
            if (e.isField()) {
                if (!fieldname.equals(e.getName())) continue;
                return e.getValue();
            }
            String s = this.findFieldRecursive(e, fieldname);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void updateActiveAnnotation() {
        this.doUpdate();
    }

    @Override
    public void updateLocale() {
        this.activeAnnotationLabel.setText(ElanLocale.getString("LexiconEntryViewer.AnnotationLabel"));
        this.tierOfActiveAnnotationLabel.setText(ElanLocale.getString("LexiconEntryViewer.Tier"));
        this.constraintsLabel.setText(ElanLocale.getString("LexiconEntryViewer.Constraints"));
        this.getLexiconEntryButton.setText(ElanLocale.getString("LexiconEntryViewer.GetEntriesButton"));
        this.changeAnnotationButton.setText(ElanLocale.getString("LexiconEntryViewer.ChangeAnnotation"));
        this.changeAnnotationButton.setToolTipText(ElanLocale.getString("LexiconEntryViewer.ChangeAnnotationToolTip"));
        this.changeAnnotationsButton.setText(ElanLocale.getString("LexiconEntryViewer.ChangeAnnotations"));
        this.changeAnnotationsButton.setToolTipText(ElanLocale.getString("LexiconEntryViewer.ChangeAnnotationsToolTip"));
    }

    @Override
    public void updateSelection() {
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        this.doUpdate();
    }

    private void doUpdate() {
        this.activeAnnotationValue.setText("");
        this.tierOfActiveAnnotationValue.setText("");
        this.constraintsComboBox.removeAllItems();
        this.getLexiconEntryButton.setEnabled(false);
        this.activeAnnotation = this.getActiveAnnotation();
        if (this.activeAnnotation != null) {
            String defaultCVEntryValue = this.getDefaultCVEntryValue();
            this.activeAnnotationText = defaultCVEntryValue != null ? defaultCVEntryValue : this.activeAnnotation.getValue();
            this.activeAnnotationValue.setText(this.activeAnnotationText);
            this.tierOfActiveAnnotation = (TierImpl)this.activeAnnotation.getTier();
            this.tierOfActiveAnnotationValue.setText(this.tierOfActiveAnnotation.getName());
            LinguisticType linguisticTypeOfTier = this.tierOfActiveAnnotation.getLinguisticType();
            this.currentLexiconQueryBundle = linguisticTypeOfTier.getLexiconQueryBundle();
            if (this.currentLexiconQueryBundle != null) {
                if (!this.clientLoadStateChecked) {
                    if (!this.tierOfActiveAnnotation.getTranscription().isLexiconServicesLoaded()) {
                        new LexiconClientFactoryLoader().loadLexiconClientFactories(this.tierOfActiveAnnotation.getTranscription());
                        this.tierOfActiveAnnotation.getTranscription().setLexiconServicesLoaded(true);
                    }
                    this.clientLoadStateChecked = true;
                }
                this.currentClient = this.currentLexiconQueryBundle.getLink().getSrvcClient();
                if (this.currentClient != null) {
                    this.getLexiconEntryButton.setEnabled(true);
                    ArrayList<String> constraints = this.currentClient.getSearchConstraints();
                    for (int i = 0; i < constraints.size(); ++i) {
                        this.constraintsComboBox.addItem(constraints.get(i));
                    }
                }
            }
        }
        this.updateChangeAnnotationButtons();
    }

    private String getDefaultCVEntryValue() {
        String cvName = this.activeAnnotation.getTier().getLinguisticType().getControlledVocabularyName();
        if (cvName != null) {
            String entryId = this.activeAnnotation.getCVEntryId();
            ControlledVocabulary cv = this.activeAnnotation.getTier().getTranscription().getControlledVocabulary(cvName);
            CVEntry entry = cv.getEntrybyId(entryId);
            if (entry != null) {
                return entry.getValue(0);
            }
            if (entryId != null && ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("The CVEntry for " + entryId + " is null.");
            }
        }
        return null;
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.lexiconEntrySelected = false;
        this.lexiconEntryFieldSelected = false;
        TreePath path = this.lexiconResponseTree.getSelectionPath();
        this.activeLexiconEntry = null;
        if (path != null) {
            Object node = path.getLastPathComponent();
            if (node instanceof LexiconEntry) {
                this.activeLexiconEntry = (LexiconEntry)node;
                this.selectedEntryValues = this.activeLexiconEntry.getFocusFieldValues();
                this.lexiconEntrySelected = true;
            } else if (node instanceof EntryElement) {
                String value = ((EntryElement)node).getValue();
                String lowercased = value.toLowerCase();
                if (lowercased.startsWith("http://") || lowercased.startsWith("https://")) {
                    try {
                        URL url = new URL(value);
                        this.openURL(value);
                    }
                    catch (MalformedURLException malformedURLException) {}
                } else if (!value.isEmpty()) {
                    this.selectedEntryValues = new ArrayList();
                    this.selectedEntryValues.add(value);
                    this.lexiconEntryFieldSelected = true;
                }
            }
        }
        this.updateChangeAnnotationButtons();
    }

    private void updateChangeAnnotationButtons() {
        this.changeAnnotationButton.setEnabled(this.activeAnnotation != null && (this.lexiconEntryFieldSelected || this.lexiconEntrySelected));
        this.changeAnnotationsButton.setEnabled(this.activeAnnotation != null && this.lexiconEntrySelected);
    }

    private void openURL(String url) {
        if (url == null) {
            return;
        }
        try {
            URI uri = new URI(url);
            Desktop.getDesktop().browse(uri);
        }
        catch (URISyntaxException use) {
            ClientLogger.LOG.warning("Error opening webpage: " + use.getMessage());
            this.errorMessage(use.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Error opening webpage: " + ioe.getMessage());
            this.errorMessage(ioe.getMessage());
        }
    }

    private void errorMessage(String message) {
        JOptionPane.showMessageDialog(this, ElanLocale.getString("Message.Web.NoConnection") + ": " + message, ElanLocale.getString("Message.Warning"), 2);
    }
}

