/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.TierOrder;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.TierSortAndSelectDialog2;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class SegmentationControlPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener,
ComponentListener {
    public static final int MARGIN = 5;
    private TranscriptionImpl transcription;
    private List<TierImpl> tiers;
    private List<TierImpl> acceptableTiers;
    private List<TierImpl> visibleTiers;
    private Map<TierImpl, String> tierNames;
    private Map<TierImpl, Color> tierRootColors;
    private Map<TierImpl, Color> prefTierColors;
    private MultiTierViewer viewer;
    private int[] tierPositions;
    private Tier activeTier;
    private BufferedImage bi;
    private Graphics2D big2d;
    private FontMetrics fontMetrics;
    private Font boldFont;
    private FontMetrics boldMetrics;
    private boolean dragging;
    private int dragX;
    private int dragY;
    private String dragLabel;
    private int tierHeight;
    private int editTierHeight;
    private JComponent resizer = null;
    private JPopupMenu popup;
    private TierOrder tierOrder;

    public SegmentationControlPanel(TranscriptionImpl transcription) {
        this.setLayout(null);
        this.transcription = transcription;
        this.initComponents();
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void initComponents() {
        this.tiers = this.transcription.getTiers();
        this.acceptableTiers = new ArrayList<TierImpl>(this.tiers.size());
        this.visibleTiers = new ArrayList<TierImpl>(this.tiers.size());
        this.tierNames = new HashMap<TierImpl, String>(this.tiers.size());
        this.tierRootColors = new HashMap<TierImpl, Color>();
        this.prefTierColors = new HashMap<TierImpl, Color>();
        this.editTierHeight = 30;
        for (TierImpl tier : this.transcription.getTiers()) {
            if (tier.hasParentTier() && (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 1)) continue;
            this.tierNames.put(tier, tier.getName());
            this.acceptableTiers.add(tier);
            this.visibleTiers.add(tier);
        }
        if (this.visibleTiers.size() > 0) {
            this.activeTier = this.visibleTiers.get(0);
        }
        this.loadPreferences();
    }

    public MultiTierViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(MultiTierViewer viewer) {
        this.viewer = viewer;
        viewer.setVisibleTiers(this.visibleTiers);
        if (this.activeTier != null) {
            viewer.setActiveTier(this.activeTier);
        }
    }

    public void setTierOrderObject(TierOrder tierOrder) {
        this.tierOrder = tierOrder;
        if (tierOrder != null && tierOrder.getTierOrder() != null && tierOrder.getTierOrder().size() > 1) {
            TierImpl iterTier;
            int j;
            String name;
            int i;
            ArrayList<TierImpl> tempList = new ArrayList<TierImpl>(this.visibleTiers);
            this.visibleTiers.clear();
            for (i = 0; i < tierOrder.getTierOrder().size(); ++i) {
                name = tierOrder.getTierOrder().get(i);
                for (j = 0; j < tempList.size(); ++j) {
                    iterTier = (TierImpl)tempList.get(j);
                    if (!name.equals(iterTier.getName())) continue;
                    tempList.remove(j);
                    this.visibleTiers.add(iterTier);
                    break;
                }
                if (tempList.size() == 0) break;
            }
            this.visibleTiers.addAll(tempList);
            tempList = new ArrayList<TierImpl>(this.acceptableTiers);
            this.acceptableTiers.clear();
            for (i = 0; i < tierOrder.getTierOrder().size(); ++i) {
                name = tierOrder.getTierOrder().get(i);
                for (j = 0; j < tempList.size(); ++j) {
                    iterTier = (TierImpl)tempList.get(j);
                    if (!name.equals(iterTier.getName())) continue;
                    tempList.remove(j);
                    this.acceptableTiers.add(iterTier);
                    break;
                }
                if (tempList.size() == 0) break;
            }
            this.acceptableTiers.addAll(tempList);
        }
    }

    public int getEditTierHeight() {
        return this.editTierHeight;
    }

    public void setEditTierHeight(int editTierHeight) {
        this.editTierHeight = editTierHeight;
        this.paintBuffer();
    }

    public void setTierHeight(int tierHeight) {
        this.tierHeight = tierHeight;
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.tierHeight = 3 * f.getSize();
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.boldFont = this.getFont().deriveFont(1);
        this.boldMetrics = this.getFontMetrics(this.boldFont);
    }

    public void setResizeComponent(JComponent comp) {
        if (this.resizer != null) {
            this.remove(this.resizer);
        }
        this.resizer = comp;
        if (this.resizer != null) {
            this.add(this.resizer);
            this.resizer.setBounds(this.getWidth() - this.resizer.getWidth(), 1, this.resizer.getWidth(), this.resizer.getHeight());
            this.resizer.setBackground(Constants.ACTIVETIERCOLOR);
        }
        this.repaint();
    }

    public void setTierPositions(int[] tierPositions) {
        this.tierPositions = tierPositions;
        this.paintBuffer();
    }

    public void setActiveTier(Tier tier) {
        if (tier == this.activeTier) {
            return;
        }
        this.activeTier = tier;
        if (this.activeTier != null) {
            if (this.viewer != null) {
                this.viewer.setActiveTier(tier);
                this.setPreference("SegmentationViewer.ActiveTier", tier.getName(), this.transcription);
            }
        } else {
            this.setPreference("SegmentationViewer.ActiveTier", null, this.transcription);
        }
        this.paintBuffer();
    }

    public Tier getActiveTier() {
        return this.activeTier;
    }

    public void addTier(TierImpl tier) {
        if (tier == null) {
            return;
        }
        if (this.tierNames.containsValue(tier.getName())) {
            return;
        }
        if (this.tierNames.containsKey(tier)) {
            return;
        }
        if (!tier.hasParentTier() || tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 1) {
            this.tierNames.put(tier, tier.getName());
            this.acceptableTiers.add(tier);
            this.visibleTiers.add(tier);
            if (this.visibleTiers.size() == 1) {
                this.activeTier = tier;
            }
            if (this.viewer != null) {
                this.viewer.setVisibleTiers(this.visibleTiers);
            }
            this.paintBuffer();
            this.storeTierOrders();
        }
    }

    public void removeTier(TierImpl tier) {
        if (tier == null) {
            return;
        }
        this.tierNames.remove(tier);
        this.acceptableTiers.remove(tier);
        this.visibleTiers.remove(tier);
        if (this.activeTier == tier) {
            this.activeTier = null;
        }
        if (this.viewer != null) {
            this.viewer.setVisibleTiers(this.visibleTiers);
        }
        this.paintBuffer();
        this.storeTierOrders();
    }

    public void changeTier(TierImpl tier) {
        if (tier == null) {
            return;
        }
        if (this.tierNames.containsKey(tier)) {
            this.tierNames.put(tier, tier.getName());
            if (this.viewer != null) {
                this.viewer.setVisibleTiers(this.visibleTiers);
            }
            this.paintBuffer();
            this.storeTierOrders();
        }
    }

    private void paintBuffer() {
        int actualLabelWidth;
        if (this.getWidth() <= 0 || this.getHeight() <= 0) {
            return;
        }
        if (this.bi == null || this.bi.getWidth() != this.getWidth() || this.bi.getHeight() != this.getHeight()) {
            this.bi = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        this.big2d = this.bi.createGraphics();
        if (SystemReporting.antiAliasedText) {
            this.big2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.big2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
        this.big2d.fillRect(0, 0, this.bi.getWidth(), this.bi.getHeight());
        if (this.tierPositions == null || this.tierPositions.length == 0) {
            this.repaint();
            return;
        }
        int y = this.tierPositions[0];
        int panelWidth = this.getWidth();
        int availableLabelWidth = panelWidth - 10;
        String label = "";
        this.big2d.setColor(Constants.ACTIVETIERCOLOR);
        this.big2d.fillRect(0, 0, panelWidth, this.editTierHeight);
        if (this.activeTier != null) {
            this.big2d.setFont(this.boldFont);
            this.big2d.setColor(Color.RED);
            label = this.truncateString(this.tierNames.get(this.activeTier), availableLabelWidth, this.boldMetrics);
            actualLabelWidth = SwingUtilities.computeStringWidth(this.boldMetrics, label);
            int x = 5 + availableLabelWidth - actualLabelWidth;
            y = this.tierPositions[0] + this.boldFont.getSize() / 2;
            this.big2d.drawString(label, x, y);
        }
        this.big2d.setColor(Constants.SHAREDCOLOR3);
        this.big2d.setFont(this.getFont());
        if (this.tierPositions.length > 1) {
            int tierIndex = 0;
            for (int i = 1; i < this.tierPositions.length; ++i) {
                y = this.tierPositions[i];
                if (y < this.editTierHeight + this.tierHeight - 2) {
                    if (i % 2 == 0 && y + this.tierHeight > this.editTierHeight) {
                        this.big2d.setColor(Constants.LIGHTBACKGROUNDCOLOR);
                        this.big2d.fillRect(0, this.editTierHeight, this.bi.getWidth(), y - this.editTierHeight);
                    }
                    if (y < this.editTierHeight + this.tierHeight) continue;
                    this.big2d.drawLine(0, y, this.bi.getWidth(), y);
                    continue;
                }
                tierIndex = i - 1;
                if (i % 2 == 0) {
                    this.big2d.setColor(Constants.LIGHTBACKGROUNDCOLOR);
                    this.big2d.fillRect(0, y - this.tierHeight + 1, this.bi.getWidth(), this.tierHeight);
                }
                if (tierIndex < this.visibleTiers.size()) {
                    TierImpl tier = this.visibleTiers.get(tierIndex);
                    if (tier == this.activeTier && tierIndex >= 0) {
                        this.big2d.setColor(Color.RED);
                        this.big2d.fillRect(1, y - this.tierHeight, 4, this.tierHeight);
                    }
                    label = this.truncateString(this.tierNames.get(tier), availableLabelWidth, this.fontMetrics);
                    actualLabelWidth = SwingUtilities.computeStringWidth(this.fontMetrics, label);
                    int x = 5 + availableLabelWidth - actualLabelWidth;
                    y -= (this.tierHeight - this.getFont().getSize()) / 2;
                    Color col = this.prefTierColors.get(tier);
                    if (col == null) {
                        this.big2d.setColor(Constants.SHAREDCOLOR6);
                    } else {
                        this.big2d.setColor(col);
                    }
                    this.big2d.drawString(label, x, y);
                }
                this.big2d.setColor(Constants.SHAREDCOLOR3);
                y = this.tierPositions[i];
                this.big2d.drawLine(0, y, this.bi.getWidth(), y);
            }
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (SystemReporting.antiAliasedText) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        if (this.bi != null) {
            g2d.drawImage((Image)this.bi, 0, 0, this);
        }
        g2d.setColor(Constants.SELECTIONCOLOR);
        g2d.drawLine(0, 0, this.getWidth() - 1, 0);
        g2d.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight());
        if (this.dragging) {
            g2d.setFont(this.boldFont);
            g2d.setColor(Color.blue);
            g2d.drawString(this.dragLabel, this.dragX, this.dragY);
        }
        if (this.resizer != null) {
            this.resizer.repaint();
        }
    }

    private String truncateString(String string, int width, FontMetrics fMetrics) {
        int stringWidth;
        Object line = string;
        if (fMetrics != null && (stringWidth = fMetrics.stringWidth((String)line)) > width - 4) {
            int i = 0;
            Object s = "";
            int size = ((String)line).length();
            while (i < size && fMetrics.stringWidth((String)s) <= width - 4) {
                s = (String)s + ((String)line).charAt(i++);
            }
            line = !((String)s).equals("") ? ((String)s).substring(0, ((String)s).length() - 1) : s;
        }
        return line;
    }

    private void showTierSelectionDialog() {
        ArrayList<String> allNames = new ArrayList<String>(this.acceptableTiers.size());
        for (TierImpl tierImpl : this.acceptableTiers) {
            allNames.add(tierImpl.getName());
        }
        ArrayList<String> visNames = new ArrayList<String>(this.visibleTiers.size());
        for (TierImpl t : this.visibleTiers) {
            visNames.add(t.getName());
        }
        TierSortAndSelectDialog2 tierSortAndSelectDialog2 = new TierSortAndSelectDialog2(ELANCommandFactory.getRootFrame(this.transcription), this.transcription, allNames, visNames, true, true, AbstractTierSortAndSelectPanel.Modes.ROOT_W_INCLUDED);
        tierSortAndSelectDialog2.setTitle(ElanLocale.getString("MultiTierControlPanel.Menu.ShowTiers"));
        tierSortAndSelectDialog2.setLocationRelativeTo(this);
        Rectangle bounds = tierSortAndSelectDialog2.getBounds();
        if (bounds.x < this.getLocationOnScreen().x) {
            tierSortAndSelectDialog2.setBounds(this.getLocationOnScreen().x, bounds.y, bounds.width, bounds.height);
        }
        String selectionMode = Preferences.getString("SegmentationViewer.SelectTierMode", this.transcription);
        List<String> hiddenItems = Preferences.getListOfString("SegmentationViewer.HiddenItems", this.transcription);
        tierSortAndSelectDialog2.setSelectionMode(selectionMode, hiddenItems);
        tierSortAndSelectDialog2.setVisible(true);
        List<String> editedTiers = tierSortAndSelectDialog2.getSelectedTiers();
        if (editedTiers != null) {
            TierImpl t;
            this.setPreference("SegmentationViewer.HiddenTiers", tierSortAndSelectDialog2.getHiddenTiers(), this.transcription);
            this.setPreference("SegmentationViewer.SelectTierMode", tierSortAndSelectDialog2.getSelectionMode(), this.transcription);
            this.setPreference("SegmentationViewer.HiddenItems", tierSortAndSelectDialog2.getUnselectedItems(), this.transcription);
            List<String> allSorted = tierSortAndSelectDialog2.getTierOrder();
            this.acceptableTiers.clear();
            for (String name : allSorted) {
                t = this.transcription.getTierWithId(name);
                if (t == null) continue;
                this.acceptableTiers.add(t);
            }
            this.visibleTiers.clear();
            for (String name : editedTiers) {
                t = this.transcription.getTierWithId(name);
                this.visibleTiers.add(t);
            }
            if (this.activeTier != null) {
                if (!this.visibleTiers.contains(this.activeTier) && this.visibleTiers.size() > 0) {
                    this.activeTier = this.visibleTiers.get(0);
                }
            } else if (this.visibleTiers.size() > 0) {
                this.activeTier = this.visibleTiers.get(0);
            }
            this.viewer.setVisibleTiers(this.visibleTiers);
            this.viewer.setActiveTier(this.activeTier);
            this.storeTierOrders();
            this.paintBuffer();
        }
    }

    private void activateTier(int yPos) {
        if (yPos < this.editTierHeight) {
            return;
        }
        if (this.tierPositions == null || this.tierPositions.length <= 1) {
            return;
        }
        if (yPos > this.tierPositions[this.tierPositions.length - 1]) {
            return;
        }
        for (int i = 0; i < this.tierPositions.length; ++i) {
            TierImpl t;
            if (yPos <= this.tierPositions[i] || i >= this.tierPositions.length - 1 || yPos > this.tierPositions[i + 1] || i >= this.visibleTiers.size() || (t = this.visibleTiers.get(i)) == this.activeTier) continue;
            this.setActiveTier(t);
            break;
        }
    }

    public void updateLocale() {
        this.popup = null;
    }

    private void loadPreferences() {
        List<String> allTiers;
        String tierName = Preferences.getString("SegmentationViewer.ActiveTier", this.transcription);
        if (tierName != null) {
            for (TierImpl tierImpl : this.acceptableTiers) {
                if (tierImpl == null || !tierImpl.getName().equals(tierName)) continue;
                this.setActiveTier(tierImpl);
                break;
            }
        }
        if ((allTiers = Preferences.getListOfString("SegmentationViewer.TierOrder", this.transcription)) != null) {
            this.acceptableTiers.clear();
            for (String name : allTiers) {
                TierImpl t = this.transcription.getTierWithId(name);
                if (t == null || t.hasParentTier() && (t.getLinguisticType().getConstraints() == null || t.getLinguisticType().getConstraints().getStereoType() != 1)) continue;
                this.acceptableTiers.add(t);
                this.tierNames.put(t, t.getName());
            }
        }
        for (TierImpl t : this.visibleTiers) {
            if (this.acceptableTiers.contains(t)) continue;
            this.acceptableTiers.add(t);
        }
        List<String> list = Preferences.getListOfString("SegmentationViewer.HiddenTiers", this.transcription);
        if (list != null) {
            this.visibleTiers.clear();
            this.visibleTiers.addAll(this.acceptableTiers);
            for (String name : list) {
                TierImpl t = this.transcription.getTierWithId(name);
                if (t == null) continue;
                this.visibleTiers.remove(t);
            }
            if (this.viewer != null) {
                this.viewer.setVisibleTiers(this.visibleTiers);
            }
        }
    }

    private void storeTierOrders() {
        ArrayList<String> hiddenTiers = new ArrayList<String>();
        ArrayList<String> allNames = new ArrayList<String>(this.acceptableTiers.size());
        for (TierImpl tierImpl : this.acceptableTiers) {
            allNames.add(tierImpl.getName());
        }
        ArrayList<String> visNames = new ArrayList<String>(this.visibleTiers.size());
        for (TierImpl t : this.visibleTiers) {
            visNames.add(t.getName());
        }
        for (String name : allNames) {
            if (visNames.contains(name)) continue;
            hiddenTiers.add(name);
        }
        this.setPreference("SegmentationViewer.HiddenTiers", hiddenTiers, this.transcription);
        this.setPreference("SegmentationViewer.TierOrder", allNames, this.transcription);
    }

    private void setPreference(String key, Object value, Transcription trans) {
        Preferences.set(key, value, trans, false, false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            this.activateTier(e.getPoint().y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.popup = new JPopupMenu("");
                JMenuItem mi = new JMenuItem(ElanLocale.getString("MultiTierControlPanel.Menu.ShowHideMore"));
                mi.addActionListener(this);
                mi.setActionCommand("Select");
                this.popup.add(mi);
            }
            this.popup.show(this, e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Select")) {
            this.showTierSelectionDialog();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.resizer != null) {
            this.resizer.setBounds(this.getWidth() - this.resizer.getWidth(), 1, this.resizer.getWidth(), this.resizer.getHeight());
        }
        this.paintBuffer();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

