/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.SpectrogramSettingsDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.DefaultTimeScaleBasedViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.util.WAVSampler;
import mpi.eudico.client.util.WAVSamplesProvider;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;
import nl.mpi.media.spectrogram.FFT;
import nl.mpi.media.spectrogram.ImageCreator;
import nl.mpi.media.spectrogram.SpectrogramSettings;
import nl.mpi.media.spectrogram.WindowFunction;
import nl.mpi.util.FileUtility;

public class SpectrogramViewer
extends DefaultTimeScaleBasedViewer
implements ItemListener {
    private String mediaFilePath;
    private MediaDescriptor mediaDescriptor;
    private WAVSamplesProvider mediaSampler;
    private SpectrogramSettings specSettings;
    private FFT fft;
    private double[] weightingWindow;
    private ImageCreator imgCreator;
    private BufferedImage specImage;
    private IntervalCache curCache = null;
    private BasicStroke dashLine = new BasicStroke(0.75f, 0, 2, 1.0f, new float[]{8.0f, 10.0f}, 0.0f);
    private String errorKey = null;
    private double[] normalizedRange = new double[]{-110.0, 0.0};
    private double[][] amplitudeRanges;
    private final ReentrantLock shiftLoadLock = new ReentrantLock();
    protected JMenuItem settingsMI;
    protected JMenuItem detailMI;
    protected JMenu channelMenu;
    protected JRadioButtonMenuItem channel1MI;
    protected JRadioButtonMenuItem channel2MI;
    protected JRadioButtonMenuItem channel12MI;
    private boolean prefsInited = false;
    private boolean globalPrefsInited = false;
    private String tooltipFormat = "<html><table><tr><td>T</td><td>%.2f &nbsp;[ %s ]</td></tr><tr><td>Hz</td><td>\u00b1 %.0f - %.0f</td></tr></table></html>";
    private long lastUpdate = 0L;
    private boolean refreshPending = false;

    public SpectrogramViewer() {
        this.initViewer();
    }

    public SpectrogramViewer(String mediaPath) {
        this();
        this.setMedia(mediaPath);
    }

    public SpectrogramViewer(MediaDescriptor mediaDescriptor) {
        this(mediaDescriptor.mediaURL);
        this.mediaDescriptor = mediaDescriptor;
        this.setMediaTimeOffset(mediaDescriptor.timeOrigin);
    }

    public SpectrogramViewer(WAVSamplesProvider sampler) {
        this();
        this.setMediaSampler(sampler, null);
        if (ClientLogger.LOG.isLoggable(Level.INFO)) {
            ClientLogger.LOG.log(Level.INFO, "MediaSampler URL for SpectrogramViewer: " + sampler.getMediaLocation());
        }
    }

    public SpectrogramViewer(WAVSamplesProvider sampler, MediaDescriptor mediaDescriptor) {
        this(sampler);
        this.mediaDescriptor = mediaDescriptor;
        if (mediaDescriptor != null && mediaDescriptor.timeOrigin != 0L) {
            this.setMediaTimeOffset(mediaDescriptor.timeOrigin);
        }
        if (ClientLogger.LOG.isLoggable(Level.INFO)) {
            ClientLogger.LOG.log(Level.INFO, "MediaSampler URL for SpectrogramViewer: " + sampler.getMediaLocation());
        }
    }

    public synchronized void setMedia(String mediaPath) {
        if (mediaPath.startsWith("file:")) {
            mediaPath = mediaPath.substring(5);
        }
        this.mediaFilePath = mediaPath;
        this.initSampler(mediaPath);
    }

    public synchronized void setMediaSampler(WAVSamplesProvider sampler, MediaDescriptor mediaDescriptor) {
        if (sampler != null) {
            this.mediaSampler = sampler;
            this.mediaFilePath = sampler.getMediaLocation();
            if (this.mediaFilePath.startsWith("file:")) {
                this.mediaFilePath = this.mediaFilePath.substring(5);
            }
            this.specSettings.setSampleFrequency(this.mediaSampler.getSampleFrequency());
            this.specSettings.setPossibleMaxFrequency((double)this.mediaSampler.getSampleFrequency() / 2.0);
            this.specSettings.setNormalizedInputData(true);
            if (this.specSettings.isNormalizedInputData()) {
                this.specSettings.setLowerValueLimit(this.normalizedRange[0]);
                this.specSettings.setUpperValueLimit(this.normalizedRange[1]);
            } else {
                this.specSettings.setLowerValueLimit(this.amplitudeRanges[this.mediaSampler.getBitsPerSample() / 8 - 1][0]);
                this.specSettings.setUpperValueLimit(this.amplitudeRanges[this.mediaSampler.getBitsPerSample() / 8 - 1][1]);
            }
        }
        this.mediaDescriptor = mediaDescriptor;
        if (mediaDescriptor != null && mediaDescriptor.timeOrigin != this.mediaTimeOffset) {
            this.setMediaTimeOffset(mediaDescriptor.timeOrigin);
        }
    }

    private void initSampler(String sourcePath) {
        this.mediaSampler = null;
        this.errorKey = null;
        try {
            this.mediaSampler = new WAVSampler(sourcePath);
            short compr = this.mediaSampler.getCompressionCode();
            if (compr != 0 && compr != 1 && compr != 6 && compr != -2) {
                this.errorKey = ElanLocale.getString("SignalViewer.Message.Compression") + ": " + this.mediaSampler.getCompressionString(compr);
                if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                    StringBuilder sb = new StringBuilder("Unsupported WAVE file, information from the Header:\n");
                    sb.append("\tWAVE Format:\t" + this.mediaSampler.getCompressionString(compr) + "\n");
                    sb.append("\tNo. Channels:\t" + this.mediaSampler.getNumberOfChannels() + "\n");
                    sb.append("\tSample Rate:\t" + this.mediaSampler.getSampleFrequency());
                    ClientLogger.LOG.info(sb.toString());
                }
            }
            this.specSettings.setSampleFrequency(this.mediaSampler.getSampleFrequency());
            this.specSettings.setPossibleMaxFrequency((double)this.mediaSampler.getSampleFrequency() / 2.0);
        }
        catch (IOException ioe) {
            if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.log(Level.INFO, "Failed to create a WAVSampler " + ioe.getMessage());
            }
            this.errorKey = ElanLocale.getString("SignalViewer.Message.NoReader") + ": " + ioe.getMessage();
        }
    }

    @Override
    protected void initViewer() {
        super.initViewer();
        this.rulerHeight = this.ruler.getHeight();
        this.timeRulerVisible = false;
        this.timeScaleConnected = true;
        this.specSettings = new SpectrogramSettings();
        this.calcWindowAndStride();
        this.fft = new FFT();
        this.imgCreator = new ImageCreator(this.specSettings);
        this.specSettings.setChannelMode(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_ALL);
        this.amplitudeRanges = new double[4][2];
        this.amplitudeRanges[0] = new double[]{-100.0, 40.0};
        this.amplitudeRanges[1] = new double[]{-60.0, 90.0};
        this.amplitudeRanges[2] = new double[]{-20.0, 140.0};
        this.amplitudeRanges[3] = new double[]{20.0, 190.0};
    }

    @Override
    protected void createPopupMenu() {
        super.createPopupMenu();
        this.timeRulerVisMI.setVisible(false);
        this.channelMenu = new JMenu(ElanLocale.getString("SpectrogramViewer.AudioChannel"));
        ButtonGroup channelGroup = new ButtonGroup();
        this.channel1MI = new JRadioButtonMenuItem(ElanLocale.getString("SpectrogramViewer.Channel1"), this.specSettings.getChannelMode() == SpectrogramSettings.FREQ_CHANNEL.CHANNEL_1);
        this.channel1MI.addItemListener(this);
        channelGroup.add(this.channel1MI);
        this.channelMenu.add(this.channel1MI);
        this.channel2MI = new JRadioButtonMenuItem(ElanLocale.getString("SpectrogramViewer.Channel2"), this.specSettings.getChannelMode() == SpectrogramSettings.FREQ_CHANNEL.CHANNEL_2);
        this.channel2MI.addItemListener(this);
        channelGroup.add(this.channel2MI);
        this.channelMenu.add(this.channel2MI);
        this.channel12MI = new JRadioButtonMenuItem(ElanLocale.getString("SpectrogramViewer.Channel12"), this.specSettings.getChannelMode() == SpectrogramSettings.FREQ_CHANNEL.CHANNEL_ALL);
        this.channel12MI.addItemListener(this);
        channelGroup.add(this.channel12MI);
        this.channelMenu.add(this.channel12MI);
        this.popup.add(this.channelMenu);
        this.settingsMI = new JMenuItem(ElanLocale.getString("SpectrogramViewer.Settings"));
        this.settingsMI.addActionListener(this);
        this.popup.addSeparator();
        this.popup.add(this.settingsMI);
    }

    @Override
    protected void updateZoomPopup(float zoom) {
        super.updateZoomPopup(zoom);
    }

    @Override
    protected void zoomToSelection() {
        long selInterval = this.getSelectionEndTime() - this.getSelectionBeginTime();
        if (selInterval < 150L) {
            selInterval = 150L;
        }
        int sw = this.imageWidth != 0 ? this.imageWidth - 32 : this.getWidth() - 32;
        float nextMsPP = (float)selInterval / (float)sw;
        this.setMsPerPixel(nextMsPP);
        if (!this.playerIsPlaying()) {
            long ibt = this.getSelectionBeginTime() - (long)(16.0f * this.msPerPixel);
            if (ibt < 0L) {
                ibt = 0L;
            }
            this.setIntervalBeginTime(ibt);
        }
    }

    private void calcWindowAndStride() {
        if (this.mediaSampler == null) {
            return;
        }
        if (this.specSettings.getSampleFrequency() != (double)this.mediaSampler.getSampleFrequency()) {
            this.specSettings.setSampleFrequency(this.mediaSampler.getSampleFrequency());
        }
    }

    private void recreateSpectrogramImage() {
        if (this.mediaSampler == null) {
            return;
        }
        int[] samples = null;
        int numToRead = 0;
        boolean needNewSamples = this.specSettings.isNewDataRequired();
        boolean needNewTransform = this.specSettings.isNewTransformRequired();
        boolean needNewImage = this.specSettings.isNewImageRequired();
        if (this.curCache == null) {
            needNewSamples = true;
            needNewTransform = true;
            needNewImage = true;
            this.curCache = new IntervalCache();
        } else if (this.curCache.beginTime != this.intervalBeginTime) {
            needNewSamples = true;
        } else if (this.curCache.endTime < this.intervalEndTime) {
            needNewSamples = true;
        }
        if (needNewSamples) {
            double fromTimeSec;
            double durSec;
            double samplesPerPixel = (double)this.msPerPixel * 0.001 * (double)this.mediaSampler.getSampleFrequency();
            double extraSec = 0.0;
            extraSec = samplesPerPixel / (double)this.specSettings.getNumSamplesPerWindow() < 1.0 ? 2.0 * this.specSettings.getActualWindowDurationSec() : 2.0 * this.specSettings.getPixelDurationSec();
            double toTimeSec = (double)(this.intervalEndTime + this.mediaTimeOffset) * 0.001;
            if ((toTimeSec += extraSec) > this.mediaSampler.getDurationSeconds()) {
                toTimeSec = this.mediaSampler.getDurationSeconds();
            }
            if ((durSec = toTimeSec - (fromTimeSec = (double)(this.intervalBeginTime + this.mediaTimeOffset) * 0.001)) <= 0.0) {
                return;
            }
            numToRead = (int)Math.ceil(durSec * (double)this.mediaSampler.getSampleFrequency());
            samples = this.loadSamples(fromTimeSec, toTimeSec, numToRead);
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, String.format("New samples: from: %d, to %.3f, sample count: %.3f", samples == null ? 0 : numToRead, fromTimeSec, toTimeSec));
            }
        }
        if (needNewSamples) {
            needNewTransform = true;
        }
        double[][] freqWindows = null;
        if (needNewTransform && (samples != null || this.curCache.loadedSamples != null)) {
            if (samples == null) {
                samples = this.curCache.loadedSamples;
                numToRead = this.curCache.samplesUsed;
            }
            freqWindows = this.getFrequencies(samples, numToRead);
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, String.format("New frequencies: number of windows: %d, number of bins per window: %d", freqWindows == null ? 0 : freqWindows.length, freqWindows == null ? 0 : freqWindows[0].length));
            }
        }
        if (needNewTransform) {
            needNewImage = true;
        } else if (this.curCache.imgHeight != this.getHeight() || this.curCache.imgWidth < this.getWidth()) {
            needNewImage = true;
        }
        if (needNewImage && this.getWidth() > 0 && this.getHeight() > 0) {
            this.imageWidth = this.getWidth();
            if (this.mediaSampler.getDuration() < (float)this.intervalEndTime) {
                double actDuration = this.mediaSampler.getDuration() - (float)this.intervalBeginTime;
                this.imageWidth = (int)(actDuration / (double)this.msPerPixel);
            }
            this.imageHeight = this.getHeight();
            if (freqWindows == null && this.curCache.freqWindows != null) {
                freqWindows = this.curCache.freqWindows;
            }
            this.specImage = this.toImage(freqWindows, this.imageWidth, this.imageHeight);
            this.repaint();
            this.curCache.beginTime = this.intervalBeginTime;
            this.curCache.endTime = this.intervalEndTime;
            if (freqWindows != null) {
                this.curCache.freqWindows = freqWindows;
            }
            if (samples != null) {
                this.curCache.loadedSamples = samples;
            }
            if (numToRead != 0) {
                this.curCache.samplesUsed = numToRead;
            }
            this.curCache.imgWidth = this.imageWidth;
            this.curCache.imgHeight = this.imageHeight;
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, String.format("New image: width: %d, height: %d", this.imageWidth, this.imageHeight));
            }
        }
        this.specSettings.resetFlags();
        this.refreshPending = false;
    }

    private boolean shiftAndLoad(float overlap) {
        if (this.curCache == null) {
            return false;
        }
        if ((double)overlap >= 0.8 && overlap < 1.0f) {
            double fromTimeSec;
            double toTimeSec;
            boolean extendRight;
            boolean extendLeft = this.intervalBeginTime < this.curCache.beginTime;
            boolean bl = extendRight = this.intervalEndTime > this.curCache.endTime;
            if (!extendLeft && !extendRight) {
                return false;
            }
            System.out.println("Shifting left/right, Thread: " + Thread.currentThread().getName());
            System.out.println(String.format("Percentage to shift: %f, #samples: %d, #windows: %d", Float.valueOf(1.0f - overlap), (int)((1.0f - overlap) * (float)this.curCache.samplesUsed), (int)((1.0f - overlap) * (float)this.curCache.freqWindows.length)));
            double shiftPerc = 1.0f - overlap;
            double shiftSamples = shiftPerc * (double)this.curCache.samplesUsed;
            double shiftWindows = shiftPerc * (double)this.curCache.freqWindows.length;
            double samplesPerPixel = (double)this.msPerPixel * 0.001 * (double)this.mediaSampler.getSampleFrequency();
            double secPerPixel = this.specSettings.getPixelDurationSec();
            double pixWinRatio = samplesPerPixel / (double)this.specSettings.getNumSamplesPerWindow();
            System.out.println("Samples per pixel: " + samplesPerPixel + " per window: " + this.specSettings.getNumSamplesPerWindow());
            double extraSec = 0.0;
            extraSec = pixWinRatio < 1.0 ? 2.0 * this.specSettings.getActualWindowDurationSec() : 2.0 * secPerPixel;
            if (extendRight) {
                toTimeSec = (double)(this.intervalEndTime + this.mediaTimeOffset) * 0.001;
                toTimeSec += extraSec;
                fromTimeSec = (double)(this.curCache.endTime + this.mediaTimeOffset) * 0.001;
                if (toTimeSec > this.mediaSampler.getDurationSeconds()) {
                    toTimeSec = this.mediaSampler.getDurationSeconds();
                }
            } else {
                toTimeSec = (double)(this.curCache.beginTime + this.mediaTimeOffset) * 0.001;
                toTimeSec += extraSec;
                fromTimeSec = (double)(this.intervalBeginTime + this.mediaTimeOffset) * 0.001;
                if (fromTimeSec < 0.0) {
                    fromTimeSec = 0.0;
                }
            }
            double durSec = toTimeSec - fromTimeSec;
            System.out.println("Orig sample diff: " + durSec * (double)this.mediaSampler.getSampleFrequency());
            int numToRead = (int)Math.ceil(durSec * (double)this.mediaSampler.getSampleFrequency());
            int[] orgSamples = null;
            orgSamples = this.curCache.loadedSamples == this.mediaSampler.getChannelArray(0) || this.curCache.loadedSamples == this.mediaSampler.getChannelArray(1) ? Arrays.copyOf(this.curCache.loadedSamples, this.curCache.samplesUsed) : this.curCache.loadedSamples;
            this.mediaSampler.seekTimeSeconds(fromTimeSec);
            int[] samples = this.loadSamples(fromTimeSec, toTimeSec, numToRead);
            if (samples == null) {
                return false;
            }
            double[][] freqWindows = this.getFrequencies(samples, numToRead);
            if (freqWindows == null) {
                return false;
            }
            System.out.println(String.format("Windows to drop %f, new windows %d", shiftWindows, freqWindows.length));
            int outsideSampleShift = (int)Math.round(shiftSamples);
            System.out.println(String.format("Num samples read: %d, shift samples: %d, discard samples: %d", numToRead, outsideSampleShift, numToRead - outsideSampleShift));
            int[] mergedSamples = new int[this.curCache.samplesUsed];
            if (extendRight) {
                System.arraycopy(orgSamples, outsideSampleShift, mergedSamples, 0, mergedSamples.length - outsideSampleShift);
                int insert = this.curCache.samplesUsed - outsideSampleShift;
                System.arraycopy(samples, 0, mergedSamples, insert, mergedSamples.length - insert);
            } else {
                System.arraycopy(samples, 0, mergedSamples, 0, numToRead);
                System.arraycopy(orgSamples, 0, mergedSamples, outsideSampleShift, this.curCache.samplesUsed - outsideSampleShift);
            }
            this.curCache.loadedSamples = mergedSamples;
            this.curCache.samplesUsed = mergedSamples.length;
            this.curCache.beginTime = this.intervalBeginTime;
            this.curCache.endTime = this.intervalEndTime;
            int outsideWinShift = (int)Math.round(shiftWindows);
            System.out.println(String.format("Shift windows: %d", outsideWinShift));
            System.out.println("Num windows to discard: " + (freqWindows.length - outsideWinShift));
            double[][] mergedFreqs = new double[this.curCache.freqWindows.length][];
            if (extendRight) {
                System.arraycopy(this.curCache.freqWindows, outsideWinShift, mergedFreqs, 0, this.curCache.freqWindows.length - outsideWinShift);
                int winsert = mergedFreqs.length - outsideWinShift;
                System.arraycopy(freqWindows, 0, mergedFreqs, winsert, Math.min(mergedFreqs.length - winsert, freqWindows.length));
            } else {
                System.arraycopy(freqWindows, 0, mergedFreqs, 0, freqWindows.length);
                System.arraycopy(this.curCache.freqWindows, 0, mergedFreqs, outsideWinShift, this.curCache.freqWindows.length - outsideWinShift);
            }
            this.curCache.freqWindows = mergedFreqs;
            this.specImage = this.toImage(mergedFreqs, this.curCache.imgWidth, this.curCache.imgHeight);
            this.repaint();
            return true;
        }
        return false;
    }

    private int[] loadSamples(double fromTimeSec, double toTimeSec, int numToRead) {
        if (this.mediaSampler != null) {
            this.mediaSampler.seekTimeSeconds(fromTimeSec);
            double duration = Math.min(this.mediaSampler.getDurationSeconds(), toTimeSec) - fromTimeSec;
            if (duration <= 0.0) {
                return null;
            }
            boolean padAtEnd = this.mediaSampler.getDurationSeconds() <= toTimeSec;
            int numActRead = 0;
            if (this.mediaSampler.getNumberOfChannels() > 1) {
                if (this.specSettings.getChannelMode() == SpectrogramSettings.FREQ_CHANNEL.CHANNEL_2) {
                    numActRead = this.mediaSampler.readInterval(numToRead, 2);
                    if (padAtEnd) {
                        int[] loaded = this.mediaSampler.getChannelArray(1);
                        if (loaded.length < numToRead) {
                            return Arrays.copyOf(loaded, numToRead);
                        }
                        return loaded;
                    }
                    return this.mediaSampler.getChannelArray(1);
                }
                if (this.specSettings.getChannelMode() == SpectrogramSettings.FREQ_CHANNEL.CHANNEL_ALL) {
                    numActRead = this.mediaSampler.readInterval(numToRead, 1);
                    if (padAtEnd) {
                        int[] loaded = this.mediaSampler.getChannelArray(0);
                        if (loaded.length < numToRead) {
                            return Arrays.copyOf(loaded, numToRead);
                        }
                        return loaded;
                    }
                    return this.mediaSampler.getChannelArray(0);
                }
                numActRead = this.mediaSampler.readInterval(numToRead, 2);
                if (padAtEnd) {
                    int[] loaded = this.mediaSampler.getChannelArray(0);
                    if (loaded.length < numToRead) {
                        return Arrays.copyOf(loaded, numToRead);
                    }
                    return loaded;
                }
                return this.mediaSampler.getChannelArray(0);
            }
            numActRead = this.mediaSampler.readInterval(numToRead, 1);
            if (padAtEnd) {
                int[] loaded = this.mediaSampler.getChannelArray(0);
                if (loaded.length < numToRead) {
                    return Arrays.copyOf(loaded, numToRead);
                }
                return loaded;
            }
            return this.mediaSampler.getChannelArray(0);
        }
        return null;
    }

    private double[][] getFrequencies(int[] samples, int numSamplesToUse) {
        int numWindows;
        if (this.specSettings.getNumSamplesPerWindow() == 0 || this.specSettings.getNumSamplesPerStride() == 0) {
            this.calcWindowAndStride();
        }
        int samplesPerWindow = this.specSettings.getNumSamplesPerWindow();
        int samplesPerStride = this.specSettings.getNumSamplesPerStride();
        if (this.weightingWindow == null || this.weightingWindow.length != samplesPerWindow || this.specSettings.isNewWindowDataRequired()) {
            this.weightingWindow = WindowFunction.windowForName(WindowFunction.getWFName(this.specSettings.getWindowFunction()), samplesPerWindow);
        }
        if ((numWindows = (numSamplesToUse - samplesPerWindow) / samplesPerStride) <= 0) {
            return null;
        }
        while (numWindows * samplesPerStride < numSamplesToUse - samplesPerWindow) {
            ++numWindows;
        }
        double[][] columnArray = new double[numWindows][];
        boolean power = this.specSettings.getAmplUnit() == SpectrogramSettings.AMPL_UNIT.POWER;
        boolean rootPower = this.specSettings.getAmplUnit() == SpectrogramSettings.AMPL_UNIT.ROOT_POWER;
        double ma = this.mediaSampler.getPossibleMaxSample();
        int ri = 0;
        for (int w = 0; ri < numSamplesToUse - samplesPerWindow && w < columnArray.length; ri += samplesPerStride, ++w) {
            double[] ra = new double[samplesPerWindow];
            for (int k = 0; k < samplesPerWindow; ++k) {
                if (this.weightingWindow != null) {
                    if (this.specSettings.isNormalizedInputData()) {
                        ra[k] = (double)samples[k + ri] / ma * this.weightingWindow[k];
                        continue;
                    }
                    ra[k] = (double)samples[k + ri] * this.weightingWindow[k];
                    continue;
                }
                ra[k] = this.specSettings.isNormalizedInputData() ? (double)samples[k + ri] / ma : (double)samples[k + ri];
            }
            double[] fa = this.fft.jFFTLROpt(ra, true, true, true, true, power, rootPower, false);
            columnArray[w] = fa;
        }
        if (power) {
            this.specSettings.setAdaptiveMinimum(10.0 * Math.log10(1.0E-14));
        } else if (rootPower) {
            this.specSettings.setAdaptiveMinimum(20.0 * Math.log10(1.0E-14));
        } else {
            this.specSettings.setAdaptiveMinimum(this.mediaSampler.getPossibleMinSample());
        }
        return columnArray;
    }

    private BufferedImage toImage(double[][] freqWindows, int imWidth, int imHeight) {
        if (freqWindows != null) {
            if (this.playerIsPlaying()) {
                return this.imgCreator.createSpecImage(freqWindows, imWidth, imHeight, SpectrogramSettings.PERFORMANCE.SPEED);
            }
            return this.imgCreator.createSpecImage(freqWindows, imWidth, imHeight, SpectrogramSettings.PERFORMANCE.QUALITY);
        }
        return null;
    }

    @Override
    public void setMediaTimeOffset(long offset) {
        if (offset != this.mediaTimeOffset) {
            super.setMediaTimeOffset(offset);
            this.crossHairPos = this.xAt(this.crossHairTime);
            this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
            this.selectionEndPos = this.xAt(this.getSelectionEndTime());
            this.recreateSpectrogramImage();
        }
    }

    @Override
    public void mediaOffsetChanged() {
        String url = null;
        url = this.mediaDescriptor != null ? this.mediaDescriptor.mediaURL : FileUtility.pathToURLString(this.mediaFilePath);
        List<MediaDescriptor> descs = this.getViewerManager().getTranscription().getMediaDescriptors();
        for (MediaDescriptor md : descs) {
            if (!url.equals(md.mediaURL)) continue;
            this.setMediaTimeOffset(md.timeOrigin);
            break;
        }
    }

    @Override
    public void setMediaTime(long milliSeconds) {
        super.setMediaTime(milliSeconds);
    }

    @Override
    protected void setLocalTimeScaleIntervalBeginTime(long begin) {
        if (begin == this.intervalBeginTime) {
            return;
        }
        if (this.playerIsPlaying()) {
            long curUpdate = System.currentTimeMillis();
            long elapsed = curUpdate - this.lastUpdate;
            if (elapsed < 50L) {
                this.refreshPending = true;
                return;
            }
            this.lastUpdate = curUpdate;
        }
        try {
            if (this.shiftLoadLock.tryLock(40L, TimeUnit.MILLISECONDS)) {
                this.intervalBeginTime = begin;
                this.intervalEndTime = this.intervalBeginTime + (long)((float)this.intervalWidth * this.msPerPixel);
                this.crossHairPos = this.xAt(this.crossHairTime);
                this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
                this.selectionEndPos = this.xAt(this.getSelectionEndTime());
                this.recreateSpectrogramImage();
                this.shiftLoadLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private float amountOverlap(long ob, long oe, long nb, long ne) {
        if (nb >= oe) {
            return 0.0f;
        }
        if (ne <= ob) {
            return 0.0f;
        }
        if (nb == ob && ne > oe) {
            return (float)(ne - nb) / (float)(oe - ob);
        }
        if (ne == oe && nb < ob) {
            return (float)(ne - nb) / (float)(oe - ob);
        }
        if (nb > ob) {
            return (float)(oe - nb) / (float)(oe - ob);
        }
        if (nb < ob) {
            return (float)(ne - ob) / (float)(oe - ob);
        }
        return 0.0f;
    }

    @Override
    protected void recalculateInterval(long mediaTime) {
        super.recalculateInterval(mediaTime);
    }

    @Override
    public void updateTimeScale() {
        super.updateTimeScale();
        this.recreateSpectrogramImage();
    }

    @Override
    protected void setLocalTimeScaleMsPerPixel(float step) {
        if (step == this.msPerPixel) {
            return;
        }
        this.msPerPixel = step >= 0.025f ? step : 0.025f;
        long mediaTime = this.getMediaTime();
        int oldScreenPos = this.crossHairPos;
        long newMediaX = (long)((float)mediaTime / this.msPerPixel);
        int numScreens = this.intervalWidth > 0 ? (int)((float)mediaTime / ((float)this.intervalWidth * this.msPerPixel)) : 0;
        int newScreenPos = (int)newMediaX - numScreens * this.intervalWidth + this.vertRulerWidth;
        int diff = oldScreenPos - newScreenPos;
        this.intervalBeginTime = (long)((float)(numScreens * this.intervalWidth - diff) * this.msPerPixel);
        if (this.intervalBeginTime < 0L) {
            this.intervalBeginTime = 0L;
        }
        this.intervalEndTime = this.intervalBeginTime + (long)((float)this.intervalWidth * this.msPerPixel);
        this.crossHairPos = this.xAt(mediaTime);
        this.selectionBeginPos = this.xAt(this.getSelectionBeginTime());
        this.selectionEndPos = this.xAt(this.getSelectionEndTime());
        this.specSettings.setPixelDurationSec((double)this.msPerPixel * 0.001);
        this.recreateSpectrogramImage();
        this.repaint();
        int zoom = Math.round(100.0f * (10.0f / this.msPerPixel));
        if (zoom <= 0) {
            zoom = 100;
        }
        this.updateZoomPopup(zoom);
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
        super.controllerUpdate(event);
        if (event instanceof StopEvent && this.refreshPending) {
            this.recreateSpectrogramImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Object object = this.getTreeLock();
        synchronized (object) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Constants.DEFAULTBACKGROUNDCOLOR);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.specImage != null) {
                g2d.drawImage((Image)this.specImage, 0, 0, this);
            }
            int h = this.getHeight();
            Stroke basicStr = g2d.getStroke();
            if (this.selectionBeginPos != this.selectionEndPos) {
                g2d.setComposite(AlphaComposite.Src);
                g2d.setColor(Constants.ACTIVEANNOTATIONCOLOR);
                g2d.setStroke(this.dashLine);
                g2d.drawLine(this.selectionBeginPos, 0, this.selectionBeginPos, h - 1);
                g2d.drawLine(this.selectionEndPos, 0, this.selectionEndPos, h - 1);
            }
            g2d.setStroke(basicStr);
            g2d.setColor(Constants.CROSSHAIRCOLOR);
            g2d.drawLine(this.crossHairPos, 0, this.crossHairPos, h);
            if (this.errorKey != null) {
                g2d.setColor(Constants.DEFAULTFOREGROUNDCOLOR);
                g2d.drawString(this.errorKey, 10, this.getHeight() / 2);
            }
        }
    }

    @Override
    public void setMsPerPixel(float mspp) {
        super.setMsPerPixel(mspp);
    }

    @Override
    public void updateSelection() {
        this.selectionBeginTime = this.getSelectionBeginTime();
        this.selectionEndTime = this.getSelectionEndTime();
        this.selectionBeginPos = this.xAt(this.selectionBeginTime);
        this.selectionEndPos = this.xAt(this.selectionEndTime);
        if (this.selectionEndPos < this.selectionBeginPos) {
            this.selectionEndPos = this.selectionBeginPos;
        }
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.intervalWidth = this.getWidth();
        long curEndTime = this.intervalEndTime;
        this.intervalEndTime = this.intervalBeginTime + (long)((int)((float)this.intervalWidth * this.msPerPixel));
        if (curEndTime != this.intervalEndTime) {
            if (this.timeScaleConnected) {
                this.setGlobalTimeScaleIntervalEndTime(this.intervalEndTime);
            }
            this.recreateSpectrogramImage();
        } else if (this.specImage == null || this.specImage.getHeight() != this.getHeight() || this.specImage.getWidth() != this.getWidth()) {
            this.recreateSpectrogramImage();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.settingsMI) {
            SpectrogramSettingsDialog settingsDiag = new SpectrogramSettingsDialog(null, this.specSettings);
            settingsDiag.setVisible(true);
            this.recreateSpectrogramImage();
            this.storePreferences();
            return;
        }
        super.actionPerformed(e);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.channel1MI && e.getStateChange() == 1) {
            this.specSettings.setChannelMode(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_1);
        } else if (e.getSource() == this.channel2MI && e.getStateChange() == 1) {
            this.specSettings.setChannelMode(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_2);
        } else if (e.getSource() == this.channel12MI && e.getStateChange() == 1) {
            this.specSettings.setChannelMode(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_ALL);
        }
        this.recreateSpectrogramImage();
        this.setPreference("SpectrogramViewer.ChannelMode", this.specSettings.getChannelMode().toString(), this.getViewerManager().getTranscription());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.playerIsPlaying()) {
            this.setToolTipText(null);
            return;
        }
        double t = (double)((float)this.intervalBeginTime + (float)e.getX() * this.msPerPixel) * 0.001;
        long tt = this.timeAt(e.getX());
        double maxFreq = Math.min(this.specSettings.getMaxDisplayFrequency(), this.specSettings.getPossibleMaxFrequency());
        double freqRange = maxFreq - this.specSettings.getMinDisplayFrequency();
        double vertPos = (double)(this.getHeight() - e.getY()) / (double)this.getHeight();
        double freqPerPix = freqRange / (double)this.getHeight();
        double freq = vertPos * freqRange + this.specSettings.getMinDisplayFrequency();
        this.setToolTipText(String.format(this.tooltipFormat, t, TimeFormatter.toString(tt), freq - freqPerPix, freq));
    }

    @Override
    public void preferencesChanged() {
        super.preferencesChanged();
        if (!this.prefsInited) {
            this.initPreferences();
        }
        if (!this.globalPrefsInited) {
            this.loadPreferences();
        }
        this.useBufferedImage = false;
    }

    private void initPreferences() {
        String chMode = Preferences.getString("SpectrogramViewer.ChannelMode", this.getViewerManager().getTranscription());
        if (chMode != null) {
            if (chMode.equals(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_1.toString())) {
                this.specSettings.setChannelMode(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_1);
            } else if (chMode.equals(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_2.toString())) {
                this.specSettings.setChannelMode(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_2);
            } else {
                this.specSettings.setChannelMode(SpectrogramSettings.FREQ_CHANNEL.CHANNEL_ALL);
            }
        }
        this.prefsInited = true;
    }

    private void storePreferences() {
        SpectrogramSettings defSettings = new SpectrogramSettings();
        if (this.specSettings.getMinDisplayFrequency() != defSettings.getMinDisplayFrequency()) {
            this.setPreference("SpectrogramViewer.MinDisplayedFrequency", this.specSettings.getMinDisplayFrequency(), null);
        } else {
            this.setPreference("SpectrogramViewer.MinDisplayedFrequency", null, null);
        }
        if (this.specSettings.getMaxDisplayFrequency() != defSettings.getMaxDisplayFrequency()) {
            this.setPreference("SpectrogramViewer.MaxDisplayedFrequency", this.specSettings.getMaxDisplayFrequency(), null);
        } else {
            this.setPreference("SpectrogramViewer.MaxDisplayedFrequency", null, null);
        }
        if (this.specSettings.getColorScheme() != defSettings.getColorScheme()) {
            this.setPreference("SpectrogramViewer.ColorScheme", this.specSettings.getColorScheme().toString(), null);
            if (this.specSettings.getColorScheme() == SpectrogramSettings.COLOR_SCHEME.BI_COLOR) {
                this.setPreference("SpectrogramViewer.ColorScheme.FG", this.specSettings.getColor1(), null);
                this.setPreference("SpectrogramViewer.ColorScheme.BG", this.specSettings.getColor2(), null);
            }
        } else {
            this.setPreference("SpectrogramViewer.ColorScheme", null, null);
        }
        if (this.specSettings.isAdaptiveContrast() != defSettings.isAdaptiveContrast()) {
            this.setPreference("SpectrogramViewer.AdaptiveContrast", this.specSettings.isAdaptiveContrast(), null);
        } else {
            this.setPreference("SpectrogramViewer.AdaptiveContrast", null, null);
        }
        if (this.specSettings.getLowerValueAdjustment() != defSettings.getLowerValueAdjustment()) {
            this.setPreference("SpectrogramViewer.Brightness.Lower", this.specSettings.getLowerValueAdjustment(), null);
        } else {
            this.setPreference("SpectrogramViewer.Brightness.Lower", null, null);
        }
        if (this.specSettings.getUpperValueAdjustment() != defSettings.getUpperValueAdjustment()) {
            this.setPreference("SpectrogramViewer.Brightness.Upper", this.specSettings.getUpperValueAdjustment(), null);
        } else {
            this.setPreference("SpectrogramViewer.Brightness.Upper", null, null);
        }
        if (!this.specSettings.getWindowFunction().equals(defSettings.getWindowFunction())) {
            this.setPreference("SpectrogramViewer.WindowFunction", this.specSettings.getWindowFunction(), null);
        } else {
            this.setPreference("SpectrogramViewer.WindowFunction", null, null);
        }
        if (this.specSettings.getWindowDurationSec() != defSettings.getWindowDurationSec()) {
            this.setPreference("SpectrogramViewer.WindowDuration", this.specSettings.getWindowDurationSec(), null);
        } else {
            this.setPreference("SpectrogramViewer.WindowDuration", null, null);
        }
        if (this.specSettings.getStrideDurationSec() != defSettings.getStrideDurationSec()) {
            this.setPreference("SpectrogramViewer.StrideDuration", this.specSettings.getStrideDurationSec(), null);
        } else {
            this.setPreference("SpectrogramViewer.StrideDuration", null, null);
        }
    }

    private void loadPreferences() {
        Boolean prefBool;
        Color prefColor;
        String prefString;
        Double prefDouble = Preferences.getDouble("SpectrogramViewer.MinDisplayedFrequency", null);
        if (prefDouble != null) {
            this.specSettings.setMinDisplayFrequency(prefDouble);
        }
        if ((prefDouble = Preferences.getDouble("SpectrogramViewer.MaxDisplayedFrequency", null)) != null) {
            this.specSettings.setMaxDisplayFrequency(prefDouble);
        }
        if ((prefString = Preferences.getString("SpectrogramViewer.ColorScheme", null)) != null) {
            if (prefString.equals(SpectrogramSettings.COLOR_SCHEME.REVERSED_GRAY.toString())) {
                this.specSettings.setColorScheme(SpectrogramSettings.COLOR_SCHEME.REVERSED_GRAY);
            } else if (prefString.equals(SpectrogramSettings.COLOR_SCHEME.BI_COLOR.toString())) {
                this.specSettings.setColorScheme(SpectrogramSettings.COLOR_SCHEME.BI_COLOR);
            } else if (prefString.equals(SpectrogramSettings.COLOR_SCHEME.GRAY.toString())) {
                this.specSettings.setColorScheme(SpectrogramSettings.COLOR_SCHEME.GRAY);
            }
        }
        if ((prefColor = Preferences.getColor("SpectrogramViewer.ColorScheme.FG", null)) != null) {
            this.specSettings.setColor1(prefColor);
        }
        if ((prefColor = Preferences.getColor("SpectrogramViewer.ColorScheme.BG", null)) != null) {
            this.specSettings.setColor2(prefColor);
        }
        if ((prefBool = Preferences.getBool("SpectrogramViewer.AdaptiveContrast", null)) != null) {
            this.specSettings.setAdaptiveContrast(prefBool);
        }
        if ((prefDouble = Preferences.getDouble("SpectrogramViewer.Brightness.Lower", null)) != null) {
            this.specSettings.setLowerValueAdjustment(prefDouble);
        }
        if ((prefDouble = Preferences.getDouble("SpectrogramViewer.Brightness.Upper", null)) != null) {
            this.specSettings.setUpperValueAdjustment(prefDouble);
        }
        if ((prefString = Preferences.getString("SpectrogramViewer.WindowFunction", null)) != null) {
            this.specSettings.setWindowFunction(prefString);
        }
        if ((prefDouble = Preferences.getDouble("SpectrogramViewer.WindowDuration", null)) != null) {
            this.specSettings.setWindowDurationSec(prefDouble);
        }
        if ((prefDouble = Preferences.getDouble("SpectrogramViewer.StrideDuration", null)) != null) {
            this.specSettings.setStrideDurationSec(prefDouble);
        }
        this.globalPrefsInited = true;
        this.recreateSpectrogramImage();
    }

    private class IntervalCache {
        int[] loadedSamples;
        int samplesUsed;
        double[][] freqWindows;
        int imgWidth;
        int imgHeight;
        long beginTime;
        long endTime;

        private IntervalCache() {
        }
    }
}

