/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.InlineEditBoxListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.InlineEditBox;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class SubtitleViewer
extends AbstractViewer
implements SingleTierViewer,
ACMEditListener,
ActionListener,
InlineEditBoxListener {
    private JMenu fontMenu;
    private ButtonGroup fontSizeBG;
    private int fontSize;
    private JPopupMenu popup;
    private Dimension minDimension = new Dimension(400, 50);
    private JTextArea taSubtitle;
    private JScrollPane jspSubtitle;
    private TierImpl tier;
    private List<? extends Annotation> annotations = new ArrayList<Annotation>();
    private long begintime = 0L;
    private long endtime = 0L;
    private long[] arrTags;
    private Highlighter highlighter;
    private Highlighter.HighlightPainter selectionPainter;
    private InlineEditBox inlineEditBox;
    private int viewerIndex = 0;

    public SubtitleViewer() {
        try {
            this.setLayout(new BorderLayout());
            this.taSubtitle = new JTextArea(){

                @Override
                protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    return false;
                }
            };
            this.taSubtitle.setFont(Constants.DEFAULTFONT);
            this.taSubtitle.setLineWrap(true);
            this.taSubtitle.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.taSubtitle.setForeground(Constants.DEFAULTFOREGROUNDCOLOR);
            this.taSubtitle.setEditable(false);
            this.taSubtitle.addMouseListener(new SubtitleViewerMouseListener(this));
            this.highlighter = this.taSubtitle.getHighlighter();
            this.selectionPainter = new DefaultHighlighter.DefaultHighlightPainter(Constants.SELECTIONCOLOR);
            this.jspSubtitle = new JScrollPane(this.taSubtitle);
            this.add((Component)this.jspSubtitle, "Center");
            this.fontSize = 12;
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minDimension;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.minDimension;
    }

    @Override
    public void updateSelection() {
        this.doUpdate();
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 14: {
                this.setTier(this.getTier());
                this.doUpdate();
            }
        }
    }

    @Override
    public void preferencesChanged() {
        Integer fontSi = Preferences.getInt("SubTitleViewer.FontSize-" + this.viewerIndex, this.getViewerManager().getTranscription());
        if (fontSi != null) {
            this.setFontSize(fontSi);
        }
        if (this.tier != null) {
            Map<String, Font> fonts = Preferences.getMapOfFont("TierFonts", this.getViewerManager().getTranscription());
            if (fonts != null) {
                Font tf = fonts.get(this.tier.getName());
                if (tf != null) {
                    this.taSubtitle.setFont(new Font(tf.getName(), 0, this.fontSize));
                } else {
                    this.taSubtitle.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
                }
            }
        } else {
            this.taSubtitle.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
        }
    }

    @Override
    public void updateLocale() {
        this.createPopup();
    }

    private void createPopup() {
        this.popup = new JPopupMenu("");
        this.fontSizeBG = new ButtonGroup();
        this.fontMenu = new JMenu(ElanLocale.getString("Menu.View.FontSize"));
        for (int element : Constants.FONT_SIZES) {
            JRadioButtonMenuItem fontRB = new JRadioButtonMenuItem(String.valueOf(element));
            fontRB.setActionCommand("font" + element);
            if (this.fontSize == element) {
                fontRB.setSelected(true);
            }
            fontRB.addActionListener(this);
            this.fontSizeBG.add(fontRB);
            this.fontMenu.add(fontRB);
        }
        this.popup.add(this.fontMenu);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String strAction = e.getActionCommand();
        if (strAction.indexOf("font") != -1) {
            int index = strAction.indexOf("font") + 4;
            try {
                this.fontSize = Integer.parseInt(strAction.substring(index));
                this.repaint();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.taSubtitle.setFont(this.taSubtitle.getFont().deriveFont((float)this.fontSize));
            this.setPreference("SubTitleViewer.FontSize-" + this.viewerIndex, this.fontSize, this.getViewerManager().getTranscription());
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        this.doUpdate();
    }

    public void doUpdate() {
        String strTagValue = "";
        boolean bFound = false;
        long mediatime = this.getMediaTime();
        int annotations_size = this.annotations.size();
        if (this.arrTags == null) {
            return;
        }
        int index = Math.abs(Arrays.binarySearch(this.arrTags, mediatime));
        int beginindex = (index /= 2) - 2;
        int endindex = index + 2;
        if (beginindex < 0) {
            beginindex = 0;
        }
        if (endindex > annotations_size - 1) {
            endindex = annotations_size - 1;
        }
        long selectionBeginTime = this.getSelectionBeginTime();
        long selectionEndTime = this.getSelectionEndTime();
        for (int i = beginindex; i <= endindex; ++i) {
            Annotation ann = this.annotations.get(i);
            this.begintime = ann.getBeginTimeBoundary();
            this.endtime = ann.getEndTimeBoundary();
            if (ann == this.getActiveAnnotation() && this.endtime == mediatime || this.begintime == selectionBeginTime && this.endtime == selectionEndTime && this.endtime == mediatime) {
                bFound = true;
                strTagValue = ann.getValue();
                strTagValue = strTagValue.replace('\n', ' ');
                break;
            }
            if (mediatime < this.begintime || mediatime >= this.endtime) continue;
            bFound = true;
            strTagValue = ann.getValue();
            strTagValue = strTagValue.replace('\n', ' ');
            break;
        }
        if (bFound) {
            try {
                this.taSubtitle.setText(" " + strTagValue);
            }
            catch (Exception ex) {
                this.taSubtitle.setText("");
            }
        } else {
            this.taSubtitle.setText("");
        }
        if (this.tier != null && selectionBeginTime != selectionEndTime && mediatime >= this.begintime && (mediatime < this.endtime || mediatime == this.endtime && selectionBeginTime == this.begintime) && (selectionBeginTime >= this.begintime && selectionBeginTime < this.endtime || selectionEndTime >= this.begintime && selectionEndTime < this.endtime)) {
            try {
                this.highlighter.addHighlight(1, this.taSubtitle.getText().length(), this.selectionPainter);
            }
            catch (Exception ex) {
                ClientLogger.LOG.warning("Cannot add a highlight: " + ex.getMessage());
            }
        } else {
            this.taSubtitle.getHighlighter().removeAllHighlights();
        }
        this.repaint();
    }

    @Override
    public void setTier(Tier tier) {
        this.putOriginalComponentBack();
        if (tier == null) {
            this.tier = null;
            this.annotations = new ArrayList<Annotation>();
            this.doUpdate();
            this.setPreference("SubTitleViewer.TierName-" + this.viewerIndex, tier, this.getViewerManager().getTranscription());
            this.taSubtitle.setFont(Constants.DEFAULTFONT.deriveFont((float)this.fontSize));
        } else {
            this.tier = (TierImpl)tier;
            try {
                this.annotations = this.tier.getAnnotations();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setPreference("SubTitleViewer.TierName-" + this.viewerIndex, tier.getName(), this.getViewerManager().getTranscription());
            this.preferencesChanged();
        }
        this.buildArray();
        this.doUpdate();
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        if (this.fontSizeBG != null) {
            Enumeration<AbstractButton> en = this.fontSizeBG.getElements();
            while (en.hasMoreElements()) {
                JMenuItem item = (JMenuItem)en.nextElement();
                String value = item.getText();
                try {
                    int v = Integer.parseInt(value);
                    if (v != this.fontSize) continue;
                    item.setSelected(true);
                    this.taSubtitle.setFont(this.taSubtitle.getFont().deriveFont((float)this.fontSize));
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        } else {
            this.createPopup();
            this.taSubtitle.setFont(this.taSubtitle.getFont().deriveFont((float)this.fontSize));
        }
    }

    public int getViewerIndex() {
        return this.viewerIndex;
    }

    public void setViewerIndex(int viewerIndex) {
        this.viewerIndex = viewerIndex;
    }

    private void buildArray() {
        int annotations_size = this.annotations.size();
        this.arrTags = new long[2 * annotations_size];
        int arrIndex = 0;
        for (int i = 0; i < annotations_size; ++i) {
            Annotation ann = this.annotations.get(i);
            this.begintime = ann.getBeginTimeBoundary();
            this.endtime = ann.getEndTimeBoundary();
            this.arrTags[arrIndex++] = this.begintime;
            this.arrTags[arrIndex++] = this.endtime;
        }
    }

    public void putOriginalComponentBack() {
        this.inlineEditBox = null;
        this.removeAll();
        this.add((Component)this.jspSubtitle, "Center");
        this.validate();
        this.repaint();
    }

    @Override
    public void isClosing() {
        if (this.inlineEditBox != null && this.inlineEditBox.isVisible()) {
            Boolean boolPref = Preferences.getBool("InlineEdit.DeselectCommits", null);
            if (boolPref != null && !boolPref.booleanValue()) {
                this.inlineEditBox.cancelEdit();
            } else {
                this.inlineEditBox.commitEdit();
            }
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void editingCommitted() {
        this.putOriginalComponentBack();
    }

    @Override
    public void editingCancelled() {
        this.putOriginalComponentBack();
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksList) {
        if (this.inlineEditBox != null) {
            this.inlineEditBox.setKeyStrokesNotToBeConsumed(ksList);
        }
    }

    private class SubtitleViewerMouseListener
    extends MouseAdapter {
        private SubtitleViewer subtitleViewer;

        SubtitleViewerMouseListener(SubtitleViewer sv) {
            this.subtitleViewer = sv;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, this.subtitleViewer);
                int x = e.getPoint().x;
                int y = e.getPoint().y;
                SubtitleViewer.this.popup.show(this.subtitleViewer, x, y);
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                SubtitleViewer.this.inlineEditBox = new InlineEditBox(true);
                Annotation annotation = this.getAnnotation();
                if (annotation != null) {
                    if (e.isShiftDown()) {
                        SubtitleViewer.this.inlineEditBox.setAnnotation(annotation, true);
                    } else {
                        SubtitleViewer.this.inlineEditBox.setAnnotation(annotation);
                    }
                    SubtitleViewer.this.inlineEditBox.setFont(SubtitleViewer.this.taSubtitle.getFont());
                    SubtitleViewer.this.inlineEditBox.configureEditor(JPanel.class, null, SubtitleViewer.this.getSize());
                    SubtitleViewer.this.inlineEditBox.addInlineEditBoxListener(this.subtitleViewer);
                    SubtitleViewer.this.removeAll();
                    SubtitleViewer.this.add((Component)SubtitleViewer.this.inlineEditBox, "Center");
                    SubtitleViewer.this.validate();
                    SubtitleViewer.this.inlineEditBox.startEdit();
                }
                return;
            }
            if (!SubtitleViewer.this.taSubtitle.getText().equals("")) {
                SubtitleViewer.this.stopPlayer();
                SubtitleViewer.this.setActiveAnnotation(this.getAnnotation());
            }
        }

        private Annotation getAnnotation() {
            int annotations_size = SubtitleViewer.this.annotations.size();
            for (int i = 0; i < annotations_size; ++i) {
                Annotation annotation = (Annotation)SubtitleViewer.this.annotations.get(i);
                if (SubtitleViewer.this.getMediaTime() < annotation.getBeginTimeBoundary() || SubtitleViewer.this.getMediaTime() >= annotation.getEndTimeBoundary()) continue;
                return annotation;
            }
            return null;
        }
    }
}

