/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.tc;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.webserviceclient.typecraft.TCWsClient;

public class TypeCraftStep1
extends StepPane
implements ActionListener {
    private JButton loginButton;
    private JTextField usernameTextField;
    private JPasswordField passwordField;
    private int loginStatus;
    private String username;
    private String password;

    public TypeCraftStep1(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        JLabel usernameLabel = new JLabel("Username");
        JLabel passwordLabel = new JLabel("Password");
        this.usernameTextField = new JTextField("");
        this.usernameTextField.setEnabled(true);
        this.passwordField = new JPasswordField("");
        this.passwordField.setEnabled(true);
        this.loginButton = new JButton("Log in");
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(2, 0, 2, 0);
        Insets labelInsets = new Insets(2, 0, 2, 20);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = labelInsets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        this.add((Component)usernameLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.usernameTextField, gbc);
        this.usernameTextField.addActionListener(this);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = labelInsets;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.add((Component)passwordLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.passwordField, gbc);
        this.passwordField.addActionListener(this);
        gbc.insets = new Insets(20, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 13;
        this.add((Component)this.loginButton, gbc);
        this.loginButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.loginButton) {
            this.username = this.usernameTextField.getText();
            if (this.username != null) {
                char[] pwd = this.passwordField.getPassword();
                if (pwd != null && pwd.length > 0) {
                    this.password = new String(pwd);
                }
            } else {
                this.showMessage("Please enter your user name");
            }
            if (this.password != null) {
                this.multiPane.setButtonEnabled(1, true);
            } else {
                this.showMessage("Please enter your password");
            }
            Object wsclObj = this.multiPane.getStepProperty("TCWsClient");
            TCWsClient tcws = null;
            if (wsclObj instanceof TCWsClient) {
                tcws = (TCWsClient)wsclObj;
            } else {
                tcws = new TCWsClient();
                this.multiPane.putStepProperty("TCWsClient", tcws);
            }
            String sessionId = tcws.login(this.username, this.password);
            if (sessionId == null) {
                this.showMessage("Login failed!");
            } else {
                TCWsClient.storedSessionId = sessionId;
                this.multiPane.putStepProperty("SessionId", sessionId);
                this.multiPane.nextStep();
            }
        }
    }

    @Override
    public String getStepTitle() {
        return "TypeCraft login";
    }

    @Override
    public void enterStepForward() {
        if (TCWsClient.storedSessionId != null) {
            Object clObj;
            if (this.multiPane.getStepProperty("SessionId") == null) {
                this.multiPane.putStepProperty("SessionId", TCWsClient.storedSessionId);
            }
            if ((clObj = this.multiPane.getStepProperty("TCWsClient")) == null) {
                this.multiPane.putStepProperty("TCWsClient", new TCWsClient());
            }
            this.multiPane.nextStep();
        } else {
            this.usernameTextField.requestFocus();
        }
    }

    @Override
    public boolean leaveStepForward() {
        return true;
    }

    private void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.enterStepForward();
    }
}

