/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.webserviceclient.weblicht;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.WebLichtTextBasedCommand;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.webserviceclient.weblicht.WLServiceDescriptor;

public class WebLichtStep4
extends ProgressStepPane {
    private Transcription trans;
    private String inputText;
    private Integer sentenceDuration;
    private WLServiceDescriptor wlDescriptor;
    private WebLichtTextBasedCommand wltCommand;

    public WebLichtStep4(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.progressLabel.setText("");
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("WebServicesDialog.WebLicht.Uploading");
    }

    @Override
    protected void endOfProcess() {
        if (this.wltCommand != null) {
            this.wltCommand.removeProgressListener(this);
        }
        if (this.completed) {
            super.endOfProcess();
        } else {
            this.progressBar.setValue(0);
            this.multiPane.setButtonEnabled(4, true);
            this.multiPane.setButtonEnabled(2, true);
        }
    }

    @Override
    public void enterStepForward() {
        if (this.progressLabel != null) {
            this.progressLabel.setText("");
        }
        this.progressBar.setValue(0);
        this.doFinish();
    }

    @Override
    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        this.inputText = (String)this.multiPane.getStepProperty("InputText");
        this.sentenceDuration = (Integer)this.multiPane.getStepProperty("SentenceDuration");
        this.wlDescriptor = (WLServiceDescriptor)this.multiPane.getStepProperty("WLTokenizerDescriptor");
        Object[] args = new Object[]{this.inputText, this.sentenceDuration, this.wlDescriptor};
        this.trans = (Transcription)this.multiPane.getStepProperty("transcription");
        this.wltCommand = new WebLichtTextBasedCommand("WebLichtTextBased");
        this.wltCommand.addProgressListener(this);
        this.wltCommand.execute(this.trans, args);
        return false;
    }
}

