/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class LinkButton
extends JEditorPane {
    private String actionName;
    private boolean enabled = true;

    public LinkButton(final Action action) {
        this.setContentType("text/html");
        this.setEditable(false);
        this.actionName = (String)action.getValue("Name");
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && LinkButton.this.enabled) {
                    action.actionPerformed(new ActionEvent(this, 0, e.getDescription()));
                }
            }
        });
        action.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("enabled".equals(e.getPropertyName())) {
                    LinkButton.this.setEnabled(action.isEnabled());
                }
            }
        });
        this.setToolTipText((String)action.getValue("ShortDescription"));
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.reset();
    }

    public void setLabel(String label) {
        this.actionName = label != null ? label : "";
        this.reset();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.reset();
        }
    }

    private void reset() {
        if (this.enabled) {
            this.setText("<a href=\"" + this.actionName + "\"><font size=\"3\">" + this.actionName + "</font></a>");
        } else {
            this.setText("<font size=\"3\">" + this.actionName + "</font>");
        }
    }
}

