/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.SubtitleUnit;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.TimeRelation;

public class SubtitleSequencer {
    private static final int SAME_ENDTIME_FUZZ = 5;
    private static final int MAX_OVERLAP = 200;

    public List<SubtitleUnit> createSequence(Transcription transcription, List<String> tierNames, long intervalBegin, long intervalEnd, int minimalDuration, long offset, boolean resolveOverlaps) {
        if (transcription == null) {
            throw new NullPointerException("The transcription is null");
        }
        if (tierNames == null) {
            throw new NullPointerException("The list of tier names is null");
        }
        if (tierNames.size() == 0) {
            throw new IllegalArgumentException("No tiers have been specified");
        }
        Stack<SubtitleUnit> units = new Stack<SubtitleUnit>();
        for (int i = 0; i < tierNames.size(); ++i) {
            String name = tierNames.get(i);
            TierImpl tier = (TierImpl)transcription.getTierWithId(name);
            if (tier == null) {
                ClientLogger.LOG.warning("The tier does not exist: " + name);
                continue;
            }
            List<AbstractAnnotation> annotations = tier.getAnnotations();
            SubtitleUnit cursub = null;
            SubtitleUnit prevsub = null;
            for (int j = 0; j < annotations.size(); ++j) {
                AbstractAnnotation ann = annotations.get(j);
                if (ann == null || !TimeRelation.overlaps(ann, intervalBegin, intervalEnd)) continue;
                cursub = new SubtitleUnit(ann.getBeginTimeBoundary() + offset, ann.getEndTimeBoundary() + offset, i, ann.getValue());
                if (prevsub != null && prevsub.getCalcEnd() - prevsub.getBegin() < (long)minimalDuration) {
                    if (resolveOverlaps && prevsub.getBegin() + (long)minimalDuration > cursub.getBegin()) {
                        prevsub.setValue(prevsub.getValues()[0] + " " + cursub.getValues()[0]);
                        prevsub.setCalcEnd(cursub.getCalcEnd());
                        continue;
                    }
                    prevsub.setCalcEnd(Math.min(cursub.getBegin(), prevsub.getBegin() + (long)minimalDuration));
                }
                units.add(cursub);
                prevsub = cursub;
            }
            if (prevsub == null || prevsub.getCalcEnd() - prevsub.getBegin() >= (long)minimalDuration) continue;
            prevsub.setCalcEnd(Math.min(intervalEnd, prevsub.getBegin() + (long)minimalDuration));
        }
        if (!resolveOverlaps || units.size() < 2) {
            Collections.sort(units);
            return units;
        }
        Collections.sort(units, Collections.reverseOrder());
        ArrayList<SubtitleUnit> output = new ArrayList<SubtitleUnit>();
        ArrayList<SubtitleUnit> group = new ArrayList<SubtitleUnit>();
        do {
            long first_start;
            if (group.isEmpty()) {
                SubtitleUnit sub = units.peek();
                first_start = sub.getBegin();
                group.add(units.pop());
            } else {
                first_start = ((SubtitleUnit)group.get(0)).getBegin();
            }
            long second_start = Long.MAX_VALUE;
            while (units.size() > 0) {
                SubtitleUnit sub = units.peek();
                long next_start = sub.getBegin();
                if (next_start != first_start) {
                    second_start = next_start;
                    break;
                }
                group.add(units.pop());
            }
            long first_end = Long.MAX_VALUE;
            long last_end = 0L;
            for (SubtitleUnit sub : group) {
                first_end = Math.min(first_end, sub.getCalcEnd());
                last_end = Math.max(last_end, sub.getCalcEnd());
            }
            long min_end = Math.min(first_end, second_start);
            long end_difference = last_end - first_end;
            long maxOverlapDuration = Math.min(200, minimalDuration / 2);
            if (end_difference <= 5L && second_start < last_end && first_end - second_start < maxOverlapDuration) {
                long half_overlap = (first_end - second_start) / 2L;
                this.decreaseEndTime(min_end += half_overlap, group);
                this.increaseBeginTime(min_end, units);
            } else if (end_difference > 0L && end_difference <= 5L) {
                this.decreaseEndTime(first_end, group);
            }
            if (group.size() > 1) {
                Collections.sort(group, new Comparator<SubtitleUnit>(){

                    @Override
                    public int compare(SubtitleUnit lhs, SubtitleUnit rhs) {
                        return lhs.getLineIndex() - rhs.getLineIndex();
                    }
                });
            }
            ArrayList<String> values = new ArrayList<String>();
            for (SubtitleUnit sub : group) {
                String[] vals;
                for (String s : vals = sub.getValues()) {
                    values.add(s);
                }
            }
            SubtitleUnit out = new SubtitleUnit(first_start, min_end, null);
            out.setValues(values.toArray(new String[0]));
            output.add(out);
            for (int i = group.size() - 1; i >= 0; --i) {
                SubtitleUnit sub = group.get(i);
                sub.setBegin(min_end);
                if (min_end < sub.getCalcEnd()) continue;
                group.remove(sub);
            }
        } while (!group.isEmpty() || !units.isEmpty());
        return output;
    }

    void increaseBeginTime(long new_time, Collection<SubtitleUnit> units) {
        for (SubtitleUnit sub : units) {
            if (sub.getBegin() >= new_time) continue;
            sub.setBegin(new_time);
        }
    }

    void decreaseEndTime(long new_time, Collection<SubtitleUnit> units) {
        for (SubtitleUnit sub : units) {
            if (sub.getCalcEnd() <= new_time) continue;
            sub.setCalcEnd(new_time);
        }
    }

    public List<SubtitleUnit> createSequence(Transcription transcription, List<String> tierNames, long intervalBegin, long intervalEnd, int minimalDuration) {
        return this.createSequence(transcription, tierNames, intervalBegin, intervalEnd, minimalDuration, 0L, false);
    }

    public List<SubtitleUnit> createSequence(Transcription transcription, String[] tierNames, long intervalBegin, long intervalEnd, int minimalDuration, long offset, boolean resolveOverlaps) {
        ArrayList<String> names = null;
        if (tierNames != null) {
            names = new ArrayList<String>(tierNames.length);
            for (int i = 0; i < tierNames.length; ++i) {
                names.add(tierNames[i]);
            }
        }
        return this.createSequence(transcription, names, intervalBegin, intervalEnd, minimalDuration, offset, resolveOverlaps);
    }

    public List<SubtitleUnit> createSequence(Transcription transcription, String[] tierNames, long intervalBegin, long intervalEnd, int minimalDuration) {
        return this.createSequence(transcription, tierNames, intervalBegin, intervalEnd, minimalDuration, 0L, false);
    }
}

