/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.IOException;
import java.util.Arrays;
import mpi.eudico.client.util.WAVSamplesProvider;
import nl.mpi.media.AudioExtractor;
import nl.mpi.media.UnsupportedMediaException;

public class WAVFromOtherSampler
implements WAVSamplesProvider {
    private String mediaUrlString;
    private AudioExtractor audioExtractor;
    private int possibleMaxSample;
    private int possibleMinSample;
    private int[] maxSamplePerChannel;
    private int[] minSamplePerChannel;
    private int[][] intArrayPerChannel;
    private double seekTime;

    public WAVFromOtherSampler(String mediaPath) throws IOException, UnsupportedMediaException {
        String urlString = mediaPath;
        if (urlString.startsWith("file:") && !urlString.startsWith("file:///")) {
            urlString = urlString.substring(5);
        }
        this.mediaUrlString = urlString;
        this.audioExtractor = new AudioExtractor(this.mediaUrlString);
        this.initTest();
    }

    private void initTest() throws UnsupportedMediaException {
        if (this.audioExtractor != null) {
            if (this.audioExtractor.getBitsPerSample() <= 0) {
                throw new UnsupportedMediaException("The native AudioExtractor could not detect the bits per sample property.");
            }
            if (this.audioExtractor.getSampleFrequency() <= 0) {
                throw new UnsupportedMediaException("The native AudioExtractor could not detect the sample frequency property.");
            }
            if (this.audioExtractor.getDuration() <= 0L) {
                throw new UnsupportedMediaException("The native AudioExtractor could not detect the media duration property.");
            }
        }
    }

    @Override
    public String getMediaLocation() {
        return this.mediaUrlString;
    }

    @Override
    public float getDuration() {
        return this.audioExtractor.getDuration();
    }

    @Override
    public double getDurationSeconds() {
        return this.audioExtractor.getDurationSec();
    }

    @Override
    public int getNumberOfChannels() {
        return this.audioExtractor.getNumberOfChannels();
    }

    @Override
    public int getBitsPerSample() {
        return this.audioExtractor.getBitsPerSample();
    }

    @Override
    public int[] getChannelArray(int channelIndex) {
        if (this.intArrayPerChannel != null && channelIndex < this.intArrayPerChannel.length) {
            return this.intArrayPerChannel[channelIndex];
        }
        return null;
    }

    @Override
    public int getMaxSample(int channelIndex) {
        if (this.maxSamplePerChannel == null && this.intArrayPerChannel != null && channelIndex < this.intArrayPerChannel.length) {
            this.maxSamplePerChannel = new int[this.intArrayPerChannel.length];
            for (int c = 0; c < this.intArrayPerChannel.length; ++c) {
                int max = Integer.MIN_VALUE;
                for (int i = 0; i < this.intArrayPerChannel[c].length; ++i) {
                    if (this.intArrayPerChannel[c][i] <= max) continue;
                    max = this.intArrayPerChannel[c][i];
                }
                if (max == Integer.MIN_VALUE) {
                    max = 0;
                }
                this.maxSamplePerChannel[c] = max;
            }
        }
        if (this.maxSamplePerChannel != null && channelIndex < this.maxSamplePerChannel.length) {
            return this.maxSamplePerChannel[channelIndex];
        }
        return 0;
    }

    @Override
    public int getMinSample(int channelIndex) {
        if (this.minSamplePerChannel == null && this.intArrayPerChannel != null && channelIndex < this.intArrayPerChannel.length) {
            this.minSamplePerChannel = new int[this.intArrayPerChannel.length];
            for (int c = 0; c < this.intArrayPerChannel.length; ++c) {
                int min = Integer.MAX_VALUE;
                for (int i = 0; i < this.intArrayPerChannel[c].length; ++i) {
                    if (this.intArrayPerChannel[c][i] >= min) continue;
                    min = this.intArrayPerChannel[c][i];
                }
                if (min == Integer.MAX_VALUE) {
                    min = 0;
                }
                this.minSamplePerChannel[c] = min;
            }
        }
        if (this.minSamplePerChannel != null && channelIndex < this.minSamplePerChannel.length) {
            return this.minSamplePerChannel[channelIndex];
        }
        return 0;
    }

    @Override
    public long getNrOfSamples() {
        return (long)(this.audioExtractor.getDurationSec() * (double)this.audioExtractor.getSampleFrequency());
    }

    @Override
    public int getPossibleMaxSample() {
        if (this.possibleMaxSample == 0) {
            this.possibleMaxSample = (int)(-1.0 + Math.pow(2.0, this.audioExtractor.getBitsPerSample() - 1));
        }
        return this.possibleMaxSample;
    }

    @Override
    public int getPossibleMinSample() {
        if (this.possibleMinSample == 0) {
            this.possibleMinSample = (int)(-Math.pow(2.0, this.audioExtractor.getBitsPerSample() - 1));
        }
        return this.possibleMinSample;
    }

    @Override
    public int getSampleFrequency() {
        return this.audioExtractor.getSampleFrequency();
    }

    @Override
    public long getSamplePointer() {
        return (long)(this.audioExtractor.getPositionSec() * (double)this.audioExtractor.getSampleFrequency());
    }

    @Override
    public long getTimeAtSample(long sample) {
        return (long)((double)((float)sample * 1000.0f / (float)this.audioExtractor.getSampleFrequency()) + 0.5);
    }

    @Override
    public float getTimePointer() {
        return (float)(this.audioExtractor.getPositionSec() * 1000.0);
    }

    @Override
    public double getTimePointerSeconds() {
        return this.audioExtractor.getPositionSec();
    }

    @Override
    public void close() {
        try {
            this.audioExtractor.release();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int readInterval(int requestedNrOfSamplesToRead, int nrOfChannelsToLoad) {
        short sampleSize;
        int actualRead;
        block21: {
            byte[] buffer;
            int encNrOfChannels;
            int actualNrOfSamplesToRead;
            boolean stereoOutput;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                int actualNrOfChannels;
                                block20: {
                                    actualRead = 0;
                                    stereoOutput = false;
                                    actualNrOfSamplesToRead = requestedNrOfSamplesToRead;
                                    int samplesAvailable = (int)(this.getNrOfSamples() - this.getSamplePointer());
                                    if (requestedNrOfSamplesToRead > samplesAvailable) {
                                        actualNrOfSamplesToRead = samplesAvailable;
                                    }
                                    actualNrOfChannels = nrOfChannelsToLoad < (encNrOfChannels = this.getNumberOfChannels()) ? nrOfChannelsToLoad : encNrOfChannels;
                                    boolean bl = stereoOutput = nrOfChannelsToLoad > 1;
                                    if (this.intArrayPerChannel == null || this.intArrayPerChannel.length < nrOfChannelsToLoad || this.intArrayPerChannel[0].length < actualNrOfSamplesToRead) {
                                        this.intArrayPerChannel = new int[actualNrOfChannels][actualNrOfSamplesToRead];
                                    } else {
                                        for (int j = 0; j < this.intArrayPerChannel.length; ++j) {
                                            Arrays.fill(this.intArrayPerChannel[j], 0);
                                        }
                                    }
                                    sampleSize = (short)(encNrOfChannels * (this.getBitsPerSample() / 8));
                                    if (sampleSize == 0) {
                                        sampleSize = 1;
                                    }
                                    buffer = null;
                                    buffer = this.audioExtractor.getSamples(this.seekTime, this.seekTime + (double)actualNrOfSamplesToRead / (double)this.audioExtractor.getSampleFrequency());
                                    if (buffer == null || buffer.length == 0) {
                                        return actualRead;
                                    }
                                    actualRead = buffer.length;
                                    if (sampleSize != 1) break block20;
                                    for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                                        this.intArrayPerChannel[0][s] = buffer[s] & 0xFF;
                                    }
                                    break block21;
                                }
                                if (sampleSize != 2) break block22;
                                if (actualNrOfChannels == 1) {
                                    int b = 0;
                                    for (int s = 0; s < actualNrOfSamplesToRead && b < buffer.length - 1; b += 2, ++s) {
                                        int b1 = buffer[b] & 0xFF;
                                        byte b2 = buffer[b + 1];
                                        this.intArrayPerChannel[0][s] = b1 | b2 << 8;
                                    }
                                } else {
                                    int b = 0;
                                    for (int s = 0; s < actualNrOfSamplesToRead && b < buffer.length - 1; b += 2, ++s) {
                                        int b1;
                                        this.intArrayPerChannel[0][s] = b1 = buffer[b] & 0xFF;
                                        b1 = buffer[b + 1] & 0xFF;
                                        if (stereoOutput) {
                                            this.intArrayPerChannel[1][s] = b1;
                                            continue;
                                        }
                                        this.intArrayPerChannel[0][s] = (this.intArrayPerChannel[0][s] + b1) / 2;
                                    }
                                }
                                break block21;
                            }
                            if (sampleSize != 3 || encNrOfChannels != 1) break block23;
                            int b = 0;
                            for (int s = 0; s < actualNrOfSamplesToRead && b < buffer.length - 2; b += 3, ++s) {
                                int b1 = buffer[b] & 0xFF;
                                int b2 = buffer[b + 1] & 0xFF;
                                byte b3 = buffer[b + 2];
                                this.intArrayPerChannel[0][s] = b1 | b2 << 8 | b3 << 16;
                            }
                            break block21;
                        }
                        if (sampleSize != 4 || encNrOfChannels != 2) break block24;
                        int b = 0;
                        for (int s = 0; s < actualNrOfSamplesToRead && b < buffer.length - 3; b += 4, ++s) {
                            int b1 = buffer[b] & 0xFF;
                            byte b2 = buffer[b + 1];
                            this.intArrayPerChannel[0][s] = b1 | b2 << 8;
                            b1 = buffer[b + 2] & 0xFF;
                            b2 = buffer[b + 3];
                            if (stereoOutput) {
                                this.intArrayPerChannel[1][s] = b1 | b2 << 8;
                                continue;
                            }
                            this.intArrayPerChannel[0][s] = (this.intArrayPerChannel[0][s] + (b1 | b2 << 8)) / 2;
                        }
                        break block21;
                    }
                    if (sampleSize != 6 || encNrOfChannels != 2) break block25;
                    int b = 0;
                    for (int s = 0; s < actualNrOfSamplesToRead && b < buffer.length - 5; b += 6, ++s) {
                        int b1 = buffer[b] & 0xFF;
                        int b2 = buffer[b + 1] & 0xFF;
                        byte b3 = buffer[b + 2];
                        this.intArrayPerChannel[0][s] = b1 | b2 << 8 | b3 << 16;
                        b1 = buffer[b + 3] & 0xFF;
                        b2 = buffer[b + 4] & 0xFF;
                        b3 = buffer[b + 5];
                        if (stereoOutput) {
                            this.intArrayPerChannel[1][s] = b1 | b1 << 8 | b3 << 16;
                            continue;
                        }
                        this.intArrayPerChannel[0][s] = (this.intArrayPerChannel[0][s] + (b1 | b2 << 8 | b3 << 16)) / 2;
                    }
                    break block21;
                }
                if (sampleSize != 4 || encNrOfChannels != 1) break block26;
                int b = 0;
                for (int s = 0; s < actualNrOfSamplesToRead && b < buffer.length - 3; b += 4, ++s) {
                    int b1 = buffer[b] & 0xFF;
                    int b2 = buffer[b + 1] & 0xFF;
                    int b3 = buffer[b + 2] & 0xFF;
                    byte b4 = buffer[b + 3];
                    this.intArrayPerChannel[0][s] = b1 | b2 << 8 | b3 << 16 | b4 << 24;
                }
                break block21;
            }
            if (sampleSize != 8 || encNrOfChannels != 2) break block21;
            int b = 0;
            for (int s = 0; s < actualNrOfSamplesToRead && b < buffer.length - 7; b += 8, ++s) {
                int b1 = buffer[b] & 0xFF;
                int b2 = buffer[b + 1] & 0xFF;
                int b3 = buffer[b + 2] & 0xFF;
                byte b4 = buffer[b + 3];
                this.intArrayPerChannel[0][s] = b1 | b2 << 8 | b3 << 16 | b4 << 24;
                b1 = buffer[b + 4] & 0xFF;
                b2 = buffer[b + 5] & 0xFF;
                b3 = buffer[b + 6] & 0xFF;
                b4 = buffer[b + 7];
                if (stereoOutput) {
                    this.intArrayPerChannel[1][s] = b1 | b1 << 8 | b3 << 16 | b4 << 24;
                    continue;
                }
                this.intArrayPerChannel[0][s] = (this.intArrayPerChannel[0][s] + (b1 | b2 << 8 | b3 << 16 | b4 << 24)) / 2;
            }
        }
        return actualRead / sampleSize;
    }

    @Override
    public void seekSample(long n) {
        this.setSeekTime((double)n / (double)this.audioExtractor.getSampleFrequency());
    }

    @Override
    public void seekTime(float time) {
        this.setSeekTime((double)time / 1000.0);
    }

    @Override
    public void seekTimeSeconds(double timeSec) {
        this.setSeekTime(timeSec);
    }

    private void setSeekTime(double t) {
        this.seekTime = t < 0.0 ? 0.0 : (t > this.audioExtractor.getDurationSec() ? this.audioExtractor.getDurationSec() : t);
        this.audioExtractor.setPositionSec(this.seekTime);
    }

    @Override
    public short getCompressionCode() {
        return 1;
    }

    @Override
    public String getCompressionString(short compr) {
        if (compr == 1) {
            return "PCM (uncompressed)";
        }
        return "Unknown";
    }

    @Override
    public void setDebugMode(boolean enable) {
        if (this.audioExtractor != null) {
            AudioExtractor.setDebugMode(enable);
        }
    }
}

