/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.util;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import mpi.eudico.client.util.WAVHeader;
import mpi.eudico.client.util.WAVSamplesProvider;

public class WAVSampler
implements WAVSamplesProvider {
    private RandomAccessFile soundFile;
    private String filePath;
    private WAVHeader wavHeader;
    private byte[] buffer = new byte[4096];
    private int[] intArrayLeft;
    private int[] intArrayRight;
    private float duration;
    private double durationSec;
    private int headerSize;
    private int maxSampleFirst;
    private int maxSampleSecond;
    private int minSampleFirst;
    private int minSampleSecond;
    private int possibleMaxSample;
    private int possibleMinSample;
    private int sampleFrequency;
    private long nrOfSamples;
    private short bitsPerSample;
    private short compressionCode;
    private short nrOfChannels;
    private short sampleSize;
    private static boolean debugMode = false;

    public WAVSampler(String fileName) throws IOException {
        if (fileName.toLowerCase().endsWith(".wav")) {
            this.soundFile = new RandomAccessFile(fileName, "r");
            this.wavHeader = new WAVHeader(this.soundFile);
            this.filePath = fileName;
            if (this.wavHeader.getHeaderSize() == 0) {
                this.soundFile.close();
                throw new IOException("Invalid wav file format");
            }
            this.sampleFrequency = this.wavHeader.getFrequency();
            this.sampleSize = this.wavHeader.getSampleSize();
            this.nrOfSamples = this.wavHeader.getDataLength() / (long)this.sampleSize;
            this.nrOfChannels = this.wavHeader.getNumberOfChannels();
            this.bitsPerSample = (short)(this.sampleSize * 8 / this.nrOfChannels);
            this.duration = 1000.0f * (float)this.nrOfSamples / (float)this.sampleFrequency;
            this.durationSec = (double)this.nrOfSamples / (double)this.sampleFrequency;
            this.possibleMinSample = (int)(-Math.pow(2.0, this.bitsPerSample - 1));
            this.possibleMaxSample = (int)(-1.0 + Math.pow(2.0, this.bitsPerSample - 1));
            this.headerSize = this.wavHeader.getHeaderSize();
            this.compressionCode = this.wavHeader.getCompressionCode();
            if (this.compressionCode == 6) {
                this.possibleMinSample *= 64;
                this.possibleMaxSample *= 64;
            }
        } else {
            throw new IOException("Unsupported file format");
        }
        this.soundFile.seek(this.headerSize);
    }

    @Override
    public String getMediaLocation() {
        if (this.filePath != null) {
            return this.filePath;
        }
        return "";
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    public double getDurationSeconds() {
        return this.durationSec;
    }

    @Override
    public int getNumberOfChannels() {
        return this.nrOfChannels;
    }

    @Override
    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    @Override
    public int[] getChannelArray(int channelIndex) {
        switch (channelIndex) {
            case 0: {
                return this.intArrayLeft;
            }
            case 1: {
                return this.intArrayRight;
            }
        }
        return null;
    }

    public int[] getFirstChannelArray() {
        return this.intArrayLeft;
    }

    public int[] getSecondChannelArray() {
        return this.intArrayRight;
    }

    @Override
    public int getMaxSample(int channelIndex) {
        switch (channelIndex) {
            case 0: {
                return this.maxSampleFirst;
            }
            case 1: {
                return this.maxSampleSecond;
            }
        }
        return 0;
    }

    public int getMaxSampleFirst() {
        return this.maxSampleFirst;
    }

    public int getMaxSampleSecond() {
        return this.maxSampleSecond;
    }

    @Override
    public int getMinSample(int channelIndex) {
        switch (channelIndex) {
            case 0: {
                return this.minSampleFirst;
            }
            case 1: {
                return this.minSampleSecond;
            }
        }
        return 0;
    }

    public int getMinSampleFirst() {
        return this.minSampleFirst;
    }

    public int getMinSampleSecond() {
        return this.minSampleSecond;
    }

    @Override
    public long getNrOfSamples() {
        return this.nrOfSamples;
    }

    @Override
    public int getPossibleMaxSample() {
        return this.possibleMaxSample;
    }

    @Override
    public int getPossibleMinSample() {
        return this.possibleMinSample;
    }

    @Override
    public int getSampleFrequency() {
        return this.sampleFrequency;
    }

    @Override
    public long getSamplePointer() {
        long pointer = 0L;
        try {
            pointer = (this.soundFile.getFilePointer() - (long)this.headerSize) / (long)this.sampleSize;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pointer;
    }

    @Override
    public long getTimeAtSample(long sample) {
        return (long)((double)((float)sample * 1000.0f / (float)this.sampleFrequency) + 0.5);
    }

    @Override
    public float getTimePointer() {
        return 1000.0f * (float)this.getSamplePointer() / (float)this.sampleFrequency;
    }

    @Override
    public double getTimePointerSeconds() {
        return (double)this.getSamplePointer() / (double)this.sampleFrequency;
    }

    public WAVHeader getWavHeader() {
        return this.wavHeader;
    }

    @Override
    public void close() {
        this.wavHeader = null;
        if (this.soundFile != null) {
            try {
                this.soundFile.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.soundFile = null;
    }

    @Override
    public int readInterval(int requestedNrOfSamplesToRead, int nrOfChannelsToLoad) {
        int actualRead;
        block27: {
            int actualNrOfSamplesToRead;
            boolean stereoOutput;
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                block26: {
                                    actualRead = 0;
                                    stereoOutput = false;
                                    actualNrOfSamplesToRead = requestedNrOfSamplesToRead;
                                    int samplesAvailable = (int)(this.getNrOfSamples() - this.getSamplePointer());
                                    if (requestedNrOfSamplesToRead > samplesAvailable) {
                                        actualNrOfSamplesToRead = samplesAvailable;
                                    }
                                    if (this.intArrayLeft == null || this.intArrayLeft.length < actualNrOfSamplesToRead) {
                                        this.intArrayLeft = new int[actualNrOfSamplesToRead];
                                    }
                                    Arrays.fill(this.intArrayLeft, 0);
                                    if (nrOfChannelsToLoad == 2) {
                                        stereoOutput = true;
                                        if (this.intArrayRight == null || this.intArrayRight.length < actualNrOfSamplesToRead) {
                                            this.intArrayRight = new int[actualNrOfSamplesToRead];
                                        }
                                        Arrays.fill(this.intArrayRight, 0);
                                    } else {
                                        nrOfChannelsToLoad = 1;
                                        this.intArrayRight = null;
                                    }
                                    if (this.buffer.length < actualNrOfSamplesToRead * this.sampleSize) {
                                        this.buffer = new byte[actualNrOfSamplesToRead * this.sampleSize];
                                    }
                                    try {
                                        actualRead = this.soundFile.read(this.buffer, 0, actualNrOfSamplesToRead * this.sampleSize);
                                    }
                                    catch (IOException ioe) {
                                        return actualRead;
                                    }
                                    if (this.sampleSize != 1) break block26;
                                    for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                                        this.intArrayLeft[s] = this.convert((this.buffer[s] & 0xFF) - 128);
                                    }
                                    break block27;
                                }
                                if (this.sampleSize != 2) break block28;
                                if (this.nrOfChannels == 1) {
                                    int b = 0;
                                    for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                                        int b1 = this.buffer[b] & 0xFF;
                                        byte b2 = this.buffer[b + 1];
                                        this.intArrayLeft[s] = this.convert(b1 | b2 << 8);
                                        b += 2;
                                    }
                                } else {
                                    int b = 0;
                                    for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                                        int b1 = (this.buffer[b] & 0xFF) - 128;
                                        this.intArrayLeft[s] = this.convert(b1);
                                        b1 = (this.buffer[b + 1] & 0xFF) - 128;
                                        if (stereoOutput) {
                                            this.intArrayRight[s] = this.convert(b1);
                                        } else {
                                            this.intArrayLeft[s] = (this.intArrayLeft[s] + this.convert(b1)) / 2;
                                        }
                                        b += 2;
                                    }
                                }
                                break block27;
                            }
                            if (this.sampleSize != 3 || this.nrOfChannels != 1) break block29;
                            int b = 0;
                            for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                                int b1 = this.buffer[b] & 0xFF;
                                int b2 = this.buffer[b + 1] & 0xFF;
                                byte b3 = this.buffer[b + 2];
                                this.intArrayLeft[s] = this.convert(b1 | b2 << 8 | b3 << 16);
                                b += 3;
                            }
                            break block27;
                        }
                        if (this.sampleSize != 4 || this.nrOfChannels != 2) break block30;
                        int b = 0;
                        for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                            int b1 = this.buffer[b] & 0xFF;
                            byte b2 = this.buffer[b + 1];
                            this.intArrayLeft[s] = this.convert(b1 | b2 << 8);
                            b1 = this.buffer[b + 2] & 0xFF;
                            b2 = this.buffer[b + 3];
                            if (stereoOutput) {
                                this.intArrayRight[s] = this.convert(b1 | b2 << 8);
                            } else {
                                this.intArrayLeft[s] = (this.intArrayLeft[s] + this.convert(b1 | b2 << 8)) / 2;
                            }
                            b += 4;
                        }
                        break block27;
                    }
                    if (this.sampleSize != 6 || this.nrOfChannels != 2) break block31;
                    int b = 0;
                    for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                        int b1 = this.buffer[b] & 0xFF;
                        int b2 = this.buffer[b + 1] & 0xFF;
                        byte b3 = this.buffer[b + 2];
                        this.intArrayLeft[s] = this.convert(b1 | b2 << 8 | b3 << 16);
                        b1 = this.buffer[b + 3] & 0xFF;
                        b2 = this.buffer[b + 4] & 0xFF;
                        b3 = this.buffer[b + 5];
                        if (stereoOutput) {
                            this.intArrayRight[s] = this.convert(b1 | b1 << 8 | b3 << 16);
                        } else {
                            this.intArrayLeft[s] = (this.intArrayLeft[s] + this.convert(b1 | b2 << 8 | b3 << 16)) / 2;
                        }
                        b += 6;
                    }
                    break block27;
                }
                if (this.sampleSize != 4 || this.nrOfChannels != 1) break block32;
                int b = 0;
                for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                    int b1 = this.buffer[b] & 0xFF;
                    int b2 = this.buffer[b + 1] & 0xFF;
                    int b3 = this.buffer[b + 2] & 0xFF;
                    byte b4 = this.buffer[b + 3];
                    this.intArrayLeft[s] = this.convert(b1 | b2 << 8 | b3 << 16 | b4 << 24);
                    b += 4;
                }
                break block27;
            }
            if (this.sampleSize != 8 || this.nrOfChannels != 2) break block27;
            int b = 0;
            for (int s = 0; s < actualNrOfSamplesToRead; ++s) {
                int b1 = this.buffer[b] & 0xFF;
                int b2 = this.buffer[b + 1] & 0xFF;
                int b3 = this.buffer[b + 2] & 0xFF;
                byte b4 = this.buffer[b + 3];
                this.intArrayLeft[s] = this.convert(b1 | b2 << 8 | b3 << 16 | b4 << 24);
                b1 = this.buffer[b + 4] & 0xFF;
                b2 = this.buffer[b + 5] & 0xFF;
                b3 = this.buffer[b + 6] & 0xFF;
                b4 = this.buffer[b + 7];
                if (stereoOutput) {
                    this.intArrayRight[s] = this.convert(b1 | b1 << 8 | b3 << 16 | b4 << 24);
                } else {
                    this.intArrayLeft[s] = (this.intArrayLeft[s] + this.convert(b1 | b2 << 8 | b3 << 16 | b4 << 24)) / 2;
                }
                b += 8;
            }
        }
        return actualRead / this.sampleSize;
    }

    @Override
    public void seekSample(long n) {
        if (n >= 0L && n <= this.nrOfSamples) {
            try {
                this.soundFile.seek((long)this.headerSize + n * (long)this.sampleSize);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void seekTime(float time) {
        if (!(time < 0.0f)) {
            this.seekSample((long)(time * (float)this.sampleFrequency / 1000.0f));
        }
    }

    @Override
    public void seekTimeSeconds(double timeSec) {
        if (timeSec >= 0.0) {
            this.seekSample((long)(timeSec * (double)this.sampleFrequency));
        }
    }

    @Override
    public short getCompressionCode() {
        return this.wavHeader.getCompressionCode();
    }

    @Override
    public String getCompressionString(short compr) {
        return this.wavHeader.getCompressionString(compr);
    }

    private int convert(int orig) {
        switch (this.compressionCode) {
            case 6: {
                byte val = this.toUnsigned((byte)orig);
                val = (byte)(val ^ 0x55);
                int t = (val & 0xF) << 4;
                int seg = (this.toUnsigned(val) & 0x70) >> 4;
                switch (seg) {
                    case 0: {
                        t += 8;
                        break;
                    }
                    case 1: {
                        t += 264;
                        break;
                    }
                    default: {
                        t += 264;
                        t <<= seg - 1;
                    }
                }
                return (val & 0x80) != 0 ? t : -t;
            }
        }
        return orig;
    }

    private byte toUnsigned(byte signed) {
        return (byte)(signed + 128);
    }

    @Override
    public void setDebugMode(boolean enable) {
        debugMode = enable;
    }
}

