/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.abstr;

import mpi.eudico.server.corpora.clom.ExternalReference;

public class ExternalReferenceImpl
implements ExternalReference,
Cloneable {
    private static final long serialVersionUID = 8946176200603135792L;
    private String value;
    private int type;

    public ExternalReferenceImpl(String value, int type) {
        this.value = value;
        this.type = type;
    }

    public ExternalReferenceImpl(String value, String type) {
        this.value = value;
        this.type = 0;
        if (type != null) {
            if (type.equals("iso12620")) {
                this.type = 2;
            } else if (type.equals("resource_url")) {
                this.type = 3;
            } else if (type.equals("ecv")) {
                this.type = 4;
            } else if (type.equals("cve_id")) {
                this.type = 5;
            } else if (type.equals("lexen_id")) {
                this.type = 6;
            }
        }
    }

    @Override
    public int getReferenceType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setReferenceType(int refType) {
        this.type = refType;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String paramString() {
        if (this.type == 2) {
            return "DCR: " + this.value;
        }
        if (this.type == 3) {
            return "URL: " + this.value;
        }
        if (this.type == 4) {
            return "ECV: " + this.value;
        }
        return this.value;
    }

    @Override
    public ExternalReference clone() throws CloneNotSupportedException {
        ExternalReferenceImpl cloneER = new ExternalReferenceImpl(this.value, this.type);
        return cloneER;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExternalReferenceImpl) {
            ExternalReferenceImpl other = (ExternalReferenceImpl)obj;
            if (other.getReferenceType() != this.type) {
                return false;
            }
            if (other.getValue() != null && !other.getValue().equals(this.value)) {
                return false;
            }
            return this.value == null || this.value.equals(other.getValue());
        }
        return false;
    }

    public int hashCode() {
        int h = 7;
        if (this.value != null) {
            h += this.value.hashCode();
        }
        return h += this.type * 17;
    }

    @Override
    public String getTypeString() {
        switch (this.type) {
            default: {
                return "undefined";
            }
            case 2: {
                return "iso12620";
            }
            case 3: {
                return "resource_url";
            }
            case 4: {
                return "ecv";
            }
            case 5: {
                return "cve_id";
            }
            case 6: 
        }
        return "lexen_id";
    }
}

