/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF26;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF26Encoder
implements AnnotationDocEncoder {
    public static final String VERSION = "2.6";
    public static boolean debug = false;

    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path) throws IOException {
        Element documentElement = EAF26Encoder.createDOM(theTranscription, tierOrder);
        EAF26Encoder.save(documentElement, path);
    }

    public void encodeAsTemplateAndSave(Transcription theTranscription, List tierOrder, String path) throws IOException {
        Element documentElement = EAF26Encoder.createTemplateDOM(theTranscription, tierOrder);
        EAF26Encoder.save(documentElement, path);
    }

    /*
     * WARNING - void declaration
     */
    public static Element createDOM(Transcription theTranscription, List tierOrder) {
        int i;
        List<LinguisticType> lTypes;
        Object extRefId;
        long beginTime = System.currentTimeMillis();
        if (debug) {
            System.out.println("Encoder creating DOM...");
        }
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        Hashtable<TimeSlot, CallSite> timeSlotIds = new Hashtable<TimeSlot, CallSite>();
        Hashtable<Annotation, Object> annotationIds = new Hashtable<Annotation, Object>();
        HashMap<CallSite, ExternalReference> extRefIds = new HashMap<CallSite, ExternalReference>();
        ArrayList<CallSite> extRefList = new ArrayList<CallSite>();
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            ServerLogger.LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF26 eafFactory = null;
        try {
            eafFactory = new EAF26();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF26Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        for (MediaDescriptor md : attisTr.getMediaDescriptors()) {
            String origin = null;
            if (md.timeOrigin != 0L) {
                origin = String.valueOf(md.timeOrigin);
            }
            String extrFrom = null;
            if (md.extractedFrom != null && md.extractedFrom != "") {
                extrFrom = md.extractedFrom;
            }
            Element mdElement = eafFactory.newMediaDescriptor(md.mediaURL, md.relativeMediaURL, md.mimeType, origin, extrFrom);
            header.appendChild(mdElement);
        }
        for (LinkedFileDescriptor lfd : attisTr.getLinkedFileDescriptors()) {
            String origin = null;
            if (lfd.timeOrigin != 0L) {
                origin = String.valueOf(lfd.timeOrigin);
            }
            Element lfdElement = eafFactory.newLinkedFileDescriptor(lfd.linkURL, lfd.relativeLinkURL, lfd.mimeType, origin, lfd.associatedWith);
            header.appendChild(lfdElement);
        }
        Property lastUsedAnnIdProp = null;
        List<Property> props = attisTr.getDocProperties();
        if (props.size() > 0) {
            for (int i2 = 0; i2 < props.size(); ++i2) {
                Property prop = props.get(i2);
                Object value = prop.getValue();
                String name = prop.getName();
                if (name == null && value == null) continue;
                if ("lastUsedAnnotationId".equals(name)) {
                    if (value == null) continue;
                    try {
                        lastUsedAnnIdProp = prop;
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Could not retrieve the last used annotation id.");
                    }
                    continue;
                }
                if (value != null) {
                    header.appendChild(eafFactory.newProperty(name, value.toString()));
                    continue;
                }
                header.appendChild(eafFactory.newProperty(name, null));
            }
        }
        if (lastUsedAnnIdProp == null) {
            lastUsedAnnIdProp = new PropertyImpl("lastUsedAnnotationId", 0);
            attisTr.addDocProperty(lastUsedAnnIdProp);
        }
        if (debug) {
            System.out.println("Header creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Iterator<TimeSlot> tsElements = timeOrder.iterator();
        while (tsElements.hasNext()) {
            TimeSlot ts = tsElements.next();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, (CallSite)((Object)tsId));
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        if (debug) {
            System.out.println("TimeSlots creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        Vector<TierImpl> storeOrder = new Vector<TierImpl>(attisTr.getTiers());
        int extRefIndex = 1;
        int annIndex = (Integer)lastUsedAnnIdProp.getValue();
        for (TierImpl t : storeOrder) {
            Locale lang;
            String id = t.getName();
            String participant = t.getParticipant();
            String string = t.getParticipant();
            String lingType = t.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = t.getDefaultLocale()) != null && !usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (t.getParentTier() != null) {
                parentName = t.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, string, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(t.getName(), tierElement);
            for (Annotation annotation : t.getAnnotations()) {
                if (annotation.getId() != null && !annotation.getId().equals("")) {
                    annotationIds.put(annotation, annotation.getId());
                    annIndex = (Integer)lastUsedAnnIdProp.getValue();
                    continue;
                }
                annotationIds.put(annotation, "a" + ++annIndex);
            }
        }
        header.appendChild(eafFactory.newProperty("lastUsedAnnotationId", String.valueOf(annIndex)));
        for (TierImpl t : storeOrder) {
            for (Annotation annotation : t.getAnnotations()) {
                extRefId = null;
                if (annotation instanceof AbstractAnnotation && ((AbstractAnnotation)annotation).getExtRef() != null) {
                    if (!extRefIds.containsValue(((AbstractAnnotation)annotation).getExtRef())) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put((CallSite)extRefId, ((AbstractAnnotation)annotation).getExtRef());
                        extRefList.add((CallSite)extRefId);
                    } else {
                        for (int i3 = 0; i3 < extRefList.size(); ++i3) {
                            if (!((AbstractAnnotation)annotation).getExtRef().equals(extRefIds.get(extRefList.get(i3)))) continue;
                            extRefId = (String)extRefList.get(i3);
                            break;
                        }
                    }
                }
                Element annElement = eafFactory.newAnnotation();
                ((Element)tierElements.get(t.getName())).appendChild(annElement);
                Node annSubElement = null;
                String annId = (String)annotationIds.get(annotation);
                if (annotation instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)annotation).getBegin());
                    String string = (String)timeSlotIds.get(((AlignableAnnotation)annotation).getEnd());
                    annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, string, (String)extRefId);
                } else if (annotation instanceof RefAnnotation) {
                    void var39_59;
                    String refId = null;
                    Object var39_57 = null;
                    List<Annotation> refs = ((RefAnnotation)annotation).getReferences();
                    RefAnnotation prev = ((RefAnnotation)annotation).getPrevious();
                    if (refs.size() > 0) {
                        refId = (String)annotationIds.get(refs.get(0));
                    }
                    if (prev != null) {
                        String string = (String)annotationIds.get(prev);
                    }
                    annSubElement = eafFactory.newRefAnnotation(annId, refId, (String)var39_59, (String)extRefId);
                }
                annElement.appendChild(annSubElement);
                Element valueElement = eafFactory.newAnnotationValue(annotation.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        if (debug) {
            System.out.println("Tiers and Annotations creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((lTypes = attisTr.getLinguisticTypes()) != null) {
            for (LinguisticType linguisticType : lTypes) {
                extRefId = null;
                if (linguisticType.getDataCategory() != null && linguisticType.getDataCategory().length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(linguisticType.getDataCategory(), 2);
                    if (!extRefIds.containsValue(eri)) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put((CallSite)extRefId, eri);
                        extRefList.add((CallSite)extRefId);
                    } else {
                        for (int i4 = 0; i4 < extRefList.size(); ++i4) {
                            if (!eri.equals(extRefIds.get(extRefList.get(i4)))) continue;
                            extRefId = (String)extRefList.get(i4);
                            break;
                        }
                    }
                }
                String stereotype = null;
                if (linguisticType.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[linguisticType.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(linguisticType.getLinguisticTypeName(), linguisticType.isTimeAlignable(), stereotype, linguisticType.getControlledVocabularyName(), (String)extRefId);
                annotDocument.appendChild(typeElement);
            }
        }
        if (debug) {
            System.out.println("Linguistic Types creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        for (Locale locale : usedLocales) {
            Element locElement = eafFactory.newLocale(locale);
            annotDocument.appendChild(locElement);
        }
        Element element = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(element);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        List<ControlledVocabulary> conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            Object extRefId2 = null;
            for (i = 0; i < conVocs.size(); ++i) {
                CVEntry[] entries;
                ControlledVocabulary cv = conVocs.get(i);
                Element element2 = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                for (CVEntry entry : entries = cv.getEntries()) {
                    if (entry.getExternalRef() != null) {
                        if (!extRefIds.containsValue(entry.getExternalRef())) {
                            extRefId2 = "er" + extRefIndex++;
                            extRefIds.put((CallSite)extRefId2, entry.getExternalRef());
                            extRefList.add((CallSite)extRefId2);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId2 = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId2 = null;
                    }
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription(), (String)extRefId2);
                    element2.appendChild(entryElement);
                }
                annotDocument.appendChild(element2);
            }
        }
        if (debug) {
            System.out.println("Constraints and CV's creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        String type = "iso12620";
        for (i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl externalReferenceImpl = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || externalReferenceImpl == null) continue;
            Element erElement = eafFactory.newExternalReference(id, type, externalReferenceImpl.getValue());
            annotDocument.appendChild(erElement);
        }
        return eafFactory.getDocumentElement();
    }

    public static Element createTemplateDOM(Transcription theTranscription, List tierOrder) {
        int i;
        Hashtable<String, Element> tierElements = new Hashtable<String, Element>();
        HashMap<CallSite, ExternalReference> extRefIds = new HashMap<CallSite, ExternalReference>();
        ArrayList<CallSite> extRefList = new ArrayList<CallSite>();
        int extRefIndex = 1;
        Vector<Locale> usedLocales = new Vector<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            ServerLogger.LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF26 eafFactory = null;
        try {
            eafFactory = new EAF26();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF26Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        author = "";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        Vector<TierImpl> storeOrder = new Vector<TierImpl>(attisTr.getTiers());
        for (TierImpl t : storeOrder) {
            Locale lang;
            String id = t.getName();
            String participant = t.getParticipant();
            String annotator = t.getParticipant();
            String lingType = t.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = t.getDefaultLocale()) != null && !usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (t.getParentTier() != null) {
                parentName = t.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, annotator, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(t.getName(), tierElement);
        }
        List<LinguisticType> lTypes = attisTr.getLinguisticTypes();
        if (lTypes != null) {
            for (LinguisticType lt : lTypes) {
                Object extRefId = null;
                if (lt.getDataCategory() != null && lt.getDataCategory().length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(lt.getDataCategory(), 2);
                    if (!extRefIds.containsValue(eri)) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put((CallSite)extRefId, eri);
                        extRefList.add((CallSite)extRefId);
                    } else {
                        for (int i2 = 0; i2 < extRefList.size(); ++i2) {
                            if (!eri.equals(extRefIds.get(extRefList.get(i2)))) continue;
                            extRefId = (String)extRefList.get(i2);
                            break;
                        }
                    }
                }
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), stereotype, lt.getControlledVocabularyName(), (String)extRefId);
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        List<ControlledVocabulary> conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            Object extRefId = null;
            for (i = 0; i < conVocs.size(); ++i) {
                CVEntry[] entries;
                ControlledVocabulary cv = conVocs.get(i);
                Element cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                for (CVEntry entry : entries = cv.getEntries()) {
                    if (entry.getExternalRef() != null) {
                        if (!extRefIds.containsValue(entry.getExternalRef())) {
                            extRefId = "er" + extRefIndex++;
                            extRefIds.put((CallSite)extRefId, entry.getExternalRef());
                            extRefList.add((CallSite)extRefId);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId = null;
                    }
                    Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription(), (String)extRefId);
                    cvElement.appendChild(entryElement);
                }
                annotDocument.appendChild(cvElement);
            }
        }
        String type = "iso12620";
        for (i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = eafFactory.newExternalReference(id, type, eri.getValue());
            annotDocument.appendChild(erElement);
        }
        return eafFactory.getDocumentElement();
    }

    private static String correctDate(String strIn) {
        Object strResult = new String(strIn);
        try {
            int indexSpace;
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            Object strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = (String)strOffset + "0";
            }
            if ((indexSpace = ((String)(strResult = (String)strResult + (String)(strOffset = (String)strOffset + offsetGMT + ":00"))).indexOf(" ")) != -1) {
                String strEnd = ((String)strResult).substring(indexSpace + 1);
                strResult = ((String)strResult).substring(0, indexSpace);
                strResult = (String)strResult + "T";
                strResult = (String)strResult + strEnd;
            }
            strResult = ((String)strResult).replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }

    private static void save(Element documentElement, String path) throws IOException {
        ServerLogger.LOG.info(path + " <----XML output\n");
        try {
            if (("" + documentElement).length() == 0) {
                throw new IOException("Unable to save this file (zero length).");
            }
            long beginTime = System.currentTimeMillis();
            IoUtil.writeEncodedEAFFile("UTF-8", path, documentElement);
            if (debug) {
                System.out.println("Saving file took: " + (System.currentTimeMillis() - beginTime) + " ms");
            }
        }
        catch (Exception eee) {
            throw new IOException("Unable to save this file: " + eee.getMessage());
        }
    }
}

