/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EAF26Parser
extends Parser {
    private SAXParser parser;
    private final HashMap<String, TierRecord> tierMap = new HashMap();
    private final HashMap<String, ArrayList<AnnotationRecord>> tiers = new HashMap();
    private final ArrayList<String> tierNames = new ArrayList();
    private final ArrayList<LingTypeRecord> linguisticTypes = new ArrayList();
    private final ArrayList<Locale> locales = new ArrayList();
    private final HashMap<String, String> timeSlots = new HashMap();
    private final HashMap<String, CVRecord> controlledVocabularies = new HashMap();
    private final ArrayList<Property> docProperties = new ArrayList();
    private final HashMap<String, ExternalReferenceImpl> extReferences = new HashMap();
    private final ArrayList<String> timeOrder = new ArrayList();
    private String mediaFile;
    private ArrayList<MediaDescriptor> mediaDescriptors = new ArrayList();
    private ArrayList<LinkedFileDescriptor> linkedFileDescriptors = new ArrayList();
    private String author;
    private String currentTierId;
    private String currentAnnotationId;
    private AnnotationRecord currentAnnRecord;
    private String currentCVId;
    private CVEntryRecord currentEntryRecord;
    private String content = "";
    private String lastParsed = "";
    private String currentFileName;
    private String currentPropertyName;

    public EAF26Parser() {
        try {
            boolean validate = Boolean.parseBoolean(System.getProperty("ELAN.EAF.Validate", "true"));
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            if (validate) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema eafSchema = schemaFactory.newSchema(this.getClass().getResource("/mpi/eudico/resources/EAFv2.6.xsd"));
                parserFactory.setSchema(eafSchema);
            } else {
                parserFactory.setValidating(false);
            }
            this.parser = parserFactory.newSAXParser();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    @Override
    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return this.mediaFile;
    }

    public ArrayList<MediaDescriptor> getMediaDescriptors(String fileName) {
        this.parse(fileName);
        if (this.mediaDescriptors.isEmpty() && this.mediaFile != null) {
            MediaDescriptor md = new MediaDescriptor(this.mediaFile, "unknown");
            this.mediaDescriptors.add(md);
        }
        return this.mediaDescriptors;
    }

    public ArrayList<LinkedFileDescriptor> getLinkedFileDescriptors(String fileName) {
        this.parse(fileName);
        return this.linkedFileDescriptors;
    }

    @Override
    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.author;
    }

    public ArrayList<Property> getTranscriptionProperties(String fileName) {
        this.parse(fileName);
        return this.docProperties;
    }

    public ArrayList<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return this.linguisticTypes;
    }

    public ArrayList<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        return this.timeOrder;
    }

    public HashMap<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        return this.timeSlots;
    }

    public HashMap<String, CVRecord> getControlledVocabularies(String fileName) {
        this.parse(fileName);
        return this.controlledVocabularies;
    }

    public ArrayList<String> getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && this.tierMap.get(tierName).getParticipant() != null) {
            return this.tierMap.get(tierName).getParticipant();
        }
        return "";
    }

    @Override
    public String getAnnotatorOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && this.tierMap.get(tierName).getAnnotator() != null) {
            return this.tierMap.get(tierName).getAnnotator();
        }
        return "";
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null && this.tierMap.get(tierName).getLinguisticType() != null) {
            return this.tierMap.get(tierName).getLinguisticType();
        }
        return "";
    }

    @Override
    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        this.parse(fileName);
        Locale resultLoc = null;
        String localeId = null;
        if (this.tierMap.get(tierName) != null) {
            localeId = this.tierMap.get(tierName).getDefaultLocale();
        }
        for (Locale l : this.locales) {
            if (!l.getLanguage().equals(localeId)) continue;
            resultLoc = l;
        }
        return resultLoc;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        if (this.tierMap.get(tierName) != null) {
            return this.tierMap.get(tierName).getParentTier();
        }
        return null;
    }

    @Override
    public List<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        return this.tiers.get(tierName);
    }

    @Override
    public Map<String, ExternalReferenceImpl> getExternalReferences(String fileName) {
        this.parse(fileName);
        return this.extReferences;
    }

    private void parse(String fileName) {
        if (this.lastParsed.equals(fileName)) {
            return;
        }
        this.tiers.clear();
        this.tierNames.clear();
        this.mediaFile = "";
        this.linguisticTypes.clear();
        this.locales.clear();
        this.timeSlots.clear();
        this.timeOrder.clear();
        this.mediaDescriptors.clear();
        this.linkedFileDescriptors.clear();
        this.controlledVocabularies.clear();
        this.lastParsed = fileName;
        this.currentFileName = fileName;
        try {
            InputSource is = ACMTranscriptionStore.toInputSource(fileName);
            EAFContentHandler contentHandler = new EAFContentHandler();
            this.parser.parse(is, (DefaultHandler)contentHandler);
        }
        catch (IOException ioe) {
            System.out.println("IO error: " + ioe.getMessage());
        }
        catch (SAXException saex) {
            System.out.println("Parsing error: " + saex.getMessage());
        }
    }

    class EAFContentHandler
    extends DefaultHandler {
        EAFContentHandler() {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            EAF26Parser.this.content = "";
            if (name.isEmpty()) {
                name = rawName;
            }
            if (name.equals("ANNOTATION_DOCUMENT")) {
                EAF26Parser.this.author = attributes.getValue("AUTHOR");
            } else if (name.equals("HEADER")) {
                EAF26Parser.this.mediaFile = attributes.getValue("MEDIA_FILE");
            } else if (name.equals("MEDIA_DESCRIPTOR")) {
                String relURL;
                String mediaURL = attributes.getValue("MEDIA_URL");
                String mimeType = attributes.getValue("MIME_TYPE");
                MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
                long timeOrigin = 0L;
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    md.timeOrigin = timeOrigin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                }
                String extractedFrom = "";
                if (attributes.getValue("EXTRACTED_FROM") != null) {
                    md.extractedFrom = extractedFrom = attributes.getValue("EXTRACTED_FROM");
                }
                if ((relURL = attributes.getValue("RELATIVE_MEDIA_URL")) != null) {
                    md.relativeMediaURL = relURL;
                }
                EAF26Parser.this.mediaDescriptors.add(md);
            } else if (name.equals("LINKED_FILE_DESCRIPTOR")) {
                String relURL;
                String assoc;
                String linkURL = attributes.getValue("LINK_URL");
                String mime = attributes.getValue("MIME_TYPE");
                LinkedFileDescriptor lfd = new LinkedFileDescriptor(linkURL, mime);
                if (attributes.getValue("TIME_ORIGIN") != null) {
                    try {
                        long origin;
                        lfd.timeOrigin = origin = Long.parseLong(attributes.getValue("TIME_ORIGIN"));
                    }
                    catch (NumberFormatException nfe) {
                        System.out.println("Could not parse the time origin: " + nfe.getMessage());
                    }
                }
                if ((assoc = attributes.getValue("ASSOCIATED_WITH")) != null) {
                    lfd.associatedWith = assoc;
                }
                if ((relURL = attributes.getValue("RELATIVE_LINK_URL")) != null) {
                    lfd.relativeLinkURL = relURL;
                }
                EAF26Parser.this.linkedFileDescriptors.add(lfd);
            } else if (name.equals("PROPERTY")) {
                EAF26Parser.this.currentPropertyName = attributes.getValue("NAME");
            } else if (!name.equals("TIME_ORDER")) {
                if (name.equals("TIME_SLOT")) {
                    String timeValue = String.valueOf(-1);
                    if (attributes.getValue("TIME_VALUE") != null) {
                        timeValue = attributes.getValue("TIME_VALUE");
                    }
                    EAF26Parser.this.timeSlots.put(attributes.getValue("TIME_SLOT_ID"), timeValue);
                    EAF26Parser.this.timeOrder.add(attributes.getValue("TIME_SLOT_ID"));
                } else if (name.equals("TIER")) {
                    EAF26Parser.this.currentTierId = attributes.getValue("TIER_ID");
                    if (!EAF26Parser.this.tiers.containsKey(EAF26Parser.this.currentTierId)) {
                        TierRecord tr = new TierRecord();
                        tr.setName(EAF26Parser.this.currentTierId);
                        EAF26Parser.this.tierMap.put(EAF26Parser.this.currentTierId, tr);
                        tr.setParticipant(attributes.getValue("PARTICIPANT"));
                        tr.setAnnotator(attributes.getValue("ANNOTATOR"));
                        tr.setLinguisticType(attributes.getValue("LINGUISTIC_TYPE_REF"));
                        tr.setDefaultLocale(attributes.getValue("DEFAULT_LOCALE"));
                        tr.setParentTier(attributes.getValue("PARENT_REF"));
                        EAF26Parser.this.tiers.put(EAF26Parser.this.currentTierId, new ArrayList());
                        EAF26Parser.this.tierNames.add(EAF26Parser.this.currentTierId);
                    }
                } else if (name.equals("ALIGNABLE_ANNOTATION")) {
                    EAF26Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    EAF26Parser.this.currentAnnRecord = new AnnotationRecord();
                    EAF26Parser.this.currentAnnRecord.setAnnotationId(EAF26Parser.this.currentAnnotationId);
                    EAF26Parser.this.currentAnnRecord.setAnnotationType("alignable");
                    EAF26Parser.this.currentAnnRecord.setBeginTimeSlotId(attributes.getValue("TIME_SLOT_REF1"));
                    EAF26Parser.this.currentAnnRecord.setEndTimeSlotId(attributes.getValue("TIME_SLOT_REF2"));
                    EAF26Parser.this.currentAnnRecord.setExtRefId(attributes.getValue("EXT_REF"));
                    ((ArrayList)EAF26Parser.this.tiers.get(EAF26Parser.this.currentTierId)).add(EAF26Parser.this.currentAnnRecord);
                } else if (name.equals("REF_ANNOTATION")) {
                    EAF26Parser.this.currentAnnotationId = attributes.getValue("ANNOTATION_ID");
                    EAF26Parser.this.currentAnnRecord = new AnnotationRecord();
                    EAF26Parser.this.currentAnnRecord.setAnnotationId(EAF26Parser.this.currentAnnotationId);
                    EAF26Parser.this.currentAnnRecord.setAnnotationType("reference");
                    EAF26Parser.this.currentAnnRecord.setReferredAnnotId(attributes.getValue("ANNOTATION_REF"));
                    if (attributes.getValue("PREVIOUS_ANNOTATION") != null) {
                        EAF26Parser.this.currentAnnRecord.setPreviousAnnotId(attributes.getValue("PREVIOUS_ANNOTATION"));
                    } else {
                        EAF26Parser.this.currentAnnRecord.setPreviousAnnotId("");
                    }
                    EAF26Parser.this.currentAnnRecord.setExtRefId(attributes.getValue("EXT_REF"));
                    ((ArrayList)EAF26Parser.this.tiers.get(EAF26Parser.this.currentTierId)).add(EAF26Parser.this.currentAnnRecord);
                } else if (name.equals("LINGUISTIC_TYPE")) {
                    LingTypeRecord ltr = new LingTypeRecord();
                    ltr.setLingTypeId(attributes.getValue("LINGUISTIC_TYPE_ID"));
                    String timeAlignable = "true";
                    if (attributes.getValue("TIME_ALIGNABLE") != null && attributes.getValue("TIME_ALIGNABLE").equals("false")) {
                        timeAlignable = "false";
                    }
                    ltr.setTimeAlignable(timeAlignable);
                    String stereotype = attributes.getValue("CONSTRAINTS");
                    ltr.setStereoType(stereotype);
                    if (stereotype != null && stereotype.startsWith("Symbolic")) {
                        ltr.setTimeAlignable("false");
                    }
                    ltr.setControlledVocabulary(attributes.getValue("CONTROLLED_VOCABULARY_REF"));
                    ltr.setExtRefId(attributes.getValue("EXT_REF"));
                    EAF26Parser.this.linguisticTypes.add(ltr);
                } else if (name.equals("LOCALE")) {
                    String variant;
                    String langCode = attributes.getValue("LANGUAGE_CODE");
                    String countryCode = attributes.getValue("COUNTRY_CODE");
                    if (countryCode == null) {
                        countryCode = "";
                    }
                    if ((variant = attributes.getValue("VARIANT")) == null) {
                        variant = "";
                    }
                    Locale l = new Locale(langCode, countryCode, variant);
                    EAF26Parser.this.locales.add(l);
                } else if (name.equals("CONTROLLED_VOCABULARY")) {
                    EAF26Parser.this.currentCVId = attributes.getValue("CV_ID");
                    CVRecord cv = new CVRecord(EAF26Parser.this.currentCVId);
                    String desc = attributes.getValue("DESCRIPTION");
                    if (desc != null) {
                        cv.setDescription(desc);
                    }
                    EAF26Parser.this.controlledVocabularies.put(EAF26Parser.this.currentCVId, cv);
                } else if (name.equals("CV_ENTRY")) {
                    EAF26Parser.this.currentEntryRecord = new CVEntryRecord();
                    EAF26Parser.this.currentEntryRecord.setDescription(attributes.getValue("DESCRIPTION"));
                    EAF26Parser.this.currentEntryRecord.setExtRefId(attributes.getValue("EXT_REF"));
                    ((CVRecord)EAF26Parser.this.controlledVocabularies.get(EAF26Parser.this.currentCVId)).addEntry(EAF26Parser.this.currentEntryRecord);
                } else if (name.equals("EXTERNAL_REF")) {
                    String value = attributes.getValue("VALUE");
                    String type = attributes.getValue("TYPE");
                    String dcId = attributes.getValue("EXT_REF_ID");
                    if (value != null && value.length() > 0) {
                        ExternalReferenceImpl eri = new ExternalReferenceImpl(value, 2);
                        if (type != null && !type.equals("iso12620")) {
                            eri.setReferenceType(0);
                        }
                        EAF26Parser.this.extReferences.put(dcId, eri);
                    }
                }
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.isEmpty()) {
                name = rawName;
            }
            if (name.equals("ANNOTATION_VALUE")) {
                EAF26Parser.this.currentAnnRecord.setValue(EAF26Parser.this.content);
            } else if (name.equals("CV_ENTRY")) {
                EAF26Parser.this.currentEntryRecord.setValue(EAF26Parser.this.content);
            } else if (name.equals("PROPERTY") && EAF26Parser.this.content.length() > 0 && EAF26Parser.this.currentPropertyName != null) {
                PropertyImpl prop = new PropertyImpl(EAF26Parser.this.currentPropertyName, EAF26Parser.this.content);
                EAF26Parser.this.docProperties.add(prop);
            }
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            EAF26Parser.this.content = EAF26Parser.this.content + new String(ch, start, end);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("System id: " + exception.getSystemId());
            System.out.println("Public id: " + exception.getPublicId());
            System.out.println("Line: " + exception.getLineNumber());
            System.out.println("Column: " + exception.getColumnNumber());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }
}

