/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import mpi.eudico.server.corpora.clomimpl.dobes.EAF26;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import org.w3c.dom.Element;

public class EAF27
extends EAF26 {
    public static final String EAF27_SCHEMA_LOCATION = "http://www.mpi.nl/tools/elan/EAFv2.7.xsd";
    public static final String EAF27_SCHEMA_RESOURCE = "/mpi/eudico/resources/EAFv2.7.xsd";

    public EAF27() throws Exception {
        this.EAF_Format = "2.7";
        this.EAF_Schema_Location = EAF27_SCHEMA_LOCATION;
    }

    public Element newLinguisticType(String id, boolean timeAlignable, String constraint, String controlledVocabularyName, String extRefId, String lexiconQueryBundleName) {
        Element result = super.newLinguisticType(id, timeAlignable, constraint, controlledVocabularyName, extRefId);
        this.attributeIfNotEmpty(result, "LEXICON_REF", lexiconQueryBundleName);
        return result;
    }

    public Element newControlledVocabulary(String conVocId, String description, String extRef) {
        Element result = super.newControlledVocabulary(conVocId, description);
        this.attributeIfNotEmpty(result, "EXT_REF", extRef);
        return result;
    }

    public Element newLexiconReference(String lexRef, LexiconQueryBundle2 queryBundle) {
        if (lexRef == null || lexRef.isEmpty()) {
            throw new RuntimeException("EAF");
        }
        if (queryBundle == null) {
            throw new RuntimeException("EAF");
        }
        if (queryBundle.getLink() == null) {
            throw new RuntimeException("EAF");
        }
        if (queryBundle.getLink().getName() == null || queryBundle.getLink().getName().isEmpty()) {
            throw new RuntimeException("EAF");
        }
        if (queryBundle.getLink().getLexSrvcClntType() == null) {
            throw new RuntimeException("EAF");
        }
        if (queryBundle.getLink().getUrl() == null) {
            throw new RuntimeException("EAF");
        }
        if (queryBundle.getLink().getLexId().getId() == null) {
            throw new RuntimeException("EAF");
        }
        if (queryBundle.getLink().getLexId().getName() == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LEXICON_REF");
        result.setAttribute("LEX_REF_ID", lexRef);
        result.setAttribute("TYPE", queryBundle.getLink().getLexSrvcClntType());
        result.setAttribute("URL", queryBundle.getLink().getUrl());
        result.setAttribute("LEXICON_ID", queryBundle.getLink().getLexId().getId());
        result.setAttribute("LEXICON_NAME", queryBundle.getLink().getLexId().getName());
        if (queryBundle.getFldId() != null) {
            if (queryBundle.getFldId().getId() != null) {
                result.setAttribute("DATCAT_ID", queryBundle.getFldId().getId());
            }
            if (queryBundle.getFldId().getName() != null) {
                result.setAttribute("DATCAT_NAME", queryBundle.getFldId().getName());
            }
        }
        result.setAttribute("NAME", queryBundle.getLink().getName());
        return result;
    }

    public Element newLexiconLink(String lexRef, LexiconLink link) {
        if (lexRef == null || lexRef.isEmpty()) {
            throw new RuntimeException("EAF");
        }
        if (link == null) {
            throw new RuntimeException("EAF");
        }
        if (link.getName() == null || link.getName().isEmpty()) {
            throw new RuntimeException("EAF");
        }
        if (link.getLexSrvcClntType() == null) {
            throw new RuntimeException("EAF");
        }
        if (link.getUrl() == null) {
            throw new RuntimeException("EAF");
        }
        if (link.getLexId() == null || link.getLexId().getId() == null) {
            throw new RuntimeException("EAF");
        }
        if (link.getLexId() == null || link.getLexId().getName() == null) {
            throw new RuntimeException("EAF");
        }
        Element result = this.doc.createElement("LEXICON_REF");
        result.setAttribute("LEX_REF_ID", lexRef);
        result.setAttribute("TYPE", link.getLexSrvcClntType());
        result.setAttribute("URL", link.getUrl());
        result.setAttribute("LEXICON_ID", link.getLexId().getId());
        result.setAttribute("LEXICON_NAME", link.getLexId().getName());
        result.setAttribute("NAME", link.getName());
        return result;
    }
}

