/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF27;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF27Encoder
implements AnnotationDocEncoder {
    public static final String VERSION = "2.7";
    public static boolean debug = false;

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        Element documentElement = EAF27Encoder.createDOM(theTranscription, tierOrder, path);
        EAF27Encoder.save(documentElement, path);
    }

    public void encodeAsTemplateAndSave(Transcription theTranscription, List<TierImpl> tierOrder, String path) throws IOException {
        Element documentElement = EAF27Encoder.createTemplateDOM(theTranscription, tierOrder, path);
        EAF27Encoder.save(documentElement, path);
    }

    /*
     * WARNING - void declaration
     */
    public static Element createDOM(Transcription theTranscription, List<TierImpl> tierOrder, String path) {
        List<LinguisticType> lTypes;
        long beginTime = System.currentTimeMillis();
        if (debug) {
            System.out.println("Encoder creating DOM...");
        }
        HashMap<String, Element> tierElements = new HashMap<String, Element>();
        HashMap<TimeSlot, CallSite> timeSlotIds = new HashMap<TimeSlot, CallSite>();
        HashMap<Object, Object> extRefIds = new HashMap<Object, Object>();
        ArrayList<Object> extRefList = new ArrayList<Object>();
        HashMap<CallSite, LexiconQueryBundle2> lexRefs = new HashMap<CallSite, LexiconQueryBundle2>();
        int lexRefIndex = 1;
        ArrayList<Locale> usedLocales = new ArrayList<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            ServerLogger.LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF27 eafFactory = null;
        try {
            eafFactory = new EAF27();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF27Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        for (MediaDescriptor md : attisTr.getMediaDescriptors()) {
            String origin = null;
            if (md.timeOrigin != 0L) {
                origin = String.valueOf(md.timeOrigin);
            }
            String extrFrom = null;
            if (md.extractedFrom != null && md.extractedFrom != "") {
                extrFrom = md.extractedFrom;
            }
            Element mdElement = eafFactory.newMediaDescriptor(md.mediaURL, md.relativeMediaURL, md.mimeType, origin, extrFrom);
            header.appendChild(mdElement);
        }
        for (LinkedFileDescriptor lfd : attisTr.getLinkedFileDescriptors()) {
            String origin = null;
            if (lfd.timeOrigin != 0L) {
                origin = String.valueOf(lfd.timeOrigin);
            }
            Element lfdElement = eafFactory.newLinkedFileDescriptor(lfd.linkURL, lfd.relativeLinkURL, lfd.mimeType, origin, lfd.associatedWith);
            header.appendChild(lfdElement);
        }
        Property lastUsedAnnIdProp = null;
        List<Property> props = attisTr.getDocProperties();
        if (props.size() > 0) {
            for (Property prop : props) {
                Object value = prop.getValue();
                String name = prop.getName();
                if (name == null && value == null) continue;
                if ("lastUsedAnnotationId".equals(name)) {
                    if (value == null) continue;
                    try {
                        lastUsedAnnIdProp = prop;
                    }
                    catch (ClassCastException nfe) {
                        System.out.println("Could not retrieve the last used annotation id.");
                    }
                    continue;
                }
                if (value != null) {
                    header.appendChild(eafFactory.newProperty(name, value.toString()));
                    continue;
                }
                header.appendChild(eafFactory.newProperty(name, null));
            }
        }
        if (lastUsedAnnIdProp == null) {
            lastUsedAnnIdProp = new PropertyImpl("lastUsedAnnotationId", 0);
            attisTr.addDocProperty(lastUsedAnnIdProp);
        }
        if (debug) {
            System.out.println("Header creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        TimeOrder timeOrder = attisTr.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Iterator<TimeSlot> tsElements = timeOrder.iterator();
        while (tsElements.hasNext()) {
            TimeSlot ts = tsElements.next();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, (CallSite)((Object)tsId));
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        if (debug) {
            System.out.println("TimeSlots creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        ArrayList<TierImpl> storeOrder = new ArrayList<TierImpl>(attisTr.getTiers());
        int extRefIndex = 1;
        for (TierImpl t : storeOrder) {
            void var37_45;
            Object lang;
            String id = t.getName();
            String participant = t.getParticipant();
            String annotator = t.getAnnotator();
            String lingType = t.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = t.getDefaultLocale()) != null && !usedLocales.contains(lang)) {
                usedLocales.add((Locale)lang);
            }
            Object var37_46 = null;
            if (t.getParentTier() != null) {
                String string = t.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, annotator, lingType, (Locale)lang, (String)var37_45);
            annotDocument.appendChild(tierElement);
            tierElements.put(t.getName(), tierElement);
            for (Annotation annotation : t.getAnnotations()) {
                String string = annotation.getId();
            }
        }
        header.appendChild(eafFactory.newProperty("lastUsedAnnotationId", lastUsedAnnIdProp.getValue().toString()));
        for (TierImpl t : storeOrder) {
            String cvName = t.getLinguisticType().getControlledVocabularyName();
            ControlledVocabulary cv = ((TranscriptionImpl)theTranscription).getControlledVocabulary(cvName);
            boolean tierHasExternalCV = cv instanceof ExternalCV;
            for (Annotation annotation : t.getAnnotations()) {
                String string;
                Object extRefId = null;
                ArrayList<ExternalReference> extRefs = new ArrayList<ExternalReference>();
                if (annotation instanceof AbstractAnnotation && ((AbstractAnnotation)annotation).getExtRefs() != null) {
                    extRefs.addAll(((AbstractAnnotation)annotation).getExtRefs());
                }
                if (tierHasExternalCV && (string = annotation.getCVEntryId()) != null) {
                    ExternalReferenceImpl extRefCv = new ExternalReferenceImpl(string, 5);
                    extRefs.add(extRefCv);
                }
                if (!extRefs.isEmpty()) {
                    void var40_64;
                    boolean bl = false;
                    while (var40_64 < extRefs.size()) {
                        Object thisExtRef = extRefs.get((int)var40_64);
                        if (!extRefIds.containsValue(thisExtRef)) {
                            String tmpExtRefId = "er" + extRefIndex++;
                            extRefId = extRefId != null && !((String)extRefId).equals("") ? (String)extRefId + " " + tmpExtRefId : tmpExtRefId;
                            extRefIds.put(tmpExtRefId, thisExtRef);
                            extRefList.add(tmpExtRefId);
                        } else {
                            for (int i = 0; i < extRefList.size(); ++i) {
                                if (!thisExtRef.equals(extRefIds.get(extRefList.get(i)))) continue;
                                String tmpExtRefId = (String)extRefList.get(i);
                                if (extRefId != null && !((String)extRefId).equals("")) {
                                    extRefId = (String)extRefId + " " + tmpExtRefId;
                                    break;
                                }
                                extRefId = tmpExtRefId;
                                break;
                            }
                        }
                        ++var40_64;
                    }
                }
                Element element = eafFactory.newAnnotation();
                ((Element)tierElements.get(t.getName())).appendChild(element);
                Node annSubElement = null;
                String annId = annotation.getId();
                if (annotation instanceof AlignableAnnotation) {
                    String beginTsId = (String)timeSlotIds.get(((AlignableAnnotation)annotation).getBegin());
                    String endTsId = (String)timeSlotIds.get(((AlignableAnnotation)annotation).getEnd());
                    annSubElement = eafFactory.newAlignableAnnotation(annId, beginTsId, endTsId, (String)extRefId);
                } else if (annotation instanceof RefAnnotation) {
                    String refId = null;
                    String prevId = null;
                    List<Annotation> refs = ((RefAnnotation)annotation).getReferences();
                    RefAnnotation prev = ((RefAnnotation)annotation).getPrevious();
                    if (refs.size() > 0) {
                        refId = refs.get(0).getId();
                    }
                    if (prev != null) {
                        prevId = prev.getId();
                    }
                    annSubElement = eafFactory.newRefAnnotation(annId, refId, prevId, (String)extRefId);
                }
                element.appendChild(annSubElement);
                Element valueElement = eafFactory.newAnnotationValue(annotation.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
        if (debug) {
            System.out.println("Tiers and Annotations creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        if ((lTypes = attisTr.getLinguisticTypes()) != null) {
            for (LinguisticType lt : lTypes) {
                void var37_55;
                Object extRefId = null;
                if (lt.getDataCategory() != null && lt.getDataCategory().length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(lt.getDataCategory(), 2);
                    if (!extRefIds.containsValue(eri)) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put(extRefId, eri);
                        extRefList.add(extRefId);
                    } else {
                        void var37_52;
                        boolean bl = false;
                        while (var37_52 < extRefList.size()) {
                            if (eri.equals(extRefIds.get(extRefList.get((int)var37_52)))) {
                                extRefId = (String)extRefList.get((int)var37_52);
                                break;
                            }
                            ++var37_52;
                        }
                    }
                }
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                Object var37_53 = null;
                LexiconQueryBundle2 queryBundle = lt.getLexiconQueryBundle();
                if (queryBundle != null) {
                    String string = "lr" + lexRefIndex++;
                    lexRefs.put((CallSite)((Object)string), queryBundle);
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), stereotype, lt.getControlledVocabularyName(), (String)extRefId, (String)var37_55);
                annotDocument.appendChild(typeElement);
            }
        }
        if (debug) {
            System.out.println("Linguistic Types creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element element = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(element);
        List<ControlledVocabulary> conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            Object extRefId = null;
            for (int i = 0; i < conVocs.size(); ++i) {
                void var40_69;
                ControlledVocabulary cv = conVocs.get(i);
                if (cv instanceof ExternalCV) {
                    ExternalReference externalRef = ((ExternalCV)cv).getExternalRef();
                    if (externalRef != null) {
                        if (!extRefIds.containsValue(externalRef)) {
                            extRefId = "er" + extRefIndex++;
                            extRefIds.put(extRefId, externalRef);
                            extRefList.add(extRefId);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!externalRef.equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId = null;
                    }
                    Element element2 = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription(), (String)extRefId);
                } else {
                    CVEntry[] entries;
                    Element element3 = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                    for (CVEntry entry : entries = cv.getEntries()) {
                        if (entry.getExternalRef() != null) {
                            if (!extRefIds.containsValue(entry.getExternalRef())) {
                                extRefId = "er" + extRefIndex++;
                                extRefIds.put(extRefId, entry.getExternalRef());
                                extRefList.add(extRefId);
                            } else {
                                for (int k = 0; k < extRefList.size(); ++k) {
                                    if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                    extRefId = (String)extRefList.get(k);
                                    break;
                                }
                            }
                        } else {
                            extRefId = null;
                        }
                        Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription(), (String)extRefId);
                        element3.appendChild(entryElement);
                    }
                }
                annotDocument.appendChild((Node)var40_69);
            }
        }
        if (debug) {
            System.out.println("Constraints and CV's creation took: " + (System.currentTimeMillis() - beginTime) + " ms");
            beginTime = System.currentTimeMillis();
        }
        HashMap<String, LexiconLink> savedLexiconLinks = new HashMap<String, LexiconLink>();
        for (Object lexRef : lexRefs.keySet()) {
            LexiconQueryBundle2 queryBundle = (LexiconQueryBundle2)lexRefs.get(lexRef);
            Element lexSrvcElement = eafFactory.newLexiconReference((String)lexRef, queryBundle);
            savedLexiconLinks.put(queryBundle.getLinkName(), queryBundle.getLink());
            annotDocument.appendChild(lexSrvcElement);
        }
        Map map = attisTr.getLexiconLinks();
        for (String linkName : map.keySet()) {
            if (savedLexiconLinks.containsKey(linkName)) continue;
            Element lexSrvcElement = eafFactory.newLexiconLink("lr" + lexRefIndex++, (LexiconLink)map.get(linkName));
            annotDocument.appendChild(lexSrvcElement);
        }
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = eafFactory.newExternalReference(id, eri.getTypeString(), eri.getValue());
            annotDocument.appendChild(erElement);
        }
        return eafFactory.getDocumentElement();
    }

    public static Element createTemplateDOM(Transcription theTranscription, List<TierImpl> tierOrder, String path) {
        HashMap<String, Element> tierElements = new HashMap<String, Element>();
        HashMap<Object, ExternalReference> extRefIds = new HashMap<Object, ExternalReference>();
        ArrayList<Object> extRefList = new ArrayList<Object>();
        int extRefIndex = 1;
        HashMap<CallSite, LexiconQueryBundle2> lexRefs = new HashMap<CallSite, LexiconQueryBundle2>();
        int lexRefIndex = 1;
        ArrayList<Locale> usedLocales = new ArrayList<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null) {
            ServerLogger.LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAF27 eafFactory = null;
        try {
            eafFactory = new EAF27();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = EAF27Encoder.correctDate(dateString);
        String author = attisTr.getAuthor();
        author = "";
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, VERSION);
        eafFactory.appendChild(annotDocument);
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        ArrayList<TierImpl> storeOrder = new ArrayList<TierImpl>(attisTr.getTiers());
        for (TierImpl t : storeOrder) {
            Locale lang;
            String id = t.getName();
            String participant = t.getParticipant();
            String annotator = t.getAnnotator();
            String lingType = t.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = t.getDefaultLocale()) != null && !usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (t.getParentTier() != null) {
                parentName = t.getParentTier().getName();
            }
            Element tierElement = eafFactory.newTier(id, participant, annotator, lingType, lang, parentName);
            annotDocument.appendChild(tierElement);
            tierElements.put(t.getName(), tierElement);
        }
        List<LinguisticType> lTypes = attisTr.getLinguisticTypes();
        if (lTypes != null) {
            for (LinguisticType lt : lTypes) {
                Object extRefId = null;
                if (lt.getDataCategory() != null && lt.getDataCategory().length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(lt.getDataCategory(), 2);
                    if (!extRefIds.containsValue(eri)) {
                        extRefId = "er" + extRefIndex++;
                        extRefIds.put(extRefId, eri);
                        extRefList.add(extRefId);
                    } else {
                        for (int i = 0; i < extRefList.size(); ++i) {
                            if (!eri.equals(extRefIds.get(extRefList.get(i)))) continue;
                            extRefId = (String)extRefList.get(i);
                            break;
                        }
                    }
                }
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                String lexRef = null;
                LexiconQueryBundle2 queryBundle = lt.getLexiconQueryBundle();
                if (queryBundle != null) {
                    lexRef = "lr" + lexRefIndex++;
                    lexRefs.put((CallSite)((Object)lexRef), queryBundle);
                }
                Element typeElement = eafFactory.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), stereotype, lt.getControlledVocabularyName(), (String)extRefId, lexRef);
                annotDocument.appendChild(typeElement);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
        List<ControlledVocabulary> conVocs = attisTr.getControlledVocabularies();
        if (conVocs.size() > 0) {
            Object extRefId = null;
            for (int i = 0; i < conVocs.size(); ++i) {
                Object cvElement;
                ControlledVocabulary cv = conVocs.get(i);
                if (cv instanceof ExternalCV) {
                    ExternalReference externalRef = ((ExternalCV)cv).getExternalRef();
                    if (externalRef != null) {
                        if (!extRefIds.containsValue(externalRef)) {
                            extRefId = "er" + extRefIndex++;
                            extRefIds.put(extRefId, externalRef);
                            extRefList.add(extRefId);
                        } else {
                            for (int k = 0; k < extRefList.size(); ++k) {
                                if (!externalRef.equals(extRefIds.get(extRefList.get(k)))) continue;
                                extRefId = (String)extRefList.get(k);
                                break;
                            }
                        }
                    } else {
                        extRefId = null;
                    }
                    cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription(), (String)extRefId);
                } else {
                    CVEntry[] entries;
                    cvElement = eafFactory.newControlledVocabulary(cv.getName(), cv.getDescription());
                    for (CVEntry entry : entries = cv.getEntries()) {
                        if (entry.getExternalRef() != null) {
                            if (!extRefIds.containsValue(entry.getExternalRef())) {
                                extRefId = "er" + extRefIndex++;
                                extRefIds.put(extRefId, entry.getExternalRef());
                                extRefList.add(extRefId);
                            } else {
                                for (int k = 0; k < extRefList.size(); ++k) {
                                    if (!entry.getExternalRef().equals(extRefIds.get(extRefList.get(k)))) continue;
                                    extRefId = (String)extRefList.get(k);
                                    break;
                                }
                            }
                        } else {
                            extRefId = null;
                        }
                        Element entryElement = eafFactory.newCVEntry(entry.getValue(), entry.getDescription(), (String)extRefId);
                        cvElement.appendChild(entryElement);
                    }
                }
                annotDocument.appendChild((Node)cvElement);
            }
        }
        HashMap<String, LexiconLink> savedLexiconLinks = new HashMap<String, LexiconLink>();
        for (Object lexRef : lexRefs.keySet()) {
            LexiconQueryBundle2 queryBundle = (LexiconQueryBundle2)lexRefs.get(lexRef);
            Element lexSrvcElement = eafFactory.newLexiconReference((String)lexRef, queryBundle);
            savedLexiconLinks.put(queryBundle.getLinkName(), queryBundle.getLink());
            annotDocument.appendChild(lexSrvcElement);
        }
        Map lexiconLinks = attisTr.getLexiconLinks();
        for (String linkName : ((HashMap)lexiconLinks).keySet()) {
            if (savedLexiconLinks.containsKey(linkName)) continue;
            Element lexSrvcElement = eafFactory.newLexiconLink("lr" + lexRefIndex++, (LexiconLink)((HashMap)lexiconLinks).get(linkName));
            annotDocument.appendChild(lexSrvcElement);
        }
        for (int i = 0; i < extRefList.size(); ++i) {
            String id = (String)extRefList.get(i);
            ExternalReferenceImpl eri = (ExternalReferenceImpl)extRefIds.get(id);
            if (id == null || eri == null) continue;
            Element erElement = eafFactory.newExternalReference(id, eri.getTypeString(), eri.getValue());
            annotDocument.appendChild(erElement);
        }
        return eafFactory.getDocumentElement();
    }

    private static String correctDate(String strIn) {
        Object strResult = new String(strIn);
        try {
            int indexSpace;
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            Object strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = (String)strOffset + "0";
            }
            if ((indexSpace = ((String)(strResult = (String)strResult + (String)(strOffset = (String)strOffset + offsetGMT + ":00"))).indexOf(" ")) != -1) {
                String strEnd = ((String)strResult).substring(indexSpace + 1);
                strResult = ((String)strResult).substring(0, indexSpace);
                strResult = (String)strResult + "T";
                strResult = (String)strResult + strEnd;
            }
            strResult = ((String)strResult).replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }

    private static void save(Element documentElement, String path) throws IOException {
        ServerLogger.LOG.info(path + " <----XML output\n");
        try {
            if (("" + documentElement).length() == 0) {
                throw new IOException("Unable to save this file (zero length).");
            }
            long beginTime = System.currentTimeMillis();
            IoUtil.writeEncodedEAFFile("UTF-8", path, documentElement);
            if (debug) {
                System.out.println("Saving file took: " + (System.currentTimeMillis() - beginTime) + " ms");
            }
        }
        catch (Exception eee) {
            throw new IOException("Unable to save this file: " + eee.getMessage());
        }
    }
}

