/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.RefLink;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.TimeOrder;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF28;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFBase;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.server.corpora.clomimpl.reflink.CrossRefLink;
import mpi.eudico.server.corpora.clomimpl.reflink.GroupRefLink;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSet;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.IoUtil;
import mpi.eudico.util.MutableInt;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;
import mpi.eudico.util.multilangcv.RecentLanguages;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EAF28Encoder
implements AnnotationDocEncoder {
    public String VERSION = "2.8";

    protected EAFBase getEAFFactory() {
        try {
            return new EAF28();
        }
        catch (Throwable t) {
            ServerLogger.LOG.warning("Could not create an EAF28 factory");
            return null;
        }
    }

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        Element documentElement = this.createDOM(theTranscription, tierOrder, path);
        this.save(documentElement, path);
    }

    public void encodeAsTemplateAndSave(Transcription theTranscription, List<TierImpl> tierOrder, String path) throws IOException {
        Element documentElement = this.createTemplateDOM(theTranscription, tierOrder, path);
        this.save(documentElement, path);
    }

    public Element createDOM(Transcription theTranscription, List<TierImpl> tierOrder, String path) {
        long beginTime = System.currentTimeMillis();
        if (ServerLogger.LOG.isLoggable(Level.FINE)) {
            ServerLogger.LOG.fine("Encoder start creating DOM");
        }
        HashMap<String, Element> tierElements = new HashMap();
        HashMap<TimeSlot, String> timeSlotIds = new HashMap();
        GetExtRefIdParams getExtRefIdParams = new GetExtRefIdParams();
        HashMap<String, LexiconQueryBundle2> lexRefs = new HashMap<String, LexiconQueryBundle2>();
        MutableInt lexRefIndexMut = new MutableInt(1);
        ArrayList<Locale> usedLocales = new ArrayList<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null && ServerLogger.LOG.isLoggable(Level.WARNING)) {
            ServerLogger.LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAFBase eafFactory = this.getEAFFactory();
        Element annotDocument = this.addAnnotationDocument(eafFactory, attisTr);
        this.addLicenses(eafFactory, annotDocument, attisTr);
        Element headerElement = this.addHeader(eafFactory, annotDocument);
        this.addMediaDescriptors(eafFactory, headerElement, attisTr);
        this.addLinkedFilesDescriptors(eafFactory, headerElement, attisTr);
        Property lastUsedAnnIdProp = this.addDocProperties(eafFactory, headerElement, attisTr);
        if (lastUsedAnnIdProp == null) {
            lastUsedAnnIdProp = new PropertyImpl("lastUsedAnnotationId", 0);
            attisTr.addDocProperty(lastUsedAnnIdProp);
        }
        if (ServerLogger.LOG.isLoggable(Level.FINE)) {
            ServerLogger.LOG.fine(String.format("Header creation took: %d ms", System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
        }
        timeSlotIds = this.addTimeOrderAndSlots(eafFactory, annotDocument, attisTr);
        if (ServerLogger.LOG.isLoggable(Level.FINE)) {
            ServerLogger.LOG.fine(String.format("TimeSlots creation took: %d ms", System.currentTimeMillis() - beginTime));
        }
        tierElements = this.addTiers(eafFactory, annotDocument, attisTr, usedLocales);
        this.addAnnotations(eafFactory, attisTr, tierElements, timeSlotIds, getExtRefIdParams);
        headerElement.appendChild(eafFactory.newProperty("lastUsedAnnotationId", lastUsedAnnIdProp.getValue().toString()));
        if (ServerLogger.LOG.isLoggable(Level.FINE)) {
            ServerLogger.LOG.fine(String.format("Tiers and Annotations creation took: %d ms", System.currentTimeMillis() - beginTime));
        }
        this.addTypes(eafFactory, annotDocument, attisTr, getExtRefIdParams, lexRefs, lexRefIndexMut);
        if (ServerLogger.LOG.isLoggable(Level.FINE)) {
            ServerLogger.LOG.fine(String.format("Linguistic Types creation took: %d ms", System.currentTimeMillis() - beginTime));
        }
        this.addLocales(eafFactory, annotDocument, usedLocales);
        List<ControlledVocabulary> conVocs = attisTr.getControlledVocabularies();
        this.addLanguages(new ArrayList<Tier>(attisTr.getTiers()), eafFactory, annotDocument, conVocs);
        this.addConstraints(eafFactory, annotDocument);
        this.addControlledVocabularies(eafFactory, annotDocument, conVocs, getExtRefIdParams);
        if (ServerLogger.LOG.isLoggable(Level.FINE)) {
            ServerLogger.LOG.fine(String.format("Constraints and CV's creation took: %d ms", System.currentTimeMillis() - beginTime));
        }
        this.addLexiconRefs(eafFactory, annotDocument, attisTr, lexRefs, lexRefIndexMut);
        this.addReferenceLinks(eafFactory, annotDocument, attisTr, getExtRefIdParams);
        this.addExternalRefs(eafFactory, annotDocument, attisTr, getExtRefIdParams);
        return eafFactory.getDocumentElement();
    }

    public Element createTemplateDOM(Transcription theTranscription, List<TierImpl> tierOrder, String path) {
        GetExtRefIdParams getExtRefIdParams = new GetExtRefIdParams();
        HashMap<String, LexiconQueryBundle2> lexRefs = new HashMap<String, LexiconQueryBundle2>();
        MutableInt lexRefIndexMut = new MutableInt(1);
        ArrayList<Locale> usedLocales = new ArrayList<Locale>();
        TranscriptionImpl attisTr = (TranscriptionImpl)theTranscription;
        if (attisTr == null && ServerLogger.LOG.isLoggable(Level.WARNING)) {
            ServerLogger.LOG.warning("[[ASSERTION FAILED]] TranscriptionStore/storeTranscription: theTranscription is null");
        }
        EAFBase eafFactory = this.getEAFFactory();
        Element annotDocument = this.addAnnotationDocument(eafFactory, attisTr);
        this.addLicenses(eafFactory, annotDocument, attisTr);
        this.addHeader(eafFactory, annotDocument);
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        this.addTiers(eafFactory, annotDocument, attisTr, usedLocales);
        this.addTypes(eafFactory, annotDocument, attisTr, getExtRefIdParams, lexRefs, lexRefIndexMut);
        this.addLocales(eafFactory, annotDocument, usedLocales);
        List<ControlledVocabulary> conVocs = attisTr.getControlledVocabularies();
        this.addLanguages(new ArrayList<Tier>(attisTr.getTiers()), eafFactory, annotDocument, conVocs);
        this.addConstraints(eafFactory, annotDocument);
        this.addControlledVocabularies(eafFactory, annotDocument, conVocs, getExtRefIdParams);
        this.addLexiconRefs(eafFactory, annotDocument, attisTr, lexRefs, lexRefIndexMut);
        this.addExternalRefs(eafFactory, annotDocument, attisTr, getExtRefIdParams);
        return eafFactory.getDocumentElement();
    }

    protected Element addAnnotationDocument(EAFBase eafFactory, Transcription transcription) {
        String dateString = this.getDate();
        String author = transcription.getAuthor();
        if (author == null) {
            author = "unspecified";
        }
        Element annotDocument = eafFactory.newAnnotationDocument(dateString, author, this.VERSION);
        eafFactory.appendChild(annotDocument);
        return annotDocument;
    }

    protected void addLicenses(EAFBase eafFactory, Element annotDocument, Transcription transcription) {
        if (!(eafFactory instanceof EAF28)) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning("Cannot add license information, EAF factory version too low");
            }
            return;
        }
        EAF28 eaf28Fact = (EAF28)eafFactory;
        List<LicenseRecord> licenses = transcription.getLicenses();
        if (licenses != null) {
            for (LicenseRecord lr : licenses) {
                Element license = eaf28Fact.newLicense(lr);
                annotDocument.appendChild(license);
            }
        }
    }

    protected Element addHeader(EAFBase eafFactory, Element annotDocument) {
        Element header = eafFactory.newHeader("");
        annotDocument.appendChild(header);
        return header;
    }

    protected void addMediaDescriptors(EAFBase eafFactory, Element headerElement, Transcription transcription) {
        for (MediaDescriptor md : transcription.getMediaDescriptors()) {
            String origin = null;
            if (md.timeOrigin != 0L) {
                origin = String.valueOf(md.timeOrigin);
            }
            String extrFrom = null;
            if (md.extractedFrom != null && md.extractedFrom != "") {
                extrFrom = md.extractedFrom;
            }
            Element mdElement = eafFactory.newMediaDescriptor(md.mediaURL, md.relativeMediaURL, md.mimeType, origin, extrFrom);
            headerElement.appendChild(mdElement);
        }
    }

    protected void addLinkedFilesDescriptors(EAFBase eafFactory, Element headerElement, Transcription transcription) {
        for (LinkedFileDescriptor lfd : transcription.getLinkedFileDescriptors()) {
            String origin = null;
            if (lfd.timeOrigin != 0L) {
                origin = String.valueOf(lfd.timeOrigin);
            }
            Element lfdElement = eafFactory.newLinkedFileDescriptor(lfd.linkURL, lfd.relativeLinkURL, lfd.mimeType, origin, lfd.associatedWith);
            headerElement.appendChild(lfdElement);
        }
    }

    protected Property addDocProperties(EAFBase eafFactory, Element headerElement, Transcription transcription) {
        Property lastUsedAnnIdProp = null;
        TranscriptionImpl transImpl = (TranscriptionImpl)transcription;
        List<Property> props = transImpl.getDocProperties();
        if (props.size() > 0) {
            for (Property prop : props) {
                Object value = prop.getValue();
                String name = prop.getName();
                if (name == null && value == null) continue;
                if ("lastUsedAnnotationId".equals(name)) {
                    if (value == null) continue;
                    try {
                        lastUsedAnnIdProp = prop;
                    }
                    catch (ClassCastException nfe) {
                        if (!ServerLogger.LOG.isLoggable(Level.INFO)) continue;
                        ServerLogger.LOG.info("Could not retrieve the last used annotation id: " + nfe.getMessage());
                    }
                    continue;
                }
                if (value != null) {
                    headerElement.appendChild(eafFactory.newProperty(name, value.toString()));
                    continue;
                }
                headerElement.appendChild(eafFactory.newProperty(name, null));
            }
        }
        return lastUsedAnnIdProp;
    }

    protected Map<TimeSlot, String> addTimeOrderAndSlots(EAFBase eafFactory, Element annotDocument, Transcription transcription) {
        HashMap<TimeSlot, String> timeSlotIds = new HashMap<TimeSlot, String>();
        TimeOrder timeOrder = transcription.getTimeOrder();
        timeOrder.pruneTimeSlots();
        Element timeOrderElement = eafFactory.newTimeOrder();
        annotDocument.appendChild(timeOrderElement);
        int index = 1;
        Iterator<TimeSlot> tsElements = timeOrder.iterator();
        while (tsElements.hasNext()) {
            TimeSlot ts = tsElements.next();
            Element tsElement = null;
            String tsId = "ts" + index;
            timeSlotIds.put(ts, tsId);
            tsElement = ts.getTime() != -1L ? eafFactory.newTimeSlot(tsId, ts.getTime()) : eafFactory.newTimeSlot(tsId);
            timeOrderElement.appendChild(tsElement);
            ++index;
        }
        return timeSlotIds;
    }

    protected Map<String, Element> addTiers(EAFBase eafFactory, Element annotDocument, Transcription transcription, List<Locale> usedLocales) {
        EAF28 eaf28Fact = (EAF28)eafFactory;
        HashMap<String, Element> tierElements = new HashMap<String, Element>();
        ArrayList<? extends Tier> storeOrder = new ArrayList<Tier>(transcription.getTiers());
        for (TierImpl tierImpl : storeOrder) {
            Locale lang;
            String id = tierImpl.getName();
            String participant = tierImpl.getParticipant();
            String annotator = tierImpl.getAnnotator();
            String lingType = tierImpl.getLinguisticType().getLinguisticTypeName();
            if (lingType == null) {
                lingType = "not specified";
            }
            if ((lang = tierImpl.getDefaultLocale()) != null && !usedLocales.contains(lang)) {
                usedLocales.add(lang);
            }
            String parentName = null;
            if (tierImpl.getParentTier() != null) {
                parentName = tierImpl.getParentTier().getName();
            }
            String extRef = tierImpl.getExtRef();
            String langRef = tierImpl.getLangRef();
            Element tierElement = eaf28Fact.newTier(id, participant, annotator, lingType, lang, parentName, extRef, langRef);
            annotDocument.appendChild(tierElement);
            tierElements.put(tierImpl.getName(), tierElement);
        }
        return tierElements;
    }

    protected void addAnnotations(EAFBase eafFactory, Transcription transcription, Map<String, Element> tierElements, Map<TimeSlot, String> timeSlotIds, GetExtRefIdParams getExtRefIdParams) {
        EAF28 eaf28Fact = (EAF28)eafFactory;
        ArrayList<? extends Tier> storeOrder = new ArrayList<Tier>(transcription.getTiers());
        for (TierImpl tierImpl : storeOrder) {
            for (Annotation annotation : tierImpl.getAnnotations()) {
                List<ExternalReference> extRefs;
                String unused = annotation.getId();
                Object extRefId = null;
                if (annotation instanceof AbstractAnnotation && (extRefs = ((AbstractAnnotation)annotation).getExtRefs()) != null) {
                    for (ExternalReference thisExtRef : extRefs) {
                        String tmpExtRefId = this.getExtRefId(getExtRefIdParams, thisExtRef);
                        if (extRefId != null && !((String)extRefId).isEmpty()) {
                            extRefId = (String)extRefId + " " + tmpExtRefId;
                            continue;
                        }
                        extRefId = tmpExtRefId;
                    }
                }
                Element annElement = eaf28Fact.newAnnotation();
                tierElements.get(tierImpl.getName()).appendChild(annElement);
                Node annSubElement = null;
                String annId = annotation.getId();
                if (annotation instanceof AlignableAnnotation) {
                    String beginTsId = timeSlotIds.get(((AlignableAnnotation)annotation).getBegin());
                    String endTsId = timeSlotIds.get(((AlignableAnnotation)annotation).getEnd());
                    if (beginTsId == null && ServerLogger.LOG.isLoggable(Level.WARNING)) {
                        ServerLogger.LOG.warning(String.format("The alignable annotation with id \"%s\" has no reference to a begin time slot.", annotation.getId()));
                    }
                    if (endTsId == null && ServerLogger.LOG.isLoggable(Level.WARNING)) {
                        ServerLogger.LOG.warning(String.format("The alignable annotation with id \"%s\" has no reference to an end time slot.", annotation.getId()));
                    }
                    annSubElement = eaf28Fact.newAlignableAnnotation(annId, beginTsId, endTsId, (String)extRefId, annotation.getCVEntryId());
                } else if (annotation instanceof RefAnnotation) {
                    String refId = null;
                    String prevId = null;
                    List<Annotation> refs = ((RefAnnotation)annotation).getReferences();
                    RefAnnotation prev = ((RefAnnotation)annotation).getPrevious();
                    if (refs.size() > 0) {
                        refId = refs.get(0).getId();
                    }
                    if (prev != null) {
                        prevId = prev.getId();
                    }
                    annSubElement = eaf28Fact.newRefAnnotation(annId, refId, prevId, (String)extRefId, annotation.getCVEntryId());
                }
                annElement.appendChild(annSubElement);
                Element valueElement = eaf28Fact.newAnnotationValue(annotation.getValue());
                annSubElement.appendChild(valueElement);
            }
        }
    }

    protected void addTypes(EAFBase eafFactory, Element annotDocument, Transcription transcription, GetExtRefIdParams getExtRefIdParams, Map<String, LexiconQueryBundle2> lexRefs, MutableInt lexRefIndexMut) {
        EAF28 eaf28Fact = (EAF28)eafFactory;
        List<LinguisticType> lTypes = transcription.getLinguisticTypes();
        if (lTypes != null) {
            for (LinguisticType lt : lTypes) {
                String extRefId = null;
                if (lt.getDataCategory() != null && lt.getDataCategory().length() > 0) {
                    ExternalReferenceImpl eri = new ExternalReferenceImpl(lt.getDataCategory(), 2);
                    extRefId = this.getExtRefId(getExtRefIdParams, eri);
                }
                String stereotype = null;
                if (lt.hasConstraints()) {
                    stereotype = Constraint.stereoTypes[lt.getConstraints().getStereoType()];
                    stereotype = stereotype.replace(' ', '_');
                }
                String lexRef = null;
                LexiconQueryBundle2 queryBundle = lt.getLexiconQueryBundle();
                if (queryBundle != null) {
                    lexRef = "lr" + lexRefIndexMut.intValue++;
                    lexRefs.put(lexRef, queryBundle);
                }
                Element typeElement = eaf28Fact.newLinguisticType(lt.getLinguisticTypeName(), lt.isTimeAlignable(), stereotype, lt.getControlledVocabularyName(), extRefId, lexRef);
                annotDocument.appendChild(typeElement);
            }
        }
    }

    protected void addLocales(EAFBase eafFactory, Element annotDocument, List<Locale> usedLocales) {
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
    }

    protected void addLanguages(List<Tier> storeOrder, EAFBase eafFactory, Element annotDocument, List<ControlledVocabulary> conVocs) {
        if (!(eafFactory instanceof EAF28)) {
            return;
        }
        EAF28 eaf28Fact = (EAF28)eafFactory;
        HashMap<String, LanguageRecord> defToLang = new HashMap<String, LanguageRecord>();
        HashMap<String, LanguageRecord> idToLang = new HashMap<String, LanguageRecord>();
        for (ControlledVocabulary cv : conVocs) {
            int nLangs = cv.getNumberOfLanguages();
            for (int i = 0; i < nLangs; ++i) {
                String id = cv.getLanguageId(i);
                String def = cv.getLongLanguageId(i);
                String label = cv.getLanguageLabel(i);
                LanguageRecord lr = new LanguageRecord(id, def, label);
                defToLang.put(def, lr);
                idToLang.put(id, lr);
            }
        }
        for (Tier tier : storeOrder) {
            LangInfo li;
            String id = tier.getLangRef();
            if (id == null || id.isEmpty()) continue;
            LanguageRecord lr = (LanguageRecord)idToLang.get(id);
            if (lr == null) {
                lr = (LanguageRecord)defToLang.get(id);
            }
            if (lr == null && (li = RecentLanguages.getInstance().getLanguageInfo(id)) != null) {
                lr = new LanguageRecord(li.getId(), li.getLongId(), li.getLabel());
            }
            if (lr == null && (li = LanguageCollection.getLanguageInfo(id)) != null) {
                lr = new LanguageRecord(li.getId(), li.getLongId(), li.getLabel());
            }
            if (lr == null) continue;
            defToLang.put(lr.getDef(), lr);
            idToLang.put(lr.getId(), lr);
        }
        for (LanguageRecord lr : defToLang.values()) {
            Element languageElement = eaf28Fact.newLanguage(lr.getId(), lr.getDef(), lr.getLabel());
            annotDocument.appendChild(languageElement);
        }
    }

    protected void addConstraints(EAFBase eafFactory, Element annotDocument) {
        Element timeSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[0].replace(' ', '_'), "Time subdivision of parent annotation's time interval, no time gaps allowed within this interval");
        Element symbSubdivision = eafFactory.newConstraint(Constraint.stereoTypes[3].replace(' ', '_'), "Symbolic subdivision of a parent annotation. Annotations refering to the same parent are ordered");
        Element symbAssociation = eafFactory.newConstraint(Constraint.stereoTypes[4].replace(' ', '_'), "1-1 association with a parent annotation");
        Element includedIn = eafFactory.newConstraint(Constraint.stereoTypes[1].replace(' ', '_'), "Time alignable annotations within the parent annotation's time interval, gaps are allowed");
        annotDocument.appendChild(timeSubdivision);
        annotDocument.appendChild(symbSubdivision);
        annotDocument.appendChild(symbAssociation);
        annotDocument.appendChild(includedIn);
    }

    protected void addControlledVocabularies(EAFBase eafFactory, Element annotDocument, List<ControlledVocabulary> conVocs, GetExtRefIdParams getExtRefIdParams) {
        if (!(eafFactory instanceof EAF28)) {
            return;
        }
        EAF28 eaf28Fact = (EAF28)eafFactory;
        for (ControlledVocabulary cv : conVocs) {
            Element cvElement;
            if (cv instanceof ExternalCV) {
                String extRefId = null;
                ExternalReference externalRef = ((ExternalCV)cv).getExternalRef();
                extRefId = this.getExtRefId(getExtRefIdParams, externalRef);
                cvElement = eaf28Fact.newControlledVocabulary(cv.getName(), null, extRefId);
            } else {
                cvElement = eafFactory.newControlledVocabulary(cv.getName(), null);
                int nLangs = cv.getNumberOfLanguages();
                for (int i = 0; i < nLangs; ++i) {
                    String languageId = cv.getLanguageId(i);
                    String description = cv.getDescription(i);
                    Element descriptionElement = eaf28Fact.newDescription(languageId, description);
                    cvElement.appendChild(descriptionElement);
                }
                for (CVEntry entry : cv) {
                    String extRefId = null;
                    ExternalReference externalRef = entry.getExternalRef();
                    extRefId = this.getExtRefId(getExtRefIdParams, externalRef);
                    Element entryElement = eaf28Fact.newCVEntryML(entry.getId(), extRefId);
                    for (int i = 0; i < nLangs; ++i) {
                        String languageId = cv.getLanguageId(i);
                        String description = entry.getDescription(i);
                        String value = entry.getValue(i);
                        if (value.isEmpty() && (description == null || description.isEmpty())) continue;
                        Element valueElement = eaf28Fact.newCVEntryValue(languageId, value, description);
                        entryElement.appendChild(valueElement);
                    }
                    if (!entryElement.hasChildNodes()) {
                        String languageId = cv.getLanguageId(0);
                        Element valueElement = eaf28Fact.newCVEntryValue(languageId, "", "");
                        entryElement.appendChild(valueElement);
                    }
                    cvElement.appendChild(entryElement);
                }
            }
            annotDocument.appendChild(cvElement);
        }
    }

    protected void addLexiconRefs(EAFBase eafFactory, Element annotDocument, Transcription transcription, Map<String, LexiconQueryBundle2> lexRefs, MutableInt lexRefIndexMut) {
        Element lexSrvcElement;
        EAF28 eaf28Fact = (EAF28)eafFactory;
        HashMap<String, LexiconLink> savedLexiconLinks = new HashMap<String, LexiconLink>();
        for (String lexRef : lexRefs.keySet()) {
            LexiconQueryBundle2 queryBundle = lexRefs.get(lexRef);
            lexSrvcElement = eaf28Fact.newLexiconReference(lexRef, queryBundle);
            savedLexiconLinks.put(queryBundle.getLinkName(), queryBundle.getLink());
            annotDocument.appendChild(lexSrvcElement);
        }
        Map<String, LexiconLink> lexiconLinks = transcription.getLexiconLinks();
        for (String linkName : lexiconLinks.keySet()) {
            if (savedLexiconLinks.containsKey(linkName)) continue;
            lexSrvcElement = eaf28Fact.newLexiconLink("lr" + lexRefIndexMut.intValue++, lexiconLinks.get(linkName));
            annotDocument.appendChild(lexSrvcElement);
        }
    }

    protected void addReferenceLinks(EAFBase eafFactory, Element annotDocument, Transcription transcription, GetExtRefIdParams getExtRefIdParams) {
        EAF28 eaf28Fact = (EAF28)eafFactory;
        List<RefLinkSet> rlSetList = ((TranscriptionImpl)transcription).getRefLinkSets();
        RefLinkSet rlset = null;
        if (rlSetList != null && !rlSetList.isEmpty()) {
            rlset = rlSetList.get(0);
        }
        if (rlset != null) {
            String extRefId = this.getExtRefId(getExtRefIdParams, rlset.getExtRef());
            Element rlsElement = eaf28Fact.newRefLinkSet(rlset.getLinksID(), extRefId, rlset.getLangRef(), rlset.getCvRef());
            annotDocument.appendChild(rlsElement);
            for (RefLink rl : rlset.getRefs()) {
                Element rlElement = null;
                extRefId = this.getExtRefId(getExtRefIdParams, rl.getExtRef());
                if (rl instanceof CrossRefLink) {
                    CrossRefLink crl = (CrossRefLink)rl;
                    rlElement = eaf28Fact.newCrossRefLink(rl.getId(), extRefId, rl.getLangRef(), rl.getCveRef(), rl.getRefType(), rl.getContent(), crl.getRef1(), crl.getRef2(), crl.getDirectionality());
                } else if (rl instanceof GroupRefLink) {
                    GroupRefLink grl = (GroupRefLink)rl;
                    rlElement = eaf28Fact.newGroupRefLink(rl.getId(), extRefId, rl.getLangRef(), rl.getCveRef(), rl.getRefType(), rl.getContent(), grl.getRefs());
                }
                rlsElement.appendChild(rlElement);
            }
        }
    }

    protected void addExternalRefs(EAFBase eafFactory, Element annotDocument, Transcription transcription, GetExtRefIdParams getExtRefIdParams) {
        EAF28 eaf28Fact = (EAF28)eafFactory;
        for (Map.Entry<ExternalReference, String> entry : getExtRefIdParams.map.entrySet()) {
            ExternalReference er = entry.getKey();
            String id = entry.getValue();
            if (id == null || er == null) continue;
            Element erElement = eaf28Fact.newExternalReference(id, er.getTypeString(), er.getValue());
            annotDocument.appendChild(erElement);
        }
    }

    protected String getExtRefId(GetExtRefIdParams params, ExternalReference extRef) {
        if (extRef == null || params == null) {
            return null;
        }
        Object id = params.map.get(extRef);
        if (id == null) {
            id = "er" + params.extRefIndex++;
            params.map.put(extRef, (String)id);
        }
        return id;
    }

    protected String getDate() {
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        String dateString = dateFmt.format(calendar.getTime());
        return this.addTimezone(calendar, dateString);
    }

    protected String addTimezone(Calendar calendar, String dateString) {
        int GMTOffsetInMinutes = calendar.getTimeZone().getRawOffset() / 60000;
        char sign = '+';
        if (GMTOffsetInMinutes < 0) {
            sign = '-';
            GMTOffsetInMinutes = -GMTOffsetInMinutes;
        }
        int hours = GMTOffsetInMinutes / 60;
        int minutes = GMTOffsetInMinutes % 60;
        String strOffset = String.format("%02d:%02d", hours, minutes);
        return dateString + sign + strOffset;
    }

    protected void save(Element documentElement, String path) throws IOException {
        if (ServerLogger.LOG.isLoggable(Level.INFO)) {
            ServerLogger.LOG.info(path + " <----XML output\n");
        }
        try {
            if (("" + documentElement).length() == 0) {
                throw new IOException("Unable to save this file (zero length).");
            }
            long beginTime = System.currentTimeMillis();
            IoUtil.writeEncodedEAFFile("UTF-8", path, documentElement);
            if (ServerLogger.LOG.isLoggable(Level.FINE)) {
                ServerLogger.LOG.fine(String.format("Saving file took: %d ms", System.currentTimeMillis() - beginTime));
            }
        }
        catch (Exception eee) {
            throw new IOException("Unable to save this file: " + eee.getMessage());
        }
    }

    protected class GetExtRefIdParams {
        private int extRefIndex = 1;
        Map<ExternalReference, String> map = new HashMap<ExternalReference, String>();

        GetExtRefIdParams() {
        }
    }
}

