/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.RefLink;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF28Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.EAF30;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFBase;
import mpi.eudico.server.corpora.clomimpl.reflink.CrossRefLink;
import mpi.eudico.server.corpora.clomimpl.reflink.GroupRefLink;
import mpi.eudico.server.corpora.clomimpl.reflink.RefLinkSet;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;

public class EAF30Encoder
extends EAF28Encoder {
    public EAF30Encoder() {
        this.VERSION = "3.0";
    }

    @Override
    protected EAFBase getEAFFactory() {
        try {
            return new EAF30();
        }
        catch (Throwable t) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning(String.format("Could not create an EAF30 factory: %s", t.getMessage()));
            }
            return null;
        }
    }

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        super.encodeAndSave(theTranscription, encoderInfo, tierOrder, path);
    }

    @Override
    public void encodeAsTemplateAndSave(Transcription theTranscription, List<TierImpl> tierOrder, String path) throws IOException {
        super.encodeAsTemplateAndSave(theTranscription, tierOrder, path);
    }

    @Override
    protected void save(Element documentElement, String path) throws IOException {
        if (ServerLogger.LOG.isLoggable(Level.INFO)) {
            ServerLogger.LOG.info(String.format("%s <---- XML output - EAF version: %s\n", path, this.VERSION));
        }
        try {
            if (documentElement == null || !documentElement.hasChildNodes()) {
                throw new IOException("Unable to save this file (no content).");
            }
            if (path == null || path.isEmpty()) {
                throw new IOException("Unable to save this file (zero length).");
            }
            long beginTime = System.currentTimeMillis();
            IoUtil.writeEncodedEAFFile("UTF-8", path, documentElement);
            if (ServerLogger.LOG.isLoggable(Level.FINE)) {
                ServerLogger.LOG.fine(String.format("Saving file took: %d ms", System.currentTimeMillis() - beginTime));
            }
        }
        catch (Exception eee) {
            throw new IOException("Unable to save this file: " + eee.getMessage());
        }
    }

    @Override
    protected void addLocales(EAFBase eafFactory, Element annotDocument, List<Locale> usedLocales) {
        for (int i = 0; i < usedLocales.size(); ++i) {
            Locale first = usedLocales.get(i);
            for (int j = usedLocales.size() - 1; j > i; --j) {
                String useCountry;
                Locale second = usedLocales.get(j);
                if (!first.getLanguage().equals(second.getLanguage())) continue;
                String variant2 = second.getVariant();
                String country2 = second.getCountry();
                String useVariant = first.getVariant();
                if ((useVariant == null || useVariant.isEmpty()) && variant2 != null && !variant2.isEmpty()) {
                    useVariant = variant2;
                }
                if (((useCountry = first.getCountry()) == null || useCountry.isEmpty()) && country2 != null && country2.isEmpty()) {
                    useCountry = country2;
                }
                Locale replaceLocale = new Locale(first.getLanguage(), useCountry, useVariant);
                usedLocales.set(i, replaceLocale);
                usedLocales.remove(j);
            }
        }
        for (Locale l : usedLocales) {
            Element locElement = eafFactory.newLocale(l);
            annotDocument.appendChild(locElement);
        }
    }

    @Override
    protected void addReferenceLinks(EAFBase eafFactory, Element annotDocument, Transcription transcription, EAF28Encoder.GetExtRefIdParams getExtRefIdParams) {
        EAF30 eaf30Fact = (EAF30)eafFactory;
        List<RefLinkSet> rlSetList = transcription.getRefLinkSets();
        if (rlSetList != null) {
            for (RefLinkSet rlset : rlSetList) {
                String extRefId = this.getExtRefId(getExtRefIdParams, rlset.getExtRef());
                Element rlsElement = eaf30Fact.newRefLinkSet(rlset.getLinksID(), rlset.getLinksName(), extRefId, rlset.getLangRef(), rlset.getCvRef());
                annotDocument.appendChild(rlsElement);
                for (RefLink rl : rlset.getRefs()) {
                    Element rlElement = null;
                    extRefId = this.getExtRefId(getExtRefIdParams, rl.getExtRef());
                    if (rl instanceof CrossRefLink) {
                        CrossRefLink crl = (CrossRefLink)rl;
                        rlElement = eaf30Fact.newCrossRefLink(rl.getId(), rl.getRefName(), extRefId, rl.getLangRef(), rl.getCveRef(), rl.getRefType(), rl.getContent(), crl.getRef1(), crl.getRef2(), crl.getDirectionality());
                    } else if (rl instanceof GroupRefLink) {
                        GroupRefLink grl = (GroupRefLink)rl;
                        rlElement = eaf30Fact.newGroupRefLink(rl.getId(), rl.getRefName(), extRefId, rl.getLangRef(), rl.getCveRef(), rl.getRefType(), rl.getContent(), grl.getRefs());
                    }
                    rlsElement.appendChild(rlElement);
                }
            }
        }
    }
}

