/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV02;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Element;

public class ECV02Encoder {
    public static final String VERSION = "0.2";

    public void encodeAndSave(ExternalCV cv, String path, String extRefId) throws IOException {
        Element documentElement = this.createDOM(cv);
        ExternalReference extRef = cv.getExternalRef();
        if (extRef != null) {
            this.save(documentElement, path, extRef.getValue());
        }
    }

    public void encodeAndSave(List<ExternalCV> cvs, String path, ExternalReference extRef) throws IOException {
        Element documentElement = this.createDOM(cvs);
        this.save(documentElement, path, extRef.getValue());
    }

    public void encodeAndSave(List<ExternalCV> cvs, String path) throws IOException {
        Element documentElement = this.createDOM(cvs);
        this.save(documentElement, path);
    }

    private void save(Element documentElement, String path) throws IOException {
        try {
            if (("" + documentElement).length() == 0) {
                throw new IOException("Unable to save this file (zero length).");
            }
            IoUtil.writeEncodedFile("UTF-8", path, documentElement);
        }
        catch (Exception eee) {
            ServerLogger.LOG.severe("Could not save the cache file: " + eee.getMessage());
        }
    }

    private void save(Element documentElement, String cachePath, String urlString) throws IOException {
        Object savePath = cachePath;
        String fileName = "";
        try {
            URL url = new URL(urlString);
            String urlHost = url.getHost();
            if (urlHost.equals("")) {
                urlHost = "localfile_system";
            }
            savePath = (String)savePath + File.separator + urlHost;
            String[] pathElements = url.getPath().substring(1).split("/");
            for (int i = 0; i < pathElements.length - 1; ++i) {
                savePath = (String)savePath + File.separator + pathElements[i];
            }
            fileName = pathElements[pathElements.length - 1];
        }
        catch (MalformedURLException e) {
            ServerLogger.LOG.warning("Could not create a cache directory structure: " + e.getMessage());
            int index = urlString.lastIndexOf(File.separator);
            fileName = index > -1 && index < urlString.length() - 2 ? urlString.substring(index + 1) : ((index = urlString.lastIndexOf("/")) > -1 && index < urlString.length() - 2 ? urlString.substring(index + 1) : urlString);
        }
        File dir = new File((String)savePath);
        if (dir.exists() || dir.mkdirs()) {
            savePath = (String)savePath + File.separator + fileName;
            try {
                if (("" + documentElement).length() == 0) {
                    throw new IOException("Unable to save this file (zero length).");
                }
                IoUtil.writeEncodedFile("UTF-8", (String)savePath, documentElement);
            }
            catch (Exception eee) {
                ServerLogger.LOG.severe("Could not save the cache file: " + eee.getMessage());
            }
        }
    }

    private Element createDOM(ExternalCV cv) {
        ArrayList<ExternalCV> list = new ArrayList<ExternalCV>(1);
        list.add(cv);
        return this.createDOM(list);
    }

    private Element createDOM(List<ExternalCV> cvs) {
        ECV02 ecvFactory = null;
        try {
            ecvFactory = new ECV02();
        }
        catch (Exception ex) {
            ServerLogger.LOG.severe("Could not create a document builder: " + ex.getMessage());
        }
        GetExtRefIdParams getExtRefIdParams = new GetExtRefIdParams();
        SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        String dateString = dateFmt.format(Calendar.getInstance().getTime());
        dateString = ECV02Encoder.correctDate(dateString);
        Element ecvDocument = ecvFactory.newExternalCVDocument(dateString, "", VERSION);
        ecvFactory.appendChild(ecvDocument);
        if (cvs != null) {
            HashMap<String, LanguageRecord> langs = new HashMap<String, LanguageRecord>();
            for (ControlledVocabulary controlledVocabulary : cvs) {
                int nLangs = controlledVocabulary.getNumberOfLanguages();
                for (int i = 0; i < nLangs; ++i) {
                    String id = controlledVocabulary.getLanguageId(i);
                    String def = controlledVocabulary.getLongLanguageId(i);
                    String label = controlledVocabulary.getLanguageLabel(i);
                    langs.put(def, new LanguageRecord(id, def, label));
                }
            }
            for (String string : langs.keySet()) {
                LanguageRecord lr = (LanguageRecord)langs.get(string);
                Element languageElement = ecvFactory.newLanguage(lr.getId(), lr.getDef(), lr.getLabel());
                ecvDocument.appendChild(languageElement);
            }
            for (ExternalCV externalCV : cvs) {
                Element cvElement = ecvFactory.newControlledVocabulary(externalCV.getName());
                int nLangs = externalCV.getNumberOfLanguages();
                for (int i = 0; i < nLangs; ++i) {
                    Element descriptionElement = ecvFactory.newDescription(externalCV.getLanguageId(i), externalCV.getDescription(i));
                    cvElement.appendChild(descriptionElement);
                }
                String extRefId = null;
                for (CVEntry entry : externalCV) {
                    extRefId = ECV02Encoder.getExtRefId(getExtRefIdParams, entry.getExternalRef());
                    Element entryElement = ecvFactory.newCVEntryML(entry.getId(), extRefId);
                    for (int i = 0; i < nLangs; ++i) {
                        String languageId = externalCV.getLanguageId(i);
                        String description = entry.getDescription(i);
                        String value = entry.getValue(i);
                        if (value.isEmpty()) continue;
                        Element valueElement = ecvFactory.newCVEntryValue(languageId, value, description);
                        entryElement.appendChild(valueElement);
                    }
                    cvElement.appendChild(entryElement);
                }
                ecvDocument.appendChild(cvElement);
            }
        }
        for (Map.Entry<ExternalReference, String> pair : getExtRefIdParams.map.entrySet()) {
            ExternalReference externalReference = pair.getKey();
            String id = pair.getValue();
            if (id == null || externalReference == null) continue;
            Element erElement = ecvFactory.newExternalReference(id, externalReference.getTypeString(), externalReference.getValue());
            ecvDocument.appendChild(erElement);
        }
        return ecvFactory.getDocumentElement();
    }

    private static String getExtRefId(GetExtRefIdParams params, ExternalReference extRef) {
        if (extRef == null || params == null) {
            return null;
        }
        Object id = params.map.get(extRef);
        if (id == null) {
            id = "er" + params.extRefIndex++;
            params.map.put(extRef, (String)id);
        }
        return id;
    }

    private static String correctDate(String strIn) {
        Object strResult = new String(strIn);
        try {
            int indexSpace;
            int offsetGMT = Calendar.getInstance().getTimeZone().getRawOffset() / 3600000;
            Object strOffset = "+";
            if (offsetGMT < 0) {
                strOffset = "-";
            }
            if ((offsetGMT = Math.abs(offsetGMT)) < 10) {
                strOffset = (String)strOffset + "0";
            }
            if ((indexSpace = ((String)(strResult = (String)strResult + (String)(strOffset = (String)strOffset + offsetGMT + ":00"))).indexOf(" ")) != -1) {
                String strEnd = ((String)strResult).substring(indexSpace + 1);
                strResult = ((String)strResult).substring(0, indexSpace);
                strResult = (String)strResult + "T";
                strResult = (String)strResult + strEnd;
            }
            strResult = ((String)strResult).replace('.', '-');
        }
        catch (Exception ex) {
            return strIn;
        }
        return strResult;
    }

    private static class GetExtRefIdParams {
        private int extRefIndex = 1;
        Map<ExternalReference, String> map = new HashMap<ExternalReference, String>();

        GetExtRefIdParams() {
        }
    }
}

