/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.dobes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ECV02Parser {
    private SAXParser parser;
    private boolean strict;
    private String url;
    private List<ExternalCV> cvList;
    private List<ExternalCV> unexpectedCvList;
    private final Map<String, ExternalReference> extReferences = new HashMap<String, ExternalReference>();
    private final Map<CVEntry, String> cvEntryExtRef = new HashMap<CVEntry, String>();
    private String currentCVId;
    private ControlledVocabulary currentCV;
    private String currentEntryDesc;
    private String currentEntryExtRef;
    private String content = "";
    public String currentEntryId;

    public ECV02Parser(String url) throws ParseException {
        this(url, false);
    }

    public ECV02Parser(String url, boolean strict) throws ParseException {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.strict = strict;
        try {
            boolean validate = Boolean.parseBoolean(System.getProperty("ELAN.EAF.Validate", "true"));
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            if (validate) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema eafSchema = schemaFactory.newSchema(this.getClass().getResource(ACMTranscriptionStore.getCurrentEAFSchemaLocal()));
                parserFactory.setSchema(eafSchema);
            } else {
                parserFactory.setValidating(false);
            }
            this.parser = parserFactory.newSAXParser();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (Throwable thr) {
            thr.printStackTrace();
        }
    }

    public void parse(List<ExternalCV> ecvList) throws ParseException {
        if (ecvList != null) {
            this.cvList = ecvList;
            this.unexpectedCvList = null;
        } else {
            this.cvList = new ArrayList<ExternalCV>();
            this.unexpectedCvList = this.cvList;
        }
        try {
            InputSource is = ACMTranscriptionStore.toInputSource(this.url);
            ECV02Handler ecvHandler = new ECV02Handler();
            this.parser.parse(is, (DefaultHandler)ecvHandler);
            this.createObjects();
        }
        catch (IOException ioe) {
            System.out.println("IO error: " + ioe.getMessage());
            throw new ParseException("IO error: " + ioe.getMessage(), ioe.getCause());
        }
        catch (SAXException saex) {
            System.out.println("Parsing error: " + saex.getMessage());
            throw new ParseException("Parsing error: " + saex.getMessage(), saex.getCause());
        }
    }

    private ExternalCV findOrCreate(String name) {
        for (int j = 0; j < this.cvList.size(); ++j) {
            ExternalCV cvFromList = this.cvList.get(j);
            if (!name.equals(cvFromList.getName())) continue;
            return cvFromList;
        }
        if (this.unexpectedCvList == null) {
            this.unexpectedCvList = new ArrayList<ExternalCV>();
        }
        ExternalCV ecv = new ExternalCV(name);
        this.unexpectedCvList.add(ecv);
        return ecv;
    }

    private void createObjects() {
        if (this.cvEntryExtRef.size() > 0) {
            for (Map.Entry<CVEntry, String> mapentry : this.cvEntryExtRef.entrySet()) {
                CVEntry entry = mapentry.getKey();
                String erId = mapentry.getValue();
                ExternalReferenceImpl eri = (ExternalReferenceImpl)this.extReferences.get(erId);
                if (eri == null) continue;
                try {
                    entry.setExternalRef(eri.clone());
                }
                catch (CloneNotSupportedException cnse) {
                    System.out.println("Could not set the external reference: " + cnse.getMessage());
                }
            }
        }
    }

    public List<ControlledVocabulary> getControlledVocabularies() {
        return Collections.unmodifiableList(this.cvList);
    }

    public List<ControlledVocabulary> getExtraControlledVocabularies() {
        return Collections.unmodifiableList(this.unexpectedCvList);
    }

    public Map<String, ExternalReference> getExternalReferences() {
        return this.extReferences;
    }

    public class ECV02Handler
    extends DefaultHandler {
        private ExternalCVEntry currentEntry;
        private boolean controlledVocabularyIsMultiLanguage;
        private String currentEntryLangRef;
        private List<LanguageRecord> languages = new ArrayList<LanguageRecord>();

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            ECV02Parser.this.content = ECV02Parser.this.content + new String(ch, start, end);
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            int index;
            if (name.equals("CV_ENTRY")) {
                if (!this.controlledVocabularyIsMultiLanguage) {
                    ExternalCVEntry entry = new ExternalCVEntry((BasicControlledVocabulary)ECV02Parser.this.currentCV, ECV02Parser.this.content, ECV02Parser.this.currentEntryDesc, ECV02Parser.this.currentEntryId);
                    ECV02Parser.this.currentCV.addEntry(entry);
                    if (ECV02Parser.this.currentEntryExtRef != null) {
                        ECV02Parser.this.cvEntryExtRef.put(entry, ECV02Parser.this.currentEntryExtRef);
                    }
                }
            } else if (name.equals("DESCRIPTION")) {
                if (ECV02Parser.this.content.length() > 0) {
                    int index2 = ECV02Parser.this.currentCV.getNumberOfLanguages() - 1;
                    ECV02Parser.this.currentCV.setDescription(index2, ECV02Parser.this.content);
                }
            } else if (name.equals("CVE_VALUE") && (index = ECV02Parser.this.currentCV.getIndexOfLanguage(this.currentEntryLangRef)) >= 0) {
                this.currentEntry.setDescription(index, ECV02Parser.this.currentEntryDesc);
                this.currentEntry.setValue(index, ECV02Parser.this.content);
            }
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            ECV02Parser.this.content = "";
            if (!name.equals("CV_RESOURCE")) {
                if (name.equals("LANGUAGE")) {
                    String id = attributes.getValue("LANG_ID");
                    String def = attributes.getValue("LANG_DEF");
                    String label = attributes.getValue("LANG_LABEL");
                    if (id != null && def != null) {
                        this.languages.add(new LanguageRecord(id, def, label));
                    }
                } else if (name.equals("CONTROLLED_VOCABULARY")) {
                    ExternalReference eri;
                    ECV02Parser.this.currentCVId = attributes.getValue("CV_ID");
                    ECV02Parser.this.currentCV = ECV02Parser.this.findOrCreate(ECV02Parser.this.currentCVId);
                    this.controlledVocabularyIsMultiLanguage = false;
                    String desc = attributes.getValue("DESCRIPTION");
                    if (desc != null) {
                        ECV02Parser.this.currentCV.setDescription(desc);
                    }
                    this.controlledVocabularyIsMultiLanguage = false;
                    String extRefId = attributes.getValue("EXT_REF");
                    if (extRefId != null && (eri = (ExternalReference)ECV02Parser.this.extReferences.get(extRefId)) != null) {
                        try {
                            ((ExternalCV)ECV02Parser.this.currentCV).setExternalRef(eri.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                } else if (name.equals("DESCRIPTION")) {
                    this.controlledVocabularyIsMultiLanguage = true;
                    String shortId = attributes.getValue("LANG_REF");
                    if (shortId != null) {
                        for (LanguageRecord lr : this.languages) {
                            if (!shortId.equals(lr.getId())) continue;
                            String longId = lr.getDef();
                            String label = lr.getLabel();
                            int index = ECV02Parser.this.currentCV.addLanguage(shortId, longId, label);
                            break;
                        }
                    }
                } else if (name.equals("CV_ENTRY")) {
                    ECV02Parser.this.currentEntryDesc = attributes.getValue("DESCRIPTION");
                    ECV02Parser.this.currentEntryExtRef = attributes.getValue("EXT_REF");
                    ECV02Parser.this.currentEntryId = attributes.getValue("CVE_ID");
                } else if (name.equals("CV_ENTRY_ML")) {
                    assert (this.controlledVocabularyIsMultiLanguage);
                    this.currentEntry = new ExternalCVEntry(ECV02Parser.this.currentCV);
                    String cveID = attributes.getValue("CVE_ID");
                    String extRefID = attributes.getValue("EXT_REF");
                    this.currentEntry.setId(cveID);
                    ECV02Parser.this.currentCV.addEntry(this.currentEntry);
                    if (extRefID != null && !extRefID.isEmpty()) {
                        ECV02Parser.this.cvEntryExtRef.put(this.currentEntry, extRefID);
                    }
                } else if (name.equals("CVE_VALUE")) {
                    assert (this.controlledVocabularyIsMultiLanguage);
                    ECV02Parser.this.currentEntryDesc = attributes.getValue("DESCRIPTION");
                    this.currentEntryLangRef = attributes.getValue("LANG_REF");
                } else if (name.equals("EXTERNAL_REF")) {
                    String value = attributes.getValue("VALUE");
                    String type = attributes.getValue("TYPE");
                    String refId = attributes.getValue("EXT_REF_ID");
                    if (value != null) {
                        ExternalReferenceImpl eri = new ExternalReferenceImpl(value, type);
                        ECV02Parser.this.extReferences.put(refId, eri);
                    }
                }
            }
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (ECV02Parser.this.strict) {
                System.out.println("Error:     " + exception.getMessage());
                System.out.println("System id: " + exception.getSystemId());
                System.out.println("Public id: " + exception.getPublicId());
                System.out.println("Line:      " + exception.getLineNumber());
                System.out.println("Column:    " + exception.getColumnNumber());
                throw exception;
            }
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            if (ECV02Parser.this.strict) {
                System.out.println("FatalError: " + exception.getMessage());
                throw exception;
            }
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (ECV02Parser.this.strict) {
                System.out.println("Warning: " + exception.getMessage());
            }
        }
    }
}

