/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.html.TAIEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.html.TAITierSetting;
import mpi.eudico.util.TimeFormatter;

public class HTMLRendererTimeAlignedInterlinear
implements AnnotationDocEncoder {
    private final String NEW_LINE = "\n";
    private int LARGE_BLOCK_TOLERANCE;
    private int SMALL_BLOCK_TOLERANCE;
    private int blockSpace;
    private boolean selectionOnly;
    private TranscriptionImpl transcription;
    private TAIEncoderInfo encoderInfo;
    private final String BREAK = "<br>";
    private final String UND_START = "<u>";
    private final String UND_END = "</u>";
    private final String BOLD_START = "<b>";
    private final String BOLD_END = "</b>";
    private final String ITALIC_START = "<i>";
    private final String ITALIC_END = "</i>";
    private final String NBSP = " ";
    private final String RIGHT_ARROW = "&rarr;";
    private final String BB_MARK = "[";
    private final String EB_MARK = "]";
    private Map<Annotation, Integer> wrapMap = new HashMap<Annotation, Integer>();

    public HTMLRendererTimeAlignedInterlinear() {
        this.LARGE_BLOCK_TOLERANCE = 60;
        this.SMALL_BLOCK_TOLERANCE = 30;
    }

    public HTMLRendererTimeAlignedInterlinear(TranscriptionImpl transcription, TAIEncoderInfo encoderInfo) {
        this.transcription = transcription;
        this.encoderInfo = encoderInfo;
        if (encoderInfo.getTierSettings() == null) {
            encoderInfo.setTierSettings(new ArrayList<TAITierSetting>(0));
        }
        this.blockSpace = encoderInfo.getBlockSpace() * encoderInfo.getTimeUnit();
        this.selectionOnly = encoderInfo.getBeginTime() > 0L || encoderInfo.getEndTime() < Long.MAX_VALUE;
        this.LARGE_BLOCK_TOLERANCE = 2 * encoderInfo.getTimeUnit();
        this.SMALL_BLOCK_TOLERANCE = 1 * encoderInfo.getTimeUnit();
    }

    @Override
    public void encodeAndSave(Transcription transcription, EncoderInfo encInfo, List<TierImpl> tierOrder, String path) throws IOException {
        this.transcription = (TranscriptionImpl)transcription;
        this.encoderInfo = (TAIEncoderInfo)encInfo;
        if (this.encoderInfo.getTierSettings() == null) {
            if (tierOrder == null) {
                this.encoderInfo.setTierSettings(new ArrayList<TAITierSetting>(0));
            } else {
                ArrayList<TAITierSetting> tierSettings = new ArrayList<TAITierSetting>(tierOrder.size());
                for (Tier tier : tierOrder) {
                    tierSettings.add(new TAITierSetting(tier.getName(), true, false, false));
                }
                this.encoderInfo.setTierSettings(tierSettings);
            }
        }
        this.blockSpace = this.encoderInfo.getBlockSpace() * this.encoderInfo.getTimeUnit();
        this.selectionOnly = this.encoderInfo.getBeginTime() > 0L || this.encoderInfo.getEndTime() < Long.MAX_VALUE;
        this.LARGE_BLOCK_TOLERANCE = 2 * this.encoderInfo.getTimeUnit();
        this.SMALL_BLOCK_TOLERANCE = 1 * this.encoderInfo.getTimeUnit();
        this.renderToFile(new File(path));
    }

    public void renderToFile(File outFile) throws IOException, FileNotFoundException {
        this.renderToFile(outFile, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderToFile(File outFile, String charEncoding) throws IOException, FileNotFoundException {
        if (this.transcription == null) {
            throw new NullPointerException("TranscriptionImpl object is null");
        }
        if (outFile == null) {
            throw new NullPointerException("Export file is null");
        }
        OutputStreamWriter writer = null;
        Charset cs = null;
        try {
            cs = Charset.forName(charEncoding);
        }
        catch (Throwable thr) {
            cs = Charset.forName("UTF-8");
        }
        try {
            writer = new FileWriter(outFile, cs);
            this.writeHTMLHeader(writer);
            this.writeTiers(writer);
            this.writeFooter(writer);
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public String renderToText() {
        if (this.transcription == null) {
            throw new NullPointerException("TranscriptionImpl object is null");
        }
        StringWriter writer = new StringWriter(10000);
        try {
            this.writeHTMLHeader(writer);
            this.writeTiers(writer);
            this.writeFooter(writer);
        }
        catch (IOException ioe) {
            return writer.toString();
        }
        return writer.toString();
    }

    private void writeHTMLHeader(Writer writer) throws IOException {
        writer.write("<!DOCTYPE html>");
        writer.write("\n");
        writer.write("<html>\n<head>\n");
        writer.write("<meta charset=\"UTF-8\"/>\n");
        writer.write("<title>" + this.transcription.getName() + "</title>\n");
        this.writeStyles(writer);
        writer.write("</head>\n");
        writer.write("<body>\n");
        writer.write("<h3>");
        writer.write(this.transcription.getFullPath());
        writer.write("</h3>");
        writer.write("\n");
        writer.write("<p>");
        writer.write(DateFormat.getDateTimeInstance(0, 3, Locale.getDefault()).format(new Date(System.currentTimeMillis())));
        writer.write("</p>");
        writer.write("<br>\n");
    }

    private void writeStyles(Writer writer) throws IOException {
        writer.write("<style>\n");
        writer.write("body {\n");
        writer.write("    background-color: #FFFFFF;\n");
        writer.write("    font-family: \"Courier New\";\n");
        writer.write("    font-weight: normal;\n");
        writer.write("    font-size: " + this.encoderInfo.getFontSize() + "px;\n");
        writer.write("    color: #000000;\n");
        writer.write("    line-height: 12px;\n");
        writer.write("    font-style: normal;\n");
        writer.write("}\n");
        writer.write("pre {\n");
        writer.write("    font-family: \"Courier New\";\n");
        writer.write("    padding: 10px;\n");
        writer.write("    line-height: 12px;\n");
        writer.write("}\n");
        writer.write("p {\n");
        writer.write("    font-size: " + (this.encoderInfo.getFontSize() + 2) + "px;\n");
        writer.write("}\n");
        writer.write("</style>");
        writer.write("\n");
    }

    private void writeTiers(Writer writer) throws IOException {
        long maxTime;
        long minTime;
        long blockET;
        if (this.selectionOnly) {
            blockET = this.encoderInfo.getBeginTime();
            minTime = this.encoderInfo.getBeginTime();
            maxTime = this.encoderInfo.getEndTime();
        } else {
            blockET = 0L;
            minTime = 0L;
            maxTime = 0L;
            for (TAITierSetting ts : this.encoderInfo.getTierSettings()) {
                TierImpl t = this.transcription.getTierWithId(ts.getTierName());
                for (Annotation annotation : t.getAnnotations()) {
                    if (maxTime >= annotation.getEndTimeBoundary()) continue;
                    maxTime = annotation.getEndTimeBoundary();
                }
            }
        }
        writer.write("<pre>");
        TAITierSetting referenceTierSetting = this.getRefTier();
        if (referenceTierSetting == null) {
            while (blockET < maxTime) {
                long blockBT = blockET;
                if ((blockET = blockBT + (long)this.blockSpace) > maxTime) {
                    blockET = maxTime;
                }
                for (int j = 0; j < this.encoderInfo.getTierSettings().size(); ++j) {
                    String tierName = this.encoderInfo.getTierSettings().get(j).getTierName();
                    TierImpl t = this.transcription.getTierWithId(tierName);
                    this.writeTierLabel(t, writer);
                    this.writeTierBlock(t, writer, blockBT, blockET);
                    writer.write("\n");
                }
                if (this.encoderInfo.isShowTimeLine()) {
                    this.writeTimeLine(writer, blockBT, blockET);
                }
                writer.write("<u>");
                for (int l = 0; l <= this.encoderInfo.getLeftMargin() + this.encoderInfo.getBlockSpace(); ++l) {
                    writer.write(" ");
                }
                writer.write("</u>");
                writer.write("\n");
                writer.write("\n");
            }
        } else {
            TierImpl referenceTier = this.transcription.getTierWithId(referenceTierSetting.getTierName());
            for (int i = 0; i < referenceTier.getAnnotations().size(); ++i) {
                Annotation refAnn = referenceTier.getAnnotations().get(i);
                if (refAnn.getEndTimeBoundary() <= minTime) continue;
                boolean bl = false;
                long blockBT = blockET;
                if (blockBT < maxTime && refAnn.getBeginTimeBoundary() <= maxTime) {
                    int l;
                    TierImpl t;
                    String tierName;
                    int j;
                    if (refAnn.getBeginTimeBoundary() > blockBT + (long)(this.blockSpace / 2)) {
                        if (blockBT >= minTime && blockBT + (long)(this.blockSpace / 2) <= maxTime) {
                            blockET = refAnn.getBeginTimeBoundary();
                            bl = true;
                            if (blockET > blockBT + (long)this.blockSpace) {
                                blockET = blockBT + (long)this.blockSpace;
                            }
                        }
                    } else if (refAnn.getEndTimeBoundary() > blockBT + (long)this.blockSpace && this.encoderInfo.isWrapWithinBlock()) {
                        blockET = blockBT + (long)this.blockSpace;
                        bl = true;
                    } else {
                        blockET = refAnn.getEndTimeBoundary();
                    }
                    long counter = blockBT;
                    if (i < referenceTier.getAnnotations().size() - 1) {
                        Annotation nextRefAnn;
                        for (j = i; j < referenceTier.getAnnotations().size() && (nextRefAnn = referenceTier.getAnnotations().get(i + 1)).getBeginTimeBoundary() < maxTime && nextRefAnn.getEndTimeBoundary() - blockBT <= (long)this.blockSpace; ++j) {
                            while (counter <= blockET) {
                                counter += (long)this.encoderInfo.getTimeUnit();
                            }
                            counter += (long)this.encoderInfo.getTimeUnit();
                            counter += (long)(nextRefAnn.getValue().length() * this.encoderInfo.getTimeUnit());
                            blockET = nextRefAnn.getEndTimeBoundary();
                            if (++i >= referenceTier.getAnnotations().size() - 1) break;
                            refAnn = referenceTier.getAnnotations().get(i + 1);
                        }
                    }
                    if (blockET > maxTime) {
                        blockET = maxTime;
                    }
                    for (j = 0; j < this.encoderInfo.getTierSettings().size(); ++j) {
                        tierName = this.encoderInfo.getTierSettings().get(j).getTierName();
                        t = this.transcription.getTierWithId(tierName);
                        if (blockBT >= blockET) continue;
                        this.writeTierLabel(t, writer);
                        this.writeTierBlock(t, writer, blockBT, blockET);
                        writer.write("\n");
                    }
                    if (this.encoderInfo.isShowTimeLine()) {
                        this.writeTimeLine(writer, blockBT, blockET);
                    }
                    writer.write("<u>");
                    for (l = 0; l <= this.encoderInfo.getLeftMargin() + this.encoderInfo.getBlockSpace(); ++l) {
                        writer.write(" ");
                    }
                    writer.write("</u>");
                    writer.write("\n");
                    writer.write("\n");
                    if (i == referenceTier.getAnnotations().size() - 1 && !bl && !this.selectionOnly) {
                        while (blockET < maxTime) {
                            blockBT = blockET;
                            if ((blockET = blockBT + (long)this.blockSpace) > maxTime) {
                                blockET = maxTime;
                            }
                            for (j = 0; j < this.encoderInfo.getTierSettings().size(); ++j) {
                                tierName = this.encoderInfo.getTierSettings().get(j).getTierName();
                                t = this.transcription.getTierWithId(tierName);
                                this.writeTierLabel(t, writer);
                                this.writeTierBlock(t, writer, blockBT, blockET);
                                writer.write("\n");
                            }
                            writer.write("<u>");
                            for (l = 0; l <= this.encoderInfo.getLeftMargin() + this.encoderInfo.getBlockSpace(); ++l) {
                                writer.write(" ");
                            }
                            writer.write("</u>");
                            writer.write("\n");
                            writer.write("\n");
                        }
                    }
                    if (!bl) continue;
                    --i;
                    continue;
                }
                break;
            }
        }
        writer.write("</pre>");
    }

    private void writeTierLabel(Tier t, Writer writer) throws IOException {
        String label = t.getName();
        if (label.length() > this.encoderInfo.getLeftMargin()) {
            for (int i = 0; i < label.length(); ++i) {
                if (i + 2 >= this.encoderInfo.getLeftMargin()) {
                    writer.write("..");
                    break;
                }
                writer.write(label.charAt(i));
            }
        } else {
            writer.write(label);
            this.padSpaces(writer, this.encoderInfo.getLeftMargin() - label.length());
        }
        writer.write("|");
    }

    private void writeTierBlock(Tier t, Writer writer, long blockBT, long blockET) throws IOException {
        TAITierSetting tierSetting = this.getTierSettingById(t.getName());
        long counter = blockBT;
        for (Annotation annotation : t.getAnnotations()) {
            long bt = annotation.getBeginTimeBoundary();
            long et = annotation.getEndTimeBoundary();
            if (bt > blockET) break;
            if (et < blockBT) continue;
            long localET = et;
            String val = annotation.getValue();
            Integer wrapInd = this.wrapMap.get(annotation);
            if (wrapInd != null && wrapInd < annotation.getValue().length() - 2) {
                int splitInd = wrapInd;
                int prevSpace = val.lastIndexOf(32, splitInd);
                if (prevSpace > 0) {
                    splitInd = prevSpace + 1;
                    this.wrapMap.put(annotation, splitInd);
                }
                val = val.substring(splitInd);
            }
            if (!(bt >= blockBT && bt < blockET - (long)this.LARGE_BLOCK_TOLERANCE || et > blockBT + (long)this.SMALL_BLOCK_TOLERANCE && et <= blockET) && (bt >= blockBT || et <= blockET)) continue;
            int bbInt = 0;
            int ebInt = 0;
            if (this.encoderInfo.isShowAnnotationBoundaries()) {
                if (bt >= blockBT && bt < blockET - (long)this.LARGE_BLOCK_TOLERANCE) {
                    bbInt = 1;
                }
                if (et > blockBT + (long)this.SMALL_BLOCK_TOLERANCE && et <= blockET) {
                    ebInt = 1;
                }
            }
            if (counter < bt - (long)(this.encoderInfo.getTimeUnit() / 2)) {
                while (counter < bt - (long)(this.encoderInfo.getTimeUnit() / 2)) {
                    writer.write(" ");
                    counter += (long)this.encoderInfo.getTimeUnit();
                }
                if (bbInt == 0) {
                    writer.write(" ");
                    counter += (long)this.encoderInfo.getTimeUnit();
                }
            }
            if (et > blockET + (long)(this.encoderInfo.getTimeUnit() / 2)) {
                localET = blockET;
            }
            int arrowInt = et > blockET + (long)this.SMALL_BLOCK_TOLERANCE ? 1 : 0;
            if (counter + (long)(this.encoderInfo.getTimeUnit() * (val.length() + arrowInt + bbInt + ebInt)) > localET) {
                if (bbInt == 1) {
                    writer.write("[");
                    counter += (long)this.encoderInfo.getTimeUnit();
                }
                if (tierSetting.isUnderlined()) {
                    writer.write("<u>");
                }
                if (tierSetting.isBold()) {
                    writer.write("<b>");
                }
                if (tierSetting.isItalic()) {
                    writer.write("<i>");
                }
                if (et > blockET + (long)this.SMALL_BLOCK_TOLERANCE) {
                    counter += (long)this.encoderInfo.getTimeUnit();
                }
                if ((counter += (long)(ebInt * this.encoderInfo.getTimeUnit())) + (long)(2 * this.encoderInfo.getTimeUnit()) <= localET) {
                    int i = 0;
                    int numChars = (int)Math.ceil((double)(localET - (counter += (long)(2 * this.encoderInfo.getTimeUnit()))) / (double)this.encoderInfo.getTimeUnit());
                    counter += (long)(numChars * this.encoderInfo.getTimeUnit());
                    if (numChars == val.length() - 2) {
                        writer.write(val, 0, numChars += 2);
                    } else {
                        writer.write(val, 0, numChars);
                        writer.write("..");
                    }
                    i = numChars;
                    if (i < val.length() - 1) {
                        Integer old = this.wrapMap.get(annotation);
                        if (old != null) {
                            this.wrapMap.put(annotation, i + old);
                        } else {
                            this.wrapMap.put(annotation, i);
                        }
                    } else {
                        this.wrapMap.remove(annotation);
                    }
                } else if (counter + (long)this.encoderInfo.getTimeUnit() <= localET) {
                    counter += (long)this.encoderInfo.getTimeUnit();
                    writer.write(".");
                }
                if (et > blockET + (long)this.SMALL_BLOCK_TOLERANCE) {
                    writer.write("&rarr;");
                }
                if (tierSetting.isItalic()) {
                    writer.write("</i>");
                }
                if (tierSetting.isBold()) {
                    writer.write("</b>");
                }
                if (tierSetting.isUnderlined()) {
                    writer.write("</u>");
                }
                if (ebInt == 1) {
                    writer.write("]");
                }
                if (this.encoderInfo.isShowAnnotationBoundaries()) continue;
                writer.write(" ");
                counter += (long)this.encoderInfo.getTimeUnit();
                continue;
            }
            counter += (long)(this.encoderInfo.getTimeUnit() * (val.length() + ebInt));
            if (bbInt == 1) {
                writer.write("[");
                counter += (long)this.encoderInfo.getTimeUnit();
            }
            if (tierSetting.isUnderlined()) {
                writer.write("<u>");
            }
            if (tierSetting.isBold()) {
                writer.write("<b>");
            }
            if (tierSetting.isItalic()) {
                writer.write("<i>");
            }
            if (et > blockET + (long)this.SMALL_BLOCK_TOLERANCE) {
                counter += (long)this.encoderInfo.getTimeUnit();
            }
            if (!tierSetting.isReference() && this.encoderInfo.getTextAlignment() != 2) {
                while (counter < localET) {
                    writer.write(" ");
                    counter += (long)this.encoderInfo.getTimeUnit();
                }
            }
            writer.write(val);
            if (tierSetting.isReference() || this.encoderInfo.getTextAlignment() == 2) {
                while (counter < localET) {
                    writer.write(" ");
                    counter += (long)this.encoderInfo.getTimeUnit();
                }
            }
            if (et > blockET + (long)this.SMALL_BLOCK_TOLERANCE) {
                writer.write("&rarr;");
            }
            if (tierSetting.isItalic()) {
                writer.write("</i>");
            }
            if (tierSetting.isBold()) {
                writer.write("</b>");
            }
            if (tierSetting.isUnderlined()) {
                writer.write("</u>");
            }
            if (ebInt == 1) {
                writer.write("]");
            }
            if (!this.encoderInfo.isShowAnnotationBoundaries()) {
                writer.write(" ");
                counter += (long)this.encoderInfo.getTimeUnit();
            }
            this.wrapMap.remove(annotation);
        }
    }

    private void writeTimeLine(Writer writer, long blockBT, long blockET) throws IOException {
        String tc = "Time";
        if (tc.length() > this.encoderInfo.getLeftMargin()) {
            for (int i = 0; i < tc.length(); ++i) {
                if (i + 2 >= this.encoderInfo.getLeftMargin()) {
                    writer.write("..");
                    break;
                }
                writer.write(tc.charAt(i));
            }
        } else {
            writer.write(tc);
            this.padSpaces(writer, this.encoderInfo.getLeftMargin() - tc.length());
        }
        writer.write("|");
        long counter = blockBT;
        String blockBTString = null;
        switch (this.encoderInfo.getTimeFormat()) {
            case HHMMSSMS: {
                blockBTString = TimeFormatter.toString(blockBT);
                break;
            }
            case SSMS: {
                blockBTString = TimeFormatter.toSSMSString(blockBT);
                break;
            }
            default: {
                blockBTString = String.valueOf(blockBT);
            }
        }
        writer.write(blockBTString);
        counter += (long)(blockBTString.length() * this.encoderInfo.getTimeUnit());
        while (counter < blockET) {
            if ((counter += (long)this.encoderInfo.getTimeUnit()) % 1000L < (long)this.encoderInfo.getTimeUnit()) {
                writer.write("\u00a6");
                continue;
            }
            writer.write("\u00b7");
        }
        writer.write("\n");
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("</body>\n");
        writer.write("</html>");
    }

    private void padSpaces(Writer writer, int pad) throws IOException {
        for (int i = 0; i < pad; ++i) {
            writer.write(" ");
        }
    }

    private TAITierSetting getRefTier() {
        for (TAITierSetting ts : this.encoderInfo.getTierSettings()) {
            if (!ts.isReference()) continue;
            return ts;
        }
        return null;
    }

    private TAITierSetting getTierSettingById(String tierName) {
        for (TAITierSetting ts : this.encoderInfo.getTierSettings()) {
            if (!ts.getTierName().equals(tierName)) continue;
            return ts;
        }
        return null;
    }
}

