/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.json;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.json.JSONWAEncoderInfo;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.TimeFormatter;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONWAEncoder
implements AnnotationDocEncoder {
    @Override
    public void encodeAndSave(Transcription transcription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        if (transcription == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while exporting to JSON: transcription is null");
            }
            throw new IllegalArgumentException("The transcription is null");
        }
        if (path == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while exporting to JSON: output path is null");
            }
            throw new IllegalArgumentException("No export path for the JSON file specified");
        }
        JSONWAEncoderInfo waEncoderInfo = encoderInfo == null ? new JSONWAEncoderInfo() : (JSONWAEncoderInfo)encoderInfo;
        List<String> selTierNames = waEncoderInfo.getSelectedTiers();
        if (tierOrder != null) {
            waEncoderInfo.setSelectedTiers(this.toTierNames(tierOrder));
        }
        String content = this.createJSONText(transcription, waEncoderInfo);
        OutputStreamWriter writer = null;
        try {
            writer = new FileWriter(path, Charset.forName("UTF-8"));
            writer.write(content);
        }
        catch (IOException ioe) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while exporting to JSON: " + ioe.getMessage());
            }
            throw ioe;
        }
        finally {
            try {
                writer.close();
            }
            catch (Throwable throwable) {}
        }
        waEncoderInfo.setSelectedTiers(selTierNames);
    }

    /*
     * WARNING - void declaration
     */
    public String createJSONText(Transcription transcription, JSONWAEncoderInfo encoderInfo) {
        if (transcription == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while creating JSON text: no transcription");
            }
            return "";
        }
        if (encoderInfo == null) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.log(Level.WARNING, "Error while creating JSON text: no encoder settings");
            }
            return "";
        }
        MediaDescriptor missingDesc = new MediaDescriptor("./nomedia", "video/*");
        ArrayList<MediaDescriptor> noFileList = new ArrayList<MediaDescriptor>(1);
        noFileList.add(missingDesc);
        JSONObject contJSON = new JSONObject();
        JSONArray contextArray = new JSONArray();
        contextArray.put((Object)"http://www.w3.org/ns/anno.jsonld");
        contextArray.put((Object)"http://www.w3.org/ns/ldp.jsonld");
        contJSON.put("@context", (Object)contextArray);
        for (Property property : transcription.getDocProperties()) {
            if (property.getName().equals("id")) {
                contJSON.put("id", property.getValue());
                continue;
            }
            if (!property.getName().equals("label")) continue;
            contJSON.put("label", property.getValue());
        }
        contJSON.put("type", (Object)"Container");
        JSONArray json = new JSONArray();
        contJSON.put("contains", (Object)json);
        boolean bl = false;
        List<? extends Tier> tiers = transcription.getTiers();
        List<String> selected = encoderInfo.getSelectedTiers();
        if (selected == null) {
            selected = this.toTierNames(tiers);
        }
        for (int i = 0; i < selected.size(); ++i) {
            Tier tier = transcription.getTierWithId(selected.get(i));
            if (tier == null || tier.getNumberOfAnnotations() == 0) continue;
            String language = null;
            if (tier.getLangRef() != null) {
                language = tier.getLangRef();
            }
            JSONObject tierJSON = new JSONObject();
            tierJSON.put("@context", (Object)"http://www.w3.org/ns/ldp.jsonld");
            tierJSON.put("id", (Object)(transcription.getURN() + "#collection" + Integer.toString(i + 1)));
            tierJSON.put("type", (Object)"AnnotationCollection");
            if (transcription.getAuthor() != null && !transcription.getAuthor().isEmpty()) {
                tierJSON.put("creator", (Object)transcription.getAuthor());
            } else if (tier.getAnnotator() != null && !tier.getAnnotator().isEmpty()) {
                tierJSON.put("creator", (Object)tier.getAnnotator());
            }
            if (encoderInfo.getGenerator() != null) {
                tierJSON.put("generator", (Object)encoderInfo.getGenerator());
            }
            tierJSON.put("label", (Object)tier.getName());
            List<? extends Annotation> annotations = tier.getAnnotations();
            int total = 0;
            JSONObject firstJSON = new JSONObject();
            firstJSON.put("type", (Object)"AnnotationPage");
            firstJSON.put("id", (Object)(transcription.getURN() + "#collection" + Integer.toString(i + 1) + "-page1"));
            firstJSON.put("startIndex", (Object)"0");
            JSONArray items = new JSONArray();
            for (int j = 0; j < annotations.size(); ++j) {
                Annotation annot = annotations.get(j);
                if (!this.withinSelection(annot, encoderInfo.getBeginTime(), encoderInfo.getEndTime())) continue;
                JSONObject annotJSON = new JSONObject();
                annotJSON.put("@context", (Object)"http://www.w3.org/ns/anno.jsonld");
                ++total;
                annotJSON.put("type", (Object)"Annotation");
                if (encoderInfo.isIncrementalIDs()) {
                    void var8_10;
                    annotJSON.put("id", (Object)Integer.toString((int)(++var8_10)));
                } else {
                    annotJSON.put("id", (Object)(transcription.getURN() + "#" + annot.getId()));
                }
                JSONObject bodyJSON = new JSONObject();
                bodyJSON.put("type", (Object)"TextualBody");
                bodyJSON.put("value", (Object)annot.getValue());
                if (encoderInfo.getPurpose() != null) {
                    bodyJSON.put("purpose", (Object)encoderInfo.getPurpose());
                }
                if (encoderInfo.getBodyFormat() != null) {
                    bodyJSON.put("format", (Object)encoderInfo.getBodyFormat());
                } else {
                    bodyJSON.put("format", (Object)"text/plain");
                }
                if (language != null) {
                    bodyJSON.put("language", (Object)language);
                }
                annotJSON.put("body", (Object)bodyJSON);
                List<MediaDescriptor> files = transcription.getMediaDescriptors();
                if (files == null || files.isEmpty()) {
                    files = noFileList;
                }
                if (encoderInfo.isSingleTargetExport()) {
                    if (files.size() > 0) {
                        annotJSON.put("target", (Object)this.createTargetObject(files.get(0), encoderInfo, annot.getBeginTimeBoundary(), annot.getEndTimeBoundary()));
                    }
                } else {
                    JSONArray targets = new JSONArray();
                    for (int k = 0; k < files.size(); ++k) {
                        targets.put((Object)this.createTargetObject(files.get(k), encoderInfo, annot.getBeginTimeBoundary(), annot.getEndTimeBoundary()));
                    }
                    if (targets.length() == 1) {
                        annotJSON.put("target", targets.get(0));
                    } else if (targets.length() > 1) {
                        annotJSON.put("target", (Object)targets);
                    }
                }
                items.put((Object)annotJSON);
            }
            firstJSON.put("items", (Object)items);
            tierJSON.put("first", (Object)firstJSON);
            tierJSON.put("total", total);
            json.put((Object)tierJSON);
        }
        return contJSON.toString(encoderInfo.getIndentationLevel());
    }

    private Tier retrieveTier(String name, List<? extends Tier> tiers) {
        for (int i = 0; i < tiers.size(); ++i) {
            if (!tiers.get(i).getName().equals(name)) continue;
            return tiers.get(i);
        }
        return null;
    }

    private boolean withinSelection(Annotation ann, long selectionBegin, long selectionEnd) {
        return selectionBegin <= ann.getBeginTimeBoundary() && ann.getEndTimeBoundary() <= selectionEnd;
    }

    private List<String> toTierNames(List<? extends Tier> tierList) {
        ArrayList<String> nameList = new ArrayList<String>(tierList.size());
        for (Tier tier : tierList) {
            nameList.add(tier.getName());
        }
        return nameList;
    }

    private JSONObject createTargetObject(MediaDescriptor md, JSONWAEncoderInfo encoderInfo, long fragBT, long fragET) {
        JSONObject targetJSON = new JSONObject();
        if (encoderInfo.isFragmentSelector()) {
            targetJSON.put("source", (Object)md.mediaURL);
            JSONObject selectorJSON = new JSONObject();
            selectorJSON.put("conformsTo", (Object)"http://www.w3.org/TR/media-frags/");
            selectorJSON.put("type", (Object)"FragmentSelector");
            selectorJSON.put("value", (Object)("t=" + TimeFormatter.toSSMSString(fragBT + md.timeOrigin) + "," + TimeFormatter.toSSMSString(fragET + md.timeOrigin)));
            targetJSON.put("selector", (Object)selectorJSON);
        } else {
            String timeSpan = "#t=" + TimeFormatter.toSSMSString(fragBT + md.timeOrigin) + "," + TimeFormatter.toSSMSString(fragET + md.timeOrigin);
            targetJSON.put("id", (Object)(md.mediaURL + timeSpan));
        }
        targetJSON.put("format", (Object)md.mimeType);
        if (md.mimeType.startsWith("video")) {
            targetJSON.put("type", (Object)"Video");
        } else if (md.mimeType.startsWith("audio")) {
            targetJSON.put("type", (Object)"Audio");
        }
        return targetJSON;
    }
}

