/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.reflink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.RefLink;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.UndoTransaction;
import mpi.eudico.server.corpora.clomimpl.reflink.CrossRefLink;
import mpi.eudico.server.corpora.clomimpl.reflink.GroupRefLink;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class RefLinkSet
implements ACMEditListener {
    private String linksID;
    private String linksName;
    private ExternalReference extRef;
    private String langRef;
    private String cvRef;
    private TranscriptionImpl trans;
    private List<RefLink> refs;
    private static final int GROUP_MEMBERS_MINIMUM = 2;

    public RefLinkSet(TranscriptionImpl trans) {
        this.trans = trans;
        trans.addACMEditListener(this);
    }

    public String getLinksID() {
        return this.linksID;
    }

    public void setLinksID(String linksID) {
        this.linksID = linksID;
    }

    public String getLinksName() {
        return this.linksName;
    }

    public void setLinksName(String linksName) {
        this.linksName = linksName;
    }

    public ExternalReference getExtRef() {
        return this.extRef;
    }

    public void setExtRef(ExternalReference extRef) {
        this.extRef = extRef;
    }

    public String getLangRef() {
        return this.langRef;
    }

    public void setLangRef(String langRef) {
        this.langRef = langRef;
    }

    public String getCvRef() {
        return this.cvRef;
    }

    public void setCvRef(String cvRef) {
        this.cvRef = cvRef;
    }

    public List<RefLink> getRefs() {
        return this.refs;
    }

    public void setRefLinks(List<RefLink> refs) {
        this.refs = refs;
    }

    Set<RefLink> removeLinksTo(String id) {
        TreeSet<String> toClean = new TreeSet<String>();
        toClean.add(id);
        return this.removeLinksTo(toClean);
    }

    Set<RefLink> removeLinksTo(NavigableSet<String> toClean) {
        TreeSet<RefLink> removed = new TreeSet<RefLink>();
        while (!toClean.isEmpty()) {
            TreeSet<String> cleanNext = new TreeSet<String>();
            Iterator<RefLink> refIter = this.refs.iterator();
            while (refIter.hasNext()) {
                RefLink rl = refIter.next();
                if (!rl.references(toClean)) continue;
                boolean removeRL = true;
                if (rl instanceof GroupRefLink) {
                    GroupRefLink grl = (GroupRefLink)rl;
                    removeRL = this.maybeShrinkRefs(grl, toClean);
                }
                if (!removeRL) continue;
                removed.add(rl);
                refIter.remove();
                cleanNext.add(rl.getId());
            }
            toClean = cleanNext;
        }
        return removed;
    }

    Set<RefLink> checkForRemovedAnnotations() {
        HashSet<RefLink> removed = new HashSet<RefLink>();
        Map<String, Annotation> annotations = null;
        if (this.refs.size() > 0) {
            annotations = this.trans.getAnnotationsByIdMap();
        }
        for (RefLink refLink : this.refs) {
            if (refLink instanceof CrossRefLink) {
                CrossRefLink crl = (CrossRefLink)refLink;
                if (this.checkId(crl.getRef1(), this.trans, annotations) && this.checkId(crl.getRef2(), this.trans, annotations)) continue;
                removed.add(refLink);
                continue;
            }
            if (!(refLink instanceof GroupRefLink)) continue;
            GroupRefLink grl = (GroupRefLink)refLink;
            Set<String> grefs = grl.getRefs();
            ArrayList<String> removeGrefs = new ArrayList<String>(grefs.size());
            for (String id : grefs) {
                if (this.checkId(id, this.trans, annotations)) continue;
                removeGrefs.add(id);
            }
            if (removeGrefs.isEmpty()) continue;
            if (grefs.size() - removeGrefs.size() >= 2) {
                this.shrinkRefs(grl, removeGrefs);
                continue;
            }
            removed.add(refLink);
        }
        if (!removed.isEmpty()) {
            this.refs.removeAll(removed);
            TreeSet<String> toClean = new TreeSet<String>();
            for (RefLink link : removed) {
                toClean.add(link.getId());
            }
            Set<RefLink> set = this.removeLinksTo(toClean);
            removed.addAll(set);
        }
        return removed;
    }

    private void shrinkRefs(GroupRefLink grl, Collection<String> removeGrefs) {
        Set<String> grefs = grl.getRefs();
        this.appendUndoTransaction(grl, grefs);
        HashSet<String> newgrefs = new HashSet<String>(grefs);
        newgrefs.removeAll(removeGrefs);
        grl.setRefs(newgrefs);
    }

    private boolean maybeShrinkRefs(GroupRefLink grl, Collection<String> removeGrefs) {
        Set<String> grefs = grl.getRefs();
        HashSet<String> newgrefs = new HashSet<String>(grefs);
        newgrefs.removeAll(removeGrefs);
        if (newgrefs.size() < 2) {
            return true;
        }
        if (newgrefs.size() < grefs.size()) {
            this.appendUndoTransaction(grl, grefs);
            grl.setRefs(newgrefs);
        }
        return false;
    }

    private boolean checkId(String id, TranscriptionImpl trans, Map<String, ?> map) {
        if (map != null) {
            return map.containsKey(id) || this.checkLinkId(id);
        }
        return this.checkLinkId(id) || trans.getAnnotationById(id) != null;
    }

    private boolean checkLinkId(String id) {
        for (RefLink rl : this.refs) {
            if (!id.equals(rl.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (this.refs.isEmpty()) {
            return;
        }
        switch (e.getOperation()) {
            case 6: {
                Object o = e.getModification();
                if (o instanceof AbstractAnnotation) {
                    String id = ((AbstractAnnotation)o).getIdLazily();
                    if (id == null) break;
                    Set<RefLink> removed = this.checkForRemovedAnnotations();
                    this.appendUndoTransaction(removed);
                    break;
                }
            }
            case 14: {
                Set<RefLink> removed = this.checkForRemovedAnnotations();
                this.appendUndoTransaction(removed);
                break;
            }
        }
    }

    private RefLinksRemovedUndoTransaction getUndoTransaction() {
        UndoTransaction ut = this.trans.getCurrentUndoTransaction();
        if (ut instanceof RefLinksRemovedUndoTransaction) {
            return (RefLinksRemovedUndoTransaction)ut;
        }
        if (ut != null) {
            RefLinksRemovedUndoTransaction rut = new RefLinksRemovedUndoTransaction();
            this.trans.addToCurrentUndoTransaction(rut);
            return rut;
        }
        return null;
    }

    private void appendUndoTransaction(Set<RefLink> removed) {
        RefLinksRemovedUndoTransaction rut;
        if (!removed.isEmpty() && (rut = this.getUndoTransaction()) != null) {
            rut.add(this, removed);
        }
    }

    private void appendUndoTransaction(GroupRefLink group, Set<String> oldMembers) {
        RefLinksRemovedUndoTransaction rut = this.getUndoTransaction();
        if (rut != null) {
            rut.add(this, group, oldMembers);
        }
    }

    class RefLinksRemovedUndoTransaction
    extends UndoTransaction {
        LinkedHashMap<RefLinkSet, Set<RefLink>> removedLinksMap;
        LinkedHashMap<RefLinkSet, Map<String, Set<String>>> shrunkGroupLinksMap;

        RefLinksRemovedUndoTransaction() {
        }

        public void add(RefLinkSet set, Set<RefLink> removed) {
            Set<RefLink> removedLinks;
            if (this.removedLinksMap == null) {
                this.removedLinksMap = new LinkedHashMap();
            }
            if ((removedLinks = this.removedLinksMap.get(set)) == null) {
                removedLinks = new HashSet<RefLink>();
                this.removedLinksMap.put(set, removedLinks);
            }
            removedLinks.addAll(removed);
        }

        public void add(RefLinkSet set, GroupRefLink group, Set<String> oldMembers) {
            Map<String, Set<String>> shrunkGroupLinks;
            if (this.shrunkGroupLinksMap == null) {
                this.shrunkGroupLinksMap = new LinkedHashMap();
            }
            if ((shrunkGroupLinks = this.shrunkGroupLinksMap.get(set)) == null) {
                shrunkGroupLinks = new HashMap<String, Set<String>>();
                this.shrunkGroupLinksMap.put(set, shrunkGroupLinks);
            }
            if (!shrunkGroupLinks.containsKey(group.getId())) {
                shrunkGroupLinks.put(group.getId(), oldMembers);
            }
        }

        @Override
        public void undo() {
            if (this.removedLinksMap != null) {
                for (RefLinkSet set : this.removedLinksMap.keySet()) {
                    set.getRefs().addAll((Collection<RefLink>)this.removedLinksMap.get(set));
                }
            }
            if (this.shrunkGroupLinksMap != null) {
                for (RefLinkSet set : this.shrunkGroupLinksMap.keySet()) {
                    Map<String, Set<String>> shrunkGroupLinks = this.shrunkGroupLinksMap.get(set);
                    if (shrunkGroupLinks == null || shrunkGroupLinks.isEmpty()) continue;
                    for (RefLink link : set.getRefs()) {
                        Set<String> oldMembers;
                        if (!(link instanceof GroupRefLink) || (oldMembers = shrunkGroupLinks.get(link.getId())) == null) continue;
                        ((GroupRefLink)link).setRefs(oldMembers);
                    }
                }
            }
        }
    }
}

