/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxArray;

public class ShoeboxTypFile {
    private String typFileName = "";
    private String databaseType = "";
    public List<String> fromArray = new ArrayList<String>();
    private List<String> toArray = new ArrayList<String>();
    public Map<String, String> tofromHash = new HashMap<String, String>();
    public Map<String, String> procedureTypeHash = new HashMap<String, String>();
    public String recordMarker = null;
    public String interlinearRootMarker = null;
    private List<String> tiersWithIPA = new ArrayList<String>();
    private List<String> tiersWithUnicode = new ArrayList<String>();
    private List<String> excludedTiers = new ArrayList<String>();
    private boolean allTiersUnicode = false;
    private boolean ddebug = "true".equals(System.getProperty("ddebug"));
    private boolean debug = "true".equals(System.getProperty("debug"));

    private void ddebug(String s) {
        if (this.ddebug) {
            System.out.println("---- ShoeboxFile3: " + s);
        }
    }

    private void debug(String s) {
        if (this.debug) {
            System.out.println("-- ShoeboxFile3: " + s);
        }
    }

    public void setDatabaseType(String theType) {
        this.databaseType = theType;
    }

    public String getDatabaseType() {
        if (this.databaseType.equals("") && !this.typFileName.equals("") && (this.typFileName.endsWith(".typ") || this.typFileName.endsWith(".TYP"))) {
            int leafIndex = this.typFileName.lastIndexOf("/") + 1;
            if (leafIndex <= 0) {
                leafIndex = this.typFileName.lastIndexOf("\\") + 1;
            }
            int endIndex = this.typFileName.lastIndexOf(".");
            if (leafIndex > 0 && endIndex > 0 && leafIndex < endIndex) {
                this.databaseType = this.typFileName.substring(leafIndex, endIndex);
            }
        }
        return this.databaseType;
    }

    public ShoeboxTypFile(File file) throws IllegalArgumentException, Exception {
        if (file != null) {
            if (!file.canRead()) {
                throw new IllegalArgumentException("cannot read \"" + file + "\"");
            }
            this.typFileName = file.getAbsolutePath();
            this.readFile(file);
        }
    }

    public ShoeboxTypFile(List<MarkerRecord> markerRecords) {
        if (markerRecords != null) {
            this.initializeFromMarkerRecords(markerRecords);
        }
    }

    public ShoeboxTypFile() throws IllegalArgumentException, Exception {
    }

    private void initializeFromMarkerRecords(List<MarkerRecord> markerRecords) {
        MarkerRecord topMarker = null;
        for (MarkerRecord mr : markerRecords) {
            if (mr.getParentMarker() != null || mr.isExcluded()) continue;
            if (topMarker == null) {
                topMarker = mr;
                continue;
            }
            topMarker = null;
            break;
        }
        if (topMarker != null) {
            this.interlinearRootMarker = topMarker.getMarker();
        }
        for (MarkerRecord mr : markerRecords) {
            if (mr.getParentMarker() != null) {
                this.fromArray.add("\\" + mr.getParentMarker());
                this.toArray.add("\\" + mr.getMarker());
                this.tofromHash.put("\\" + mr.getMarker(), "\\" + mr.getParentMarker());
                if (mr.getStereoType() != null && mr.getStereoType().equals("Symbolic Association")) {
                    this.procedureTypeHash.put("\\" + mr.getMarker(), "Lookup");
                } else if (mr.getStereoType() != null && mr.getStereoType().equals("Time Subdivision")) {
                    this.procedureTypeHash.put("\\" + mr.getMarker(), "TimeSubdivision");
                } else if (mr.getStereoType() != null && mr.getStereoType().equals("Included In")) {
                    this.procedureTypeHash.put("\\" + mr.getMarker(), "IncludedIn");
                } else {
                    this.procedureTypeHash.put("\\" + mr.getMarker(), "Parse");
                }
            }
            if (mr.getCharsetString().equals("SIL IPA")) {
                this.tiersWithIPA.add(mr.getMarker());
            }
            if (mr.getCharsetString().equals("Unicode (UTF-8)")) {
                this.tiersWithUnicode.add(mr.getMarker());
            }
            if (mr.getParticipantMarker()) {
                ShoeboxArray.label_eudicoparticipant = "\\" + mr.getMarker();
            }
            if (!mr.isExcluded()) continue;
            this.excludedTiers.add(mr.getMarker());
        }
        if (this.excludedTiers.size() > 0) {
            for (int i = 0; i < this.excludedTiers.size(); ++i) {
                String parent = "\\" + this.excludedTiers.get(i);
                if (!this.fromArray.contains(parent)) continue;
                this.addDescendantsToExcludedTiers(parent);
            }
        }
    }

    public static void main(String[] arg) throws Exception {
        ShoeboxTypFile s = new ShoeboxTypFile(new File(arg[0]));
        System.out.println(s.interlinearRootMarker);
        System.out.println(s.fromArray);
        System.out.println(s.toArray);
        System.out.println("");
        System.out.println(s.procedureTypeHash.keySet());
        System.out.println(s.procedureTypeHash.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readFile(File file) throws IOException, Exception {
        InputStreamReader filereader;
        String line = null;
        boolean useDedicatedCharacterset = false;
        if (useDedicatedCharacterset) {
            FileInputStream fis = new FileInputStream(file);
            filereader = new InputStreamReader((InputStream)fis, "DedicatedCharacterset");
        } else {
            filereader = new FileReader(file);
        }
        BufferedReader br = new BufferedReader(filereader);
        String label = null;
        String content = null;
        String tierToSetLanguageFor = null;
        int linenumber = 0;
        String lastFrom = "";
        String lastTo = "";
        String procType = "Lookup";
        try {
            while ((line = br.readLine()) != null) {
                ++linenumber;
                line = line.trim();
                this.debug("  ..." + line);
                if (line.length() == 0) continue;
                if (linenumber == 1) {
                    if (line.startsWith("\\+DatabaseType")) {
                        StringTokenizer st = new StringTokenizer(line);
                        st.nextToken();
                        String db = st.nextToken();
                        if (db == null) continue;
                        this.databaseType = db.trim();
                        continue;
                    }
                    throw new Exception("Shoebox typ file must begin with '\\+DatabaseType', found '" + line + "'");
                }
                StringTokenizer xxx = new StringTokenizer(line);
                label = xxx.nextToken();
                content = line.substring(label.length()).trim();
                if (this.recordMarker == null && label.equals("\\mkrRecord")) {
                    this.interlinearRootMarker = content;
                    this.recordMarker = content;
                }
                if (label.equals("\\+intprc")) {
                    lastFrom = "";
                    lastTo = "";
                    procType = "Parse";
                }
                if (label.equals("\\mkrFrom")) {
                    lastFrom = content;
                }
                if (label.equals("\\mkrTo")) {
                    lastTo = content;
                }
                if (line.indexOf("Lookup") >= 0) {
                    procType = "Lookup";
                }
                if (line.indexOf("ParseProc") >= 0) {
                    procType = "Parse";
                }
                if (label.equals("\\-intprc")) {
                    this.fromArray.add("\\" + lastFrom);
                    this.toArray.add("\\" + lastTo);
                    this.tofromHash.put("\\" + lastTo, "\\" + lastFrom);
                    this.procedureTypeHash.put("\\" + lastTo, procType);
                }
                if (label.equals("\\+mkr")) {
                    tierToSetLanguageFor = content;
                }
                if (label.equals("\\lng")) {
                    if (content == null || !content.equals("IPA") && !content.equals("Phonetic") || tierToSetLanguageFor == null) continue;
                    this.tiersWithIPA.add(tierToSetLanguageFor);
                }
                if (!label.equals("\\-mkr")) continue;
                tierToSetLanguageFor = null;
            }
        }
        finally {
            br.close();
            ((Reader)filereader).close();
        }
        int size = this.toArray.size();
        for (int i = 0; i < size; ++i) {
            String from;
            String key = this.toArray.get(i);
            String val = this.procedureTypeHash.get(key);
            if (val == null || !val.equals("Parse") && !val.equals("Lookup") || (from = this.tofromHash.get(key)) == null || this.toArray.contains(from)) continue;
            this.fromArray.add("\\" + this.recordMarker);
            this.toArray.add(from);
            this.tofromHash.put(from, "\\" + this.recordMarker);
            this.procedureTypeHash.put(from, "Parse");
        }
    }

    public HashSet<String> getInterlinearTierMarkers() {
        HashSet<String> markerSet = new HashSet<String>();
        String rootMkr = "\\" + this.interlinearRootMarker;
        for (int i = 0; i < this.toArray.size(); ++i) {
            String mkrLabel = this.toArray.get(i);
            if (mkrLabel.equals(rootMkr) || this.excludeFromImport(mkrLabel)) continue;
            String proc = this.procedureTypeHash.get(mkrLabel);
            String parent = this.tofromHash.get(mkrLabel);
            if (proc == null || parent == null || !parent.equals(rootMkr)) continue;
            if (proc.equals("Parse") || proc.equals("TimeSubdivision") || proc.equals("IncludedIn")) {
                markerSet.add(mkrLabel);
                markerSet.addAll(this.getDescendantsOf(mkrLabel));
                continue;
            }
            if (!this.atLeastOneParseInTree(mkrLabel)) continue;
            markerSet.add(mkrLabel);
            markerSet.addAll(this.getDescendantsOf(mkrLabel));
        }
        if (markerSet.contains("\\" + this.interlinearRootMarker)) {
            markerSet.remove("\\" + this.interlinearRootMarker);
        }
        return markerSet;
    }

    private List<String> getDescendantsOf(String mkrLabel) {
        ArrayList<String> desc = new ArrayList<String>();
        if (this.fromArray.contains(mkrLabel) && !this.excludeFromImport(mkrLabel)) {
            for (Map.Entry<String, String> e : this.tofromHash.entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                if (!val.equals(mkrLabel) || this.excludeFromImport(key)) continue;
                desc.add(key);
                desc.addAll(this.getDescendantsOf(key));
            }
        }
        return desc;
    }

    private boolean atLeastOneParseInTree(String mkrLabel) {
        boolean parse = false;
        if (this.toArray.contains(mkrLabel)) {
            for (Map.Entry<String, String> e : this.tofromHash.entrySet()) {
                String key = e.getKey();
                String val = e.getValue();
                String proc = this.procedureTypeHash.get(key);
                if (!val.equals(mkrLabel)) continue;
                if (proc != null && (proc.equals("Parse") || proc.equals("TimeSubdivision"))) {
                    return true;
                }
                return this.atLeastOneParseInTree(key);
            }
        }
        return parse;
    }

    private void addDescendantsToExcludedTiers(String parent) {
        for (Map.Entry<String, String> e : this.tofromHash.entrySet()) {
            String toKey = e.getKey();
            String fromVal = e.getValue();
            if (!fromVal.equals(parent)) continue;
            this.excludedTiers.add(toKey.substring(1));
            this.addDescendantsToExcludedTiers(toKey);
        }
    }

    public boolean isIPAtier(String name) {
        if (name.startsWith("\\")) {
            name = name.substring(1);
        }
        return this.tiersWithIPA.contains(name);
    }

    public boolean isUnicodeTier(String name) {
        if (this.allTiersUnicode) {
            return true;
        }
        if (name.startsWith("\\")) {
            name = name.substring(1);
        }
        return this.tiersWithUnicode.contains(name);
    }

    public boolean excludeFromImport(String name) {
        if (name.startsWith("\\")) {
            name = name.substring(1);
        }
        return this.excludedTiers.contains(name);
    }

    private void printStats() {
        String mkrLabel;
        int i;
        String val;
        String key;
        System.out.println("Root: " + this.interlinearRootMarker);
        System.out.println("\nTo-From hash...");
        for (Map.Entry<String, String> e : this.tofromHash.entrySet()) {
            key = e.getKey();
            val = e.getValue();
            System.out.println("Key-value: " + key + " - " + val);
        }
        System.out.println("\nProcedure hash...");
        for (Map.Entry<String, String> e : this.procedureTypeHash.entrySet()) {
            key = e.getKey();
            val = e.getValue();
            System.out.println("Key-value: " + key + " - " + val);
        }
        String rootMkr = "\\" + this.interlinearRootMarker;
        System.out.println("\nTo array...");
        for (i = 0; i < this.toArray.size(); ++i) {
            mkrLabel = this.toArray.get(i);
            if (mkrLabel.equals(rootMkr)) {
                System.out.println(mkrLabel + " (root)");
                continue;
            }
            System.out.println(mkrLabel);
        }
        System.out.println("\nFrom array...");
        for (i = 0; i < this.fromArray.size(); ++i) {
            mkrLabel = this.fromArray.get(i);
            if (mkrLabel.equals(rootMkr)) {
                System.out.println(mkrLabel + " (root)");
                continue;
            }
            System.out.println(mkrLabel);
        }
        System.out.println("\nExcluded array...");
        for (i = 0; i < this.excludedTiers.size(); ++i) {
            mkrLabel = this.excludedTiers.get(i);
            if (mkrLabel.equals(rootMkr)) {
                System.out.println(mkrLabel + " (root)");
                continue;
            }
            System.out.println(mkrLabel);
        }
    }

    public boolean isAllTiersUnicode() {
        return this.allTiersUnicode;
    }

    public void setAllTiersUnicode(boolean allTiersUnicode) {
        this.allTiersUnicode = allTiersUnicode;
    }
}

