/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Metrics;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;

public class Positioner {
    public static void calcHorizontalPositions(Metrics metrics) {
        TimeCodedTranscription tr = metrics.getTranscription();
        String[] visibleTiers = metrics.getInterlinearizer().getVisibleTiers();
        List<String> vTierList = Arrays.asList(visibleTiers);
        ArrayList<AbstractAnnotation> rootAnnotations = new ArrayList<AbstractAnnotation>();
        HashMap<Tier, Integer> positionPerTier = new HashMap<Tier, Integer>();
        int hBlockOffset = 0;
        List<TierImpl> topTiers = ((TranscriptionImpl)tr.getTranscription()).getTopTiers();
        for (TierImpl tierImpl : topTiers) {
            rootAnnotations.addAll(tierImpl.getAnnotations());
        }
        Collections.sort(rootAnnotations);
        for (Annotation annotation : rootAnnotations) {
            Positioner.positionAnnotation(annotation, hBlockOffset, vTierList, metrics, positionPerTier);
            hBlockOffset += metrics.getUsedWidth(annotation) + metrics.getInterlinearizer().getEmptySpace();
            positionPerTier.clear();
        }
    }

    private static void positionAnnotation(Annotation a, int blockOffset, List<String> vTierList, Metrics metrics, Map<Tier, Integer> posPerTier) {
        int parentHPos;
        Annotation parentAnn;
        Integer hPosInteger;
        int hPosition = 0;
        boolean annVisible = true;
        annVisible = vTierList.contains(a.getTier().getName());
        if (annVisible) {
            metrics.setVerticalPosition(a);
        }
        if ((hPosInteger = posPerTier.get(a.getTier())) != null) {
            hPosition = hPosInteger;
        }
        if ((parentAnn = a.getParentAnnotation()) != null && (parentHPos = metrics.getHorizontalPosition(parentAnn)) > hPosition + blockOffset) {
            hPosition = parentHPos - blockOffset;
        }
        metrics.setHorizontalPosition(a, blockOffset + hPosition);
        posPerTier.put(a.getTier(), hPosition += metrics.getUsedWidth(a) + metrics.getInterlinearizer().getEmptySpace());
        TimeCodedTranscription tr = metrics.getTranscription();
        List<? extends Annotation> childAnnots = null;
        childAnnots = tr.getChildAnnotationsOf(a);
        Collections.sort(childAnnots);
        for (Annotation annotation : childAnnots) {
            Positioner.positionAnnotation(annotation, blockOffset, vTierList, metrics, posPerTier);
        }
    }

    public static void wrap(Metrics metrics) {
        int horWrap = 0;
        int vertWrap = 0;
        int lastBlockStart = 0;
        int lastBlockIndex = 0;
        List<TierImpl> topTiers = ((TranscriptionImpl)metrics.getTranscription().getTranscription()).getTopTiers();
        boolean wrap = false;
        List<Annotation> orderedAnnots = metrics.getBlockWiseOrdered();
        for (int i = 0; i < orderedAnnots.size(); ++i) {
            Annotation a = orderedAnnots.get(i);
            TierImpl t = (TierImpl)a.getTier();
            wrap = false;
            if (topTiers.contains(t)) {
                lastBlockStart = metrics.getHorizontalPosition(a);
                lastBlockIndex = i;
                if (metrics.getInterlinearizer().getBlockWrapStyle() == 0 && i > 0) {
                    wrap = true;
                } else if (metrics.getInterlinearizer().getBlockWrapStyle() == 1 && metrics.getHorizontalPosition(a) + metrics.getUsedWidth(a) > metrics.getInterlinearizer().getWidth() - metrics.getLeftMargin()) {
                    if (i > 0) {
                        wrap = true;
                    }
                } else if (metrics.getHorizontalPosition(a) + metrics.getSize(a) <= metrics.getInterlinearizer().getWidth() - metrics.getLeftMargin()) continue;
            }
            if (t.hasParentTier() && topTiers.contains(t.getParentTier()) && t.getLinguisticType().getConstraints().getStereoType() == 4 || !Positioner.crossesPageWidth(a, metrics) && !wrap) continue;
            horWrap = -metrics.getHorizontalPosition(a);
            vertWrap = metrics.getCumulativeTierHeights() + metrics.getInterlinearizer().getBlockSpacing();
            int startAt = i;
            if (metrics.getHorizontalPosition(a) == lastBlockStart) {
                startAt = lastBlockIndex;
            }
            Positioner.wrap(metrics, horWrap, vertWrap, startAt);
            wrap = false;
        }
    }

    private static boolean crossesPageWidth(Annotation a, Metrics metrics) {
        return metrics.getHorizontalPosition(a) + metrics.getUsedWidth(a) > metrics.getInterlinearizer().getWidth() - metrics.getLeftMargin();
    }

    private static void wrap(Metrics metrics, int hWrap, int vWrap, int startingIndex) {
        List<Annotation> orderedAnnots = metrics.getBlockWiseOrdered();
        for (int i = startingIndex; i < orderedAnnots.size(); ++i) {
            Annotation a = orderedAnnots.get(i);
            metrics.setHorizontalPosition(a, metrics.getHorizontalPosition(a) + hWrap);
            metrics.setVerticalPosition(a, metrics.getVerticalPosition(a) + vWrap);
        }
    }

    public static void hideEmptyLines(Metrics metrics) {
        int currentVPos = 0;
        int currentVBlockBegin = 0;
        ArrayList<Integer> emptyLines = new ArrayList<Integer>();
        ArrayList<Integer> emptyLineHeights = new ArrayList<Integer>();
        int[] vPositionsInTemplate = metrics.getVPositionsInTemplate();
        int maxVerticalPosition = metrics.getMaxVerticalPosition();
        List<Integer> annotPositions = metrics.getPositionsOfNonEmptyTiers();
        while (currentVPos < maxVerticalPosition) {
            for (int i = 0; i < vPositionsInTemplate.length; ++i) {
                currentVPos = currentVBlockBegin + vPositionsInTemplate[i];
                Integer currentVPosInt = currentVPos;
                if (annotPositions.contains(currentVPosInt)) continue;
                emptyLines.add(currentVPosInt);
                int previousPos = 0;
                if (i > 0) {
                    previousPos = vPositionsInTemplate[i - 1];
                }
                emptyLineHeights.add(vPositionsInTemplate[i] - previousPos);
            }
            currentVBlockBegin = currentVPos + metrics.getInterlinearizer().getBlockSpacing() + metrics.getInterlinearizer().getLineSpacing();
        }
        if (emptyLines.size() == 0) {
            return;
        }
        Iterator emptyLineIter = emptyLines.iterator();
        Iterator lineHeightIter = emptyLineHeights.iterator();
        int nextEmptyLine = 0;
        if (emptyLineIter.hasNext()) {
            nextEmptyLine = (Integer)emptyLineIter.next();
        }
        int nextLineHeight = 0;
        if (lineHeightIter.hasNext()) {
            nextLineHeight = (Integer)lineHeightIter.next();
        }
        int correction = 0;
        List<Annotation> sortedAnnots = metrics.getVerticallyOrdered();
        for (Annotation a : sortedAnnots) {
            int vPos = metrics.getVerticalPosition(a);
            if (vPos > nextEmptyLine) {
                while (emptyLineIter.hasNext()) {
                    correction += nextLineHeight;
                    nextEmptyLine = (Integer)emptyLineIter.next();
                    nextLineHeight = (Integer)lineHeightIter.next();
                    if (vPos >= nextEmptyLine) continue;
                }
            }
            if (correction <= 0) continue;
            metrics.setVerticalPosition(a, vPos - correction);
        }
    }
}

