/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.subtitletext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecordComparator;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TimeSlotRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TimeSlotRecordComparator;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.subtitletext.SubtitleFormat;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.util.TimeFormatter;

public class SubtitleTextParser
extends Parser {
    private SubtitleDecoderInfo decoderInfo;
    private String lastParsedFile;
    private final String TS_ID_PREFIX = "ts";
    private final String ANN_PREFIX = "a";
    private final String TYPE_NAME = "imported-sub";
    private ArrayList<LingTypeRecord> lingTypeRecords = new ArrayList();
    private ArrayList<String> tierNames = new ArrayList();
    private ArrayList<String> timeOrder = new ArrayList();
    private ArrayList<TimeSlotRecord> timeSlots = new ArrayList();
    private HashMap<String, ArrayList<AnnotationRecord>> recordsPerTier = new HashMap();
    private String baseTierName = "Subtitle-Tier";
    private int annCount = 1;
    private int tsCount = 1;

    public SubtitleTextParser() {
    }

    public SubtitleTextParser(SubtitleDecoderInfo decoderInfo) {
        this();
        this.decoderInfo = decoderInfo;
        this.parse(decoderInfo.getSourceFilePath());
    }

    @Override
    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof SubtitleDecoderInfo) {
            this.decoderInfo = (SubtitleDecoderInfo)decoderInfo;
        }
    }

    protected void parse(String fileName) {
        if (fileName == null || fileName.equals(this.lastParsedFile)) {
            return;
        }
        this.lingTypeRecords.clear();
        this.tierNames.clear();
        this.timeOrder.clear();
        this.timeSlots.clear();
        this.recordsPerTier.clear();
        this.parseFile(fileName);
        this.lastParsedFile = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(String filePath) {
        if (filePath == null) {
            throw new NullPointerException("The file name is null");
        }
        if (filePath.startsWith("file:")) {
            filePath = filePath.substring(5);
        }
        BufferedReader bufRead = null;
        try {
            File sourceFile = new File(filePath);
            String charSet = "UTF-8";
            if (this.decoderInfo != null && this.decoderInfo.getFileEncoding() != null) {
                charSet = this.decoderInfo.getFileEncoding();
            }
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(sourceFile), charSet);
            bufRead = new BufferedReader(isr);
            if (this.decoderInfo != null) {
                SubtitleFormat format = this.decoderInfo.getFormat();
                switch (format) {
                    case SUBRIP: {
                        this.parseSubRip(bufRead);
                        break;
                    }
                    case AUDACITY_lABELS: {
                        this.parseAudacity(bufRead);
                        break;
                    }
                }
            } else {
                this.parseSubRip(bufRead);
            }
            this.sortRecords();
            Iterator<ArrayList<AnnotationRecord>> valIt = this.recordsPerTier.values().iterator();
            while (valIt.hasNext()) {
                this.correctOverlaps((List<AnnotationRecord>)valIt.next());
            }
            this.sortTimeSlots();
        }
        catch (FileNotFoundException fnfe) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning("Import failed: " + fnfe.getMessage());
            }
        }
        catch (IOException ioe) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning("Import failed: " + ioe.getMessage());
            }
        }
        catch (Throwable t) {
            if (ServerLogger.LOG.isLoggable(Level.WARNING)) {
                ServerLogger.LOG.warning("Import failed: " + t.getMessage());
            }
        }
        finally {
            if (bufRead != null) {
                try {
                    bufRead.close();
                }
                catch (Throwable fnfe) {}
            }
        }
    }

    private void parseSubRip(BufferedReader reader) throws IOException {
        String FROM_TO = "-->";
        String TAG_PAT = "[<{].+?[>}]";
        String line = null;
        long curBT = 0L;
        long curET = 0L;
        boolean inUnit = false;
        StringBuilder sb = new StringBuilder();
        String tierName = this.baseTierName;
        this.tierNames.add(tierName);
        this.recordsPerTier.put(tierName, new ArrayList());
        while ((line = reader.readLine()) != null) {
            if (line.isEmpty()) {
                if (inUnit && curET > curBT) {
                    this.addAnnotationRecord(tierName, curBT, curET, sb.toString());
                }
                inUnit = false;
                sb.delete(0, sb.length());
                continue;
            }
            if (line.indexOf("-->") > 0) {
                int index1 = line.indexOf("-->");
                String btStr = line.substring(0, index1).strip();
                String etStr = line.substring(index1 + "-->".length()).strip();
                int index2 = etStr.indexOf(32);
                if (index2 > -1) {
                    etStr = etStr.substring(0, index2);
                }
                btStr = btStr.replace(',', '.');
                etStr = etStr.replace(',', '.');
                curBT = TimeFormatter.toMilliSeconds(btStr);
                curET = TimeFormatter.toMilliSeconds(etStr);
                inUnit = true;
                continue;
            }
            if (!inUnit) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (this.decoderInfo.isRemoveHTML()) {
                String[] noTags = line.split("[<{].+?[>}]");
                for (int i = 0; i < noTags.length; ++i) {
                    sb.append(noTags[i]);
                }
                continue;
            }
            sb.append(line);
        }
        if (inUnit && curET > curBT && sb.length() > 0) {
            this.addAnnotationRecord(tierName, curBT, curET, sb.toString());
        }
    }

    private void parseAudacity(BufferedReader reader) throws IOException {
        String TAB = "\t";
        int tierCount = 1;
        this.baseTierName = "Label-Track-";
        String tierName = this.baseTierName + String.valueOf(tierCount++);
        this.tierNames.add(tierName);
        this.recordsPerTier.put(tierName, new ArrayList());
        int defDur = 1000;
        if (this.decoderInfo != null) {
            defDur = this.decoderInfo.getDefaultDuration();
        }
        long lastBT = -2L;
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] parts = line.split("\t");
            if (parts.length < 3) continue;
            long bt = TimeFormatter.toMilliSeconds(parts[0], TimeFormatter.TIME_FORMAT.SSMS);
            long et = TimeFormatter.toMilliSeconds(parts[1], TimeFormatter.TIME_FORMAT.SSMS);
            if (bt < lastBT) {
                tierName = this.baseTierName + String.valueOf(tierCount++);
                this.tierNames.add(tierName);
                this.recordsPerTier.put(tierName, new ArrayList());
            }
            if (bt <= -1L) continue;
            if (et <= bt) {
                et = bt + (long)defDur;
            }
            this.addAnnotationRecord(tierName, bt, et, parts[2]);
            lastBT = bt;
        }
    }

    private void addAnnotationRecord(String tierName, long bt, long et, String annValue) {
        AnnotationRecord annRec = new AnnotationRecord();
        annRec.setAnnotationType("alignable");
        annRec.setValue(annValue);
        annRec.setAnnotationId("a" + this.annCount++);
        TimeSlotRecord tsRec = new TimeSlotRecord(this.tsCount++, bt);
        annRec.setBeginTimeSlotRecord(tsRec);
        this.timeSlots.add(tsRec);
        tsRec = new TimeSlotRecord(this.tsCount++, et);
        annRec.setEndTimeSlotRecord(tsRec);
        this.timeSlots.add(tsRec);
        this.recordsPerTier.get(tierName).add(annRec);
    }

    private void sortRecords() {
        if (!this.recordsPerTier.isEmpty()) {
            AnnotationRecordComparator comp = new AnnotationRecordComparator(true);
            Iterator<ArrayList<AnnotationRecord>> valIt = this.recordsPerTier.values().iterator();
            while (valIt.hasNext()) {
                Collections.sort((List)valIt.next(), comp);
            }
        }
    }

    private void correctOverlaps(List<AnnotationRecord> annRecords) {
        ArrayList<AnnotationRecord> forRemoval = new ArrayList<AnnotationRecord>();
        for (int i = 0; i < annRecords.size() - 1; ++i) {
            AnnotationRecord annRec = annRecords.get(i);
            AnnotationRecord nextRec = annRecords.get(i + 1);
            TimeSlotRecord tsBRec1 = annRec.getBeginTimeSlotRecord();
            TimeSlotRecord tsERec1 = annRec.getEndTimeSlotRecord();
            TimeSlotRecord tsBRec2 = nextRec.getBeginTimeSlotRecord();
            TimeSlotRecord tsERec2 = nextRec.getEndTimeSlotRecord();
            if (tsBRec1.getValue() == tsBRec2.getValue()) {
                forRemoval.add(annRec);
                continue;
            }
            if (tsERec1.getValue() <= tsBRec2.getValue()) continue;
            tsERec1.setValue(tsBRec2.getValue());
        }
        if (!forRemoval.isEmpty()) {
            for (AnnotationRecord ar : forRemoval) {
                annRecords.remove(ar);
                this.timeSlots.remove(ar.getBeginTimeSlotRecord());
                this.timeSlots.remove(ar.getEndTimeSlotRecord());
            }
        }
    }

    private void sortTimeSlots() {
        if (this.timeSlots != null && this.timeSlots.size() > 1) {
            Collections.sort(this.timeSlots, new TimeSlotRecordComparator());
            for (int i = 0; i < this.timeSlots.size(); ++i) {
                TimeSlotRecord tsr = this.timeSlots.get(i);
                tsr.setId(i + 1);
            }
        }
    }

    @Override
    public List<MediaDescriptor> getMediaDescriptors(String fileName) {
        this.parse(fileName);
        return new ArrayList<MediaDescriptor>();
    }

    @Override
    public List<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        if (this.lingTypeRecords.size() == 0) {
            LingTypeRecord lt = new LingTypeRecord();
            lt.setLingTypeId("imported-sub");
            lt.setTimeAlignable("true");
            this.lingTypeRecords.add(lt);
        }
        return this.lingTypeRecords;
    }

    @Override
    public List<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        this.timeOrder.clear();
        for (int i = 0; i < this.timeSlots.size(); ++i) {
            TimeSlotRecord tsr = this.timeSlots.get(i);
            this.timeOrder.add("ts" + tsr.getId());
        }
        return this.timeOrder;
    }

    @Override
    public Map<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> tsMap = new HashMap<String, String>(this.timeSlots.size());
        for (int i = 0; i < this.timeSlots.size(); ++i) {
            TimeSlotRecord tsr = this.timeSlots.get(i);
            tsMap.put("ts" + tsr.getId(), Long.toString(tsr.getValue()));
        }
        return tsMap;
    }

    @Override
    public List<String> getTierNames(String fileName) {
        this.parse(fileName);
        return this.tierNames;
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        return "imported-sub";
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        return null;
    }

    @Override
    public List<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> records = this.recordsPerTier.get(tierName);
        if (records != null) {
            return records;
        }
        return new ArrayList<AnnotationRecord>();
    }
}

