/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.theme;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.theme.ThemeEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.theme.ThemeLine;
import mpi.eudico.server.corpora.util.ServerLogger;

public class ThemeEncoder
implements AnnotationDocEncoder {
    private final String NEW_LINE = "\r\n";
    private final String TAB = "\t";
    private final String B = "b";
    private final String E = "e";
    private final String COMMA = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo theEncoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        if (theTranscription == null) {
            ServerLogger.LOG.warning("The transcription is null");
            throw new IllegalArgumentException("The transcription is null.");
        }
        if (tierOrder == null || tierOrder.size() == 0) {
            ServerLogger.LOG.warning("No tiers have been specified for export");
            throw new IllegalArgumentException("No tiers specified for export");
        }
        if (path == null) {
            ServerLogger.LOG.warning("No file path for the TextGrid file has been specified");
            throw new IllegalArgumentException("No file path for the TextGrid file has been specified");
        }
        ThemeEncoderInfo encoderInfo = null;
        encoderInfo = theEncoderInfo instanceof ThemeEncoderInfo ? (ThemeEncoderInfo)theEncoderInfo : new ThemeEncoderInfo();
        ArrayList<ThemeLine> lineList = new ArrayList<ThemeLine>();
        LinkedHashMap vvtMap = new LinkedHashMap();
        vvtMap.put("A", new ArrayList());
        ArrayList<String> be = new ArrayList<String>(2);
        be.add("B");
        be.add("E");
        vvtMap.put("b_e", be);
        for (TierImpl ti : tierOrder) {
            Annotation ann;
            int i;
            String tierName = ti.getName();
            String partName = ti.getParticipant();
            ArrayList<String> tValues = new ArrayList<String>();
            List<AbstractAnnotation> annos = ti.getAnnotations();
            if (encoderInfo.isTierNameAsActor() || partName == null || partName.isEmpty()) {
                ((List)vvtMap.get("A")).add(tierName);
                vvtMap.put(tierName, tValues);
                for (i = 0; i < annos.size(); ++i) {
                    ann = annos.get(i);
                    lineList.add(new ThemeLine(ann.getBeginTimeBoundary(), "b", tierName, ann.getValue()));
                    lineList.add(new ThemeLine(ann.getEndTimeBoundary(), "e", tierName, ann.getValue()));
                    if (tValues.contains(ann.getValue())) continue;
                    tValues.add(ann.getValue());
                }
                continue;
            }
            if (!((List)vvtMap.get("A")).contains(partName)) {
                ((List)vvtMap.get("A")).add(partName);
            }
            if (!vvtMap.containsKey(partName)) {
                vvtMap.put(partName, tValues);
            }
            for (i = 0; i < annos.size(); ++i) {
                ann = annos.get(i);
                String codeValues = tierName + "," + ann.getValue();
                lineList.add(new ThemeLine(ann.getBeginTimeBoundary(), "b", partName, codeValues));
                lineList.add(new ThemeLine(ann.getEndTimeBoundary(), "e", partName, codeValues));
                if (tValues.contains(ann.getValue())) continue;
                tValues.add(ann.getValue());
            }
        }
        if (lineList.size() == 0) {
            ServerLogger.LOG.warning("There are no annotations to export");
            throw new IOException("There are no annotations to export.");
        }
        Collections.sort(lineList);
        OutputStreamWriter out = null;
        BufferedWriter writer = null;
        try {
            out = encoderInfo.getEncoding() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(path), encoderInfo.getEncoding()) : new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
            writer = new BufferedWriter(out);
            writer.write("Time");
            writer.write("\t");
            writer.write("Event");
            writer.write("\r\n");
            ThemeLine tl = (ThemeLine)lineList.get(0);
            writer.write(String.valueOf(tl.time));
            writer.write("\t");
            writer.write(":");
            writer.write("\r\n");
            for (ThemeLine thl : lineList) {
                writer.write(String.valueOf(thl.time));
                writer.write("\t");
                writer.write(thl.partName);
                writer.write(",");
                writer.write(thl.beginOrEnd);
                writer.write(",");
                writer.write(thl.label);
                writer.write("\r\n");
            }
            tl = (ThemeLine)lineList.get(lineList.size() - 1);
            writer.write(String.valueOf(tl.time));
            writer.write("\t");
            writer.write("&");
            writer.write("\r\n");
            writer.flush();
        }
        catch (UnsupportedEncodingException uee) {
            ServerLogger.LOG.warning("Encoding not supported: " + uee.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Throwable t) {
                ServerLogger.LOG.warning("Could not close the file writer: " + t.getMessage());
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable t) {
                ServerLogger.LOG.warning("Could not close the file: " + t.getMessage());
            }
        }
        int lastSep = path.lastIndexOf(File.separatorChar);
        String vvtPath = null;
        if (lastSep > 0) {
            vvtPath = path.substring(0, lastSep) + File.separator + "vvt.vvt";
        } else if (File.separatorChar != '/' && (lastSep = path.lastIndexOf(47)) > 0) {
            vvtPath = path.substring(0, lastSep) + "/vvt.vvt";
        }
        if (vvtPath != null) {
            OutputStreamWriter vvtOut = null;
            BufferedWriter vvtWriter = null;
            try {
                vvtOut = encoderInfo.getEncoding() != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(vvtPath), encoderInfo.getEncoding()) : new OutputStreamWriter((OutputStream)new FileOutputStream(vvtPath), "UTF-8");
                vvtWriter = new BufferedWriter(vvtOut);
                for (String key : vvtMap.keySet()) {
                    List tValues = (List)vvtMap.get(key);
                    if (tValues.size() > 0) {
                        vvtWriter.write(key);
                        vvtWriter.write("\r\n");
                        for (String s : tValues) {
                            vvtWriter.write("\t");
                            vvtWriter.write(s);
                            vvtWriter.write("\r\n");
                        }
                    }
                    vvtWriter.flush();
                }
            }
            catch (UnsupportedEncodingException uee) {
                ServerLogger.LOG.warning("Encoding not supported: " + uee.getMessage());
            }
            finally {
                try {
                    if (vvtWriter != null) {
                        vvtWriter.close();
                    }
                }
                catch (Throwable t) {
                    ServerLogger.LOG.warning("Could not close the vvt file writer: " + t.getMessage());
                }
                try {
                    if (vvtOut != null) {
                        vvtOut.close();
                    }
                }
                catch (Throwable t) {
                    ServerLogger.LOG.warning("Could not close the vvt file: " + t.getMessage());
                }
            }
        } else {
            ServerLogger.LOG.warning("Could not write the vvt file: unable to construct a file path.");
        }
    }
}

