/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;

public class SymbolicSubdivision
extends ConstraintImpl {
    @Override
    public int getStereoType() {
        return 3;
    }

    @Override
    public void forceTimes(long[] segment, TierImpl forTier) {
    }

    @Override
    public long getBeginTimeForRefAnnotation(RefAnnotation theAnnot) {
        long[] segment = new long[]{0L, 0L};
        int[] elmtsLeftAndRight = new int[]{0, 0};
        this.getSegmentForChainOf(theAnnot, segment, elmtsLeftAndRight);
        long duration = segment[1] - segment[0];
        double durationPerAnnot = (double)duration / (double)(elmtsLeftAndRight[0] + elmtsLeftAndRight[1] + 1);
        return segment[0] + (long)((double)elmtsLeftAndRight[0] * durationPerAnnot);
    }

    @Override
    public long getEndTimeForRefAnnotation(RefAnnotation theAnnot) {
        long[] segment = new long[]{0L, 0L};
        int[] elmtsLeftAndRight = new int[]{0, 0};
        this.getSegmentForChainOf(theAnnot, segment, elmtsLeftAndRight);
        long duration = segment[1] - segment[0];
        double durationPerAnnot = (double)duration / (double)(elmtsLeftAndRight[0] + elmtsLeftAndRight[1] + 1);
        return segment[0] + (long)((double)(elmtsLeftAndRight[0] + 1) * durationPerAnnot);
    }

    @Override
    public boolean supportsInsertion() {
        return true;
    }

    @Override
    public Annotation insertBefore(Annotation beforeAnn, TierImpl theTier) {
        Annotation parentAnn = ((RefAnnotation)beforeAnn).getReferences().get(0);
        RefAnnotation newAnn = new RefAnnotation(parentAnn, theTier);
        if (((RefAnnotation)beforeAnn).hasPrevious()) {
            RefAnnotation prevAnn = ((RefAnnotation)beforeAnn).getPrevious();
            prevAnn.setNext(newAnn);
        }
        newAnn.setNext((RefAnnotation)beforeAnn);
        theTier.addAnnotation(newAnn);
        return newAnn;
    }

    @Override
    public Annotation insertAfter(Annotation afterAnn, TierImpl theTier) {
        RefAnnotation afterRefAnn = (RefAnnotation)afterAnn;
        Annotation parentAnn = afterRefAnn.getReferences().get(0);
        RefAnnotation newAnn = new RefAnnotation(parentAnn, theTier);
        if (afterRefAnn.hasNext()) {
            RefAnnotation nextAnn = afterRefAnn.getNext();
            newAnn.setNext(nextAnn);
        }
        afterRefAnn.setNext(newAnn);
        theTier.addAnnotation(newAnn);
        return newAnn;
    }

    private void getSegmentForChainOf(RefAnnotation theAnnot, long[] segment, int[] elmtsLeftAndRight) {
        List<Annotation> refsOfLast;
        RefAnnotation firstOfChain = this.getFirstOfChain(theAnnot, elmtsLeftAndRight);
        RefAnnotation lastOfChain = this.getLastOfChain(theAnnot, elmtsLeftAndRight);
        List<Annotation> refsOfFirst = firstOfChain.getReferences();
        if (refsOfFirst.size() > 0) {
            Annotation beginRef = refsOfFirst.get(0);
            segment[0] = beginRef.getBeginTimeBoundary();
        }
        if ((refsOfLast = lastOfChain.getReferences()).size() > 0) {
            Annotation endRef = lastOfChain.getReferences().get(0);
            segment[1] = endRef.getEndTimeBoundary();
        }
    }

    private RefAnnotation getFirstOfChain(RefAnnotation theAnnot, int[] elmtsLeftAndRight) {
        RefAnnotation first = theAnnot;
        int leftElementCount = 0;
        while (first.hasPrevious()) {
            first = first.getPrevious();
            ++leftElementCount;
        }
        elmtsLeftAndRight[0] = leftElementCount;
        return first;
    }

    private RefAnnotation getLastOfChain(RefAnnotation theAnnot, int[] elmtsLeftAndRight) {
        RefAnnotation last = theAnnot;
        int rightElementCount = 0;
        while (last.hasNext()) {
            last = last.getNext();
            ++rightElementCount;
        }
        elmtsLeftAndRight[1] = rightElementCount;
        return last;
    }

    @Override
    public void detachAnnotation(Annotation theAnn, TierImpl theTier) {
        RefAnnotation a = (RefAnnotation)theAnn;
        RefAnnotation prev = a.getPrevious();
        RefAnnotation next = a.getNext();
        if (prev != null) {
            prev.setNext(next);
        } else if (next != null) {
            next.setPrevious(null);
        }
    }
}

