/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class MediaDescriptorUtility {
    public static boolean checkLinkStatus(MediaDescriptor md) {
        if (md == null || md.mediaURL == null || md.mediaURL.length() < 5) {
            return false;
        }
        if (FileUtility.isRemoteFile(md.mediaURL)) {
            return true;
        }
        int colonPos = md.mediaURL.indexOf(58);
        String fileName = md.mediaURL.substring(colonPos + 1);
        File file = new File(fileName = fileName.replace('\\', '/'));
        return file.exists();
    }

    public static MediaDescriptor createMediaDescriptor(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        String mediaURL = FileUtility.pathToURLString(filePath);
        if (mediaURL == null) {
            return null;
        }
        String mimeType = null;
        String mediaExtension = mediaURL.indexOf(46) > -1 ? mediaURL.substring(mediaURL.lastIndexOf(46) + 1) : mediaURL.substring(mediaURL.length() - 3);
        mimeType = MediaDescriptorUtility.mimeTypeForExtension(mediaExtension);
        MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
        return md;
    }

    public static List<MediaDescriptor> createMediaDescriptors(List<String> fileNames) {
        ArrayList<MediaDescriptor> mediaDescriptors = new ArrayList<MediaDescriptor>();
        if (fileNames == null) {
            return mediaDescriptors;
        }
        block0: for (int i = 0; i < fileNames.size(); ++i) {
            String path = fileNames.get(i);
            MediaDescriptor nextMD = MediaDescriptorUtility.createMediaDescriptor(path);
            if (nextMD == null) continue;
            for (int j = 0; j < mediaDescriptors.size(); ++j) {
                MediaDescriptor otherMD = (MediaDescriptor)mediaDescriptors.get(j);
                if (otherMD.mediaURL.equals(nextMD.mediaURL)) continue block0;
                if (nextMD.mimeType.equals("audio/x-wav") && MediaDescriptorUtility.isVideoType(otherMD) && FileUtility.sameNameIgnoreExtension(nextMD.mediaURL, otherMD.mediaURL)) {
                    nextMD.extractedFrom = otherMD.mediaURL;
                }
                if (!otherMD.mimeType.equals("audio/x-wav") || !MediaDescriptorUtility.isVideoType(nextMD) || !FileUtility.sameNameIgnoreExtension(nextMD.mediaURL, otherMD.mediaURL)) continue;
                otherMD.extractedFrom = nextMD.mediaURL;
            }
            mediaDescriptors.add(nextMD);
        }
        return mediaDescriptors;
    }

    public static String mimeTypeForExtension(String fileExtension) {
        if (fileExtension == null || fileExtension.length() < 2) {
            return "unknown";
        }
        String lowExt = fileExtension.toLowerCase();
        for (String element : FileExtension.MPEG_EXT) {
            if (!lowExt.equals(element)) continue;
            return "video/mpeg";
        }
        for (String element : FileExtension.MPEG4_EXT) {
            if (!lowExt.equals(element)) continue;
            return "video/mp4";
        }
        for (String element : FileExtension.WAV_EXT) {
            if (!lowExt.equals(element)) continue;
            return "audio/x-wav";
        }
        for (String element : FileExtension.QT_EXT) {
            if (!lowExt.equals(element)) continue;
            return "video/quicktime";
        }
        for (String element : FileExtension.MISC_AUDIO_EXT) {
            if (!lowExt.equals(element)) continue;
            return "audio/*";
        }
        for (String element : FileExtension.MISC_VIDEO_EXT) {
            if (!lowExt.equals(element)) continue;
            return "video/*";
        }
        for (String element : FileExtension.IMAGE_MEDIA_EXT) {
            if (!lowExt.equals(element)) continue;
            if (lowExt.equals("jpg") || lowExt.equals("jpeg")) {
                return "image/jpeg";
            }
            return "image/" + lowExt;
        }
        return "unknown";
    }

    public static String[] extensionForMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if (mimeType.equals("video/mpeg")) {
            return FileExtension.MPEG_EXT;
        }
        if (mimeType.equals("video/mp4")) {
            return FileExtension.MPEG4_EXT;
        }
        if (mimeType.equals("audio/x-wav")) {
            return FileExtension.WAV_EXT;
        }
        if (mimeType.equals("video/quicktime")) {
            return FileExtension.QT_EXT;
        }
        if (mimeType.equals("image/jpeg") || mimeType.startsWith("image")) {
            return FileExtension.IMAGE_MEDIA_EXT;
        }
        return null;
    }

    public static boolean isVideoType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.equals("video/*") || mimeType.equals("video/mpeg") || mimeType.equals("video/quicktime") || mimeType.equals("video/mp4");
    }

    public static boolean isVideoType(MediaDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        return MediaDescriptorUtility.isVideoType(descriptor.mimeType);
    }
}

