/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.util;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.multilangcv.LangInfo;

public class TranscriptionCompare {
    public List<String> getTierNamesOnlyInFirst(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (TierImpl t : tr1.getTiers()) {
            if (tr2.getTierWithId(t.getName()) != null) continue;
            uniqueNames.add(t.getName());
        }
        return uniqueNames;
    }

    public List<String> getTierNamesInBoth(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> sharedNames = new ArrayList<String>();
        for (TierImpl t : tr1.getTiers()) {
            if (tr2.getTierWithId(t.getName()) == null) continue;
            sharedNames.add(t.getName());
        }
        return sharedNames;
    }

    public List<String> getTierNamesWithDifferentTypeNames(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> diffTypeNames = new ArrayList<String>();
        for (TierImpl t : tr1.getTiers()) {
            TierImpl t2 = tr2.getTierWithId(t.getName());
            if (t2 == null) continue;
            LinguisticType lt1 = t.getLinguisticType();
            LinguisticType lt2 = t2.getLinguisticType();
            if (lt1.getLinguisticTypeName().equals(lt2.getLinguisticTypeName())) continue;
            diffTypeNames.add(t.getName());
        }
        return diffTypeNames;
    }

    public List<String> getTypeNamesOnlyInFirst(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (LinguisticType lt : tr1.getLinguisticTypes()) {
            if (tr2.getLinguisticTypeByName(lt.getLinguisticTypeName()) != null) continue;
            uniqueNames.add(lt.getLinguisticTypeName());
        }
        return uniqueNames;
    }

    public List<String> getTypeNamesInBoth(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> sharedNames = new ArrayList<String>();
        for (LinguisticType lt : tr1.getLinguisticTypes()) {
            if (tr2.getLinguisticTypeByName(lt.getLinguisticTypeName()) == null) continue;
            sharedNames.add(lt.getLinguisticTypeName());
        }
        return sharedNames;
    }

    public List<String> getTypeNamesWithDifferentConstraints(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> diffConstraints = new ArrayList<String>();
        for (LinguisticType lt : tr1.getLinguisticTypes()) {
            LinguisticType lt2 = tr2.getLinguisticTypeByName(lt.getLinguisticTypeName());
            if (lt2 == null) continue;
            if (lt.hasConstraints() && lt2.hasConstraints()) {
                if (lt.getConstraints().getStereoType() == lt2.getConstraints().getStereoType()) continue;
                diffConstraints.add(lt.getLinguisticTypeName());
                continue;
            }
            if (lt.hasConstraints() == lt2.hasConstraints()) continue;
            diffConstraints.add(lt.getLinguisticTypeName());
        }
        return diffConstraints;
    }

    public List<String> getCVNamesOnlyInFirst(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (ControlledVocabulary cv : tr1.getControlledVocabularies()) {
            if (tr2.getControlledVocabulary(cv.getName()) != null) continue;
            uniqueNames.add(cv.getName());
        }
        return uniqueNames;
    }

    public List<String> getCVNamesInBoth(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> sharedNames = new ArrayList<String>();
        for (ControlledVocabulary cv : tr1.getControlledVocabularies()) {
            if (tr2.getControlledVocabulary(cv.getName()) == null) continue;
            sharedNames.add(cv.getName());
        }
        return sharedNames;
    }

    public List<String> getLanguagesOnlyInFirst(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        ArrayList<String> firstList = new ArrayList<String>();
        for (TierImpl t1 : tr1.getTiers()) {
            String lref = t1.getLangRef();
            if (lref == null) continue;
            firstList.add(lref);
        }
        for (ControlledVocabulary cv1 : tr1.getControlledVocabularies()) {
            for (int i = 0; i < cv1.getNumberOfLanguages(); ++i) {
                firstList.add(cv1.getLanguageId(i));
            }
        }
        if (firstList != null) {
            ArrayList<String> secList = new ArrayList<String>();
            for (TierImpl t : tr2.getTiers()) {
                String lref = t.getLangRef();
                if (lref == null) continue;
                secList.add(lref);
            }
            for (ControlledVocabulary cv2 : tr2.getControlledVocabularies()) {
                for (int i = 0; i < cv2.getNumberOfLanguages(); ++i) {
                    secList.add(cv2.getLanguageId(i));
                }
            }
            for (String s : firstList) {
                if (secList.contains(s) || uniqueNames.contains(s)) continue;
                uniqueNames.add(s);
            }
        }
        return uniqueNames;
    }

    public List<String> getLanguagesInBoth(TranscriptionImpl tr1, TranscriptionImpl tr2) {
        ArrayList<String> sharedNames = new ArrayList<String>();
        ArrayList<String> firstList = new ArrayList<String>();
        for (TierImpl t1 : tr1.getTiers()) {
            String lref = t1.getLangRef();
            if (lref == null) continue;
            firstList.add(lref);
        }
        for (ControlledVocabulary cv1 : tr1.getControlledVocabularies()) {
            for (int i = 0; i < cv1.getNumberOfLanguages(); ++i) {
                firstList.add(cv1.getLanguageId(i));
            }
        }
        if (firstList != null) {
            ArrayList<String> secList = new ArrayList<String>();
            for (TierImpl t : tr2.getTiers()) {
                String lref = t.getLangRef();
                if (lref == null) continue;
                secList.add(lref);
            }
            for (ControlledVocabulary cv2 : tr2.getControlledVocabularies()) {
                for (int i = 0; i < cv2.getNumberOfLanguages(); ++i) {
                    secList.add(cv2.getLanguageId(i));
                }
            }
            for (String s : firstList) {
                if (!secList.contains(s) || sharedNames.contains(s)) continue;
                sharedNames.add(s);
            }
        }
        return sharedNames;
    }

    public boolean sameTierProperty(TierImpl t1, TierImpl t2, TierImpl.ValueGetter propGetter) {
        return propGetter.getSortValue(t1).equals(propGetter.getSortValue(t2));
    }

    public boolean sameParentTierName(TierImpl t1, TierImpl t2) {
        if (!t1.hasParentTier() && !t2.hasParentTier()) {
            return true;
        }
        if (t1.hasParentTier() ^ t2.hasParentTier()) {
            return false;
        }
        return t1.getParentTier().getName().equals(t2.getParentTier().getName());
    }

    public boolean sameTypeProperty(LinguisticType lt1, LinguisticType lt2, LinguisticType.PropKey propKey) {
        switch (propKey) {
            case ID: 
            case NAME: {
                return lt1.getLinguisticTypeName().equals(lt2.getLinguisticTypeName());
            }
            case CONSTRAINT: {
                return this.sameStereoType(lt1, lt2);
            }
            case CV_NAME: {
                if (lt1.isUsingControlledVocabulary() && lt2.isUsingControlledVocabulary()) {
                    return lt1.getControlledVocabularyName().equals(lt2.getControlledVocabularyName());
                }
                return !lt1.isUsingControlledVocabulary() && !lt2.isUsingControlledVocabulary();
            }
            case DC: {
                if (lt1.getDataCategory() == null && lt2.getDataCategory() == null) {
                    return true;
                }
                if (lt1.getDataCategory() == null ^ lt2.getDataCategory() == null) {
                    return false;
                }
                return lt1.getDataCategory().equals(lt2.getDataCategory());
            }
            case LEX_BUNDLE: {
                if (lt1.getLexiconQueryBundle() == null && lt2.getLexiconQueryBundle() == null) {
                    return true;
                }
                if (lt1.getLexiconQueryBundle() == null ^ lt2.getLexiconQueryBundle() == null) {
                    return false;
                }
                return lt1.getLexiconQueryBundle().equals(lt2.getLexiconQueryBundle());
            }
            case LEX_FIELD: {
                if (lt1.getLexiconQueryBundle() != null && lt2.getLexiconQueryBundle() != null) {
                    if (lt1.getLexiconQueryBundle().getFldId() != null) {
                        return lt1.getLexiconQueryBundle().getFldId().compareTo(lt2.getLexiconQueryBundle().getFldId()) == 0;
                    }
                    if (lt2.getLexiconQueryBundle().getFldId() == null) {
                        return true;
                    }
                } else if (lt1.getLexiconQueryBundle() == null && lt2.getLexiconQueryBundle() == null) {
                    return true;
                }
                return false;
            }
            case LEX_LINK: {
                if (lt1.getLexiconQueryBundle() != null && lt2.getLexiconQueryBundle() != null) {
                    if (lt1.getLexiconQueryBundle().getLink() != null) {
                        return lt1.getLexiconQueryBundle().getLink().compareNameAndLexId(lt2.getLexiconQueryBundle().getLink()) == 0;
                    }
                    if (lt2.getLexiconQueryBundle().getLink() == null) {
                        return true;
                    }
                } else if (lt1.getLexiconQueryBundle() == null && lt2.getLexiconQueryBundle() == null) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public boolean sameStereoType(LinguisticType lt1, LinguisticType lt2) {
        if (!lt1.hasConstraints() && !lt2.hasConstraints()) {
            return true;
        }
        if (lt1.hasConstraints() ^ lt2.hasConstraints()) {
            return false;
        }
        return lt1.getConstraints().getStereoType() == lt2.getConstraints().getStereoType();
    }

    public boolean sameCVProperty(ControlledVocabulary cv1, ControlledVocabulary cv2, BasicControlledVocabulary.PropKey propKey) {
        switch (propKey) {
            case NAME: {
                return cv1.getName().equals(cv2.getName());
            }
            case DESCRIPTION: {
                String lid;
                int i;
                for (i = 0; i < cv1.getNumberOfLanguages(); ++i) {
                    lid = cv1.getLanguageId(i);
                    int index2 = cv2.getIndexOfLanguage(lid);
                    if (!(cv1.getDescription(i) != null ? index2 < 0 || !cv1.getDescription(i).equals(cv2.getDescription(index2)) : index2 > -1 && cv2.getDescription(index2) != null)) continue;
                    return false;
                }
                for (i = 0; i < cv2.getNumberOfLanguages(); ++i) {
                    lid = cv2.getLanguageId(i);
                    int index1 = cv1.getIndexOfLanguage(lid);
                    if (!(cv2.getDescription(i) != null ? index1 < 0 || !cv2.getDescription(i).equals(cv1.getDescription(index1)) : index1 > -1 && cv1.getDescription(index1) != null)) continue;
                    return false;
                }
                return true;
            }
            case NUM_ENTRIES: {
                return cv1.size() == cv2.size();
            }
            case NUM_LANGUAGES: {
                return cv1.getNumberOfLanguages() == cv2.getNumberOfLanguages();
            }
            case EXTERNAL_REF: {
                if (cv1 instanceof ExternalCV) {
                    if (cv2 instanceof ExternalCV) {
                        ExternalReference er1 = ((ExternalCV)cv1).getExternalRef();
                        ExternalReference er2 = ((ExternalCV)cv2).getExternalRef();
                        return er1.getReferenceType() == er2.getReferenceType() && er1.getValue().equals(er2.getValue());
                    }
                    return false;
                }
                return !(cv2 instanceof ExternalCV);
            }
        }
        return false;
    }

    public boolean sameExternalReference(ExternalReference er1, ExternalReference er2) {
        return er1.getReferenceType() == er2.getReferenceType() && er1.getValue().equals(er2.getValue());
    }

    public boolean sameLanguage(LangInfo li1, LangInfo li2) {
        return li1.getId().equals(li2.getId());
    }

    public boolean sameLexiconLink(LexiconLink ll1, LexiconLink ll2) {
        return ll1.compareNameAndLexId(ll2) == 0;
    }

    public boolean sameLexiconLinkProperty(LexiconLink ll1, LexiconLink ll2, LexiconLink.PropKey propKey) {
        switch (propKey) {
            case NAME: {
                return ll1.getName().equals(ll2.getName());
            }
            case LEXICON_CLIENT_TYPE: {
                if (ll1.getLexSrvcClntType() != null) {
                    return ll1.getLexSrvcClntType().equals(ll2.getLexSrvcClntType());
                }
                return ll2.getLexSrvcClntType() == null;
            }
            case LEXICON_IDENTIFICATION: {
                if (ll1.getLexId() != null && ll2.getLexId() != null) {
                    if (ll1.getName() != null && ll2.getName() != null) {
                        return ll1.getLexId().getName().equals(ll2.getLexId().getName());
                    }
                    if (ll1.getLexId().getId() == null) break;
                    return ll1.getLexId().getId().equals(ll2.getLexId().getId());
                }
                if (ll1.getLexId() != null || ll2.getLexId() != null) break;
                return true;
            }
            case URL: {
                if (ll1.getUrl() != null && ll1.getUrl().equals(ll2.getUrl())) {
                    return true;
                }
                if (ll1.getUrl() != null || ll2.getUrl() != null) break;
                return true;
            }
        }
        return false;
    }

    public boolean sameLicense(LicenseRecord lr1, LicenseRecord lr2) {
        boolean urlEq = lr1.getUrl() == null && lr2.getUrl() == null || lr1.getUrl() != null && lr1.getUrl().equals(lr2.getUrl());
        boolean txtEq = lr1.getText() == null && lr2.getText() == null || lr1.getText() != null && lr1.getText().equals(lr2.getText());
        return urlEq && txtEq;
    }
}

