/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.lexicon;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class EntryElement {
    protected boolean isField;
    protected String name;
    protected String value;
    protected List<EntryElement> elements;
    protected EntryElement parent;

    public EntryElement(String name, EntryElement parent) {
        this.parent = parent;
        this.isField = true;
        this.name = name;
        this.value = "";
        this.elements = new ArrayList<EntryElement>();
    }

    public void addElement(EntryElement element) {
        this.elements.add(element);
        this.isField = false;
    }

    public boolean isField() {
        return this.isField;
    }

    public void setField(boolean isField) {
        this.isField = isField;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<EntryElement> getElements() {
        return this.elements;
    }

    public void setElements(List<EntryElement> elements) {
        this.elements = elements;
    }

    public EntryElement getParent() {
        return this.parent;
    }

    public void setParent(EntryElement parent) {
        this.parent = parent;
    }

    public String toString() {
        String str = "<html><b>" + this.name + "</b>";
        if (this.value != null && !this.value.equals("")) {
            try {
                URL url = new URL(this.value);
                str = str + ": <i><a href=\"" + this.value + "\">" + this.value + "</a></i>";
            }
            catch (MalformedURLException mue) {
                str = str + ": <i>" + this.value + "</i>";
            }
        }
        str = str + "</html>";
        return str;
    }
}

