/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.SimpleCVEntry;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.RecentLanguages;

public class BasicControlledVocabulary
implements Iterable<CVEntry>,
Cloneable {
    public static final int MOVE_TO_TOP = 0;
    public static final int MOVE_UP = 1;
    public static final int MOVE_DOWN = 2;
    public static final int MOVE_TO_BOTTOM = 3;
    public static final String DEFAULT_LANGUAGE_ID = "und";
    public static final String DEFAULT_LANGUAGE_DEF = "http://cdb.iso.org/lg/CDB-00130975-001";
    public static final String DEFAULT_LANGUAGE_LABEL = "undetermined (und)";
    protected List<CVEntry> entries;
    private String name;
    protected boolean initMode;
    private List<CVLangInfo> languages;
    private int defaultLanguageIndex;
    private int numberOfLanguages;
    private String preferenceLanguage;
    protected Map<String, CVEntry> idToEntry;
    private static final CVLangInfo defaultLangInfo = new CVLangInfo("und", "http://cdb.iso.org/lg/CDB-00130975-001", "undetermined (und)", "");

    public BasicControlledVocabulary(String name, String description) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name can not be null or empty.");
        }
        this.name = name;
        this.defaultLanguageIndex = 0;
        this.numberOfLanguages = 1;
        this.entries = new ArrayList<CVEntry>();
        this.languages = new ArrayList<CVLangInfo>(2);
        this.idToEntry = new HashMap<String, CVEntry>();
        this.addLanguage(new CVLangInfo(defaultLangInfo));
        this.setDescription(0, description);
    }

    public BasicControlledVocabulary(String name) {
        this(name, "");
    }

    public BasicControlledVocabulary(BasicControlledVocabulary orig) {
        this.clone(orig);
    }

    public void cloneStructure(BasicControlledVocabulary orig) {
        this.setName(orig.getName());
        this.entries.clear();
        this.languages.clear();
        this.numberOfLanguages = 0;
        int nLangs = orig.getNumberOfLanguages();
        for (int i = 0; i < nLangs; ++i) {
            CVLangInfo li = new CVLangInfo(orig.languages.get(i));
            this.addLanguage(li);
        }
    }

    public void cloneEntries(BasicControlledVocabulary orig) {
        this.initMode = true;
        this.entries.clear();
        for (CVEntry e : orig) {
            this.addEntry(new CVEntry(this, e));
        }
        this.initMode = false;
    }

    public void clone(BasicControlledVocabulary orig) {
        this.cloneStructure(orig);
        this.cloneEntries(orig);
    }

    public BasicControlledVocabulary clone() {
        return new BasicControlledVocabulary(this);
    }

    @Deprecated
    public void setDescription(String description) {
        this.setDescription(this.defaultLanguageIndex, description);
    }

    @Deprecated
    public String getDescription() {
        return this.getDescription(this.defaultLanguageIndex);
    }

    public void setDescription(int languageIndex, String description) {
        this.languages.get(languageIndex).setDescription(description);
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public String getLanguageLabel(int languageIndex) {
        return this.languages.get(languageIndex).getLabel();
    }

    public String getDescription(int languageIndex) {
        return this.languages.get(languageIndex).getDescription();
    }

    public CVEntry[] getEntries() {
        return this.entries.toArray(new CVEntry[0]);
    }

    public SimpleCVEntry[] getSimpleEntries(int langIndex) {
        int size = this.entries.size();
        SimpleCVEntry[] simple = new SimpleCVEntry[size];
        for (int i = 0; i < size; ++i) {
            simple[i] = new SimpleCVEntry(this.entries.get(i), langIndex);
        }
        return simple;
    }

    @Override
    public Iterator<CVEntry> iterator() {
        return Collections.unmodifiableList(this.entries).iterator();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public CVEntry[] getEntriesSortedByAlphabet(int langIndex) {
        CVEntry[] allEntries = this.getEntries();
        Arrays.sort(allEntries, new CVEntry.CVELangComparator(langIndex));
        this.entries.clear();
        for (int i = 0; i < allEntries.length; ++i) {
            this.entries.add(allEntries[i]);
        }
        return allEntries;
    }

    public CVEntry[] getEntriesSortedByReverseAlphabetOrder(int langIndex) {
        CVEntry[] allEntries = this.getEntries();
        Arrays.sort(allEntries, Collections.reverseOrder(new CVEntry.CVELangComparator(langIndex)));
        this.entries.clear();
        for (int i = 0; i < allEntries.length; ++i) {
            this.entries.add(allEntries[i]);
        }
        return allEntries;
    }

    public String[] getValuesSortedByAlphabet(int langIndex) {
        Object[] values = this.getEntryValues(langIndex);
        Arrays.sort(values);
        return values;
    }

    protected String[] getEntryValues(int langIndex) {
        String[] values = new String[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            values[i] = this.entries.get(i).getValue(langIndex);
        }
        return values;
    }

    public Iterable<String> getValuesIterable(int index) {
        return new ValuesIterable(index);
    }

    public CVEntry getEntryWithValue(String value) {
        return this.getEntryWithValue(this.defaultLanguageIndex, value);
    }

    public CVEntry getEntryWithValue(int languageIndex, String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        for (CVEntry entry : this.entries) {
            if (!entry.getValue(languageIndex).equals(value)) continue;
            return entry;
        }
        return null;
    }

    public CVEntry getEntrybyId(String entryId) {
        if (entryId == null) {
            return null;
        }
        return this.idToEntry.get(entryId);
    }

    public void setInitMode(boolean initMode) {
        this.initMode = initMode;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("The name can not be null or empty.");
        }
        this.name = name;
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public String getName() {
        return this.name;
    }

    public void addAll(CVEntry[] entries) {
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                this.addEntry(entries[i]);
            }
        }
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public boolean addEntry(CVEntry entry) {
        if (entry == null) {
            return false;
        }
        assert (entry.getParent() == this);
        for (int i = 0; i < this.numberOfLanguages; ++i) {
            String le = entry.getValue(i);
            if (le.isEmpty() || this.getEntryWithValue(i, le) == null) continue;
            return false;
        }
        if (entry.getId().isEmpty()) {
            this.ensureIdIsUnique(entry);
        }
        this.entries.add(entry);
        if (!this.initMode) {
            this.handleModified();
        }
        return true;
    }

    public int getDefaultLanguageIndex() {
        return this.defaultLanguageIndex;
    }

    protected void setDefaultLanguageIndex(int defaultLanguageIndex) {
        this.defaultLanguageIndex = defaultLanguageIndex;
    }

    public String getPreferenceLanguage() {
        return this.preferenceLanguage;
    }

    public void setPreferenceLanguage(String language) {
        this.preferenceLanguage = language;
        this.languagesChanged();
    }

    public int getNumberOfLanguages() {
        return this.numberOfLanguages;
    }

    private void setNumberOfLanguages(int numberOfLanguages) {
        assert (this.numberOfLanguages == numberOfLanguages || this.entries.isEmpty());
        assert (numberOfLanguages > 0);
        this.numberOfLanguages = numberOfLanguages;
    }

    public void clear() {
        this.entries.clear();
        this.idToEntry.clear();
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public boolean contains(CVEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.entries.contains(entry);
    }

    public boolean containsValue(int index, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).getValue(index).equals(value)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BasicControlledVocabulary)) {
            return false;
        }
        BasicControlledVocabulary other = (BasicControlledVocabulary)obj;
        if (!this.name.equals(other.getName())) {
            return false;
        }
        if (this.numberOfLanguages != other.getNumberOfLanguages()) {
            return false;
        }
        for (int i = 0; i < this.numberOfLanguages; ++i) {
            CVLangInfo cvlio;
            CVLangInfo cvli = this.languages.get(i);
            if (!cvli.valueEquals(cvlio = (CVLangInfo)other.getLangInfo(i))) {
                return false;
            }
            if (cvli.getDescription() != null && !cvli.getDescription().equals(cvlio.getDescription())) {
                return false;
            }
            if (cvli.getDescription() != null || cvlio.getDescription() == null) continue;
            return false;
        }
        boolean entriesEqual = true;
        block1: for (int i = 0; i < this.entries.size(); ++i) {
            CVEntry entry = this.entries.get(i);
            for (CVEntry otherEntry : other) {
                if (!entry.equals(otherEntry)) continue;
                continue block1;
            }
            entriesEqual = false;
            break;
        }
        return entriesEqual;
    }

    public int hashCode() {
        return 1;
    }

    public void modifyEntryValue(CVEntry entry, int langIndex, String value) {
        if (entry == null || value == null) {
            return;
        }
        if (!this.entries.contains(entry)) {
            return;
        }
        if (this.containsValue(langIndex, value)) {
            return;
        }
        String origId = entry.getId();
        CVEntry newEntry = new CVEntry(entry);
        newEntry.setValue(langIndex, value);
        int index = this.entries.indexOf(entry);
        this.entries.set(index, newEntry);
        this.removeId(entry);
        newEntry.setId(origId);
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public void moveEntries(CVEntry[] entryArray, int moveType) {
        switch (moveType) {
            case 0: {
                this.moveToTop(entryArray);
                break;
            }
            case 1: {
                this.moveUp(entryArray);
                break;
            }
            case 2: {
                this.moveDown(entryArray);
                break;
            }
            case 3: {
                this.moveToBottom(entryArray);
                break;
            }
        }
    }

    public boolean removeEntries(CVEntry[] entryArray) {
        if (entryArray == null) {
            return false;
        }
        boolean removed = false;
        for (CVEntry entry : entryArray) {
            boolean b = this.entries.remove(entry);
            this.idToEntry.remove(entry.getId());
            if (!b) continue;
            removed = true;
        }
        if (removed && !this.initMode) {
            this.handleModified();
        }
        return removed;
    }

    public boolean removeEntry(CVEntry entry) {
        boolean b = this.entries.remove(entry);
        this.idToEntry.remove(entry.getId());
        if (b && !this.initMode) {
            this.handleModified();
        }
        return b;
    }

    public void removeValue(int langIndex, String value) {
        if (value == null) {
            return;
        }
        CVEntry entry = null;
        boolean removed = false;
        for (int i = 0; i < this.entries.size(); ++i) {
            entry = this.entries.get(i);
            if (!entry.getValue(langIndex).equals(value)) continue;
            this.entries.remove(i);
            removed = true;
            break;
        }
        if (removed) {
            this.idToEntry.remove(entry.getId());
            if (!this.initMode) {
                this.handleModified();
            }
        }
    }

    public void replaceAll(CVEntry[] newEntries) {
        if (newEntries == null) {
            return;
        }
        this.entries.clear();
        this.idToEntry.clear();
        this.addAll(newEntries);
        if (!this.initMode) {
            this.handleModified();
        }
    }

    public boolean replaceEntry(CVEntry oldEntry, CVEntry newEntry) {
        if (oldEntry == null || newEntry == null) {
            return false;
        }
        int index = this.entries.indexOf(oldEntry);
        if (index == -1) {
            return false;
        }
        if (this.entries.get(index) != oldEntry) {
            // empty if block
        }
        this.entries.set(index, newEntry);
        newEntry.internalSetId(oldEntry.getId());
        this.replaceInIndex(oldEntry, newEntry);
        if (!this.initMode) {
            this.handleModified();
        }
        return true;
    }

    protected void replaceInIndex(CVEntry oldEntry, CVEntry newEntry) {
        this.idToEntry.remove(oldEntry.getId());
        this.idToEntry.put(newEntry.getId(), newEntry);
    }

    public String toString() {
        return this.name;
    }

    protected void handleModified() {
    }

    protected void moveToTop(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = 0; i < entryArray.length; ++i) {
            entry = entryArray[i];
            boolean removed = this.entries.remove(entry);
            if (!removed) continue;
            moved = true;
            this.entries.add(i, entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }

    private void moveDown(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = entryArray.length - 1; i >= 0; --i) {
            boolean removed;
            entry = entryArray[i];
            int curIndex = this.entries.indexOf(entry);
            if (curIndex < 0 || curIndex >= this.entries.size() - 1 || !(removed = this.entries.remove(entry))) continue;
            moved = true;
            this.entries.add(curIndex + 1, entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }

    private void moveToBottom(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = 0; i < entryArray.length; ++i) {
            entry = entryArray[i];
            boolean removed = this.entries.remove(entry);
            if (!removed) continue;
            moved = true;
            this.entries.add(entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }

    private void moveUp(CVEntry[] entryArray) {
        if (entryArray == null || entryArray.length == 0) {
            return;
        }
        CVEntry entry = null;
        boolean moved = false;
        for (int i = 0; i < entryArray.length; ++i) {
            boolean removed;
            entry = entryArray[i];
            int curIndex = this.entries.indexOf(entry);
            if (curIndex <= 0 || !(removed = this.entries.remove(entry))) continue;
            moved = true;
            this.entries.add(curIndex - 1, entry);
        }
        if (moved && !this.initMode) {
            this.handleModified();
        }
    }

    protected boolean ensureIdIsUnique(CVEntry entry) {
        String newid;
        String id = entry.getId();
        if ((id == null || id.isEmpty() || this.idToEntry.containsKey(id)) && !this.idToEntry.containsKey(newid = "cveid_" + UUID.randomUUID())) {
            entry.internalSetId(newid);
            this.idToEntry.put(newid, entry);
            return false;
        }
        return true;
    }

    protected void removeId(CVEntry entry) {
        String id = entry.getId();
        if (id != null) {
            CVEntry toremove = this.idToEntry.get(id);
            if (toremove != entry) {
                System.err.printf("Entry associated with id '%s' (%s) is not this Entry (%s)!\n", id, toremove, entry.toString());
            }
            this.idToEntry.remove(id);
        }
    }

    protected void addId(CVEntry entry) {
        if (this.ensureIdIsUnique(entry)) {
            this.idToEntry.put(entry.getId(), entry);
        }
    }

    public int addLanguage(String id, String longId, String label) {
        CVLangInfo li = new CVLangInfo(id, longId, label, "");
        return this.addLanguage(li);
    }

    public int addLanguage(LangInfo li) {
        CVLangInfo cvli = new CVLangInfo(li);
        return this.addLanguage(cvli);
    }

    private int addLanguage(CVLangInfo li) {
        if (!this.checkIds(-1, li.getId(), li.getLongId())) {
            return -1;
        }
        if (!RecentLanguages.getInstance().canAddLanguage(li)) {
            return -1;
        }
        if (this.languages.size() == 1 && this.languages.get(0).valueEquals(defaultLangInfo)) {
            this.languages.set(0, li);
        } else {
            this.languages.add(li);
        }
        if (this.languages.size() > this.numberOfLanguages) {
            this.setNumberOfLanguages(this.languages.size());
        }
        if (!this.initMode) {
            this.handleModified();
        }
        RecentLanguages.getInstance().addRecentLanguage(li);
        this.languagesChanged();
        return this.languages.size() - 1;
    }

    private boolean checkIds(int oldIndex, String id, String longId) {
        if (!id.matches("^[a-z][a-z0-9]*$")) {
            return false;
        }
        if (longId.isEmpty()) {
            return false;
        }
        if (this.languages.size() > 0) {
            for (int i = 0; i < this.numberOfLanguages; ++i) {
                CVLangInfo li;
                if (i == oldIndex || !(li = this.languages.get(i)).getId().equals(id) && !li.getLongId().equals(longId)) continue;
                return false;
            }
        }
        return true;
    }

    public void removeLanguage(int index) {
        if (index >= 0 && index < this.languages.size() && this.languages.size() > 1) {
            if (index == this.defaultLanguageIndex) {
                this.setDefaultLanguageIndex(0);
            }
            this.languages.remove(index);
            for (CVEntry e : this.entries) {
                e.removeLanguage(index);
            }
            --this.numberOfLanguages;
            if (!this.initMode) {
                this.handleModified();
            }
            this.languagesChanged();
        }
    }

    public boolean setLanguageIds(int index, String id, String longId, String label) {
        if (!this.checkIds(index, id, longId)) {
            return false;
        }
        String description = this.languages.get(index).getDescription();
        CVLangInfo newInfo = new CVLangInfo(id, longId, label, description);
        if (!RecentLanguages.getInstance().canAddLanguage(newInfo)) {
            return false;
        }
        this.languages.set(index, newInfo);
        if (!this.initMode) {
            this.handleModified();
        }
        RecentLanguages.getInstance().addRecentLanguage(newInfo);
        this.languagesChanged();
        return true;
    }

    public LangInfo getLangInfo(int index) {
        return this.languages.get(index);
    }

    public String getLanguageId(int index) {
        return this.languages.get(index).getId();
    }

    public String getLongLanguageId(int index) {
        return this.languages.get(index).getLongId();
    }

    public int getIndexOfLanguage(String id) {
        for (int i = 0; i < this.languages.size(); ++i) {
            if (!this.languages.get(i).getId().equals(id) && !this.languages.get(i).getLongId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public void languagesChanged() {
        int index = this.getIndexOfLanguage(this.preferenceLanguage);
        if (index >= 0) {
            this.setDefaultLanguageIndex(index);
        }
    }

    private static class CVLangInfo
    extends LangInfo {
        private String description;

        public CVLangInfo(String id, String longId, String label, String description) {
            super(id, longId, label);
            this.description = description;
        }

        public CVLangInfo(CVLangInfo other) {
            super(other);
            this.description = other.description;
        }

        public CVLangInfo(LangInfo other) {
            super(other);
            this.description = "";
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    protected class ValuesIterable
    implements Iterable<String> {
        private int index;

        public ValuesIterable(int index) {
            this.index = index;
        }

        @Override
        public Iterator<String> iterator() {
            return new ValuesIterator(this.index);
        }
    }

    protected class ValuesIterator
    implements Iterator<String> {
        private int index;
        private int pos;

        public ValuesIterator(int index) {
            this.index = index;
            this.pos = 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < BasicControlledVocabulary.this.entries.size();
        }

        @Override
        public String next() {
            return BasicControlledVocabulary.this.entries.get(this.pos++).getValue(this.index);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum PropKey {
        NAME,
        DESCRIPTION,
        NUM_ENTRIES,
        NUM_LANGUAGES,
        EXTERNAL_REF;

    }
}

