/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DebugInputStream
extends FilterInputStream {
    public DebugInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        System.out.printf("read: 0x%02x '%c'\n", b, b);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        System.out.printf("read: %d bytes: ", result);
        for (int i = 0; i < result; ++i) {
            System.out.printf("%c", b[off + i]);
        }
        System.out.print("\n");
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        System.out.printf("skip: %d\n", n);
        return super.skip(n);
    }

    @Override
    public synchronized void mark(int readlimit) {
        System.out.printf("mark: %d\n", readlimit);
        super.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        System.out.printf("reset\n", new Object[0]);
        super.reset();
    }

    @Override
    public boolean markSupported() {
        System.out.printf("markSupported\n", new Object[0]);
        return super.markSupported();
    }
}

