/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.io.File;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class ExtClassLoader
extends URLClassLoader {
    private static final String EXTENSIONS_DIR = System.getProperty("user.dir") + File.separator + "extensions";
    private static String extFolder = EXTENSIONS_DIR;
    private static Logger LOG = Logger.getLogger(ExtClassLoader.class.getName());
    private static ExtClassLoader loader;
    private static Map<String, List<Class<?>>> loadedClasses;
    private static Map<String, List<URL>> resourceURLS;

    private ExtClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        File plDir;
        loadedClasses = new HashMap();
        resourceURLS = new HashMap<String, List<URL>>();
        String extDirProperty = System.getProperty("app.extensions.dir");
        if (extDirProperty != null) {
            extFolder = extDirProperty;
        }
        if ((plDir = new File(extFolder)).exists() && plDir.isDirectory()) {
            File[] plfs = plDir.listFiles();
            try {
                for (File plf : plfs) {
                    super.addURL(plf.toURI().toURL());
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.loadClasses();
    }

    public static ExtClassLoader getInstance() {
        if (loader == null) {
            loader = new ExtClassLoader(ClassLoader.getSystemClassLoader());
        }
        return loader;
    }

    public static void setExtensionsDirectory(String directoryPath) {
        if (directoryPath != null && !directoryPath.equals(extFolder)) {
            File folder = new File(directoryPath);
            if (folder.exists() && folder.isDirectory()) {
                extFolder = directoryPath;
                loader = null;
            } else {
                LOG.warning("The specified folder does not exist: " + directoryPath);
            }
        } else {
            LOG.warning("The folder path is null or equal to current path");
        }
    }

    public static String getExtensionsDirectory() {
        return extFolder;
    }

    private void loadClasses() {
        block13: {
            try {
                File[] plfs;
                File plDir = new File(extFolder);
                LOG.info("Extensions dir: " + plDir.getAbsolutePath());
                if (!plDir.exists() || !plDir.isDirectory()) break block13;
                for (File plf : plfs = plDir.listFiles()) {
                    String jarUrlPref;
                    JarFile jf;
                    if (!plf.isFile()) continue;
                    try {
                        jf = new JarFile(plf.getAbsolutePath());
                        jarUrlPref = "jar:file:/" + plf.getAbsolutePath().replace('\\', '/') + "!/";
                    }
                    catch (JarException je) {
                        LOG.warning("Error loading jar '" + plf.getAbsolutePath() + "': " + je.getMessage());
                        continue;
                    }
                    catch (ZipException ze) {
                        continue;
                    }
                    catch (Throwable ioe) {
                        LOG.warning("Error loading jar '" + plf.getAbsolutePath() + "': " + ioe.getMessage());
                        continue;
                    }
                    Enumeration<JarEntry> clEnum = jf.entries();
                    ArrayList foundClasses = new ArrayList();
                    ArrayList<URL> foundRes = new ArrayList<URL>();
                    while (clEnum.hasMoreElements()) {
                        JarEntry jae = clEnum.nextElement();
                        if (jae.getName().endsWith(".class") || jae.getName().endsWith(".CLASS")) {
                            try {
                                Class<?> nextClass = super.loadClass(jae.getName().replace('/', '.').substring(0, jae.getName().lastIndexOf(46)));
                                if (nextClass == null) continue;
                                foundClasses.add(nextClass);
                            }
                            catch (Throwable exception) {
                                LOG.warning("Cannot create class from " + plf.getAbsolutePath() + " member " + jae.getName() + ": " + exception.toString());
                            }
                            continue;
                        }
                        try {
                            foundRes.add(new URL(jarUrlPref + jae.getName()));
                        }
                        catch (MalformedURLException mue) {
                            LOG.warning("Could not create url for: " + jae.getName());
                        }
                    }
                    loadedClasses.put(jf.getName().replace('\\', '/'), foundClasses);
                    resourceURLS.put(jf.getName().replace('\\', '/'), foundRes);
                }
            }
            catch (Exception ex) {
                LOG.warning("Could not load extension classes: " + ex.getMessage());
            }
        }
    }

    public List<Class<?>> getImplementingClasses(String name) {
        if (name == null) {
            return null;
        }
        Class<?> superClass = null;
        try {
            superClass = Class.forName(name);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            return null;
        }
        return this.getImplementingClasses(superClass);
    }

    public List<Class<?>> getImplementingClasses(Class<?> superClass) {
        if (superClass == null) {
            return null;
        }
        ArrayList cList = new ArrayList();
        for (String name : loadedClasses.keySet()) {
            List<Class<?>> li = loadedClasses.get(name);
            if (li == null) continue;
            for (Class<?> cl : li) {
                if (!superClass.isAssignableFrom(cl)) continue;
                cList.add(cl);
            }
        }
        return cList;
    }

    public <T> List<Class<? extends T>> getImplementingTypedClasses(Class<T> superClass) {
        if (superClass == null) {
            return null;
        }
        ArrayList<Class<T>> cList = new ArrayList<Class<T>>();
        for (String name : loadedClasses.keySet()) {
            List<Class<?>> li = loadedClasses.get(name);
            if (li == null) continue;
            for (Class<?> cl : li) {
                if (!superClass.isAssignableFrom(cl)) continue;
                cList.add(cl.asSubclass(superClass));
            }
        }
        return cList;
    }

    public <T> T createInstance(Class<? extends T> implClass) {
        try {
            return implClass.newInstance();
        }
        catch (InstantiationException ia) {
            LOG.warning("Cannot create new instance of: " + implClass);
            LOG.warning(ia.getClass().getName() + " - " + ia.getMessage());
        }
        catch (IllegalAccessException iae) {
            LOG.warning("Cannot create new instance of: " + implClass);
            LOG.warning(iae.getClass().getName() + " - " + iae.getMessage());
        }
        catch (SecurityException se) {
            LOG.warning("Cannot create new instance of: " + implClass);
            LOG.warning(se.getClass().getName() + " - " + se.getMessage());
        }
        catch (Throwable exc) {
            LOG.warning("Cannot create new instance of: " + implClass);
            LOG.warning(exc.getClass().getName() + " - " + exc.getMessage());
        }
        return null;
    }

    public <T> List<T> getInstanceList(Class<T> interfaceClass, List<Class<?>> implementingClasses) {
        if (interfaceClass == null) {
            LOG.warning("Cannot create instances, interface Class is null");
            return null;
        }
        if (implementingClasses == null || implementingClasses.isEmpty()) {
            LOG.warning("Cannot create instances, the list of implementing classes is null or empty");
            return null;
        }
        ArrayList<T> instanceList = new ArrayList<T>(implementingClasses.size());
        for (Class<?> cl : implementingClasses) {
            try {
                int modifiers = cl.getModifiers();
                if (!Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers)) {
                    instanceList.add(interfaceClass.cast(cl.newInstance()));
                    continue;
                }
                if (!LOG.isLoggable(Level.INFO)) continue;
                if (Modifier.isInterface(modifiers)) {
                    LOG.info("Cannot instantiate interface: " + cl.getName());
                    continue;
                }
                if (!Modifier.isAbstract(modifiers)) continue;
                LOG.info("Cannot instantiate abstract class: " + cl.getName());
            }
            catch (InstantiationException ia) {
                LOG.warning("Cannot create new instance of: " + cl);
                LOG.warning(ia.getClass().getName() + " - " + ia.getMessage());
            }
            catch (IllegalAccessException iae) {
                LOG.warning("Cannot create new instance of: " + cl);
                LOG.warning(iae.getClass().getName() + " - " + iae.getMessage());
            }
            catch (SecurityException se) {
                LOG.warning("Cannot create new instance of: " + cl);
                LOG.warning(se.getClass().getName() + " - " + se.getMessage());
            }
            catch (Throwable exc) {
                LOG.warning("Cannot create new instance of: " + cl);
                LOG.warning(exc.getClass().getName() + " - " + exc.getMessage());
            }
        }
        return instanceList;
    }

    public <T> List<T> getInstanceList(Class<T> interfaceClass) {
        if (interfaceClass == null) {
            LOG.warning("Cannot create instances, interface Class is null");
            return null;
        }
        List<Class<?>> implClassList = this.getImplementingClasses(interfaceClass);
        if (implClassList == null || implClassList.isEmpty()) {
            LOG.warning("Cannot create instances, the list of implementing classes is null or empty");
            return null;
        }
        return this.getInstanceList(interfaceClass, implClassList);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("No class found for null");
        }
        return super.findClass(name);
    }

    @Override
    public URL findResource(String name) {
        if (name == null) {
            return null;
        }
        name = !name.startsWith("/") ? name.replace('.', '/') : name.substring(1);
        for (String key : resourceURLS.keySet()) {
            List<URL> li = resourceURLS.get(key);
            if (li == null) continue;
            for (URL url : li) {
                String res;
                int index;
                if (url == null || (index = (res = url.toString()).indexOf("!/")) <= -1 || index >= res.length() - 2 || !name.equals(res = res.substring(index + 2))) continue;
                return url;
            }
        }
        return null;
    }
}

