/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util.lock;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;

public class FileLockUtil {
    private static System.Logger logger = System.getLogger("util");
    private static final String PREFIX = "~";
    private static final String SUFFIX = ".lock";

    private FileLockUtil() {
    }

    public static synchronized FileLock acquireNativeLock(String fileString) throws IOException {
        try {
            Path path = Paths.get(fileString, new String[0]);
            FileChannel fjChannel = FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE);
            try {
                return fjChannel.tryLock();
            }
            catch (IOException ioe) {
                if (logger.isLoggable(System.Logger.Level.INFO)) {
                    logger.log(System.Logger.Level.INFO, String.format("Cannot acquire system lock (io): %s", ioe.getMessage()));
                }
                throw ioe;
            }
            catch (Throwable tt) {
                if (logger.isLoggable(System.Logger.Level.INFO)) {
                    logger.log(System.Logger.Level.INFO, String.format("Cannot acquire system lock (t1): %s", tt.getMessage()));
                }
                throw new IOException(tt);
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(System.Logger.Level.INFO)) {
                logger.log(System.Logger.Level.INFO, String.format("Cannot acquire system lock (t2): %s", t.getMessage()));
            }
            throw new IOException(t);
        }
    }

    public static synchronized boolean releaseNativeLock(FileLock fileLock) {
        if (fileLock == null) {
            return false;
        }
        try {
            fileLock.release();
            return true;
        }
        catch (Exception e) {
            if (logger.isLoggable(System.Logger.Level.INFO)) {
                logger.log(System.Logger.Level.INFO, e.getMessage());
            }
            return false;
        }
    }

    public static boolean isNativeLocked(String fileString) throws IOException {
        FileLock fl = FileLockUtil.acquireNativeLock(fileString);
        if (fl == null) {
            return true;
        }
        fl.release();
        return false;
    }

    public static synchronized File acquireAppLockFile(String fileString) throws IOException {
        try {
            Path path = Paths.get(fileString, new String[0]);
            File f = path.toFile();
            if (!f.exists()) {
                throw new FileNotFoundException(String.format("The file \"%s\" does not exist: ", fileString));
            }
            String lockFileName = f.getParent() + File.separator + PREFIX + f.getName() + SUFFIX;
            File lockFile = new File(lockFileName);
            if (lockFile.exists()) {
                if (logger.isLoggable(System.Logger.Level.INFO)) {
                    logger.log(System.Logger.Level.INFO, String.format("A .lock file exists for: \"%s\"", fileString));
                }
                return null;
            }
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, String.format("Creating lock file with filename %s", lockFileName));
            }
            Path lockFilePath = lockFile.toPath();
            InetAddress localMachine = InetAddress.getLocalHost();
            ArrayList<String> lockInfo = new ArrayList<String>();
            lockInfo.add(OffsetDateTime.now().truncatedTo(ChronoUnit.SECONDS).toString());
            lockInfo.add(System.getProperty("user.name"));
            lockInfo.add(localMachine.getHostName());
            Files.write(lockFilePath, lockInfo, Charset.forName("UTF-8"), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            lockFile.deleteOnExit();
            return lockFile;
        }
        catch (Throwable t) {
            if (logger.isLoggable(System.Logger.Level.INFO)) {
                logger.log(System.Logger.Level.INFO, String.format("An error occured when acquiring a lock for file \"%s\": ", fileString, t.getMessage()));
            }
            throw new IOException(t);
        }
    }

    public static synchronized boolean releaseAppLockFile(File appLockFile) {
        try {
            if (appLockFile != null) {
                Files.delete(appLockFile.toPath());
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            if (logger.isLoggable(System.Logger.Level.INFO)) {
                logger.log(System.Logger.Level.INFO, String.format("An error occured when deleting a lock file: \"%s\" ", t.getMessage()));
            }
            return false;
        }
    }

    public static boolean isAppLocked(String fileString) throws IOException {
        try {
            Path path = Paths.get(fileString, new String[0]);
            File f = path.toFile();
            if (!f.exists()) {
                throw new FileNotFoundException(String.format("The file \"%s\" does not exist: ", fileString));
            }
            String lockFileName = f.getParent() + File.separator + PREFIX + f.getName() + SUFFIX;
            File lockFile = new File(lockFileName);
            if (lockFile.exists()) {
                if (logger.isLoggable(System.Logger.Level.INFO)) {
                    logger.log(System.Logger.Level.INFO, String.format("A .lock file exists for: \"%s\"", fileString));
                }
                return true;
            }
        }
        catch (Throwable t) {
            if (logger.isLoggable(System.Logger.Level.WARNING)) {
                logger.log(System.Logger.Level.WARNING, String.format("Cannot determine if a .lock file exists for: \"%s\"", fileString));
            }
            throw new IOException(t);
        }
        return false;
    }

    public static List<String> getAppLockContent(String fileString) {
        try {
            Path path = Paths.get(fileString, new String[0]);
            File f = path.toFile();
            String lockFileName = f.getParent() + File.separator + PREFIX + f.getName() + SUFFIX;
            File lockFile = new File(lockFileName);
            return FileLockUtil.getAppLockContent(lockFile);
        }
        catch (Throwable t) {
            if (logger.isLoggable(System.Logger.Level.WARNING)) {
                logger.log(System.Logger.Level.WARNING, String.format("Cannot determine if a .lock file exists for: \"%s\"", fileString));
            }
            return null;
        }
    }

    public static List<String> getAppLockContent(File appLockFile) {
        block7: {
            try {
                if (appLockFile.exists()) {
                    ArrayList<String> lines = new ArrayList<String>();
                    BufferedReader br = new BufferedReader(new FileReader(appLockFile));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        lines.add(line);
                    }
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return lines;
                }
                if (logger.isLoggable(System.Logger.Level.INFO)) {
                    logger.log(System.Logger.Level.INFO, String.format("The .lock file does not exist: \"%s\"", appLockFile.getAbsolutePath()));
                }
            }
            catch (Throwable t) {
                if (!logger.isLoggable(System.Logger.Level.INFO)) break block7;
                logger.log(System.Logger.Level.INFO, String.format("Cannot get the contents of the .lock file: \"%s\"", t.getMessage()));
            }
        }
        return null;
    }
}

