/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ServerLogger;

public class WsClientRest {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String callServicePostMethodWithFiles(String urlString, Map<String, String> params, Map<String, String> requestProperties, Map<String, File> files, ProcessReport pr, ProgressListener progListener, float beginProg, float progExtent) throws IOException {
        if (urlString == null) {
            if (pr != null) {
                pr.append("callServicePostMethodWithFiles: the webservice url is null.\n");
                return null;
            } else {
                ServerLogger.LOG.warning("callServicePostMethodWithFiles: the webservice url is null.");
            }
            return null;
        }
        URL url = null;
        if (params == null || params.size() == 0) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                if (pr != null) {
                    pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
                    return null;
                } else {
                    ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
                }
                return null;
            }
        }
        StringBuilder urlBuilder = new StringBuilder(urlString);
        urlBuilder.append('?');
        Iterator<String> paramIter = params.keySet().iterator();
        String key = null;
        String val = null;
        int i = 0;
        while (paramIter.hasNext()) {
            key = paramIter.next();
            val = params.get(key);
            if (key != null && val != null) {
                if (i > 0) {
                    urlBuilder.append('&');
                }
                urlBuilder.append(key);
                urlBuilder.append('=');
                urlBuilder.append(val);
            }
            ++i;
        }
        try {
            url = new URL(urlBuilder.toString());
        }
        catch (MalformedURLException mue) {
            if (pr != null) {
                pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
                return null;
            } else {
                ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
            }
            return null;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setInstanceFollowRedirects(false);
            if (requestProperties != null && requestProperties.size() > 0) {
                Iterator<String> propIter = requestProperties.keySet().iterator();
                key = null;
                val = null;
                while (propIter.hasNext()) {
                    key = propIter.next();
                    val = requestProperties.get(key);
                    if (key == null || val == null) continue;
                    httpConn.setRequestProperty(key, val);
                }
            } else {
                httpConn.setRequestProperty("User-Agent", "ELAN");
                httpConn.setRequestProperty("Connection", "Keep-Alive");
            }
            if (files == null) return null;
        }
        catch (ProtocolException pe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + pe.getMessage() + "\n");
                throw new IOException(pe.getMessage());
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + pe.getMessage());
            }
            throw new IOException(pe.getMessage());
        }
        catch (IOException ioe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + ioe.getMessage() + "\n");
                throw ioe;
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + ioe.getMessage());
            }
            throw ioe;
        }
        return null;
    }

    public String callServicePostMethodWithString(String urlString, Map<String, String> params, Map<String, String> requestProperties, String text, ProcessReport pr, ProgressListener progListener, float beginProg, float progExtent) throws IOException {
        if (urlString == null) {
            if (pr != null) {
                pr.append("callServicePostMethodWithString: the webservice url is null.\n");
            } else {
                ServerLogger.LOG.warning("callServicePostMethodWithString: the webservice url is null.");
            }
            return null;
        }
        URL url = null;
        if (params == null || params.size() == 0) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                if (pr != null) {
                    pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
                } else {
                    ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
                }
                return null;
            }
        }
        StringBuilder urlBuilder = new StringBuilder(urlString);
        urlBuilder.append('?');
        Iterator<String> paramIter = params.keySet().iterator();
        String key = null;
        String val = null;
        int i = 0;
        while (paramIter.hasNext()) {
            key = paramIter.next();
            val = params.get(key);
            if (key != null && val != null) {
                if (i > 0) {
                    urlBuilder.append('&');
                }
                urlBuilder.append(key);
                urlBuilder.append('=');
                urlBuilder.append(val);
            }
            ++i;
        }
        try {
            url = new URL(urlBuilder.toString());
        }
        catch (MalformedURLException mue) {
            if (pr != null) {
                pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
            }
            return null;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setInstanceFollowRedirects(false);
            if (requestProperties != null && requestProperties.size() > 0) {
                Iterator<String> propIter = requestProperties.keySet().iterator();
                key = null;
                val = null;
                while (propIter.hasNext()) {
                    key = propIter.next();
                    val = requestProperties.get(key);
                    if (key == null || val == null) continue;
                    httpConn.setRequestProperty(key, val);
                }
            } else {
                httpConn.setRequestProperty("User-Agent", "ELAN");
                httpConn.setRequestProperty("Connection", "Keep-Alive");
            }
            if (text != null) {
                try {
                    BufferedWriter osw = new BufferedWriter(new OutputStreamWriter(httpConn.getOutputStream(), "UTF-8"));
                    osw.write(text);
                    if (progListener != null) {
                        progListener.progressUpdated(this, (int)(100.0f * (beginProg + progExtent / 2.0f)), "Upload complete, waiting for response");
                    }
                    ((Writer)osw).flush();
                }
                catch (IOException ioe) {
                    if (pr != null) {
                        pr.append("Could not upload the text: " + ioe.getMessage() + "\n");
                    } else {
                        ServerLogger.LOG.warning("Could not upload the text: " + ioe.getMessage());
                    }
                    throw ioe;
                }
            } else if (pr != null) {
                pr.append("There is no text to upload.\n");
            } else {
                ServerLogger.LOG.warning("There is no text to upload.");
            }
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                BufferedReader procReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), "UTF-8"));
                StringBuilder builder = new StringBuilder(1000);
                String line = null;
                String nl = "\n";
                while ((line = procReader.readLine()) != null) {
                    builder.append(line);
                    builder.append("\n");
                }
                try {
                    procReader.close();
                    httpConn.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (pr != null) {
                    pr.append("Successfully received the response text.\n");
                } else {
                    ServerLogger.LOG.warning("Successfully received the response text.");
                }
                if (progListener != null) {
                    progListener.progressUpdated(this, (int)(100.0f * (beginProg + progExtent)), "Received the response text.");
                }
                return builder.toString();
            }
            if (pr != null) {
                pr.append("The server returned an error: " + respCode + "\n");
            } else {
                ServerLogger.LOG.warning("The server returned an error: " + respCode);
            }
            throw new IOException("The server returned an error code: " + respCode);
        }
        catch (ProtocolException pe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + pe.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + pe.getMessage());
            }
            throw new IOException(pe.getMessage());
        }
        catch (IOException ioe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + ioe.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + ioe.getMessage());
            }
            throw ioe;
        }
    }

    public String callServicePostMethod(String urlString, Map<String, String> params, Map<String, String> requestProperties, ProcessReport pr, ProgressListener progListener, float beginProg, float progExtent) throws IOException {
        if (urlString == null && pr != null) {
            pr.append("callServicePostMethod: the webservice url is null.\n");
            ServerLogger.LOG.warning("callServicePostMethod: the webservice url is null.");
            return null;
        }
        URL url = null;
        if (params == null || params.size() == 0) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                if (pr != null) {
                    pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
                } else {
                    ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
                }
                return null;
            }
        }
        StringBuilder urlBuilder = new StringBuilder(urlString);
        urlBuilder.append('?');
        Iterator<String> paramIter = params.keySet().iterator();
        String key = null;
        String val = null;
        int i = 0;
        while (paramIter.hasNext()) {
            key = paramIter.next();
            val = params.get(key);
            if (key != null && val != null) {
                if (i > 0) {
                    urlBuilder.append('&');
                }
                urlBuilder.append(key);
                urlBuilder.append('=');
                urlBuilder.append(val);
            }
            ++i;
        }
        try {
            url = new URL(urlBuilder.toString());
        }
        catch (MalformedURLException mue) {
            if (pr != null) {
                pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
            }
            return null;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setUseCaches(false);
            httpConn.setDoInput(true);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("POST");
            httpConn.setInstanceFollowRedirects(false);
            if (requestProperties != null && requestProperties.size() > 0) {
                Iterator<String> propIter = requestProperties.keySet().iterator();
                key = null;
                val = null;
                while (propIter.hasNext()) {
                    key = propIter.next();
                    val = requestProperties.get(key);
                    if (key == null || val == null) continue;
                    httpConn.setRequestProperty(key, val);
                }
            } else {
                httpConn.setRequestProperty("User-Agent", "ELAN");
                httpConn.setRequestProperty("Connection", "Keep-Alive");
            }
            httpConn.connect();
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                BufferedReader procReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), "UTF-8"));
                StringBuilder outputBuilder = new StringBuilder();
                String line = null;
                while ((line = procReader.readLine()) != null) {
                    outputBuilder.append(line);
                }
                try {
                    procReader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (pr != null) {
                    pr.append("Succesfully connected to the server: " + respCode + "\n");
                } else {
                    ServerLogger.LOG.warning("Succesfully connected to the server: " + respCode);
                }
                if (progListener != null) {
                    progListener.progressUpdated(this, (int)(beginProg + progExtent), "Succesfully connected to the server");
                }
                return outputBuilder.toString();
            }
            if (pr != null) {
                pr.append("Server returned error code: " + respCode + "\n");
            } else {
                ServerLogger.LOG.warning("Server returned error code: " + respCode);
            }
            throw new IOException("The server returned an error code: " + respCode);
        }
        catch (ProtocolException pe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + pe.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + pe.getMessage());
            }
            throw new IOException(pe.getMessage());
        }
        catch (IOException ioe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + ioe.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + ioe.getMessage());
            }
            throw ioe;
        }
    }

    public String callServiceGetMethod(String urlString, Map<String, String> params, Map<String, String> requestProperties, ProcessReport pr, ProgressListener progListener, float beginProg, float progExtent) throws IOException {
        if (urlString == null) {
            if (pr != null) {
                pr.append("callServiceGetMethod: the webservice url string is null.\n");
            } else {
                ServerLogger.LOG.warning("callServiceGetMethod: the webservice url string is null.");
            }
            return null;
        }
        URL url = this.createFullURL(urlString, params, pr);
        if (url == null) {
            if (pr != null) {
                pr.append("callServiceGetMethod: the webservice url is null.\n");
            } else {
                ServerLogger.LOG.warning("callServiceGetMethod: the webservice url is null.");
            }
            return null;
        }
        try {
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDefaultUseCaches(false);
            httpConn.setUseCaches(false);
            httpConn.setDoOutput(true);
            httpConn.setRequestMethod("GET");
            httpConn.setInstanceFollowRedirects(false);
            if (requestProperties != null && requestProperties.size() > 0) {
                Iterator<String> propIter = requestProperties.keySet().iterator();
                String key = null;
                String val = null;
                while (propIter.hasNext()) {
                    key = propIter.next();
                    val = requestProperties.get(key);
                    if (key == null || val == null) continue;
                    httpConn.setRequestProperty(key, val);
                }
            } else {
                httpConn.setRequestProperty("User-Agent", "ELAN");
                httpConn.setRequestProperty("Connection", "Keep-Alive");
            }
            httpConn.connect();
            int respCode = httpConn.getResponseCode();
            if (respCode == 200) {
                BufferedReader procReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), "UTF-8"));
                StringBuilder outputBuilder = new StringBuilder();
                String line = null;
                while ((line = procReader.readLine()) != null) {
                    outputBuilder.append(line);
                }
                try {
                    procReader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (pr != null) {
                    pr.append("Succesfully connected to the server: " + respCode + "\n");
                } else {
                    ServerLogger.LOG.warning("Succesfully connected to the server: " + respCode);
                }
                if (progListener != null) {
                    progListener.progressUpdated(this, (int)(beginProg + progExtent), "Succesfully connected to the server");
                }
                return outputBuilder.toString();
            }
            if (pr != null) {
                pr.append("Server returned error code: " + respCode + "\n");
            } else {
                ServerLogger.LOG.warning("Server returned error code: " + respCode);
            }
            throw new IOException("The server returned an error code: " + respCode);
        }
        catch (ProtocolException pe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + pe.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + pe.getMessage());
            }
            throw new IOException(pe.getMessage());
        }
        catch (IOException ioe) {
            if (pr != null) {
                pr.append("Could not contact the server: " + ioe.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not contact the server: " + ioe.getMessage());
            }
            throw ioe;
        }
    }

    private URL createFullURL(String urlString, Map<String, String> params, ProcessReport pr) {
        URL url = null;
        if (params == null || params.size() == 0) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                if (pr != null) {
                    pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
                } else {
                    ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
                }
                return null;
            }
        }
        StringBuilder urlBuilder = new StringBuilder(urlString);
        urlBuilder.append('?');
        Iterator<String> paramIter = params.keySet().iterator();
        String key = null;
        String val = null;
        int i = 0;
        while (paramIter.hasNext()) {
            key = paramIter.next();
            val = params.get(key);
            if (key != null && val != null) {
                if (i > 0) {
                    urlBuilder.append('&');
                }
                urlBuilder.append(key);
                urlBuilder.append('=');
                urlBuilder.append(val);
            }
            ++i;
        }
        try {
            url = new URL(urlBuilder.toString());
        }
        catch (MalformedURLException mue) {
            if (pr != null) {
                pr.append("Could not create a valid URL: " + mue.getMessage() + "\n");
            } else {
                ServerLogger.LOG.warning("Could not create a valid URL: " + mue.getMessage());
            }
            return null;
        }
        return url;
    }
}

