/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.typecraft;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.webserviceclient.WsClientRest;
import mpi.eudico.webserviceclient.typecraft.PhraseRecord;
import mpi.eudico.webserviceclient.typecraft.TCParser;
import mpi.eudico.webserviceclient.typecraft.TCTextId;

public class TCWsClient {
    public static String storedSessionId = null;
    private String sessionId = null;
    private String userName;
    private WsClientRest wsClient = new WsClientRest();
    private String loginUrl = "http://typecraft.org/w/api.php";
    private String downloadUrl = "http://typecraft.org/tc2/ELAN";

    public TCWsClient() {
    }

    public TCWsClient(String name, String pwd) {
        this.sessionId = this.login(name, pwd);
        System.out.println(this.sessionId);
        if (this.sessionId != null) {
            this.listTexts();
            String xmlText = this.downloadText("1891");
            if (xmlText != null) {
                TCParser parser = new TCParser(xmlText);
                List<PhraseRecord> records = parser.getPhraseRecords();
                System.out.println("Number of records: " + records.size());
            }
        }
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            TCWsClient tCWsClient = new TCWsClient(args[0], args[1]);
        } else {
            TCWsClient tCWsClient = new TCWsClient();
        }
    }

    public String login(String username, String pwd) {
        this.userName = username;
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("action", "login");
        try {
            params.put("lgname", URLEncoder.encode(username, "UTF-8"));
            params.put("lgpassword", URLEncoder.encode(pwd, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println("Cannot encode user name: " + uee.getMessage());
        }
        params.put("format", "xml");
        try {
            String result = this.wsClient.callServicePostMethod(this.loginUrl, params, null, null, null, 0.0f, 0.0f);
            return this.parseLoginMessage(result);
        }
        catch (IOException ioe) {
            System.out.println("Cannot connect to server: " + ioe.getMessage());
            return null;
        }
    }

    public List<TCTextId> listTexts(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("sessionid", sessionId);
        params.put("command", "listtexts");
        try {
            String result = this.wsClient.callServicePostMethod(this.downloadUrl, params, null, null, null, 0.0f, 0.0f);
            if (result != null) {
                return this.parseTextList(result);
            }
            return null;
        }
        catch (IOException ioe) {
            System.out.println("Cannot list the texts of user: " + ioe.getMessage());
            return null;
        }
    }

    public String downloadText(String textId, String sessionId) {
        if (textId == null || sessionId == null) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("sessionid", sessionId);
        params.put("command", "export");
        params.put("text", textId);
        try {
            String result = this.wsClient.callServicePostMethod(this.downloadUrl, params, null, null, null, 0.0f, 0.0f);
            return result;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Cannot export the text: " + ioe.getMessage());
            return null;
        }
    }

    private String parseLoginMessage(String result) {
        int index3;
        int index2;
        int index;
        if (result == null) {
            return null;
        }
        if (result.startsWith("<?xml") && (index = result.indexOf("sessionid")) > -1 && (index2 = result.indexOf(34, index)) > -1 && index2 < result.length() - 1 && (index3 = result.indexOf(34, index2 + 1)) > -1 && index3 > index2 + 1) {
            return result.substring(index2 + 1, index3);
        }
        return null;
    }

    private List<TCTextId> parseTextList(String textListXml) {
        if (textListXml == null) {
            return null;
        }
        ArrayList<TCTextId> texts = new ArrayList<TCTextId>();
        if (textListXml.startsWith("<?xml")) {
            int lastIndex = 0;
            int index = -1;
            while ((index = textListXml.indexOf("<text", lastIndex)) != -1) {
                String textId = null;
                int idIndex = textListXml.indexOf("id", index);
                if (idIndex > -1) {
                    int quot2;
                    int quot1 = textListXml.indexOf(34, idIndex);
                    if (quot1 > -1 && quot1 < textListXml.length() - 1 && (quot2 = textListXml.indexOf(34, quot1 + 1)) > -1) {
                        textId = textListXml.substring(quot1 + 1, quot2);
                    }
                } else {
                    ServerLogger.LOG.warning("No id attribute for text.");
                    break;
                }
                int title1 = textListXml.indexOf("<title>", index);
                if (title1 > -1) {
                    int title2 = textListXml.indexOf("</title>", title1);
                    lastIndex = title2;
                    if (lastIndex == -1) {
                        ServerLogger.LOG.info("No end tag found for a <title> element");
                        break;
                    }
                    String title = textListXml.substring(title1 + 7, title2);
                    if (textId != null && title != null) {
                        TCTextId tid = new TCTextId();
                        tid.id = textId;
                        tid.title = title;
                        texts.add(tid);
                    }
                } else {
                    ServerLogger.LOG.info("No <title> element found inside the <text> element");
                    break;
                }
                if (index > -1) continue;
            }
        }
        return texts;
    }

    private String listTexts() {
        if (this.sessionId == null) {
            System.out.println("Not logged in.");
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("sessionid", this.sessionId);
        params.put("command", "listtexts");
        try {
            String result = this.wsClient.callServicePostMethod(this.downloadUrl, params, null, null, null, 0.0f, 0.0f);
            System.out.println("Texts: " + result);
            return result;
        }
        catch (IOException ioe) {
            System.out.println("Cannot list the texts of user: " + ioe.getMessage());
            return null;
        }
    }

    private String downloadText(String textId) {
        if (this.sessionId == null) {
            System.out.println("Not logged in.");
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("sessionid", this.sessionId);
        params.put("command", "export");
        params.put("text", textId);
        try {
            String result = this.wsClient.callServicePostMethod(this.downloadUrl, params, null, null, null, 0.0f, 0.0f);
            System.out.println("Text " + textId + ": " + result);
            return result;
        }
        catch (IOException ioe) {
            System.out.println("Cannot export the text: " + ioe.getMessage());
            return null;
        }
    }
}

