/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.weblicht;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.webserviceclient.weblicht.TCFElement;
import mpi.eudico.webserviceclient.weblicht.TCFType;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TCFParser
extends DefaultHandler {
    private String inputContent;
    private StringBuilder content = new StringBuilder();
    private TCFElement curElement;
    private TCFType curType;
    private String text;
    private Map<TCFType, List<TCFElement>> baseElements;

    public TCFParser(String inputContent) {
        this.inputContent = inputContent;
    }

    public String getText() {
        return this.text;
    }

    public List<TCFElement> getElementsByType(TCFType type) {
        return this.baseElements.get((Object)type);
    }

    public void parse() throws SAXException, IOException {
        if (this.inputContent == null) {
            return;
        }
        this.baseElements = new HashMap<TCFType, List<TCFElement>>();
        this.baseElements.put(TCFType.SENTENCE, new ArrayList());
        this.baseElements.put(TCFType.TOKEN, new ArrayList());
        this.baseElements.put(TCFType.TAG, new ArrayList());
        this.baseElements.put(TCFType.LEMMA, new ArrayList());
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            parserFactory.newSAXParser().parse(new InputSource(new StringReader(this.inputContent)), (DefaultHandler)this);
        }
        catch (SAXException se) {
            ServerLogger.LOG.warning("Parser exception: " + se.getMessage());
            throw se;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("IO exception: " + ioe.getMessage());
            throw ioe;
        }
        catch (ParserConfigurationException pce) {
            ServerLogger.LOG.warning("Parser configuration exception: " + pce.getMessage());
            throw new SAXException(pce);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ("sentence".equals(localName)) {
            this.baseElements.get((Object)TCFType.SENTENCE).add(new TCFElement(atts.getValue("ID"), atts.getValue("tokenIDs"), null));
            this.curType = TCFType.SENTENCE;
        } else if ("token".equals(localName)) {
            this.curElement = new TCFElement(atts.getValue("ID"), null, null);
            this.baseElements.get((Object)TCFType.TOKEN).add(this.curElement);
            this.curType = TCFType.TOKEN;
        } else if ("tag".equals(localName)) {
            this.curElement = new TCFElement(atts.getValue("ID"), atts.getValue("tokenIDs"), null);
            this.baseElements.get((Object)TCFType.TAG).add(this.curElement);
        } else if ("POStags".equals(localName)) {
            this.curType = TCFType.POS_TAG;
        } else if ("lemma".equals(localName)) {
            this.curElement = new TCFElement(null, atts.getValue("tokenIDs"), null);
            this.baseElements.get((Object)TCFType.LEMMA).add(this.curElement);
            this.curType = TCFType.LEMMA;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("token".equals(localName) || "tag".equals(localName) || "lemma".equals(localName)) {
            this.curElement.setText(this.content.toString().trim());
        } else if ("text".equals(localName)) {
            this.text = this.content.toString().trim();
        }
        this.content.delete(0, this.content.length());
    }
}

